/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.ByteArrayInputStream;
import java.io.RandomAccessFile;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class backupRestore1 {
    private static final byte[] blob1;
    private static final byte[] blob2;
    private static final byte[] blob3;
    private static final byte[] blob4;
    private static final byte[] clob1;
    private static final byte[] clob2;
    private static final byte[] clob3;
    private static final byte[] clob4;

    public static void main(String[] stringArray) {
        AutoCloseable autoCloseable;
        Statement statement;
        AutoCloseable autoCloseable2;
        System.out.println("Test backupRestore starting");
        try {
            ij.getPropertyArg((String[])stringArray);
            autoCloseable2 = ij.startJBMS();
            statement = autoCloseable2.createStatement();
            statement.execute("CREATE FUNCTION ConsistencyChecker() RETURNS VARCHAR(128) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.runConsistencyChecker' LANGUAGE JAVA PARAMETER STYLE JAVA");
            statement.executeUpdate("create table t( id integer not null primary key, cBlob blob(64K),cClob clob(64K), clvarchar long varchar, clvarbinary long varchar for bit data)");
            autoCloseable2.setAutoCommit(false);
            autoCloseable = autoCloseable2.prepareStatement("insert into t( id, cBlob, cClob, clvarchar, clvarbinary) values( ?, ?, ?, ?, ?)");
            autoCloseable.setInt(1, 1);
            autoCloseable.setBinaryStream(2, new ByteArrayInputStream(blob1), blob1.length);
            autoCloseable.setAsciiStream(3, new ByteArrayInputStream(clob1), clob1.length);
            autoCloseable.setAsciiStream(4, new ByteArrayInputStream(clob2), clob2.length);
            autoCloseable.setBinaryStream(5, new ByteArrayInputStream(blob2), blob2.length);
            autoCloseable.executeUpdate();
            autoCloseable.setInt(1, 2);
            autoCloseable.setBinaryStream(2, new ByteArrayInputStream(blob3), blob3.length);
            autoCloseable.setAsciiStream(3, new ByteArrayInputStream(clob3), clob3.length);
            autoCloseable.setAsciiStream(4, new ByteArrayInputStream(clob4), clob4.length);
            autoCloseable.setBinaryStream(5, new ByteArrayInputStream(blob4), blob4.length);
            autoCloseable.executeUpdate();
            autoCloseable2.commit();
            CallableStatement callableStatement = autoCloseable2.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(?, ?)");
            callableStatement.setString(1, "extinout/mybackup");
            callableStatement.setInt(2, 1);
            callableStatement.execute();
            callableStatement.close();
            autoCloseable.setInt(1, 3);
            autoCloseable.setBinaryStream(2, new ByteArrayInputStream(blob3), blob3.length);
            autoCloseable.setAsciiStream(3, new ByteArrayInputStream(clob3), clob3.length);
            autoCloseable.setAsciiStream(4, new ByteArrayInputStream(clob4), clob4.length);
            autoCloseable.setBinaryStream(5, new ByteArrayInputStream(blob4), blob4.length);
            autoCloseable.executeUpdate();
            autoCloseable2.commit();
            autoCloseable.close();
            autoCloseable2.close();
        }
        catch (SQLException sQLException) {
            backupRestore1.dumpSQLExceptions(sQLException);
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception:" + throwable.toString());
        }
        try {
            TestUtil.getConnection("wombat", "shutdown=true");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            } else {
                backupRestore1.dumpSQLExceptions(sQLException);
            }
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception:" + throwable.toString());
        }
        System.out.println("testing rollforward recovery");
        try {
            autoCloseable2 = TestUtil.getConnection("wombat", "rollForwardRecoveryFrom=extinout/mybackup/wombat");
            statement = autoCloseable2.createStatement();
            statement.execute("VALUES (ConsistencyChecker())");
            autoCloseable = statement.executeQuery("select count(*) from t");
            while (autoCloseable.next()) {
                int n = autoCloseable.getInt(1);
                System.out.println(n);
            }
            autoCloseable2.commit();
            autoCloseable2.close();
            TestUtil.getConnection("wombat", "shutdown=true");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            } else {
                backupRestore1.dumpSQLExceptions(sQLException);
            }
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception:" + throwable.toString());
        }
        autoCloseable2 = null;
        boolean bl = false;
        try {
            autoCloseable = TestUtil.getConnection("wombat", null);
            autoCloseable2 = new RandomAccessFile("extinout/mybackup/wombat/service.properties", "r");
            CallableStatement callableStatement = autoCloseable.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
            callableStatement.setString(1, "extinout/mybackup");
            callableStatement.execute();
            callableStatement.close();
            autoCloseable.close();
            TestUtil.getConnection("wombat", "shutdown=true");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("XSRS4")) {
                bl = false;
            } else if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
                bl = true;
            } else {
                backupRestore1.dumpSQLExceptions(sQLException);
            }
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception:" + throwable.toString());
        }
        if (!bl) {
            try {
                TestUtil.getConnection("wombat", "shutdown=true");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("08006")) {
                    System.out.println("database shutdown properly");
                } else {
                    backupRestore1.dumpSQLExceptions(sQLException);
                }
            }
            catch (Throwable throwable) {
                System.out.println("FAIL -- unexpected exception:" + throwable.toString());
            }
        }
        try {
            if (autoCloseable2 != null) {
                ((RandomAccessFile)autoCloseable2).close();
            }
            autoCloseable = TestUtil.getConnection("wombat", "restoreFrom=extinout/mybackup/wombat");
            Statement statement2 = autoCloseable.createStatement();
            statement2.execute("VALUES (ConsistencyChecker())");
            autoCloseable.close();
            TestUtil.getConnection("wombat", "shutdown=true");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            } else {
                backupRestore1.dumpSQLExceptions(sQLException);
            }
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception:" + throwable.toString());
        }
        try {
            autoCloseable = TestUtil.getConnection("wombat", null);
            CallableStatement callableStatement = autoCloseable.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
            callableStatement.setString(1, "extinout/mybackup");
            callableStatement.execute();
            callableStatement.close();
            Statement statement3 = autoCloseable.createStatement();
            statement3.execute("VALUES (ConsistencyChecker())");
            autoCloseable.close();
            TestUtil.getConnection("wombat", "shutdown=true");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            } else {
                backupRestore1.dumpSQLExceptions(sQLException);
            }
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception:" + throwable.toString());
        }
        System.out.println("Test backupRestore1 finished");
    }

    private static void dumpSQLExceptions(SQLException sQLException) {
        System.out.println("FAIL -- unexpected exception: " + sQLException.toString());
        SQLException sQLException2 = sQLException;
        while (sQLException != null) {
            System.out.print("SQLSTATE(" + sQLException.getSQLState() + "):");
            sQLException2 = sQLException;
            sQLException = sQLException.getNextException();
        }
        System.out.println("");
        sQLException2.printStackTrace(System.out);
    }

    static {
        int n;
        blob1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        blob2 = new byte[16385];
        blob3 = new byte[32768];
        blob4 = new byte[32700];
        clob1 = new byte[]{97, 98, 99, 100, 101, 102, 103, 104};
        clob2 = new byte[16385];
        clob3 = new byte[32768];
        clob4 = new byte[4096];
        for (n = 0; n < clob2.length; ++n) {
            backupRestore1.clob2[n] = 97;
        }
        for (n = 0; n < clob3.length; ++n) {
            backupRestore1.clob3[n] = 98;
        }
        for (n = 0; n < clob4.length; ++n) {
            backupRestore1.clob4[n] = 99;
        }
    }
}

