/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CollationTest2
extends BaseJDBCTestCase {
    private static final boolean verbose_debug = false;
    private static final int TEST_DEFAULT = 0;
    private static final int TEST_ENGLISH = 1;
    private static final int TEST_POLISH = 2;
    private static final int TEST_NORWAY = 3;
    private static final String[] NAMES = new String[]{"Smith", "Zebra", "\u0104corn", "\u017bebra", "Acorn", "\u015amith", "aacorn"};
    private static final int[] DEFAULT_NAME_ORDER = new int[]{4, 0, 1, 6, 2, 5, 3};
    private static final int[] ENGLISH_NAME_ORDER = new int[]{6, 4, 2, 0, 5, 1, 3};
    private static final int[] POLISH_NAME_ORDER = new int[]{6, 4, 2, 0, 5, 1, 3};
    private static final int[] NORWAY_NAME_ORDER = new int[]{4, 2, 0, 5, 1, 3, 6};
    private static final int[][] EXPECTED_NAME_ORDER = new int[][]{DEFAULT_NAME_ORDER, ENGLISH_NAME_ORDER, POLISH_NAME_ORDER, NORWAY_NAME_ORDER};
    private static final String[] LIKE_NAMES = new String[]{"Waagan", "Smith", "Zebra", "xcorn", "aBebra", "Acorn", "Amith", "aacorn", "xxxaa", "aaxxx", "yyyaa y"};
    private static final String[] LIKE_TEST_CASES = new String[]{"Waagan", "W_gan", "aaxxx", "_xxx", "xxxaa", "xxx_", "xxx_%", "yyy_%"};
    private static final String[] LIKE_CHAR_TEST_CASES = new String[]{"Waagan    ", "W_gan    ", "aaxxx%", "_xxx%", "xxx%", "xxx_ %", "xxx%", "yyy_%"};
    private static final int[] DEFAULT_LIKE_RESULT = new int[]{0, -1, 9, -1, 8, -1, 8, 10};
    private static final int[] ENGLISH_LIKE_RESULT = new int[]{0, -1, 9, -1, 8, -1, 8, 10};
    private static final int[] POLISH_LIKE_RESULT = new int[]{0, -1, 9, -1, 8, -1, 8, 10};
    private static final int[] NORWAY_LIKE_RESULT = new int[]{0, -1, 9, -1, 8, -1, 8, 10};
    private static final int[][] EXPECTED_LIKE_RESULTS = new int[][]{DEFAULT_LIKE_RESULT, ENGLISH_LIKE_RESULT, POLISH_LIKE_RESULT, NORWAY_LIKE_RESULT};
    private static final String[] derby2670_pattern = new String[]{"%", "a%", "b%", "c%", "%a%", "%b%", "%c%", "%a", "%b", "%c"};
    private static final String[][][] derby2670_pattern_result = new String[][][]{{{"a"}, {"A"}, {" a"}, {"-a"}, {"\u00ada"}, {"b"}, {"B"}, {" b"}, {"-b"}, {"\u00adb"}, {"C"}, {"ekstra\u00adarbeid"}, {"ekstrabetaling"}, {"ekstraarbeid"}, {"Wanvik"}, {"W\u00e5gan"}, {"Waagan"}, {"W\u00e5han"}}, {{"a"}}, {{"b"}}, null, {{"a"}, {" a"}, {"-a"}, {"\u00ada"}, {"ekstra\u00adarbeid"}, {"ekstrabetaling"}, {"ekstraarbeid"}, {"Wanvik"}, {"W\u00e5gan"}, {"Waagan"}, {"W\u00e5han"}}, {{"b"}, {" b"}, {"-b"}, {"\u00adb"}, {"ekstra\u00adarbeid"}, {"ekstrabetaling"}, {"ekstraarbeid"}}, null, {{"a"}, {" a"}, {"-a"}, {"\u00ada"}}, {{"b"}, {" b"}, {"-b"}, {"\u00adb"}}, null};

    public CollationTest2(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    private static final void printRuleBasedCollator() {
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)Collator.getInstance(Locale.US);
        String string = ruleBasedCollator.getRules();
        System.out.println("ENGLISH RULES: " + string);
        System.out.println("ENGLISH RULES: " + CollationTest2.formatString(string, true));
        System.out.println("ENGLISH RULES: " + CollationTest2.formatString(string, false));
    }

    private static final String formatString(String string, boolean bl) {
        Object object = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            object = !bl && c <= '\u0080' ? (String)object + Character.toString(c) : (String)object + "\\u" + Integer.toString(c, 16) + "(" + Character.toString(c) + ")";
        }
        return object;
    }

    private final void formatLikeResults(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        int n = 0;
        while (resultSet.next()) {
            if (++n == 1) {
                object = "{";
                object2 = "{";
                object3 = "{";
            } else {
                object = (String)object + ", ";
                object2 = (String)object2 + ", ";
                object3 = (String)object3 + ", ";
            }
            String string2 = resultSet.getString(1);
            object = (String)object + "\"" + string2 + "\"";
            object2 = (String)object2 + CollationTest2.formatString(string2, true);
            object3 = (String)object3 + "{\"" + CollationTest2.formatString(string2, false) + "\"}";
        }
        if (n != 0) {
            object = object + "}";
            object2 = object2 + "}";
            object3 = (String)object3 + "}";
        }
        System.out.println("Query: " + string + "\nnumber rows  :" + n + "\nString Result:" + (String)object + "\nUcode  Result:" + (String)object2 + "\nmixed  Result:" + object3);
        resultSet.close();
        statement.close();
    }

    private final void printLikeResults(Connection connection) throws SQLException {
    }

    private void checkLangBasedQuery(String string, String[][] stringArray, boolean bl) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (stringArray == null) {
            JDBC.assertEmpty(resultSet);
        } else if (bl) {
            JDBC.assertFullResultSet(resultSet, stringArray);
        } else {
            JDBC.assertUnorderedResultSet(resultSet, stringArray);
        }
    }

    private void checkParamQuery(String string, String[] stringArray, int n, String[][] stringArray2, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string);
        for (int i = 0; i < n; ++i) {
            preparedStatement.setString(i + 1, stringArray[i]);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        if (stringArray2 == null) {
            JDBC.assertEmpty(resultSet);
        } else if (bl) {
            JDBC.assertFullResultSet(resultSet, stringArray2);
        } else {
            JDBC.assertUnorderedResultSet(resultSet, stringArray2);
        }
        for (int i = 0; i < n; ++i) {
            preparedStatement.setString(i + 1, stringArray[i]);
        }
        resultSet = preparedStatement.executeQuery();
        if (stringArray2 == null) {
            JDBC.assertEmpty(resultSet);
        } else if (bl) {
            JDBC.assertFullResultSet(resultSet, stringArray2);
        } else {
            JDBC.assertUnorderedResultSet(resultSet, stringArray2);
        }
        this.commit();
    }

    protected void doExportTable(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        SupportFilesSetup.deleteFile(string3);
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (? , ? , ? , ?, ? , ?)");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.setString(4, string4);
        callableStatement.setString(5, string5);
        callableStatement.setString(6, string6);
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    protected void doImportTable(String string, String string2, String string3, String string4, String string5, String string6, int n) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE (?, ?, ?, ?, ?, ?, ?)");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.setString(4, string4);
        callableStatement.setString(5, string5);
        callableStatement.setString(6, string6);
        callableStatement.setInt(7, n);
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    private String[][] full_row_set(int[] nArray, int n, int n2, boolean bl) {
        String[][] stringArray;
        block4: {
            stringArray = null;
            int n3 = n2 - n + 1;
            if (n3 <= 0) break block4;
            stringArray = new String[n3][2];
            if (bl) {
                int n4 = 0;
                for (int i = n; i <= n2; ++i) {
                    stringArray[n4][0] = String.valueOf(nArray[i]);
                    stringArray[n4][1] = NAMES[nArray[i]];
                    ++n4;
                }
            } else {
                int n5 = 0;
                for (int i = n2; i >= n; --i) {
                    stringArray[n5][0] = String.valueOf(nArray[i]);
                    stringArray[n5][1] = NAMES[nArray[i]];
                    ++n5;
                }
            }
        }
        return stringArray;
    }

    private String[][] full_row_single_value(int n, String[] stringArray) {
        String[][] stringArray2 = null;
        if (n != -1) {
            stringArray2 = new String[1][2];
            stringArray2[0][0] = String.valueOf(n);
            stringArray2[0][1] = stringArray[n];
        }
        return stringArray2;
    }

    private boolean isDatabaseBasicCollation() throws SQLException {
        return "UCS_BASIC".equals(this.getDatabaseProperty("derby.database.collation"));
    }

    private void setUpTable() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE CUSTOMER(D1 CHAR(200), D2 CHAR(200), D3 CHAR(200), D4 INT, ID INT, NAME VARCHAR(40), NAME2 VARCHAR(40))");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO CUSTOMER VALUES(?,?,?,?,?,?,?)");
        for (int i = 0; i < NAMES.length; ++i) {
            preparedStatement.setString(1, NAMES[i]);
            preparedStatement.setString(2, NAMES[i]);
            preparedStatement.setString(3, NAMES[i]);
            preparedStatement.setInt(4, i);
            preparedStatement.setInt(5, i);
            preparedStatement.setString(6, NAMES[i]);
            preparedStatement.setString(7, NAMES[i]);
            preparedStatement.executeUpdate();
        }
        statement.execute("CREATE TABLE EMPTY_TABLE (NAME VARCHAR(40))");
        statement.execute("CREATE INDEX EMPTY_TABLE_IDX ON EMPTY_TABLE(NAME)");
        this.commit();
    }

    private void addSomeMoreCustomers(int n) throws SQLException {
        this.addSomeMoreCustomers(n, true, true);
    }

    private void addSomeMoreCustomers(int n, boolean bl, boolean bl2) throws SQLException {
        PreparedStatement preparedStatement = bl && bl2 ? this.prepareStatement("INSERT INTO CUSTOMER VALUES(?,?,?,?,?,?,?)") : (bl2 ? this.prepareStatement("INSERT INTO CUSTOMER VALUES(?,?,?,?,?,?)") : this.prepareStatement("INSERT INTO CUSTOMER VALUES(?,?,?,?,?)"));
        int n2 = 1;
        for (int i = 0; i < NAMES.length; ++i) {
            if (bl) {
                preparedStatement.setString(n2++, "Another " + n + NAMES[i]);
            }
            if (bl2) {
                preparedStatement.setString(n2++, "Another " + n + NAMES[i]);
            }
            preparedStatement.setString(n2++, "Another " + n + NAMES[i]);
            preparedStatement.setInt(n2++, NAMES.length + n + i);
            preparedStatement.setInt(n2++, NAMES.length + n + i);
            preparedStatement.setString(n2++, "Another " + n + NAMES[i]);
            preparedStatement.setString(n2++, "Another " + n + NAMES[i]);
            preparedStatement.executeUpdate();
            n2 = 1;
        }
    }

    private void dropExtraCustomers(int n) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("DELETE FROM CUSTOMER WHERE ID >= ?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
    }

    private void setUpLikeTable() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE CUSTOMER (NAME_CHAR          CHAR(10), NAME_VARCHAR       VARCHAR(40),NAME_LONGVARCHAR   LONG VARCHAR,NAME_CLOB          CLOB,ID                 INT)");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO CUSTOMER VALUES(?,?,?,?,?)");
        for (int i = 0; i < LIKE_NAMES.length; ++i) {
            preparedStatement.setString(1, LIKE_NAMES[i]);
            preparedStatement.setString(2, LIKE_NAMES[i]);
            preparedStatement.setString(3, LIKE_NAMES[i]);
            preparedStatement.setString(4, LIKE_NAMES[i]);
            preparedStatement.setInt(5, i);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        statement.close();
        this.commit();
    }

    private void setUpALLVALS(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE ALLVALS (STR_CHAR          CHAR(3), STR_VARCHAR       VARCHAR(40),STR_LONGVARCHAR   LONG VARCHAR,STR_CLOB          CLOB,ID                INT)");
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO ALLVALS VALUES(?,?,?,?,?)");
        char[] cArray = new char[1];
        char[] cArray2 = new char[2];
        char[] cArray3 = new char[2];
        char[] cArray4 = new char[3];
        cArray2[0] = 98;
        cArray3[cArray3.length - 1] = 98;
        cArray4[1] = 98;
        int n = 65535;
        long l = System.currentTimeMillis();
        for (int i = 0; i <= n; ++i) {
            cArray[0] = (char)i;
            String string = String.valueOf(cArray);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, string);
            preparedStatement.setInt(5, i);
            preparedStatement.executeUpdate();
            cArray2[1] = (char)i;
            string = String.valueOf(cArray2);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, string);
            preparedStatement.setInt(5, i);
            preparedStatement.executeUpdate();
            cArray3[0] = (char)i;
            string = String.valueOf(cArray3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, string);
            preparedStatement.setInt(5, i);
            preparedStatement.executeUpdate();
            cArray4[0] = (char)i;
            cArray4[2] = (char)i;
            string = String.valueOf(cArray4);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, string);
            preparedStatement.setInt(5, i);
            preparedStatement.executeUpdate();
        }
        long l2 = System.currentTimeMillis();
        connection.commit();
        long l3 = System.currentTimeMillis();
        preparedStatement.close();
        statement.close();
    }

    private void runDERBY_2703(int n) throws SQLException {
        this.setUpTable();
        ResultSet resultSet = this.getConnection().getMetaData().getColumns(null, "APP", "CUSTOMER", "%");
        int n2 = JDBC.assertDrainResults(resultSet);
        Assert.assertTrue((String)"catch bug where no rows are returned.", (n2 > 0 ? 1 : 0) != 0);
        this.dropTable();
    }

    public void ci_testDerby5367() throws SQLException {
        CollationTest2.assertFalse((boolean)this.isDatabaseBasicCollation());
        this.setAutoCommit(true);
        String string = "DERBY_5367";
        Statement statement = this.createStatement();
        statement.executeUpdate("create table " + string + "(VAL varchar(10) not null unique)");
        this.runDerby5367TestCode(string);
        TestConfiguration.getCurrent().shutdownDatabase();
        this.getConnection();
        this.runDerby5367TestCode(string);
        this.dropTable(string);
    }

    private void runDerby5367TestCode(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select val from " + string + " where val = 'Test'");
        PreparedStatement preparedStatement2 = this.prepareStatement("insert into " + string + " values ?");
        preparedStatement2.setString(1, "Test");
        preparedStatement2.executeUpdate();
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"Test"}});
        Statement statement = this.createStatement();
        statement.executeUpdate("delete from " + string + " where val = 'Test'");
        preparedStatement2.setString(1, "test");
        preparedStatement2.executeUpdate();
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"test"}});
        statement.executeUpdate("delete from " + string);
    }

    private void checkSimpleCompare(int[] nArray) throws SQLException {
        for (int i = 0; i < nArray.length; ++i) {
            this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER where NAME < '" + NAMES[nArray[i]] + "' ORDER BY NAME", this.full_row_set(nArray, 0, i - 1, true), true);
            this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER where NAME <= '" + NAMES[nArray[i]] + "' ORDER BY NAME", this.full_row_set(nArray, 0, i, true), true);
            this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER where NAME = '" + NAMES[nArray[i]] + "' ORDER BY NAME", this.full_row_set(nArray, i, i, true), true);
            this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER where NAME >= '" + NAMES[nArray[i]] + "' ORDER BY NAME", this.full_row_set(nArray, i, nArray.length - 1, true), true);
            this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER where NAME > '" + NAMES[nArray[i]] + "' ORDER BY NAME", this.full_row_set(nArray, i + 1, nArray.length - 1, true), true);
            this.checkParamQuery("SELECT ID, NAME FROM CUSTOMER where NAME < ? ORDER BY NAME", new String[]{NAMES[nArray[i]]}, 1, this.full_row_set(nArray, 0, i - 1, true), true);
            this.checkParamQuery("SELECT ID, NAME FROM CUSTOMER where NAME <= ? ORDER BY NAME", new String[]{NAMES[nArray[i]]}, 1, this.full_row_set(nArray, 0, i, true), true);
            this.checkParamQuery("SELECT ID, NAME FROM CUSTOMER where NAME = ? ORDER BY NAME", new String[]{NAMES[nArray[i]]}, 1, this.full_row_set(nArray, i, i, true), true);
            this.checkParamQuery("SELECT ID, NAME FROM CUSTOMER where NAME >= ? ORDER BY NAME", new String[]{NAMES[nArray[i]]}, 1, this.full_row_set(nArray, i, nArray.length - 1, true), true);
            this.checkParamQuery("SELECT ID, NAME FROM CUSTOMER where NAME > ? ORDER BY NAME", new String[]{NAMES[nArray[i]]}, 1, this.full_row_set(nArray, i + 1, nArray.length - 1, true), true);
        }
    }

    private void checkTwoPersistentCompare(int[] nArray) throws SQLException {
        Statement statement = this.createStatement();
        this.commit();
        statement.execute("ALTER TABLE CUSTOMER ADD COLUMN TWO_CHECK_CHAR CHAR(40)");
        statement.execute("ALTER TABLE CUSTOMER ADD COLUMN TWO_CHECK_VARCHAR VARCHAR(400)");
        PreparedStatement preparedStatement = this.prepareStatement("UPDATE CUSTOMER SET TWO_CHECK_CHAR = ?");
        preparedStatement.setString(1, NAMES[nArray[3]]);
        preparedStatement.executeUpdate();
        preparedStatement = this.prepareStatement("UPDATE CUSTOMER SET TWO_CHECK_VARCHAR = ?");
        preparedStatement.setString(1, NAMES[nArray[3]]);
        preparedStatement.executeUpdate();
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER WHERE NAME > TWO_CHECK_CHAR ORDER BY NAME", this.full_row_set(nArray, 4, nArray.length - 1, true), true);
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER WHERE TWO_CHECK_CHAR < NAME ORDER BY NAME", this.full_row_set(nArray, 4, nArray.length - 1, true), true);
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER WHERE NAME > TWO_CHECK_VARCHAR ORDER BY NAME", this.full_row_set(nArray, 4, nArray.length - 1, true), true);
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER WHERE D3 > TWO_CHECK_CHAR ORDER BY NAME", this.full_row_set(nArray, 4, nArray.length - 1, true), true);
        this.rollback();
    }

    private void dropTable() throws SQLException {
        this.dropTable("CUSTOMER");
        this.dropTable("EMPTY_TABLE");
    }

    private void runQueries(int n, String string, String string2) throws SQLException {
        Statement statement = this.createStatement();
        if (string != null) {
            statement.execute(string);
            this.commit();
        }
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", this.full_row_set(EXPECTED_NAME_ORDER[n], 0, EXPECTED_NAME_ORDER[n].length - 1, true), true);
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER ORDER BY NAME, ID", this.full_row_set(EXPECTED_NAME_ORDER[n], 0, EXPECTED_NAME_ORDER[n].length - 1, true), true);
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER ORDER BY NAME DESC", this.full_row_set(EXPECTED_NAME_ORDER[n], 0, EXPECTED_NAME_ORDER[n].length - 1, false), true);
        this.checkSimpleCompare(EXPECTED_NAME_ORDER[n]);
        this.checkTwoPersistentCompare(EXPECTED_NAME_ORDER[n]);
        if (string != null) {
            statement.execute("DROP INDEX " + string2);
        }
        this.commit();
    }

    private void runLikeTests(int n) throws SQLException {
        this.setUpLikeTable();
        for (int i = 0; i < LIKE_TEST_CASES.length; ++i) {
            this.checkLangBasedQuery("SELECT ID, NAME_VARCHAR FROM CUSTOMER WHERE NAME_VARCHAR LIKE '" + LIKE_TEST_CASES[i] + "'", this.full_row_single_value(EXPECTED_LIKE_RESULTS[n][i], LIKE_NAMES), true);
            this.checkParamQuery("SELECT ID, NAME_VARCHAR FROM CUSTOMER WHERE NAME_VARCHAR LIKE ?", new String[]{LIKE_TEST_CASES[i]}, 1, this.full_row_single_value(EXPECTED_LIKE_RESULTS[n][i], LIKE_NAMES), true);
            this.checkLangBasedQuery("SELECT ID, NAME_LONGVARCHAR FROM CUSTOMER WHERE NAME_LONGVARCHAR LIKE '" + LIKE_TEST_CASES[i] + "'", this.full_row_single_value(EXPECTED_LIKE_RESULTS[n][i], LIKE_NAMES), true);
            this.checkParamQuery("SELECT ID, NAME_LONGVARCHAR FROM CUSTOMER WHERE NAME_LONGVARCHAR LIKE ?", new String[]{LIKE_TEST_CASES[i]}, 1, this.full_row_single_value(EXPECTED_LIKE_RESULTS[n][i], LIKE_NAMES), true);
            this.checkLangBasedQuery("SELECT ID, NAME_CLOB FROM CUSTOMER WHERE NAME_CLOB LIKE '" + LIKE_TEST_CASES[i] + "'", this.full_row_single_value(EXPECTED_LIKE_RESULTS[n][i], LIKE_NAMES), true);
            this.checkParamQuery("SELECT ID, NAME_CLOB FROM CUSTOMER WHERE NAME_CLOB LIKE ?", new String[]{LIKE_TEST_CASES[i]}, 1, this.full_row_single_value(EXPECTED_LIKE_RESULTS[n][i], LIKE_NAMES), true);
            this.checkLangBasedQuery("SELECT ID, NAME_CHAR FROM CUSTOMER WHERE NAME_CHAR LIKE '" + LIKE_CHAR_TEST_CASES[i] + "%'", this.full_row_single_value(EXPECTED_LIKE_RESULTS[n][i], LIKE_NAMES), true);
            this.checkParamQuery("SELECT ID, NAME_CHAR FROM CUSTOMER WHERE NAME_CHAR LIKE ?", new String[]{LIKE_CHAR_TEST_CASES[i] + "%"}, 1, this.full_row_single_value(EXPECTED_LIKE_RESULTS[n][i], LIKE_NAMES), true);
        }
        String string = "SELECT * from SYS.SYSCOLUMNS where COLUMNNAME like 'nonmatchiing'";
        String string2 = "SELECT * from SYS.SYSCOLUMNS where 'nonmatchiing' like COLUMNNAME";
        String string3 = "SELECT * from SYS.SYSCOLUMNS where COLUMNNAME like ?";
        String string4 = "SELECT * from SYS.SYSCOLUMNS where ? like COLUMNNAME";
        String string5 = "SELECT count(*) from SYS.SYSCOLUMNS where ? like ?";
        if (!this.isDatabaseBasicCollation()) {
            this.assertCompileError("42ZA2", string);
            this.assertCompileError("42ZA2", string2);
            this.checkParamQuery(string3, new String[]{"nonmatchiing"}, 1, null, true);
            this.checkParamQuery(string4, new String[]{"nonmatchiing"}, 1, null, true);
            this.checkParamQuery(string5, new String[]{"nonmatching", "matching"}, 2, new String[][]{{"0"}}, true);
        } else {
            this.checkLangBasedQuery(string, null, true);
            this.checkLangBasedQuery(string2, null, true);
            this.checkParamQuery(string3, new String[]{"nonmatchiing"}, 1, null, true);
            this.checkParamQuery(string4, new String[]{"nonmatchiing"}, 1, null, true);
            this.checkParamQuery(string5, new String[]{"nonmatching", "123"}, 2, new String[][]{{"0"}}, true);
        }
        this.dropTable();
    }

    private void runAlterTableCompress(int n) throws SQLException {
        Statement statement = this.createStatement();
        this.setUpTable();
        statement.execute("CREATE INDEX IDX1 ON CUSTOMER (NAME)");
        statement.execute("CREATE INDEX IDX2 ON CUSTOMER (NAME, ID)");
        statement.execute("CREATE INDEX IDX3 ON CUSTOMER (ID,   NAME)");
        statement.execute("CREATE INDEX IDX4 ON CUSTOMER (ID)");
        statement.execute("CREATE INDEX IDX5 ON CUSTOMER (ID, NAME, D1, D2, D3)");
        this.commit();
        CallableStatement callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'CUSTOMER', 1)");
        CollationTest2.assertUpdateCount(callableStatement, 0);
        this.commit();
        this.runQueries(n, null, null);
        statement.execute("DROP INDEX IDX1 ");
        statement.execute("DROP INDEX IDX2 ");
        statement.execute("DROP INDEX IDX3 ");
        statement.execute("DROP INDEX IDX4 ");
        statement.execute("DROP INDEX IDX5 ");
        this.rollback();
        this.runQueries(n, null, null);
        this.addSomeMoreCustomers(100);
        this.dropTable();
        this.commit();
    }

    private void runAlterTableDropColumn(int n) throws SQLException {
        Statement statement = this.createStatement();
        this.setUpTable();
        statement.execute("ALTER TABLE CUSTOMER DROP COLUMN D1");
        this.runQueries(n, null, null);
        this.addSomeMoreCustomers(100, false, true);
        this.dropExtraCustomers(100);
        statement.execute("CREATE INDEX IDX1 ON CUSTOMER (NAME)");
        statement.execute("ALTER TABLE CUSTOMER DROP COLUMN D2");
        this.runQueries(n, null, null);
        this.addSomeMoreCustomers(100, false, false);
        this.rollback();
        this.dropTable();
        this.commit();
    }

    private void runAlterTableAddColumn(int n) throws SQLException {
        Statement statement = this.createStatement();
        this.setUpTable();
        statement.execute("ALTER TABLE CUSTOMER DROP COLUMN NAME");
        statement.execute("ALTER TABLE CUSTOMER ADD COLUMN NAME CHAR(40)");
        statement.execute("UPDATE CUSTOMER SET NAME = D1");
        this.runQueries(n, null, null);
        statement.execute("CREATE INDEX IDX1 ON CUSTOMER (NAME)");
        this.runQueries(n, null, null);
        this.addSomeMoreCustomers(100);
        this.dropTable();
        this.commit();
    }

    private void runBulkInsert(int n) throws SQLException {
        Statement statement = this.createStatement();
        this.setUpTable();
        String string = SupportFilesSetup.getReadWrite("empty_file.dat").getPath();
        statement.execute("DELETE FROM EMPTY_TABLE");
        this.doExportTable("APP", "EMPTY_TABLE", string, null, null, "UTF-16");
        this.commit();
        this.doImportTable("APP", "EMPTY_TABLE", string, "|", "`", null, 1);
        this.commit();
        String string2 = SupportFilesSetup.getReadWrite("names.dat").getPath();
        this.doExportTable("APP", "CUSTOMER", string2, null, null, "UTF-16");
        this.commit();
        statement.execute("DELETE FROM CUSTOMER");
        this.commit();
        this.doImportTable("APP", "CUSTOMER", string2, null, null, "UTF-16", 0);
        this.runQueries(n, null, null);
        statement.execute("DELETE FROM CUSTOMER");
        statement.execute("CREATE INDEX IDX1 ON CUSTOMER (NAME)");
        statement.execute("CREATE INDEX IDX2 ON CUSTOMER (NAME, ID)");
        statement.execute("CREATE INDEX IDX3 ON CUSTOMER (ID,   NAME)");
        statement.execute("CREATE INDEX IDX4 ON CUSTOMER (ID)");
        statement.execute("CREATE INDEX IDX5 ON CUSTOMER (ID, NAME, D1, D2, D3)");
        this.doImportTable("APP", "CUSTOMER", string2, null, null, "UTF-16", 0);
        this.runQueries(n, null, null);
        statement.execute("DROP INDEX IDX1 ");
        statement.execute("DROP INDEX IDX2 ");
        statement.execute("DROP INDEX IDX3 ");
        statement.execute("DROP INDEX IDX4 ");
        statement.execute("DROP INDEX IDX5 ");
        this.doImportTable("APP", "CUSTOMER", string2, null, null, "UTF-16", 0);
        this.doImportTable("APP", "CUSTOMER", string2, null, null, "UTF-16", 1);
        this.runQueries(n, null, null);
        statement.execute("CREATE INDEX IDX1 ON CUSTOMER (NAME)");
        statement.execute("CREATE INDEX IDX2 ON CUSTOMER (NAME, ID)");
        statement.execute("CREATE INDEX IDX3 ON CUSTOMER (ID,   NAME)");
        statement.execute("CREATE INDEX IDX4 ON CUSTOMER (ID)");
        statement.execute("CREATE INDEX IDX5 ON CUSTOMER (ID, NAME, D1, D2, D3)");
        this.doImportTable("APP", "CUSTOMER", string2, null, null, "UTF-16", 0);
        this.doImportTable("APP", "CUSTOMER", string2, null, null, "UTF-16", 1);
        this.runQueries(n, null, null);
        statement.execute("DROP INDEX IDX1 ");
        statement.execute("DROP INDEX IDX2 ");
        statement.execute("DROP INDEX IDX3 ");
        statement.execute("DROP INDEX IDX4 ");
        statement.execute("DROP INDEX IDX5 ");
        this.dropTable();
        this.commit();
    }

    private void runDerby2670() throws SQLException {
        ResultSet resultSet;
        String string;
        int n;
        Statement statement = this.createStatement();
        String[] stringArray = new String[]{"Waagan", "W\u00e5han", "Wanvik", "W\u00e5gan", "ekstrabetaling", "ekstraarbeid", "ekstra\u00adarbeid", "\u00ada", "a", "\u00adb", "b", "-a", "-b", " a", " b", "A", "B", "C"};
        statement.executeUpdate("create table t (x varchar(20))");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i]);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        Assert.assertEquals((String)"source and result arrays do not match for derby2670", (int)derby2670_pattern_result.length, (int)derby2670_pattern.length);
        String string2 = "select * from t where x like ";
        PreparedStatement preparedStatement2 = this.prepareStatement("select * from t where x like ?");
        PreparedStatement preparedStatement3 = this.prepareStatement("select * from t where x like ? order by x");
        for (n = 0; n < derby2670_pattern.length; ++n) {
            string = string2 + "'" + derby2670_pattern[n] + "'";
            this.checkLangBasedQuery(string, derby2670_pattern_result[n], false);
            string = string + " order by x";
            this.checkLangBasedQuery(string, derby2670_pattern_result[n], false);
            preparedStatement2.setString(1, derby2670_pattern[n]);
            resultSet = preparedStatement2.executeQuery();
            if (derby2670_pattern_result[n] == null) {
                JDBC.assertEmpty(resultSet);
            } else {
                JDBC.assertUnorderedResultSet(resultSet, derby2670_pattern_result[n]);
            }
            resultSet.close();
            resultSet = null;
            preparedStatement3.setString(1, derby2670_pattern[n]);
            resultSet = preparedStatement3.executeQuery();
            if (derby2670_pattern_result[n] == null) {
                JDBC.assertEmpty(resultSet);
            } else {
                JDBC.assertFullResultSet(resultSet, derby2670_pattern_result[n]);
            }
            resultSet.close();
            resultSet = null;
        }
        statement.executeUpdate("create index t_idx on t (x)");
        string2 = "select * from t where x like ";
        for (n = 0; n < derby2670_pattern.length; ++n) {
            string = string2 + "'" + derby2670_pattern[n] + "'";
            this.checkLangBasedQuery(string, derby2670_pattern_result[n], false);
            string = string + " order by x";
            this.checkLangBasedQuery(string, derby2670_pattern_result[n], false);
            preparedStatement2.setString(1, derby2670_pattern[n]);
            resultSet = preparedStatement2.executeQuery();
            if (derby2670_pattern_result[n] == null) {
                JDBC.assertEmpty(resultSet);
            } else {
                JDBC.assertUnorderedResultSet(resultSet, derby2670_pattern_result[n]);
            }
            resultSet.close();
            resultSet = null;
            preparedStatement3.setString(1, derby2670_pattern[n]);
            resultSet = preparedStatement3.executeQuery();
            if (derby2670_pattern_result[n] == null) {
                JDBC.assertEmpty(resultSet);
            } else {
                JDBC.assertFullResultSet(resultSet, derby2670_pattern_result[n]);
            }
            resultSet.close();
            resultSet = null;
        }
        statement.executeUpdate("drop table t");
        this.commit();
        preparedStatement3.close();
        preparedStatement2.close();
        statement.close();
    }

    private void runDerby5530TruncateIndex() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table d5530i (val varchar(10))");
        statement.executeUpdate("create index idx on d5530i(val)");
        statement.executeUpdate("truncate table d5530i");
        statement.executeUpdate("insert into d5530i values 'one', 'two'");
        ResultSet resultSet = statement.executeQuery("select * from d5530i");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"one"}, {"two"}});
        this.rollback();
    }

    private void runDerby5530TruncateNoIndex() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table d5530 (val varchar(10))");
        statement.executeUpdate("truncate table d5530");
        statement.executeUpdate("insert into d5530 values 'one', 'two'");
        ResultSet resultSet = statement.executeQuery("select * from d5530");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"one"}, {"two"}});
        this.rollback();
    }

    private void runTestIter(int n) throws SQLException {
        this.setUpTable();
        this.runQueries(n, null, null);
        this.runQueries(n, "CREATE INDEX NAME_IDX ON CUSTOMER (NAME)", "NAME_IDX");
        this.runQueries(n, "CREATE UNIQUE INDEX IDX ON CUSTOMER (NAME)", "IDX");
        this.runQueries(n, "CREATE INDEX NAME_IDX ON CUSTOMER (NAME DESC)", "NAME_IDX");
        this.runQueries(n, "CREATE UNIQUE INDEX IDX ON CUSTOMER (NAME DESC)", "IDX");
        this.runQueries(n, "CREATE UNIQUE INDEX IDX ON CUSTOMER (NAME, ID)", "IDX");
        this.dropTable();
        this.runDERBY_2703(n);
        this.runAlterTableAddColumn(n);
        this.runAlterTableCompress(n);
        if (JDBC.vmSupportsJDBC3()) {
            this.runBulkInsert(n);
        }
        this.runLikeTests(n);
        this.runDerby5530TruncateNoIndex();
        this.runDerby5530TruncateIndex();
        this.dropTable();
        this.runAlterTableDropColumn(n);
        this.commit();
    }

    public void testDefaultCollation() throws SQLException {
        CollationTest2.assertTrue((boolean)this.isDatabaseBasicCollation());
        this.runTestIter(0);
    }

    public void testEnglishCollation() throws SQLException {
        CollationTest2.assertFalse((boolean)this.isDatabaseBasicCollation());
        this.runTestIter(1);
    }

    public void testPolishCollation() throws SQLException {
        CollationTest2.assertFalse((boolean)this.isDatabaseBasicCollation());
        this.runTestIter(2);
    }

    public void testNorwayCollation() throws SQLException {
        CollationTest2.assertFalse((boolean)this.isDatabaseBasicCollation());
        this.runDerby2670();
        this.runTestIter(3);
    }

    public void testDefaultJVMTerritoryCollation() throws SQLException {
        Locale locale = Locale.getDefault();
        if (locale.getLanguage().equals("en")) {
            this.testEnglishCollation();
        } else if (locale.getLanguage().equals("no")) {
            this.testNorwayCollation();
        } else if (locale.getLanguage().equals("po")) {
            this.testPolishCollation();
        }
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("CollationTest2");
        baseTestSuite.addTest((Test)new CollationTest2("testDefaultCollation"));
        baseTestSuite.addTest(CollationTest2.collatedTest("en", "testEnglishCollation"));
        baseTestSuite.addTest(CollationTest2.caseInsensitiveCollationSuite());
        Locale[] localeArray = Collator.getAvailableLocales();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < localeArray.length; ++i) {
            if ("no".equals(localeArray[i].getLanguage())) {
                bl = true;
            }
            if (!"pl".equals(localeArray[i].getLanguage())) continue;
            bl2 = true;
        }
        if (bl) {
            baseTestSuite.addTest(CollationTest2.collatedTest("no_NO", "testNorwayCollation"));
        }
        if (bl2) {
            baseTestSuite.addTest(CollationTest2.collatedTest("pl", "testPolishCollation"));
        }
        baseTestSuite.addTest(CollationTest2.collatedTest(null, "testDefaultJVMTerritoryCollation"));
        SupportFilesSetup supportFilesSetup = new SupportFilesSetup((Test)baseTestSuite);
        return supportFilesSetup;
    }

    private static Test collatedTest(String string, String string2) {
        return Decorator.territoryCollatedDatabase((Test)new CollationTest2(string2), string);
    }

    private static Test caseInsensitiveCollationSuite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Case insensitive specific tests");
        baseTestSuite.addTest((Test)new CollationTest2("ci_testDerby5367"));
        return Decorator.territoryCollatedCaseInsensitiveDatabase((Test)baseTestSuite, "en_US");
    }
}

