/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class DataSourceSerializationTest
extends BaseJDBCTestCase {
    private static final String VERSION_10_0_2_1 = "10_0_2_1";
    private static final String VERSION_10_1_3_1 = "10_1_3_1";
    private static final String VERSION_10_2_2_0 = "10_2_2_0";
    private static final String VERSION_10_3_2_1 = "10_3_2_1";
    private static final String VERSION_10_10_1_0 = "10_10_1_0";
    private static final String VERSION_10_11_1_0 = "10_11_1_0";
    private final String _40Suffix = "40";

    public DataSourceSerializationTest(String string) {
        super(string);
    }

    public void serTestEmbeddedDataSource() throws Exception {
        if (JDBC.vmSupportsJNDI()) {
            this.deSerializeDs("EmbeddedDataSource", VERSION_10_0_2_1, true);
            this.deSerializeDs("EmbeddedDataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("EmbeddedDataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("EmbeddedDataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("EmbeddedDataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("EmbeddedDataSource40", VERSION_10_10_1_0, true);
        }
        this.deSerializeDs("BasicEmbeddedDataSource40", VERSION_10_10_1_0, false);
    }

    public void serTestEmbeddedConnectionPoolDataSource() throws Exception {
        if (JDBC.vmSupportsJNDI()) {
            this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_0_2_1, true);
            this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("EmbeddedConnectionPoolDataSource40", VERSION_10_10_1_0, true);
        }
        this.deSerializeDs("BasicEmbeddedConnectionPoolDataSource40", VERSION_10_10_1_0, false);
    }

    public void serTestEmbeddedXADataSource() throws Exception {
        if (JDBC.vmSupportsJNDI()) {
            this.deSerializeDs("EmbeddedXADataSource", VERSION_10_0_2_1, true);
            this.deSerializeDs("EmbeddedXADataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("EmbeddedXADataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("EmbeddedXADataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("EmbeddedXADataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("EmbeddedXADataSource40", VERSION_10_10_1_0, true);
        }
        this.deSerializeDs("BasicEmbeddedXADataSource40", VERSION_10_10_1_0, false);
    }

    public void serTestClientDataSource() throws Exception {
        if (JDBC.vmSupportsJNDI()) {
            this.deSerializeDs("ClientDataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("ClientDataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("ClientDataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("ClientDataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("ClientDataSource40", VERSION_10_10_1_0, true);
        }
        this.deSerializeDs("BasicClientDataSource40", VERSION_10_10_1_0, false);
    }

    public void serTestClientConnectionPoolDataSource() throws Exception {
        if (JDBC.vmSupportsJNDI()) {
            this.deSerializeDs("ClientConnectionPoolDataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("ClientConnectionPoolDataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("ClientConnectionPoolDataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("ClientConnectionPoolDataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("ClientConnectionPoolDataSource40", VERSION_10_10_1_0, true);
        }
        this.deSerializeDs("BasicClientConnectionPoolDataSource40", VERSION_10_10_1_0, false);
    }

    public void serTestClientXADataSource() throws Exception {
        if (JDBC.vmSupportsJNDI()) {
            this.deSerializeDs("ClientXADataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("ClientXADataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("ClientXADataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("ClientXADataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("ClientXADataSource40", VERSION_10_10_1_0, true);
        }
        this.deSerializeDs("BasicClientXADataSource40", VERSION_10_10_1_0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deSerializeDs(String string, String string2, boolean bl) throws Exception {
        Object object;
        String string3;
        Object object2;
        if (!JDBC.vmSupportsJDBC4() && string.contains("40")) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('-');
        stringBuffer.append(string2);
        stringBuffer.append(".ser");
        DataSourceSerializationTest.println("Deserializing " + stringBuffer.toString());
        FileInputStream fileInputStream = new FileInputStream(SupportFilesSetup.getReadOnly(stringBuffer.toString()));
        DataSourceSerializationTest.assertNotNull((String)"FileInputStream is null", (Object)fileInputStream);
        Object object3 = null;
        DataSource dataSource = null;
        Object object4 = null;
        boolean bl2 = false;
        try {
            object2 = new ObjectInputStream(fileInputStream);
            string3 = ((ObjectInputStream)object2).readUTF();
            object = ((ObjectInputStream)object2).readUTF();
            DataSourceSerializationTest.println("Data source " + string + ", version " + string3 + ", build " + (String)object);
            object3 = ((ObjectInputStream)object2).readObject();
            DataSourceSerializationTest.assertNotNull((String)"De-serialized data source is null", (Object)object3);
            DataSourceSerializationTest.assertTrue((String)("Unexpected class instantiated: " + object3.getClass().getName()), (object3.getClass().getName().indexOf(string) > 0 ? 1 : 0) != 0);
            dataSource = (DataSource)object3;
            int n = dataSource.getLoginTimeout() + 9;
            DataSourceSerializationTest.assertFalse((dataSource.getLoginTimeout() == n ? 1 : 0) != 0);
            dataSource.setLoginTimeout(n);
            DataSourceSerializationTest.assertEquals((int)n, (int)dataSource.getLoginTimeout());
            if (bl) {
                object4 = ((ObjectInputStream)object2).readObject();
            }
            ((ObjectInputStream)object2).close();
            bl2 = true;
        }
        finally {
            if (bl2) {
                ((InputStream)fileInputStream).close();
            } else {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bl) {
            object2 = Class.forName("javax.naming.Reference").getMethod("getFactoryClassName", null);
            string3 = (String)((Method)object2).invoke(object4, null);
            object = Class.forName(string3);
            Object t = ((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = t.getClass().getMethod("getObjectInstance", Class.forName("java.lang.Object"), Class.forName("javax.naming.Name"), Class.forName("javax.naming.Context"), Class.forName("java.util.Hashtable"));
            Object object5 = method.invoke(t, object4, null, null, null);
            dataSource = (DataSource)object5;
            DataSourceSerializationTest.assertTrue((String)("Unexpected class instantiated by Reference: " + object3.getClass().getName()), (object3.getClass().getName().indexOf(string) > 0 ? 1 : 0) != 0);
        }
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DataSourceSerializationTest");
        String string = "functionTests/testData/serializedDataSources/";
        if (Derby.hasEmbedded()) {
            baseTestSuite.addTest((Test)new DataSourceSerializationTest("serTestEmbeddedDataSource"));
            baseTestSuite.addTest((Test)new DataSourceSerializationTest("serTestEmbeddedConnectionPoolDataSource"));
            baseTestSuite.addTest((Test)new DataSourceSerializationTest("serTestEmbeddedXADataSource"));
        }
        if (Derby.hasClient()) {
            baseTestSuite.addTest((Test)new DataSourceSerializationTest("serTestClientDataSource"));
            baseTestSuite.addTest((Test)new DataSourceSerializationTest("serTestClientConnectionPoolDataSource"));
            baseTestSuite.addTest((Test)new DataSourceSerializationTest("serTestClientXADataSource"));
        }
        return new SupportFilesSetup((Test)baseTestSuite, new String[]{string + "EmbeddedDataSource-10_0_2_1.ser", string + "EmbeddedConnectionPoolDataSource-10_0_2_1.ser", string + "EmbeddedXADataSource-10_0_2_1.ser", string + "EmbeddedDataSource-10_1_3_1.ser", string + "EmbeddedConnectionPoolDataSource-10_1_3_1.ser", string + "EmbeddedXADataSource-10_1_3_1.ser", string + "ClientDataSource-10_1_3_1.ser", string + "ClientConnectionPoolDataSource-10_1_3_1.ser", string + "ClientXADataSource-10_1_3_1.ser", string + "EmbeddedDataSource-10_2_2_0.ser", string + "EmbeddedConnectionPoolDataSource-10_2_2_0.ser", string + "EmbeddedXADataSource-10_2_2_0.ser", string + "ClientDataSource-10_2_2_0.ser", string + "ClientConnectionPoolDataSource-10_2_2_0.ser", string + "ClientXADataSource-10_2_2_0.ser", string + "EmbeddedDataSource-10_3_2_1.ser", string + "EmbeddedConnectionPoolDataSource-10_3_2_1.ser", string + "EmbeddedXADataSource-10_3_2_1.ser", string + "ClientDataSource-10_3_2_1.ser", string + "ClientConnectionPoolDataSource-10_3_2_1.ser", string + "ClientXADataSource-10_3_2_1.ser", string + "EmbeddedDataSource-10_10_1_0.ser", string + "EmbeddedDataSource40-10_10_1_0.ser", string + "EmbeddedConnectionPoolDataSource-10_10_1_0.ser", string + "EmbeddedConnectionPoolDataSource40-10_10_1_0.ser", string + "EmbeddedXADataSource-10_10_1_0.ser", string + "EmbeddedXADataSource40-10_10_1_0.ser", string + "ClientDataSource-10_10_1_0.ser", string + "ClientDataSource40-10_10_1_0.ser", string + "ClientConnectionPoolDataSource-10_10_1_0.ser", string + "ClientConnectionPoolDataSource40-10_10_1_0.ser", string + "ClientXADataSource-10_10_1_0.ser", string + "ClientXADataSource40-10_10_1_0.ser", string + "BasicEmbeddedDataSource40-10_10_1_0.ser", string + "BasicEmbeddedConnectionPoolDataSource40-10_10_1_0.ser", string + "BasicEmbeddedXADataSource40-10_10_1_0.ser", string + "BasicClientDataSource40-10_10_1_0.ser", string + "BasicClientConnectionPoolDataSource40-10_10_1_0.ser", string + "BasicClientXADataSource40-10_10_1_0.ser", string + "EmbeddedDataSource-10_11_1_0.ser", string + "EmbeddedDataSource40-10_11_1_0.ser", string + "EmbeddedConnectionPoolDataSource-10_11_1_0.ser", string + "EmbeddedConnectionPoolDataSource40-10_11_1_0.ser", string + "EmbeddedXADataSource-10_11_1_0.ser", string + "EmbeddedXADataSource40-10_11_1_0.ser", string + "ClientDataSource-10_11_1_0.ser", string + "ClientDataSource40-10_11_1_0.ser", string + "ClientConnectionPoolDataSource-10_11_1_0.ser", string + "ClientConnectionPoolDataSource40-10_11_1_0.ser", string + "ClientXADataSource-10_11_1_0.ser", string + "ClientXADataSource40-10_11_1_0.ser", string + "BasicEmbeddedDataSource40-10_11_1_0.ser", string + "BasicEmbeddedConnectionPoolDataSource40-10_11_1_0.ser", string + "BasicEmbeddedXADataSource40-10_11_1_0.ser", string + "BasicClientDataSource40-10_11_1_0.ser", string + "BasicClientConnectionPoolDataSource40-10_11_1_0.ser", string + "BasicClientXADataSource40-10_11_1_0.ser"});
    }
}

