/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests.helpers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.IndexStatsUtil;

public class DisposableIndexStatistics {
    private static final int ROW_COUNT = 2000;
    private final DerbyVersion oldVersion;
    private final Connection con;
    private final String tbl;
    private final String fktbl;
    private final String pktbl;

    public DisposableIndexStatistics(DerbyVersion derbyVersion, Connection connection, String string) {
        this.oldVersion = derbyVersion;
        this.con = connection;
        this.tbl = string;
        this.fktbl = string + "_FK";
        this.pktbl = string + "_PK_2COL";
    }

    public void createAndPopulateTables() throws SQLException {
        this.con.setAutoCommit(true);
        Statement statement = this.con.createStatement();
        statement.executeUpdate("create table " + this.pktbl + "( id1 int generated always as identity, id2 int not null)");
        statement.executeUpdate("create table " + this.fktbl + "( id int not null generated always as identity)");
        statement.executeUpdate("create table " + this.tbl + "( id int not null generated always as identity, fk_dropped int not null, fk_self int, fk_self_notnull int not null, nonunique int)");
        this.insertData(this.con);
        IndexStatsUtil indexStatsUtil = new IndexStatsUtil(this.con);
        statement.executeUpdate("alter table " + this.pktbl + " add constraint PK_TWOCOL_PKTAB primary key (id1, id2)");
        indexStatsUtil.getStatsTable(this.pktbl, 2);
        statement.executeUpdate("alter table " + this.fktbl + " add constraint PK_FKTAB primary key (id)");
        indexStatsUtil.getStatsTable(this.fktbl, 1);
        statement.executeUpdate("alter table " + this.tbl + " add constraint PK_MAIN primary key (id)");
        indexStatsUtil.getStatsTable(this.tbl, 1);
        statement.executeUpdate("create index DUPS_MAIN on " + this.tbl + "(nonunique)");
        indexStatsUtil.getStatsTable(this.tbl, 2);
        statement.executeUpdate("alter table " + this.tbl + " add constraint FKS_MAIN foreign key (fk_self) references " + this.tbl + "(id)");
        indexStatsUtil.getStatsTable(this.tbl, 3);
        statement.executeUpdate("alter table " + this.tbl + " add constraint FKSNN_MAIN foreign key (fk_self_notnull) references " + this.tbl + "(id)");
        indexStatsUtil.getStatsTable(this.tbl, 4);
        int n = indexStatsUtil.getStatsTable(this.tbl).length;
        statement.executeUpdate("alter table " + this.tbl + " add constraint fk_to_be_dropped foreign key (fk_dropped) references " + this.fktbl + "(id)");
        Assert.assertTrue((indexStatsUtil.getStatsTable(this.tbl).length == n + 1 ? 1 : 0) != 0);
        statement.executeUpdate("alter table " + this.tbl + " drop constraint fk_to_be_dropped");
        Assert.assertTrue((indexStatsUtil.getStatsTable(this.tbl).length == n ? 1 : 0) != 0);
        statement.executeUpdate("alter table " + this.tbl + " add constraint fk_on_pk foreign key (id) references " + this.fktbl + "(id)");
        statement.executeUpdate("call syscs_util.syscs_update_statistics('APP', '" + this.tbl + "', null)");
        Assert.assertTrue((indexStatsUtil.getStatsTable(this.tbl).length == n + 1 ? 1 : 0) != 0);
        statement.executeUpdate("alter table " + this.tbl + " drop constraint fk_on_pk");
        int n2 = indexStatsUtil.getStatsTable(this.tbl).length;
        if (DisposableIndexStatistics.hasDerby5681Bug(this.oldVersion)) {
            Assert.assertEquals((int)(n + 1), (int)n2);
        } else {
            Assert.assertEquals((int)n, (int)n2);
        }
        int n3 = DisposableIndexStatistics.getNumTotalPossibleStats();
        int n4 = n3 - (DisposableIndexStatistics.getNumNotNeededDisposableStats() + DisposableIndexStatistics.getNumOrphanedDisposableStats());
        int n5 = this.getAllRelevantStats(null);
        Assert.assertTrue((String)("cur=" + n5 + ", min=" + n4), (n5 >= n4 ? 1 : 0) != 0);
        Assert.assertTrue((String)("cur=" + n5 + ", max=" + n3), (n5 <= n3 ? 1 : 0) != 0);
    }

    private void insertData(Connection connection) throws SQLException {
        int n;
        boolean bl = connection.getAutoCommit();
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement("insert into " + this.fktbl + " values (DEFAULT)");
        for (n = 0; n < 2000; ++n) {
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        connection.commit();
        preparedStatement = connection.prepareStatement("insert into " + this.pktbl + " values (DEFAULT, ?)");
        for (n = 0; n < 2000; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        connection.commit();
        preparedStatement = connection.prepareStatement("insert into " + this.tbl + " values (DEFAULT,?,?,?,?)");
        for (n = 0; n < 2000; ++n) {
            preparedStatement.setInt(1, n % 2000 + 1);
            preparedStatement.setInt(2, n % 2000 + 1);
            preparedStatement.setInt(3, n % 19 + 1);
            preparedStatement.setInt(4, n % 10);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        connection.commit();
        connection.setAutoCommit(bl);
    }

    public String[] getTableNames() {
        return new String[]{this.tbl, this.fktbl, this.pktbl};
    }

    public void assertStatsCount(boolean bl, boolean bl2) throws SQLException {
        ArrayList<IndexStatsUtil.IdxStats> arrayList;
        int n;
        int n2 = DisposableIndexStatistics.getNumTotalPossibleStats();
        if (!DisposableIndexStatistics.hasDerby5681Bug(this.oldVersion)) {
            n2 -= DisposableIndexStatistics.getNumOrphanedDisposableStats();
        } else if (bl) {
            n2 -= DisposableIndexStatistics.getNumOrphanedDisposableStats();
        }
        if (bl2) {
            n2 -= DisposableIndexStatistics.getNumNotNeededDisposableStats();
        }
        if ((n = this.getAllRelevantStats(arrayList = new ArrayList<IndexStatsUtil.IdxStats>())) != n2) {
            Assert.assertEquals((String)IndexStatsUtil.buildStatString(this.getStatArray(arrayList), "DisposableIndexStatistics tables"), (int)n2, (int)n);
        }
    }

    private IndexStatsUtil.IdxStats[] getStatArray(List<IndexStatsUtil.IdxStats> list) {
        return list.toArray(new IndexStatsUtil.IdxStats[list.size()]);
    }

    private int getAllRelevantStats(List<IndexStatsUtil.IdxStats> list) throws SQLException {
        boolean bl = this.con.getAutoCommit();
        this.con.setAutoCommit(true);
        IndexStatsUtil indexStatsUtil = new IndexStatsUtil(this.con);
        String[] stringArray = this.getTableNames();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            IndexStatsUtil.IdxStats[] idxStatsArray = indexStatsUtil.getStatsTable(stringArray[i]);
            if (list != null) {
                list.addAll(Arrays.asList(idxStatsArray));
            }
            n += idxStatsArray.length;
        }
        indexStatsUtil.release(false);
        this.con.setAutoCommit(bl);
        return n;
    }

    public static int getNumTotalPossibleStats() {
        return 8;
    }

    public static int getNumNotNeededDisposableStats() {
        return 2;
    }

    public static int getNumOrphanedDisposableStats() {
        return 1;
    }

    public static boolean hasDerby5681Bug(DerbyVersion derbyVersion) {
        if (derbyVersion.atLeast(DerbyVersion._10_9)) {
            return false;
        }
        if (derbyVersion.atMajorMinor(10, 8)) {
            return !derbyVersion.greaterThan(DerbyVersion._10_8_2_2);
        }
        if (derbyVersion.atMajorMinor(10, 7)) {
            return !derbyVersion.greaterThan(DerbyVersion._10_7_1_1);
        }
        if (derbyVersion.atMajorMinor(10, 6)) {
            return !derbyVersion.greaterThan(DerbyVersion._10_6_2_1);
        }
        if (derbyVersion.atMajorMinor(10, 5)) {
            return !derbyVersion.greaterThan(DerbyVersion._10_5_3_0);
        }
        throw new IllegalStateException("didn't expect to get here, old version is " + derbyVersion);
    }
}

