/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;

public class ResultSetsFromPreparedStatementTest
extends BaseJDBCTestCase {
    public static final Integer i1 = 1;
    public static final Integer i2 = 2;
    public static final Integer i3 = 3;
    public static final Integer i4 = 4;
    public static final Integer i5 = 5;
    public static final Integer i6 = 6;
    public static final Integer i7 = 7;
    public static final Integer i8 = 8;
    public static final Integer i9 = 9;
    public static final Integer i10 = 10;
    public static final Integer i11 = 11;
    public static final Integer i12 = 12;
    public static final Integer i13 = 13;
    public static final Integer i14 = 14;
    public static final Integer i15 = 15;
    public static final Integer i16 = 16;
    public static final Integer i17 = 17;
    public static final Integer i18 = 18;
    public static final Integer i19 = 19;
    public static final Integer i20 = 20;
    public static final String k55 = "K55";
    public static final String k52 = "K52";
    public static final String k51 = "K51";
    public static final String ashok = "ASHOK     ";
    public static final String john = "JOHN      ";
    public static final String robin = "ROBIN     ";
    public static final String joe1 = "JOE1      ";
    public static final String joe2 = "JOE2      ";
    public static final String hamid = "HAMID     ";
    public static final String truong = "TRUONG    ";
    public static final String larry1 = "LARRY1    ";
    public static final String larry2 = "LARRY2    ";
    public static final String bobbie = "BOBBIE    ";
    public static final String roger = "ROGER     ";
    public static final String jim = "JIM       ";
    public static final String dan = "DAN       ";
    public static final String sam1 = "SAM1      ";
    public static final String sam2 = "SAM2      ";
    public static final String guy = "GUY       ";
    public static final String don = "DON       ";
    public static final String monica = "MONICA    ";
    public static final String lily1 = "LILY1     ";
    public static final String lily2 = "LILY2     ";
    public static final Object[] db_dept = new Object[]{i1, "K55", "DB        "};
    public static final Object[] ofc_dept = new Object[]{i2, "K52", "OFC       "};
    public static final Object[] cs_dept = new Object[]{i3, "K51", "CS        "};
    public static final Object[][] dept = new Object[][]{db_dept, ofc_dept, cs_dept};
    public static final Object[] ashok_emp = new Object[]{i1, "ASHOK     ", null, "K51"};
    public static final Object[] john_emp = new Object[]{i2, "JOHN      ", "ASHOK     ", "K51"};
    public static final Object[] robin_emp = new Object[]{i3, "ROBIN     ", "ASHOK     ", "K51"};
    public static final Object[] joe1_emp = new Object[]{i4, "JOE1      ", "ASHOK     ", "K51"};
    public static final Object[] joe2_emp = new Object[]{i5, "JOE2      ", "ASHOK     ", "K51"};
    public static final Object[] hamid_emp = new Object[]{i6, "HAMID     ", "JOHN      ", "K55"};
    public static final Object[] truong_emp = new Object[]{i7, "TRUONG    ", "HAMID     ", "K55"};
    public static final Object[] larry1_emp = new Object[]{i8, "LARRY1    ", "HAMID     ", "K55"};
    public static final Object[] larry2_emp = new Object[]{i9, "LARRY2    ", "HAMID     ", "K55"};
    public static final Object[] bobbie_emp = new Object[]{i10, "BOBBIE    ", "HAMID     ", "K55"};
    public static final Object[] roger_emp = new Object[]{i11, "ROGER     ", "ROBIN     ", "K52"};
    public static final Object[] jim_emp = new Object[]{i12, "JIM       ", "ROGER     ", "K52"};
    public static final Object[] dan_emp = new Object[]{i13, "DAN       ", "ROGER     ", "K52"};
    public static final Object[] sam1_emp = new Object[]{i14, "SAM1      ", "ROGER     ", "K52"};
    public static final Object[] sam2_emp = new Object[]{i15, "SAM2      ", "ROGER     ", "K52"};
    public static final Object[] guy_emp = new Object[]{i16, "GUY       ", "JOHN      ", "K55"};
    public static final Object[] don_emp = new Object[]{i17, "DON       ", "GUY       ", "K55"};
    public static final Object[] monica_emp = new Object[]{i18, "MONICA    ", "GUY       ", "K55"};
    public static final Object[] lily1_emp = new Object[]{i19, "LILY1     ", "GUY       ", "K55"};
    public static final Object[] lily2_emp = new Object[]{i20, "LILY2     ", "GUY       ", "K55"};
    public static final Object[][] emp = new Object[][]{ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp};
    private static final String[] mgrs = new String[]{"ASHOK     ", "JOHN      ", "HAMID     ", "ROBIN     ", "ROGER     ", "GUY       "};
    private static final String[] non_mgrs = new String[]{"JOE1      ", "JOE2      ", "TRUONG    ", "LARRY1    ", "LARRY2    ", "BOBBIE    ", "JIM       ", "DAN       ", "SAM1      ", "SAM2      ", "DON       ", "MONICA    ", "LILY1     ", "LILY2     "};
    public static final String SCHEMA = "db2test";
    public static final String CT = "create table ";
    public static final String DS = " (c0 int, dno char(3) not null primary key, dname char(10))";
    public static final String ES = " (c0 int, name char(10) not null primary key, mgrname char(10)";
    public static final String DNO = " dno char(3)";
    public static final String CAS = " on delete cascade";
    public static final String SETN = " on delete set null";
    private Connection c2;
    private Connection c3;
    private static final long DERBY_DEFAULT_TIMEOUT = 60L;
    private static final String SQLSTATE_NULL_INTO_NON_NULL = "23502";

    public static String ref(String string) {
        return " references " + string;
    }

    public static String insertInto(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer("insert into " + string + " values ( ?");
        while (--n > 0) {
            stringBuffer.append(", ?");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String insertFrom(String string, String string2) {
        return "insert into " + string + " select * from " + string2;
    }

    private void createTestTable(String string, String string2, String string3) throws SQLException {
        Statement statement = this.createStatement();
        statement.execute(CT + string + string2);
        statement.execute(ResultSetsFromPreparedStatementTest.insertFrom(string, string3));
        statement.close();
    }

    public static void apply(PreparedStatement preparedStatement, Object[][] objectArray) throws SQLException {
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray[i].length; ++j) {
                Object object = objectArray[i][j];
                if (object == null) {
                    preparedStatement.setNull(j + 1, 1);
                    continue;
                }
                preparedStatement.setObject(j + 1, object);
            }
            preparedStatement.execute();
        }
    }

    private static void assertResultSet(String string, Object[][] objectArray, ResultSet resultSet) throws SQLException {
        int n;
        boolean bl = false;
        try {
            for (n = 0; n < objectArray.length && (bl = resultSet.next()); ++n) {
                ResultSetsFromPreparedStatementTest.assertRow(string + "(row " + (n + 1) + ", ", objectArray[n], resultSet);
            }
            ResultSetsFromPreparedStatementTest.assertEquals((String)(string + " too few rows, "), (int)objectArray.length, (int)n);
            bl = resultSet.next();
            ResultSetsFromPreparedStatementTest.assertFalse((String)(string + " too many rows, expected:<" + objectArray.length + "> but was at least:<" + ++n + ">"), (boolean)bl);
        }
        catch (AssertionFailedError assertionFailedError) {
            System.err.println((Object)assertionFailedError);
            ResultSetsFromPreparedStatementTest.dumpDiff(objectArray, n, resultSet, bl, System.err);
            throw assertionFailedError;
        }
        finally {
            resultSet.close();
        }
    }

    private static void assertRow(String string, Object[] objectArray, ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ResultSetsFromPreparedStatementTest.assertEquals((String)(string + " columns:"), (int)objectArray.length, (int)resultSetMetaData.getColumnCount());
        for (int i = 0; i < objectArray.length; ++i) {
            ResultSetsFromPreparedStatementTest.assertEquals((String)(string + resultSetMetaData.getColumnLabel(i + 1) + ") "), (Object)objectArray[i], (Object)resultSet.getObject(i + 1));
        }
    }

    private static void dump(ResultSet resultSet, PrintStream printStream) throws SQLException {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        for (n = 1; n <= n2; ++n) {
            printStream.print(resultSetMetaData.getColumnLabel(n) + " " + resultSetMetaData.getColumnTypeName(n) + ", ");
        }
        printStream.println("");
        while (resultSet.next()) {
            for (n = 1; n <= n2; ++n) {
                printStream.print(resultSet.getObject(n) + ", ");
            }
            printStream.println("");
        }
        resultSet.close();
    }

    private static void dumpDiff(Object[][] objectArray, int n, ResultSet resultSet, boolean bl, PrintStream printStream) throws SQLException {
        int n2;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        for (n2 = 1; n2 <= n3; ++n2) {
            printStream.print(resultSetMetaData.getColumnLabel(n2) + " " + resultSetMetaData.getColumnTypeName(n2) + ", ");
        }
        printStream.println("");
        while (bl || n < objectArray.length) {
            for (n2 = 1; n2 <= n3; ++n2) {
                Object object = n < objectArray.length ? objectArray[n][n2 - 1] : null;
                Object object2 = bl ? resultSet.getObject(n2) : null;
                printStream.print(object);
                if (object == null || object2 == null || !object2.equals(object)) {
                    printStream.print("<" + object2 + ">");
                }
                printStream.print(", ");
            }
            printStream.println("");
            bl = resultSet.next();
            ++n;
        }
        resultSet.close();
    }

    private static void dumpObjectArray(ResultSet resultSet, PrintStream printStream) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 0;
        String string = "";
        while (resultSet.next()) {
            ++n2;
            printStream.print(string + "{ ");
            string = ",\n";
            String string2 = "";
            for (int i = 1; i <= n; ++i) {
                printStream.print(string2);
                string2 = ", ";
                Object object = resultSet.getObject(i);
                if (object == null) {
                    printStream.print("null");
                    continue;
                }
                if (object instanceof String) {
                    printStream.print("\"" + object + "\"");
                    continue;
                }
                printStream.print("new " + resultSetMetaData.getColumnClassName(i) + "(" + object + ")");
            }
            printStream.print(" }");
        }
        if (n2 > 0) {
            printStream.println("");
        } else {
            printStream.println("<empty ResultSet>");
        }
        resultSet.close();
    }

    private boolean hasTableXLock(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select count(*) from syscs_diag.lock_table where tablename=? and CAST(type AS CHAR(5))='TABLE' and CAST(mode AS CHAR(1))='X'");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSetsFromPreparedStatementTest.assertTrue((boolean)resultSet.next());
        int n = resultSet.getInt(1);
        resultSet.close();
        preparedStatement.close();
        return n != 0;
    }

    protected void setUp() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set schema db2test");
        statement.close();
        this.getConnection().setAutoCommit(false);
        this.c2 = this.openDefaultConnection();
        Statement statement2 = this.c2.createStatement();
        statement2.executeUpdate("set schema db2test");
        statement2.close();
        this.c2.setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        this.c2.rollback();
        this.c2.close();
        this.c2 = null;
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("drop view vemp");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            statement.executeUpdate("drop view vdept");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            statement.executeUpdate("drop table emp");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            statement.executeUpdate("drop table emp2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            statement.executeUpdate("drop table dept");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (this.c3 != null && !this.c3.isClosed()) {
                this.c3.rollback();
                this.c3.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.c3 = null;
        try {
            statement.executeUpdate("drop table APP.FILECHANGES");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            statement.executeUpdate("drop table APP.CHANGESETS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            statement.executeUpdate("drop table APP.AUTHORS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            statement.executeUpdate("drop table APP.FILES");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            statement.executeUpdate("drop table APP.REPOSITORIES");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            statement.executeUpdate("drop table APP.FILECHANGES_2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setTimeout(60L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
        this.commit();
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Create ResultSets from PreparedStatements");
        baseTestSuite.addTestSuite(ResultSetsFromPreparedStatementTest.class);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = statement.getConnection();
                statement.execute("create schema db2test");
                statement.execute("set schema db2test");
                statement.execute("create table dept_data (c0 int, dno char(3) not null primary key, dname char(10))");
                statement.execute("create table emp_data (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))");
                connection.commit();
                PreparedStatement preparedStatement = connection.prepareStatement(ResultSetsFromPreparedStatementTest.insertInto("dept_data", 3));
                ResultSetsFromPreparedStatementTest.apply(preparedStatement, dept);
                connection.commit();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement(ResultSetsFromPreparedStatementTest.insertInto("emp_data", 4));
                ResultSetsFromPreparedStatementTest.apply(preparedStatement, emp);
                connection.commit();
                preparedStatement.close();
            }
        };
        return cleanDatabaseTestSetup;
    }

    public ResultSetsFromPreparedStatementTest(String string) {
        super(string);
    }

    public void testSetTransactionResultSet() throws Exception {
        int n;
        PreparedStatement[] preparedStatementArray = new PreparedStatement[]{this.prepareStatement("set current isolation = read uncommitted"), this.prepareStatement("set current isolation = read committed"), this.prepareStatement("set current isolation = rs"), this.prepareStatement("set current isolation = serializable")};
        int[] nArray = new int[]{1, 2, 4, 8};
        Connection connection = this.getConnection();
        for (n = 0; n < 20; ++n) {
            for (int i = 0; i < preparedStatementArray.length; ++i) {
                preparedStatementArray[i].execute();
                ResultSetsFromPreparedStatementTest.assertEquals((String)("i=" + n + " iso=" + i), (int)nArray[i], (int)connection.getTransactionIsolation());
            }
        }
        for (n = 0; n < preparedStatementArray.length; ++n) {
            preparedStatementArray[n].close();
        }
    }

    public void testCallStatementResultSet() throws Exception {
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        callableStatement.setString(1, "some.property.name");
        PreparedStatement preparedStatement = this.prepareStatement("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('some.property.name')");
        for (int i = 0; i < 20; ++i) {
            Integer n = i;
            callableStatement.setObject(2, (Object)n);
            callableStatement.execute();
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=?=" + i, new Object[][]{{n.toString()}}, resultSet);
            callableStatement.execute();
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=?=" + i, new Object[][]{{n.toString()}}, resultSet);
        }
        callableStatement.close();
        preparedStatement.close();
    }

    public void testVTIResultSet() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("select tablename, schemaname from sys.systables inner join sys.sysschemas on sys.systables.schemaid = sys.sysschemas.schemaid");
        ResultSet resultSet = preparedStatement.executeQuery();
        preparedStatement = this.prepareStatement("select st.conglomeratename from TABLE(SYSCS_DIAG.SPACE_TABLE(?,?)) st where st.isindex = 0");
        while (resultSet.next()) {
            preparedStatement.setString(1, resultSet.getString(2));
            preparedStatement.setString(2, resultSet.getString(1));
            ResultSet resultSet2 = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("BooHoo", new Object[][]{{resultSet.getString(1)}}, resultSet2);
            resultSet2 = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Re-exec", new Object[][]{{resultSet.getString(1)}}, resultSet2);
        }
        resultSet.close();
        preparedStatement.close();
    }

    public void testScalarAggregateResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("select max(c0) from emp where mgrname = ?");
        this.testScalarAggregateResultSet(preparedStatement2, preparedStatement);
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testScalarAggregateResultSet(preparedStatement2, preparedStatement);
        statement.executeUpdate("delete from emp");
        statement.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement statement2 = this.c2.createStatement();
        statement2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        this.testScalarAggregateResultSet(preparedStatement2, null);
        preparedStatement2.close();
        preparedStatement.close();
        statement.close();
        statement2.close();
    }

    private void testScalarAggregateResultSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws SQLException {
        for (int i = 0; i < non_mgrs.length; ++i) {
            preparedStatement.setObject(1, non_mgrs[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            ResultSetsFromPreparedStatementTest.assertNull((Object)resultSet.getObject(1));
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            ResultSetsFromPreparedStatementTest.assertNull((Object)resultSet.getObject(1));
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet.close();
        }
        if (preparedStatement2 == null) {
            return;
        }
        Object[][][] objectArrayArray = new Object[][][]{{{i5}}, {{i16}}, {{i10}}, {{i11}}, {{i15}}, {{i20}}};
        for (int i = 0; i < mgrs.length; ++i) {
            preparedStatement.setObject(1, mgrs[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + mgrs[i], objectArrayArray[i], resultSet);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + mgrs[i], objectArrayArray[i], resultSet);
            preparedStatement2.setString(1, mgrs[i]);
            preparedStatement2.execute();
        }
    }

    public void testLastIndexKeyResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("select ? || max(name) from emp");
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from emp where name = ?");
        this.testLastIndexKeyResultSet(preparedStatement, preparedStatement2);
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testLastIndexKeyResultSet(preparedStatement, preparedStatement2);
        statement.executeUpdate("delete from emp");
        statement.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement statement2 = this.c2.createStatement();
        statement2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        preparedStatement.setString(1, "0_");
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), (Object[][])new String[][]{{"0_TRUONG    "}}, false);
        preparedStatement.close();
        preparedStatement2.close();
        statement.close();
        statement2.close();
    }

    private void testLastIndexKeyResultSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws SQLException {
        Object[][][] objectArrayArray = new Object[][][]{{{"0_TRUONG    "}}, {{"1_SAM2      "}}, {{"2_SAM1      "}}, {{"3_ROGER     "}}, {{"4_ROBIN     "}}, {{"5_MONICA    "}}, {{"6_LILY2     "}}, {{"7_LILY1     "}}, {{"8_LARRY2    "}}, {{"9_LARRY1    "}}, {{"10_JOHN      "}}, {{"11_JOE2      "}}, {{"12_JOE1      "}}, {{"13_JIM       "}}, {{"14_HAMID     "}}, {{"15_GUY       "}}, {{"16_DON       "}}, {{"17_DAN       "}}, {{"18_BOBBIE    "}}, {{"19_ASHOK     "}}, {{null}}};
        for (int i = 0; i < objectArrayArray.length; ++i) {
            preparedStatement.setString(1, Integer.toString(i) + "_");
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("?=" + i + "_", objectArrayArray[i], resultSet);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("R ?=" + i + "_", objectArrayArray[i], resultSet);
            String string = (String)objectArrayArray[i][0][0];
            if (string == null) continue;
            preparedStatement2.setString(1, string.substring(string.indexOf(95) + 1));
            preparedStatement2.execute();
        }
    }

    public void testDistinctScanResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("select ? || T.dm from (select distinct mgrname dm from emp) as T");
        this.testDistinctScanResultSet(preparedStatement2, preparedStatement);
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testDistinctScanResultSet(preparedStatement2, preparedStatement);
        statement.executeUpdate("delete from emp");
        statement.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement statement2 = this.c2.createStatement();
        statement2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        preparedStatement2.setString(1, "0_");
        JDBC.assertDrainResults(preparedStatement2.executeQuery(), 7);
        preparedStatement2.close();
        preparedStatement.close();
        statement.close();
        statement2.close();
    }

    private void testDistinctScanResultSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws SQLException {
        Object[][][] objectArrayArray = new Object[][][]{{{"0_ROGER     "}, {"0_JOHN      "}, {"0_ROBIN     "}, {"0_GUY       "}, {"0_HAMID     "}, {"0_ASHOK     "}, {null}}, {{"1_ROGER     "}, {"1_JOHN      "}, {"1_ROBIN     "}, {"1_GUY       "}, {"1_HAMID     "}, {null}}, {{"2_ROGER     "}, {"2_ROBIN     "}, {"2_GUY       "}, {"2_HAMID     "}, {null}}, {{"3_ROGER     "}, {"3_ROBIN     "}, {"3_GUY       "}, {null}}, {{"4_ROGER     "}, {"4_GUY       "}, {null}}, {{"5_GUY       "}, {null}}, {{null}}};
        for (int i = 0; i < objectArrayArray.length; ++i) {
            preparedStatement.setString(1, Integer.toString(i) + "_");
            ResultSet resultSet = preparedStatement.executeQuery();
            JDBC.assertUnorderedResultSet(resultSet, objectArrayArray[i], false);
            resultSet = preparedStatement.executeQuery();
            JDBC.assertUnorderedResultSet(resultSet, objectArrayArray[i], false);
            if (i >= mgrs.length) continue;
            preparedStatement2.setObject(1, mgrs[i]);
            preparedStatement2.execute();
        }
    }

    public void testDistinctScalarAggregateResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("select count(distinct mgrname)+? from emp");
        this.testDistinctScalarAggregateResultSet(preparedStatement2, preparedStatement);
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testDistinctScalarAggregateResultSet(preparedStatement2, preparedStatement);
        statement.executeUpdate("delete from emp");
        statement.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement statement2 = this.c2.createStatement();
        statement2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        preparedStatement2.setInt(1, 0);
        JDBC.assertFullResultSet(preparedStatement2.executeQuery(), (Object[][])new Integer[][]{{i6}}, false);
        preparedStatement2.close();
        preparedStatement.close();
        statement.close();
        statement2.close();
    }

    private void testDistinctScalarAggregateResultSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws SQLException {
        Object[][][] objectArrayArray = new Object[][][]{{{i6}}, {{i6}}, {{i6}}, {{i6}}, {{i6}}, {{i6}}, {{i6}}};
        for (int i = 0; i < objectArrayArray.length; ++i) {
            preparedStatement.setInt(1, i);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("?=" + i, objectArrayArray[i], resultSet);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + i, objectArrayArray[i], resultSet);
            if (i >= mgrs.length) continue;
            preparedStatement2.setString(1, mgrs[i]);
            preparedStatement2.execute();
        }
    }

    public void testDistinctGroupedAggregateResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("select count(distinct mgrname) nummgrs, dno from emp group by dno having dno <> ?");
        this.testDistinctGroupedAggregateResultSet(preparedStatement2, preparedStatement);
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testDistinctGroupedAggregateResultSet(preparedStatement2, preparedStatement);
        statement.executeUpdate("delete from emp");
        statement.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement statement2 = this.c2.createStatement();
        statement2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        preparedStatement2.setObject(1, dept[0][1]);
        JDBC.assertFullResultSet(preparedStatement2.executeQuery(), (Object[][])new Object[][]{{i1, k51}, {i2, k52}}, false);
        preparedStatement2.close();
        preparedStatement.close();
        statement.close();
        statement2.close();
    }

    private void testDistinctGroupedAggregateResultSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws SQLException {
        Integer n = 0;
        Object[][][][] objectArrayArray = new Object[][][][]{{{{i1, k51}, {i2, k52}}, {{i1, k51}, {i3, k55}}, {{i2, k52}, {i3, k55}}}, {{{n, k51}, {i2, k52}}, {{n, k51}, {i3, k55}}, {{i2, k52}, {i3, k55}}}, {{{n, k51}, {i2, k52}}, {{n, k51}, {i2, k55}}, {{i2, k52}, {i2, k55}}}, {{{n, k51}, {i2, k52}}, {{n, k51}, {i1, k55}}, {{i2, k52}, {i1, k55}}}, {{{n, k51}, {i1, k52}}, {{n, k51}, {i1, k55}}, {{i1, k52}, {i1, k55}}}, {{{n, k51}}, {{n, k51}, {i1, k55}}, {{i1, k55}}}, {{{n, k51}}, {{n, k51}}, new Object[0][]}};
        for (int i = 0; i < objectArrayArray.length; ++i) {
            for (int j = 0; j < dept.length; ++j) {
                preparedStatement.setObject(1, dept[j][1]);
                ResultSet resultSet = preparedStatement.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " d=" + j + "(" + dept[j][1] + ")", objectArrayArray[i][j], resultSet);
                resultSet = preparedStatement.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " d=" + j + "(" + dept[j][1] + ")", objectArrayArray[i][j], resultSet);
            }
            if (i >= mgrs.length) continue;
            preparedStatement2.setString(1, mgrs[i]);
            preparedStatement2.execute();
        }
    }

    public void testGroupedAggregateResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("delete from emp where name = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("select max(name) maxemp, mgrname from emp group by mgrname having mgrname <> ?");
        this.testGroupedAggregateResultSet(preparedStatement2, preparedStatement);
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testGroupedAggregateResultSet(preparedStatement2, preparedStatement);
        statement.executeUpdate("delete from emp");
        statement.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement statement2 = this.c2.createStatement();
        statement2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        preparedStatement2.setString(1, mgrs[0]);
        JDBC.assertDrainResults(preparedStatement2.executeQuery(), 5);
        preparedStatement2.close();
        preparedStatement.close();
        statement.close();
        statement2.close();
    }

    private void testGroupedAggregateResultSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws SQLException {
        Object[][][] objectArrayArray = new Object[][][]{{{monica, guy}, {truong, hamid}, {hamid, john}, {roger, robin}, {sam2, roger}}, {{robin, ashok}, {monica, guy}, {truong, hamid}, {roger, robin}, {sam2, roger}}, {{robin, ashok}, {monica, guy}, {hamid, john}, {roger, robin}, {sam2, roger}}, {{robin, ashok}, {monica, guy}, {truong, hamid}, {guy, john}, {sam2, roger}}, {{joe2, ashok}, {monica, guy}, {truong, hamid}, {guy, john}, {roger, robin}}, {{joe2, ashok}, {truong, hamid}, {guy, john}, {sam2, roger}}};
        for (int i = 0; i < mgrs.length; ++i) {
            preparedStatement.setString(1, mgrs[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("?=" + mgrs[i], objectArrayArray[i], resultSet);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + mgrs[i], objectArrayArray[i], resultSet);
            if (i >= mgrs.length) continue;
            preparedStatement2.setString(1, mgrs[i]);
            preparedStatement2.execute();
        }
    }

    public void testNestedLoopResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("select T.name, T.mgrname, T.dno, dept.dname from dept, (select * from emp where mgrname = ?) as T where dept.dno = T.dno");
        this.testNestedLoopResultSet(preparedStatement2, preparedStatement);
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testNestedLoopResultSet(preparedStatement2, preparedStatement);
        statement.executeUpdate("delete from emp");
        statement.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement statement2 = this.c2.createStatement();
        statement2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        preparedStatement2.setString(1, mgrs[0]);
        JDBC.assertDrainResults(preparedStatement2.executeQuery(), 4);
        preparedStatement2.close();
        preparedStatement.close();
        statement.close();
        statement2.close();
    }

    private void testNestedLoopResultSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws SQLException {
        for (int i = 0; i < non_mgrs.length; ++i) {
            preparedStatement.setString(1, non_mgrs[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet.close();
        }
        Object[][][] objectArrayArray = new Object[][][]{{{john, ashok, k51, "CS        "}, {robin, ashok, k51, "CS        "}, {joe1, ashok, k51, "CS        "}, {joe2, ashok, k51, "CS        "}}, {{hamid, john, k55, "DB        "}, {guy, john, k55, "DB        "}}, {{truong, hamid, k55, "DB        "}, {larry1, hamid, k55, "DB        "}, {larry2, hamid, k55, "DB        "}, {bobbie, hamid, k55, "DB        "}}, {{roger, robin, k52, "OFC       "}}, {{jim, roger, k52, "OFC       "}, {dan, roger, k52, "OFC       "}, {sam1, roger, k52, "OFC       "}, {sam2, roger, k52, "OFC       "}}, {{don, guy, k55, "DB        "}, {monica, guy, k55, "DB        "}, {lily1, guy, k55, "DB        "}, {lily2, guy, k55, "DB        "}}};
        for (int i = 0; i < mgrs.length; ++i) {
            preparedStatement.setString(1, mgrs[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + mgrs[i], objectArrayArray[i], resultSet);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + mgrs[i], objectArrayArray[i], resultSet);
            preparedStatement2.setString(1, mgrs[i]);
            preparedStatement2.execute();
        }
    }

    public void testHashTableResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("delete from emp where mgrname = ?");
        Statement statement = this.createStatement();
        statement.execute("create view vemp as select * from emp");
        statement.execute("create view vdept as select * from dept");
        PreparedStatement preparedStatement2 = this.prepareStatement("select vemp.name, vemp.mgrname, vemp.dno, vdept.dname from vemp inner join vdept on vemp.dno = vdept.dno where mgrname = ?");
        this.testHashTableResultSet(preparedStatement2, preparedStatement);
        statement.executeUpdate("drop view vemp");
        statement.executeUpdate("drop view vdept");
        statement.executeUpdate("drop table dept");
        this.createTestTable("dept", DS, "dept_data");
        statement.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        statement.executeUpdate("create view vemp as select * from emp");
        statement.executeUpdate("create view vdept as select * from dept");
        this.testHashTableResultSet(preparedStatement2, preparedStatement);
        statement.executeUpdate("delete from emp");
        statement.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement statement2 = this.c2.createStatement();
        statement2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        preparedStatement2.setString(1, mgrs[0]);
        JDBC.assertDrainResults(preparedStatement2.executeQuery(), 4);
        preparedStatement2.close();
        preparedStatement.close();
        statement.close();
        statement2.close();
    }

    private void testHashTableResultSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws SQLException {
        for (int i = 0; i < non_mgrs.length; ++i) {
            preparedStatement.setObject(1, non_mgrs[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet.close();
        }
        Object[][][] objectArrayArray = new Object[][][]{{{john, ashok, k51, "CS        "}, {robin, ashok, k51, "CS        "}, {joe1, ashok, k51, "CS        "}, {joe2, ashok, k51, "CS        "}}, {{hamid, john, k55, "DB        "}, {guy, john, k55, "DB        "}}, {{truong, hamid, k55, "DB        "}, {larry1, hamid, k55, "DB        "}, {larry2, hamid, k55, "DB        "}, {bobbie, hamid, k55, "DB        "}}, {{roger, robin, k52, "OFC       "}}, {{jim, roger, k52, "OFC       "}, {dan, roger, k52, "OFC       "}, {sam1, roger, k52, "OFC       "}, {sam2, roger, k52, "OFC       "}}, {{don, guy, k55, "DB        "}, {monica, guy, k55, "DB        "}, {lily1, guy, k55, "DB        "}, {lily2, guy, k55, "DB        "}}};
        for (int i = 0; i < mgrs.length; ++i) {
            preparedStatement.setObject(1, mgrs[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + mgrs[i], objectArrayArray[i], resultSet);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + mgrs[i], objectArrayArray[i], resultSet);
            preparedStatement2.setString(1, mgrs[i]);
            preparedStatement2.execute();
        }
    }

    public void testNestedLoopLeftOuterJoinResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("select emp.name, emp.mgrname, emp.dno, dept.dname from emp left outer join dept on emp.dno = dept.dno where mgrname = ?");
        this.testNestedLoopLeftOuterJoinResultSet(preparedStatement2, preparedStatement);
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table dept");
        this.createTestTable("dept", DS, "dept_data");
        statement.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testNestedLoopLeftOuterJoinResultSet(preparedStatement2, preparedStatement);
        statement.executeUpdate("delete from emp");
        statement.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement statement2 = this.c2.createStatement();
        statement2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        preparedStatement2.setString(1, mgrs[0]);
        JDBC.assertDrainResults(preparedStatement2.executeQuery(), 4);
        preparedStatement2.close();
        preparedStatement.close();
        statement.close();
        statement2.close();
    }

    private void testNestedLoopLeftOuterJoinResultSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws SQLException {
        for (int i = 0; i < non_mgrs.length; ++i) {
            preparedStatement.setObject(1, non_mgrs[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet.close();
        }
        Object[][][] objectArrayArray = new Object[][][]{{{john, ashok, k51, "CS        "}, {robin, ashok, k51, "CS        "}, {joe1, ashok, k51, "CS        "}, {joe2, ashok, k51, "CS        "}}, {{hamid, john, k55, "DB        "}, {guy, john, k55, "DB        "}}, {{truong, hamid, k55, "DB        "}, {larry1, hamid, k55, "DB        "}, {larry2, hamid, k55, "DB        "}, {bobbie, hamid, k55, "DB        "}}, {{roger, robin, k52, "OFC       "}}, {{jim, roger, k52, "OFC       "}, {dan, roger, k52, "OFC       "}, {sam1, roger, k52, "OFC       "}, {sam2, roger, k52, "OFC       "}}, {{don, guy, k55, "DB        "}, {monica, guy, k55, "DB        "}, {lily1, guy, k55, "DB        "}, {lily2, guy, k55, "DB        "}}};
        for (int i = 0; i < mgrs.length; ++i) {
            preparedStatement.setObject(1, mgrs[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + mgrs[i], objectArrayArray[i], resultSet);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + mgrs[i], objectArrayArray[i], resultSet);
            preparedStatement2.setString(1, mgrs[i]);
            preparedStatement2.execute();
        }
    }

    public void testHashLeftOuterJoinResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.createTestTable("emp2", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("select distinct emp.* from emp left outer join emp2 on emp.dno = emp2.dno where emp.mgrname = ? order by emp.c0");
        this.testHashLeftOuterJoinResultSet(preparedStatement2, preparedStatement);
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        statement.executeUpdate("drop table emp2");
        this.createTestTable("emp2", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testHashLeftOuterJoinResultSet(preparedStatement2, preparedStatement);
        statement.executeUpdate("delete from emp");
        statement.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement statement2 = this.c2.createStatement();
        statement2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        preparedStatement2.setString(1, mgrs[0]);
        JDBC.assertDrainResults(preparedStatement2.executeQuery(), 4);
        preparedStatement2.close();
        preparedStatement.close();
        statement.close();
        statement2.close();
    }

    private void testHashLeftOuterJoinResultSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2) throws SQLException {
        for (int i = 0; i < non_mgrs.length; ++i) {
            preparedStatement.setObject(1, non_mgrs[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet.close();
        }
        Object[][][] objectArrayArray = new Object[][][]{{john_emp, robin_emp, joe1_emp, joe2_emp}, {hamid_emp, guy_emp}, {truong_emp, larry1_emp, larry2_emp, bobbie_emp}, {roger_emp}, {jim_emp, dan_emp, sam1_emp, sam2_emp}, {don_emp, monica_emp, lily1_emp, lily2_emp}};
        for (int i = 0; i < mgrs.length; ++i) {
            preparedStatement.setObject(1, mgrs[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + mgrs[i], objectArrayArray[i], resultSet);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + mgrs[i], objectArrayArray[i], resultSet);
            preparedStatement2.setString(1, mgrs[i]);
            preparedStatement2.execute();
        }
    }

    public void testUpdateResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("update dept set dname = ? where dno = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("select dno, dname from dept order by c0");
        Object[][][] objectArrayArray = new Object[][][]{{{k55, "DataBase  "}, {k52, "OFC       "}, {k51, "CS        "}}, {{k55, "DataBase  "}, {k52, "Office    "}, {k51, "CS        "}}, {{k55, "DataBase  "}, {k52, "Office    "}, {k51, "Computer S"}}};
        for (int i = 0; i < objectArrayArray.length; ++i) {
            preparedStatement.setObject(1, objectArrayArray[i][i][1]);
            preparedStatement.setObject(2, objectArrayArray[i][i][0]);
            preparedStatement.executeUpdate();
            ResultSet resultSet = preparedStatement2.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + objectArrayArray[i][i][1] + " ?=" + objectArrayArray[i][i][0], objectArrayArray[i], resultSet);
            preparedStatement.executeUpdate();
            resultSet = preparedStatement2.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + objectArrayArray[i][i][1] + " ?=" + objectArrayArray[i][i][0], objectArrayArray[i], resultSet);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testUpdateResultSetWithIsolation() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("update dept set c0 = c0");
        this.getConnection().setTransactionIsolation(8);
        ResultSetsFromPreparedStatementTest.assertEquals((int)3, (int)preparedStatement.executeUpdate());
        ResultSetsFromPreparedStatementTest.assertTrue((boolean)this.hasTableXLock("DEPT"));
        this.commit();
        ResultSetsFromPreparedStatementTest.assertFalse((boolean)this.hasTableXLock("DEPT"));
        this.getConnection().setTransactionIsolation(2);
        ResultSetsFromPreparedStatementTest.assertEquals((int)3, (int)preparedStatement.executeUpdate());
        ResultSetsFromPreparedStatementTest.assertFalse((boolean)this.hasTableXLock("DEPT"));
        preparedStatement.close();
    }

    public void testCurrentOfResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("select * from dept for update of dname");
        preparedStatement.setCursorName("C1");
        ResultSet resultSet = preparedStatement.executeQuery();
        PreparedStatement preparedStatement2 = this.prepareStatement("update dept set dname = ? where current of C1");
        PreparedStatement preparedStatement3 = this.prepareStatement("select dname from dept");
        Object[][][] objectArrayArray = new Object[][][]{{{"foobar___0"}, {"OFC       "}, {"CS        "}}, {{"foobar___0"}, {"foobar___1"}, {"CS        "}}, {{"foobar___0"}, {"foobar___1"}, {"foobar___2"}}};
        for (int i = 0; i < objectArrayArray.length; ++i) {
            ResultSetsFromPreparedStatementTest.assertTrue((boolean)resultSet.next());
            preparedStatement2.setObject(1, objectArrayArray[i][i][0]);
            preparedStatement2.executeUpdate();
            ResultSet resultSet2 = preparedStatement3.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + objectArrayArray[i][i][0], objectArrayArray[i], resultSet2);
            preparedStatement2.executeUpdate();
            resultSet2 = preparedStatement3.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + objectArrayArray[i][i][0], objectArrayArray[i], resultSet2);
        }
        ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        preparedStatement2.close();
        preparedStatement3.close();
        preparedStatement.close();
    }

    public void testDeleteResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("select * from emp");
        for (int i = 0; i < non_mgrs.length; ++i) {
            preparedStatement.setObject(1, non_mgrs[i]);
            preparedStatement.execute();
            ResultSet resultSet = preparedStatement2.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + non_mgrs[i], emp, resultSet);
            preparedStatement.execute();
            resultSet = preparedStatement2.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + non_mgrs[i], emp, resultSet);
        }
        Object[][][] objectArrayArray = new Object[][][]{{ashok_emp, hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {ashok_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {ashok_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {ashok_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {ashok_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {ashok_emp}};
        for (int i = 0; i < mgrs.length; ++i) {
            preparedStatement.setObject(1, mgrs[i]);
            preparedStatement.execute();
            ResultSet resultSet = preparedStatement2.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + non_mgrs[i], objectArrayArray[i], resultSet);
            preparedStatement.execute();
            resultSet = preparedStatement2.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + non_mgrs[i], objectArrayArray[i], resultSet);
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testDeleteCascadeUpdateResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", ES + ResultSetsFromPreparedStatementTest.ref("emp") + " on delete set null, dno char(3)" + ResultSetsFromPreparedStatementTest.ref("dept") + " on delete set null)", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from emp");
        PreparedStatement preparedStatement3 = this.prepareStatement(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        PreparedStatement preparedStatement4 = this.prepareStatement("select * from emp");
        for (int i = 0; i < mgrs.length; ++i) {
            preparedStatement.setString(1, mgrs[i]);
            preparedStatement.execute();
            preparedStatement2.execute();
            ResultSet resultSet = preparedStatement4.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
            resultSet.close();
            preparedStatement3.execute();
        }
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
        preparedStatement4.close();
    }

    public void testSetOpResultSet_intersect() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("select * from emp where dno = ? intersect select * from emp where mgrname = ?");
        Object[][][][] objectArrayArray = new Object[][][][]{{new Object[0][], {hamid_emp, guy_emp}, {truong_emp, larry1_emp, larry2_emp, bobbie_emp}, new Object[0][], new Object[0][], {don_emp, monica_emp, lily1_emp, lily2_emp}}, {new Object[0][], new Object[0][], new Object[0][], {roger_emp}, {jim_emp, dan_emp, sam1_emp, sam2_emp}, new Object[0][]}, {{john_emp, robin_emp, joe1_emp, joe2_emp}, new Object[0][], new Object[0][], new Object[0][], new Object[0][], new Object[0][]}};
        for (int i = 0; i < dept.length; ++i) {
            preparedStatement.setObject(1, dept[i][1]);
            for (int j = 0; j < mgrs.length; ++j) {
                preparedStatement.setString(2, mgrs[j]);
                ResultSet resultSet = preparedStatement.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("?=" + dept[i][1] + " ?=" + mgrs[j], objectArrayArray[i][j], resultSet);
                resultSet = preparedStatement.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + dept[i][1] + " ?=" + mgrs[j], objectArrayArray[i][j], resultSet);
            }
        }
        preparedStatement.close();
    }

    public void testSetOpResultSet_except() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("select * from emp where dno = ? except select * from emp where mgrname = ?");
        Object[][][][] objectArrayArray = new Object[][][][]{{{hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {truong_emp, larry1_emp, larry2_emp, bobbie_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp}}, {{roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}}, {{ashok_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}}};
        for (int i = 0; i < dept.length; ++i) {
            preparedStatement.setObject(1, dept[i][1]);
            for (int j = 0; j < mgrs.length; ++j) {
                preparedStatement.setString(2, mgrs[j]);
                ResultSet resultSet = preparedStatement.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("?=" + dept[i][1] + " ?=" + mgrs[j], objectArrayArray[i][j], resultSet);
                resultSet = preparedStatement.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + dept[i][1] + " ?=" + mgrs[j], objectArrayArray[i][j], resultSet);
            }
        }
        preparedStatement.close();
    }

    public void testUnionResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("(select * from emp where dno = ?) union (select * from emp where mgrname = ?)");
        Object[][][][] objectArrayArray = new Object[][][][]{{{john_emp, robin_emp, joe1_emp, joe2_emp, hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, roger_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}}, {{john_emp, robin_emp, joe1_emp, joe2_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {hamid_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, guy_emp}, {truong_emp, larry1_emp, larry2_emp, bobbie_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, don_emp, monica_emp, lily1_emp, lily2_emp}}, {{ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, hamid_emp, guy_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, roger_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, don_emp, monica_emp, lily1_emp, lily2_emp}}};
        for (int i = 0; i < dept.length; ++i) {
            preparedStatement.setObject(1, dept[i][1]);
            for (int j = 0; j < mgrs.length; ++j) {
                preparedStatement.setString(2, mgrs[j]);
                ResultSet resultSet = preparedStatement.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("?=" + dept[i][1] + " ?=" + mgrs[j], objectArrayArray[i][j], resultSet);
                resultSet = preparedStatement.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + dept[i][1] + " ?=" + mgrs[j], objectArrayArray[i][j], resultSet);
            }
        }
        preparedStatement.close();
    }

    public void testOnceResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("select * from emp where c0 = (values (1+?) union values (1+?))");
        for (int i = 0; i < emp.length; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i, new Object[][]{emp[i]}, resultSet);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i, new Object[][]{emp[i]}, resultSet);
        }
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.prepareStatement("select * from emp where name = (select name from emp where c0 <= ? intersect select name from emp where c0 >= ?)");
        for (int i = 0; i < emp.length; ++i) {
            preparedStatement2.setInt(1, i + 1);
            preparedStatement2.setInt(2, i + 1);
            ResultSet resultSet = preparedStatement2.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i, new Object[][]{emp[i]}, resultSet);
            resultSet = preparedStatement2.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i, new Object[][]{emp[i]}, resultSet);
        }
        preparedStatement2.close();
    }

    public void testAnyResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("select * from ( values 'EXISTED' ) as T(result) where exists ((select name from emp where c0 <= ?) intersect (select name from emp where c0 >= ?))");
        Object[][] objectArray = new Object[][]{{"EXISTED"}};
        Object[][] objectArray2 = new Object[][]{};
        for (int i = 0; i < emp.length; ++i) {
            preparedStatement.setInt(1, i + 1);
            preparedStatement.setInt(2, i + 1);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("?=" + (i + 1) + " ?=" + (i + 1), objectArray, resultSet);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + (i + 1) + " ?=" + (i + 1), objectArray, resultSet);
            preparedStatement.setInt(1, i);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("?=" + i + " ?=" + (i + 1), objectArray2, resultSet);
            resultSet = preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + i + " ?=" + (i + 1), objectArray2, resultSet);
        }
        preparedStatement.close();
    }

    private void testGeneratedIdentity(String string, String string2) throws Exception {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE T(GI " + string + " PRIMARY KEY GENERATED " + string2 + " AS IDENTITY (START WITH 5, INCREMENT BY 10), L VARCHAR(8))");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO T(L) VALUES('implicit')");
        preparedStatement.executeUpdate();
        preparedStatement.executeUpdate();
        preparedStatement.executeUpdate();
        PreparedStatement preparedStatement2 = this.prepareStatement("INSERT INTO T(GI, L) VALUES(DEFAULT, 'explicit')");
        preparedStatement2.executeUpdate();
        preparedStatement2.executeUpdate();
        preparedStatement2.executeUpdate();
    }

    public void testIntGeneratedByDefaultAsIdentity() throws Exception {
        this.testGeneratedIdentity("INT", "BY DEFAULT");
    }

    public void testSmallintGeneratedByDefaultAsIdentity() throws Exception {
        this.testGeneratedIdentity("SMALLINT", "BY DEFAULT");
    }

    public void testBigintGeneratedByDefaultAsIdentity() throws Exception {
        this.testGeneratedIdentity("BIGINT", "BY DEFAULT");
    }

    public void testIntGeneratedAlwaysAsIdentity() throws Exception {
        this.testGeneratedIdentity("INT", "ALWAYS");
    }

    public void testSmallintGeneratedAlwaysAsIdentity() throws Exception {
        this.testGeneratedIdentity("SMALLINT", "ALWAYS");
    }

    public void testBigintGeneratedAlwaysAsIdentity() throws Exception {
        this.testGeneratedIdentity("BIGINT", "ALWAYS");
    }

    public void testSetMaxRowsTable() throws SQLException {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement preparedStatement = this.prepareStatement("select * from emp_data", 1004, 1007);
        ResultSetsFromPreparedStatementTest.assertTrue((JDBC.assertDrainResults(preparedStatement.executeQuery()) >= 20 ? 1 : 0) != 0);
        preparedStatement.setMaxRows(5);
        JDBC.assertDrainResults(preparedStatement.executeQuery(), 5);
        preparedStatement.setMaxRows(20);
        JDBC.assertDrainResults(preparedStatement.executeQuery(), 20);
    }

    public void testSetMaxRowsValues() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("values 0,1,2,3,4,5,6,7,8,9", 1004, 1007);
        preparedStatement.setMaxRows(10);
        JDBC.assertDrainResults(preparedStatement.executeQuery(), 10);
        preparedStatement.setMaxRows(2);
        JDBC.assertDrainResults(preparedStatement.executeQuery(), 2);
    }

    private void testRuntimeStatistics(String string, String string2) throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call syscs_util.syscs_set_runtimestatistics(1)");
        if (string2 != null) {
            statement.execute("call syscs_util.syscs_set_xplain_schema('" + string2.toUpperCase() + "')");
        }
        PreparedStatement preparedStatement = this.prepareStatement(string);
        for (int i = 0; i < 5; ++i) {
            preparedStatement.execute();
            while (true) {
                if (preparedStatement.getMoreResults()) {
                    JDBC.assertDrainResults(preparedStatement.getResultSet());
                    continue;
                }
                if (preparedStatement.getUpdateCount() == -1) break;
            }
            RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
            ResultSetsFromPreparedStatementTest.assertTrue((String)"Wrong statement", (boolean)runtimeStatisticsParser.findString(string, 1));
        }
        if (string2 != null) {
            statement.execute("call syscs_util.syscs_set_xplain_schema('')");
            PreparedStatement preparedStatement2 = this.prepareStatement("select count(*) from " + string2 + ".sysxplain_statements where stmt_text = ?");
            preparedStatement2.setString(1, string);
            JDBC.assertSingleValueResultSet(preparedStatement2.executeQuery(), "5");
        }
    }

    public void testRuntimeStatisticsForSelect() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.testRuntimeStatistics("select * from dept", "select_stats");
    }

    public void testRuntimeStatisticsForUpdate() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.testRuntimeStatistics("update dept set dname = upper(dname)", "update_stats");
    }

    public void testRuntimeStatisticsForInsert() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.testRuntimeStatistics("insert into dept select * from dept where 1<>1", "insert_stats");
    }

    public void testRuntimeStatisticsForDelete() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.testRuntimeStatistics("delete from dept", "delete_stats");
    }

    public void testRuntimeStatisticsForValues() throws SQLException {
        this.testRuntimeStatistics("values (1, 2, 3, 'this is a test')", "values_stats");
    }

    public void testRuntimeStatisticsForCall() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.testRuntimeStatistics("call syscs_util.syscs_compress_table(current schema, 'DEPT', 1)", null);
    }

    public void testDerby4330_JoinResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_join_tables();
        PreparedStatement preparedStatement = this.prepareStatement("SELECT CS.REVISION, A.NAME, CS.TIME, CS.MESSAGE, F.PATH FROM CHANGESETS CS, FILECHANGES FC,            REPOSITORIES R, FILES F, AUTHORS A WHERE F.REPOSITORY = R.ID AND A.REPOSITORY = R.ID AND CS.REPOSITORY = R.ID AND CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND A.ID = CS.AUTHOR AND EXISTS ( SELECT 1 FROM FILES F2 WHERE F2.ID = FC.FILE AND F2.REPOSITORY = R.ID) ORDER BY CS.ID DESC");
        this.c3 = this.openDefaultConnection();
        this.c3.setAutoCommit(false);
        Statement statement = this.c3.createStatement();
        statement.execute("LOCK TABLE FILECHANGES IN EXCLUSIVE MODE");
        statement.close();
        try {
            preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException sQLException) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", sQLException);
        }
        this.c3.rollback();
        this.c3.close();
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSetsFromPreparedStatementTest.assertTrue((boolean)resultSet.next());
        ResultSetsFromPreparedStatementTest.assertEquals((String)resultSet.getString(2), (String)"xyz");
        ResultSetsFromPreparedStatementTest.assertFalse((boolean)resultSet.next());
        preparedStatement.close();
    }

    public void testDerby4330_UnionResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_union_tables();
        PreparedStatement preparedStatement = this.prepareStatement("SELECT * FROM (SELECT * FROM FILECHANGES_2  UNION SELECT * FROM FILECHANGES) X");
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT * FROM (SELECT * FROM FILECHANGES  UNION SELECT * FROM FILECHANGES_2) X");
        this.c3 = this.openDefaultConnection();
        this.c3.setAutoCommit(false);
        Statement statement = this.c3.createStatement();
        statement.execute("LOCK TABLE FILECHANGES IN EXCLUSIVE MODE");
        statement.close();
        try {
            preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException sQLException) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", sQLException);
        }
        try {
            preparedStatement2.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException sQLException) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", sQLException);
        }
        this.c3.rollback();
        this.c3.close();
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "1", "1"}});
        resultSet = preparedStatement2.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "1", "1"}});
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testDerby4330_SetOpResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_union_tables();
        String[] stringArray = new String[]{"EXCEPT", "INTERSECT"};
        String[][][] stringArrayArray = new String[][][]{null, {{"1", "1", "1"}}};
        for (int i = 0; i < 2; ++i) {
            PreparedStatement preparedStatement = this.prepareStatement("SELECT * FROM (SELECT * FROM FILECHANGES_2 " + stringArray[i] + " SELECT * FROM FILECHANGES) X ORDER BY ID");
            PreparedStatement preparedStatement2 = this.prepareStatement("SELECT * FROM (SELECT * FROM FILECHANGES " + stringArray[i] + " SELECT * FROM FILECHANGES_2) X ORDER BY ID");
            this.c3 = this.openDefaultConnection();
            this.c3.setAutoCommit(false);
            Statement statement = this.c3.createStatement();
            statement.execute("LOCK TABLE FILECHANGES IN EXCLUSIVE MODE");
            statement.close();
            try {
                preparedStatement.executeQuery();
                ResultSetsFromPreparedStatementTest.fail();
            }
            catch (SQLException sQLException) {
                ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", sQLException);
            }
            try {
                preparedStatement2.executeQuery();
                ResultSetsFromPreparedStatementTest.fail();
            }
            catch (SQLException sQLException) {
                ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", sQLException);
            }
            this.c3.rollback();
            this.c3.close();
            ResultSet resultSet = preparedStatement.executeQuery();
            if (stringArrayArray[i] != null) {
                JDBC.assertFullResultSet(resultSet, stringArrayArray[i]);
            } else {
                JDBC.assertEmpty(resultSet);
            }
            resultSet = preparedStatement2.executeQuery();
            if (stringArrayArray[i] != null) {
                JDBC.assertFullResultSet(resultSet, stringArrayArray[i]);
            } else {
                JDBC.assertEmpty(resultSet);
            }
            preparedStatement.close();
            preparedStatement2.close();
        }
    }

    public void testDerby4330_GroupedAggregateResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_union_tables();
        PreparedStatement preparedStatement = this.prepareStatement("SELECT SUM(CHANGESET) from FILECHANGES GROUP BY FILE");
        this.c3 = this.openDefaultConnection();
        this.c3.setAutoCommit(false);
        Statement statement = this.c3.createStatement();
        statement.execute("INSERT INTO FILECHANGES(FILE,CHANGESET) VALUES (2,2)");
        statement.close();
        try {
            preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException sQLException) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", sQLException);
        }
        this.c3.rollback();
        this.c3.close();
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        preparedStatement.close();
    }

    public void testDerby4330_DistinctGroupedAggregateResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_union_tables();
        PreparedStatement preparedStatement = this.prepareStatement("SELECT SUM(DISTINCT CHANGESET) from FILECHANGES GROUP BY FILE");
        this.c3 = this.openDefaultConnection();
        this.c3.setAutoCommit(false);
        Statement statement = this.c3.createStatement();
        statement.execute("INSERT INTO FILECHANGES(FILE,CHANGESET) VALUES (2,2)");
        statement.close();
        try {
            preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException sQLException) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", sQLException);
        }
        this.c3.rollback();
        this.c3.close();
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        preparedStatement.close();
    }

    public void testDerby4330_DistinctScalarAggregateResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_union_tables();
        PreparedStatement preparedStatement = this.prepareStatement("SELECT SUM(DISTINCT CHANGESET) from FILECHANGES");
        this.c3 = this.openDefaultConnection();
        this.c3.setAutoCommit(false);
        Statement statement = this.c3.createStatement();
        statement.execute("INSERT INTO FILECHANGES(FILE,CHANGESET) VALUES (2,2)");
        statement.close();
        try {
            preparedStatement.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException sQLException) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", sQLException);
        }
        this.c3.rollback();
        this.c3.close();
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        preparedStatement.close();
    }

    private void setTimeout(long l) throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call syscs_util.syscs_set_database_property('derby.locks.waitTimeout', '" + l + "')");
        statement.close();
    }

    private void createDerby4330_join_tables() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE REPOSITORIES (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,PATH VARCHAR(32672) UNIQUE NOT NULL)");
        statement.execute("INSERT INTO REPOSITORIES(PATH) VALUES ('r')");
        statement.execute("CREATE TABLE FILES (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,PATH VARCHAR(32672) NOT NULL,REPOSITORY INT NOT NULL REFERENCES REPOSITORIES    ON DELETE CASCADE,UNIQUE (REPOSITORY, PATH))");
        statement.execute("INSERT INTO FILES(PATH, REPOSITORY) VALUES ('/adsf',1)");
        statement.execute("CREATE TABLE AUTHORS (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,REPOSITORY INT NOT NULL REFERENCES REPOSITORIES            ON DELETE CASCADE,NAME VARCHAR(32672) NOT NULL,UNIQUE (REPOSITORY, NAME))");
        statement.execute("INSERT INTO AUTHORS(REPOSITORY, NAME) VALUES (1, 'xyz')");
        statement.execute("CREATE TABLE CHANGESETS (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,REPOSITORY INT NOT NULL REFERENCES REPOSITORIES            ON DELETE CASCADE,REVISION VARCHAR(1024) NOT NULL,AUTHOR INT NOT NULL REFERENCES AUTHORS ON DELETE CASCADE,TIME TIMESTAMP NOT NULL,MESSAGE VARCHAR(32672) NOT NULL,UNIQUE (REPOSITORY, REVISION))");
        statement.execute("INSERT INTO CHANGESETS(REPOSITORY, REVISION,                        AUTHOR, TIME, MESSAGE) VALUES (1,'',1,CURRENT_TIMESTAMP,'')");
        statement.execute("CREATE TABLE FILECHANGES (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,FILE INT NOT NULL REFERENCES FILES ON DELETE CASCADE,CHANGESET INT NOT NULL REFERENCES CHANGESETS ON DELETE CASCADE,UNIQUE (FILE, CHANGESET))");
        statement.execute("INSERT INTO FILECHANGES(FILE,CHANGESET) VALUES (1,1)");
        statement.close();
        this.commit();
    }

    private void createDerby4330_union_tables() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE FILECHANGES (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,FILE INT NOT NULL,CHANGESET INT NOT NULL,UNIQUE (FILE, CHANGESET))");
        statement.execute("CREATE TABLE FILECHANGES_2 (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,FILE INT NOT NULL,CHANGESET INT NOT NULL,UNIQUE (FILE, CHANGESET))");
        statement.execute("INSERT INTO FILECHANGES(FILE,CHANGESET) VALUES (1,1)");
        statement.execute("INSERT INTO FILECHANGES_2(FILE,CHANGESET) VALUES (1,1)");
        statement.close();
        this.commit();
    }

    private void setSchema(String string) throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("SET SCHEMA " + string);
        statement.close();
    }

    public void testInsertNullIntoNonNullableColumn() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d4488_t1 (pk int primary key)");
        statement.execute("insert into d4488_t1 values 1");
        statement.execute("create table d4488_t2 (c1 int, c2 int not null)");
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("insert into d4488_t2(c1) select 1 from d4488_t1");
        for (int i = 0; i < 5; ++i) {
            ResultSetsFromPreparedStatementTest.assertStatementError(SQLSTATE_NULL_INTO_NON_NULL, preparedStatement);
            this.rollback();
        }
    }
}

