/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.IdentitySequenceTest;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class AutoIncrementTest
extends BaseJDBCTestCase {
    public AutoIncrementTest(String string) {
        super(string);
    }

    private static void createSchemaObjects(Statement statement) throws SQLException {
        statement.executeUpdate("create table ai_zero (i int, a_zero int generated always as identity)");
        statement.executeUpdate("create table ai_one (i int, a_one smallint generated always as identity)");
        statement.executeUpdate("create table ai_two (i int, a_two int generated always as identity)");
        statement.executeUpdate("create table ai_three (i int, a_three int generated always as identity)");
        statement.executeUpdate("create table ai (i  int, autoinc int generated always as identity (start with 100))");
        statement.executeUpdate("create table ai1 (i int, autoinc1 int generated always as identity (increment by 100))");
        statement.executeUpdate("create table ai2 (i int,autoinc2 int generated always as identity (start with 101, increment by 100))");
        statement.executeUpdate("create table ai3 (i int,a11 int generated always as identity (start with  0, increment by -1))");
        statement.executeUpdate("create table ai4 (i int,a21 int generated always as identity (start with  +0, increment by -1))");
        statement.executeUpdate("create table ai5 (i int, a31 int generated always as identity (start with  -1, increment by -1))");
        statement.executeUpdate("create table ai6 (i int, a41 int generated always as identity (start with  -11, increment by +100))");
        statement.executeUpdate("create table ai_short (i int,ais smallint generated always as identity (start with 0, increment by 2))");
        statement.executeUpdate("create table ai_single1 (i int, a0 int generated always as identity (start with  -1, increment by -1))");
        statement.executeUpdate("create table ai_single2 (i int, a1 smallint generated always as identity)");
        statement.executeUpdate("create table ai_single3 (i int, a2 int generated always as identity (start with 0))");
        statement.executeUpdate("create table ai_single4 (i int, a3 bigint generated always as identity(start with  -100, increment by 10))");
        statement.executeUpdate("create table ai_test (x int generated always as identity (start with 2, increment by 2),y int)");
        statement.executeUpdate("create table ai_single1conn (c char(100), a_odd int generated always as identity (start with 1, increment by 2))");
        statement.executeUpdate("create table ai_single2conn (c char(100), a_even int generated always as identity (start with 0, increment by 2))");
        statement.executeUpdate("create table ai_single3conn (c char(100), a_sum bigint generated always as identity (start with 1, increment by 2))");
        statement.executeUpdate("create table t1 (c1 int generated always as identity, name char(32))");
        statement.executeUpdate("create table t2 (c2 int generated always as identity, name char(32))");
        statement.executeUpdate("create trigger insert_trigger after insert on t1 for each row insert into t2 (name) values ('Bob Finocchio')");
        statement.executeUpdate("create table tab1(s1 int generated always as identity,lvl int)");
        statement.executeUpdate("create table tab3 (c1 int)");
        statement.executeUpdate("create trigger tab1_after1 after insert on tab3 referencing new as newrow for each row insert into tab1 (lvl) values 1,2,3");
        statement.executeUpdate("create table tab1schema (i int, a1 int generated always as identity (start with -1, increment by -1))");
        statement.executeUpdate("create table tab2schema (i int, a2 smallint generated always as identity (start with 1, increment by +1))");
        statement.executeUpdate("create table tab3schema (i int, a1 int generated always as identity (start with 0, increment by -2))");
        statement.executeUpdate("create table tab4schema (i int, a2 bigint generated always as identity (start with 0, increment by 2))");
        statement.executeUpdate("create table t1_1 (x int, s1 int generated always as identity)");
        statement.executeUpdate("create table t2_1 (x smallint, s2 int generated always as identity (start with 0))");
        statement.executeUpdate("create table t1_2 (s1 int generated always as identity)");
        statement.executeUpdate("alter table t1_2 add column x int");
        statement.executeUpdate("create table t2_2 (s2 int generated always as identity (start with 2))");
        statement.executeUpdate("alter table t2_2 add column x int");
        statement.executeUpdate("create table t3_2 (s0 int generated always as identity (start with 0))");
        statement.executeUpdate("alter table t3_2 add column x int");
        statement.executeUpdate("create table trigtest (s1 smallint generated always as identity, lvl int)");
        statement.executeUpdate("create table t1_col (x char(2) default 'yy', y bigint generated always as identity)");
        statement.executeUpdate("create table testme (text varchar(10), autonum int generated always as identity)");
        statement.executeUpdate("create table ai_neg (x smallint generated always as identity, y int)");
        statement.executeUpdate("create table ai_over1 (x int, y int generated always as identity (increment by 200000000))");
        statement.executeUpdate("create table ai_over2 (x int, y smallint generated always as identity (start with  -32760, increment by -1))");
        statement.executeUpdate("create table ai_over3 (x int, y int generated always as identity (start with  2147483646))");
        statement.executeUpdate("create table ai_over4 (x int, y bigint generated always as identity(start with     9223372036854775805))");
        statement.executeUpdate("create table base (x int)");
        statement.executeUpdate("create table always (a int)");
        statement.executeUpdate("create table start (a int)");
        statement.executeUpdate("create table generated (a int)");
        statement.executeUpdate("create table idt1(c1 int generated always as identity, c2 int)");
        statement.executeUpdate("create table autoinct2 (a int, b int generated always as identity)");
        statement.executeUpdate("create table autoinct1(c1 int generated always as identity)");
        statement.executeUpdate("create table autoinct3(c1 int generated always as identity (increment by 3))");
        statement.execute("create table withinct1(i int, withinct1_autogen int generated always as identity)");
        statement.execute("create table withinct2(i int, withinct2_autogen int generated by default as identity)");
        statement.execute("create table withinctempt1(i int, withinct1_autogen int generated always as identity)");
        statement.execute("create table withinctempt2(i int, withinct2_autogen int generated by default as identity)");
        statement.execute("create table withinct3(i int, withinct3_autogen int generated always as identity(increment by 10))");
        statement.execute("create table withinct4(i int, withinct4_autogen int generated by default as identity(increment by 10))");
        statement.execute("create table variantt1 (c11 int generated always as identity (start with 101, increment by 3), c12 int)");
        statement.execute("create table variantt2 (c21 int generated always as identity (start with 201, increment by 5), c22 int)");
        statement.execute("create trigger variantt1tr1 after insert on variantt1 for each row insert into variantt2 (c22) values (1)");
        statement.execute("create table restartt1 (rec11 int generated by default as identity(start with 2, increment by 2), c12 int)");
        statement.execute("create table cycle1 (rec21 int generated by default as identity(start with 2, increment by 2), c32 int)");
        statement.execute("create table t1lock(lockc11 int generated by default as identity (start with 1, increment by 1), c12 int)");
        statement.execute("create unique index t1locki1 on t1lock(lockc11)");
        statement.execute("create table restart (c11 int)");
        statement.execute("create table newTable (restart int)");
        statement.execute("create table newTable2 (c11 int)");
        statement.execute("alter table newTable2 add column RESTART int");
        statement.execute("CREATE TABLE DERBY_1495 (testid INT GENERATED BY DEFAULT AS IDENTITY(START WITH 1, INCREMENT BY 1) NOT NULL,testcol2 INT NOT NULL)");
        statement.execute("create table derby_1645 (testTableId INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL,testStringValue VARCHAR(20) not null,constraint PK_derby_1645 primary key (testTableId))");
        statement.execute("create table D1644 (d1644c1 int, d1644c2 int generated by default as identity)");
        statement.execute("create table D1644_A (d1644_Ac1 int, d1644_Ac2 int generated by default as identity, c3 int)");
        statement.execute("create table D1644_B (d1644_Bc1 int generated by default as identity)");
        statement.execute("create table d4006 (x varchar(5) default 'abc')");
        statement.execute("create table d4006_a (z int generated always as identity)");
        statement.execute("create table d4419_t1(x int)");
        statement.execute("insert into d4419_t1 values 1,2");
        statement.execute("create table d4419_t2(x int)");
        statement.execute("insert into d4419_t2 values 2,3");
        statement.execute("create table d4419_t3(x int, y int generated always as identity)");
        statement.execute("insert into d4419_t3(x) select * from d4419_t1 union select * from d4419_t2");
        statement.execute("create table lockt1 (x int, yyyy int generated always as identity (start with  0))");
        statement.execute("create view lock_table as select cast(username as char(8)) as username, cast(t.type as char(8)) as trantype,cast(l.type as char(8)) as type, cast(lockcount as char(3)) as cnt, mode, cast(tablename as char(12)) as tabname,state, status from  syscs_diag.lock_table l right outer join syscs_diag.transaction_table t on l.xid = t.xid  where t.type='UserTransaction' and l.lockcount is not null");
        statement.execute("create table uniquet1(i int, t1_autogen int generated always as identity(start with 100, increment by 20))");
        statement.execute("create table uniquet2(i int, t2_autogen int generated by default as identity(start with 100, increment by 20))");
        statement.execute("create table uniquetempt1(i int, t1_autogen int generated always as identity(start with 100, increment by 20))");
        statement.execute("create table uniquetempt2(i int, t2_autogen int generated by default as identity(start with 100, increment by 20))");
        statement.execute("create table uniquet3(i int,uniquet3_autogen int generated by default as identity(start with 0, increment by 1) unique)");
        statement.execute("create table uniquet4(i int,uniquet4_autogen int generated by default as identity(start with 0, increment by 1))");
        statement.execute("create unique index idx_uniquet4_autogen on uniquet4(uniquet4_autogen)");
        statement.execute("create table withinctempt3(i int, t1_autogen int generated always as identity(increment by 10))");
        statement.execute("create table withinctempt4(i int, t2_autogen int generated by default as identity(increment by 10))");
    }

    public void testderbyIncrementTest() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME in ('A_ZERO','A_ONE', 'A_TWO', 'A_THREE') order by COLUMNNAME");
        String[][] stringArray = new String[][]{{"A_ONE", "1", "1", "1"}, {"A_THREE", "1", "1", "1"}, {"A_TWO", "1", "1", "1"}, {"A_ZERO", "1", "1", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testautoIncSysColTest() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME = 'AUTOINC'");
        String[][] stringArray = new String[][]{{"100", "100", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME = 'AUTOINC1'");
        stringArray = new String[][]{{"1", "1", "100"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME = 'AUTOINC2'");
        stringArray = new String[][]{{"101", "101", "100"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testnegative() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME = 'A11'");
        String[][] stringArray = new String[][]{{"0", "0", "-1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME = 'A21'");
        stringArray = new String[][]{{"0", "0", "-1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME = 'A31'");
        stringArray = new String[][]{{"-1", "-1", "-1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME = 'A41'");
        stringArray = new String[][]{{"-11", "-11", "100"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testsimpleincrement() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into ai_short (i) values (0)");
        statement.executeUpdate("insert into ai_short (i) values (1)");
        statement.executeUpdate("insert into ai_short (i) values (2)");
        statement.executeUpdate("insert into ai_short (i) values (33)");
        ResultSet resultSet = statement.executeQuery("select * from ai_short order by i");
        String[][] stringArray = new String[][]{{"0", "0"}, {"1", "2"}, {"2", "4"}, {"33", "6"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        this.vetSequenceState("ai_short", 8L, 0L, 2L);
    }

    private void vetSequenceState(String string, long l, long l2, long l3) throws Exception {
        Connection connection = this.getConnection();
        String string2 = IdentitySequenceTest.getIdentitySequenceName(connection, string);
        ResultSet resultSet = connection.prepareStatement("select s.startValue, s.increment\nfrom sys.syssequences s\nwhere sequenceName = '" + string2 + "'").executeQuery();
        String[][] stringArray = new String[][]{{Long.toString(l2), Long.toString(l3)}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = connection.prepareStatement("values syscs_util.syscs_peek_at_identity( 'APP', '" + string.toUpperCase() + "' )").executeQuery();
        stringArray = new String[][]{{Long.toString(l)}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testonegeneratedcolumn() throws Exception {
        String string;
        Statement statement = this.createStatement();
        Integer n = 1;
        while (n < 11) {
            string = "insert into ai_single1 (i) values (" + n.toString() + ")";
            statement.executeUpdate(string);
            string = "insert into ai_single2 (i) values (" + n.toString() + ")";
            statement.executeUpdate(string);
            string = "insert into ai_single3 (i) values (" + n.toString() + ")";
            statement.executeUpdate(string);
            string = "insert into ai_single4 (i) values (" + n.toString() + ")";
            statement.executeUpdate(string);
            int n2 = n + 1;
            n = n2;
        }
        ResultSet resultSet = statement.executeQuery("select a.i, a0, a1, a2, a3 from ai_single1 a join ai_single2 b on a.i = b.i join ai_single3 c on a.i = c.i join ai_single4 d on a.i = d.i order by a.i");
        string = new String[][]{{"1", "-1", "1", "0", "-100"}, {"2", "-2", "2", "1", "-90"}, {"3", "-3", "3", "2", "-80"}, {"4", "-4", "4", "3", "-70"}, {"5", "-5", "5", "4", "-60"}, {"6", "-6", "6", "5", "-50"}, {"7", "-7", "7", "6", "-40"}, {"8", "-8", "8", "7", "-30"}, {"9", "-9", "9", "8", "-20"}, {"10", "-10", "10", "9", "-10"}};
        JDBC.assertFullResultSet(resultSet, (String[][])string);
        statement.executeUpdate("delete from ai_single1");
        statement.executeUpdate("delete from ai_single2");
        statement.executeUpdate("delete from ai_single3");
        statement.executeUpdate("delete from ai_single4");
        statement.executeUpdate("insert into ai_single1 (i) values (1)");
        statement.executeUpdate("insert into ai_single2 (i) values (1)");
        statement.executeUpdate("insert into ai_single3 (i) values (1)");
        statement.executeUpdate("insert into ai_single4 (i) values (1)");
        resultSet = statement.executeQuery("select a.i, a0, a1, a2, a3 from ai_single1 a join ai_single2 b on a.i = b.i join ai_single3 c on a.i = c.i join ai_single4 d on a.i = d.i");
        string = new String[][]{{"1", "-11", "11", "10", "0"}};
        JDBC.assertFullResultSet(resultSet, (String[][])string);
        AutoIncrementTest.assertStatementError("428C1", statement, "create table ai_multiple (i int, a0 int generated always as identity (start with  -1,increment by -1),a1 smallint generated always as identity,a2 int generated always as identity (start with  0),a3 bigint generated always as identity (start with  -100,increment by 10))");
    }

    public void testConnectionInfo() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into ai_test (y) values (1),(2),(3),(4),(5),(6),(7),(8),(9),(10)");
        ResultSet resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        String[][] stringArray = new String[][]{{null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into ai_test (y) select y+10 from ai_test");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into ai_single1conn (c) values ('a')");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into ai_single2conn (c) values ('a')");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"0"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into ai_single3conn (c) values ('a')");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into ai_single1conn (c) values ('b')");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"3"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into ai_single2conn (c) values ('b')");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into ai_single3conn (c) values ('b')");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"3"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testTrigger() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into t1 (name) values ('Phil White')");
        ResultSet resultSet = statement.executeQuery("select * from t1");
        String[][] stringArray = new String[][]{{"1", "Phil White"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from t2");
        stringArray = new String[][]{{"1", "Bob Finocchio"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into t2 (name) values ('Jean-Yves Dexemier')");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testSchema() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create schema BPP");
        statement.executeUpdate("set schema BPP");
        statement.executeUpdate("create table tab1schema (i int, a1 int generated always as identity (start with 100, increment by 1))");
        statement.executeUpdate("create table tab2schema (i int, a2 bigint generated always as identity (start with 100, increment by -1))");
        statement.executeUpdate("create table tab3schema (i int, a1 int generated always as identity (start with 100, increment by 2))");
        statement.executeUpdate("create table tab4schema (i int, a2 smallint generated always as identity (start with 100, increment by -2))");
        statement.executeUpdate("insert into APP.tab1schema (i) values (1)");
        statement.executeUpdate("insert into APP.tab2schema (i) values (1)");
        statement.executeUpdate("insert into APP.tab3schema (i) values (1)");
        statement.executeUpdate("insert into APP.tab4schema (i) values (1)");
        statement.executeUpdate("insert into tab1schema (i) values (1)");
        statement.executeUpdate("insert into tab1schema (i) values (2)");
        statement.executeUpdate("insert into tab2schema (i) values (1)");
        statement.executeUpdate("insert into tab2schema (i) values (2)");
        statement.executeUpdate("insert into tab3schema (i) values (1)");
        statement.executeUpdate("insert into tab3schema (i) values (2)");
        statement.executeUpdate("insert into tab4schema (i) values (1)");
        statement.executeUpdate("insert into tab4schema (i) values (2)");
        ResultSet resultSet = statement.executeQuery("select a.i, a1, a2 from app.tab1schema a join app.tab2schema b on a.i = b.i");
        String[][] stringArray = new String[][]{{"1", "-1", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select a.i, a1, a2 from app.tab3schema a join app.tab4schema b on a.i = b.i");
        stringArray = new String[][]{{"1", "0", "0"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select a.i, a1, a2 from tab1schema a join tab2schema b on a.i = b.i order by a.i");
        stringArray = new String[][]{{"1", "100", "100"}, {"2", "101", "99"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select a1, a2, a.i from tab3schema a join tab4schema b on a.i = b.i order by a1");
        stringArray = new String[][]{{"100", "100", "1"}, {"102", "98", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"98"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("set schema APP");
        statement.executeUpdate("drop table BPP.tab1schema");
        statement.executeUpdate("drop table BPP.tab2schema");
        statement.executeUpdate("drop table BPP.tab3schema");
        statement.executeUpdate("drop table BPP.tab4schema");
        statement.executeUpdate("drop schema BPP restrict");
        statement.executeUpdate("insert into tab3 values null");
        resultSet = statement.executeQuery("select * from tab1 order by s1");
        stringArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        this.vetSequenceState("TAB1", 4L, 1L, 1L);
        statement.executeUpdate("create table tab2 (lvl int, s1  bigint generated always as identity)");
        statement.executeUpdate("create trigger tab1_after2 after insert on tab3 referencing new as newrow for each row insert into tab2 (lvl) values 1,2,3");
        statement.executeUpdate("insert into tab3 values null");
        resultSet = statement.executeQuery("select * from tab2 order by lvl");
        stringArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        this.vetSequenceState("TAB2", 4L, 1L, 1L);
    }

    public void testadditionalSysCol() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into t1_1 (x) values (1)");
        ResultSet resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        String[][] stringArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into t1_1 (x) values (2)");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into t2_1 (x) values (1)");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"0"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into t1_2 (x) values (1),(2),(3),(4),(5)");
        statement.executeUpdate("insert into t2_2 (x) values (1),(2),(3),(4),(5)");
        statement.executeUpdate("insert into t3_2 (x) values (1),(2),(3),(4),(5)");
        resultSet = statement.executeQuery("select a.x, s1, s2, s0 from t1_2 a join t2_2 b on a.x = b.x join t3_2 c on a.x = c.x order by a.x");
        stringArray = new String[][]{{"1", "1", "2", "0"}, {"2", "2", "3", "1"}, {"3", "3", "4", "2"}, {"4", "4", "5", "3"}, {"5", "5", "6", "4"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"0"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into trigtest (lvl) values (0)");
        statement.executeUpdate("insert into trigtest (lvl) values (1),(2)");
        statement.executeUpdate("insert into trigtest (lvl) values (3),(4)");
        statement.executeUpdate("insert into trigtest (lvl) values (5),(6)");
        statement.executeUpdate("insert into trigtest (lvl) values (7),(8)");
        resultSet = statement.executeQuery("select * from trigtest order by s1");
        stringArray = new String[][]{{"1", "0"}, {"2", "1"}, {"3", "2"}, {"4", "3"}, {"5", "4"}, {"6", "5"}, {"7", "6"}, {"8", "7"}, {"9", "8"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select count(*) from t1_2");
        stringArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("delete from t1_2");
        statement.executeUpdate("delete from t2_2");
        statement.executeUpdate("delete from t3_2");
        statement.executeUpdate("insert into t1_2 (x) values (1),(2),(3),(4),(5)");
        statement.executeUpdate("insert into t2_2 (x) values (1),(2),(3),(4),(5)");
        statement.executeUpdate("insert into t3_2 (x) values (1),(2),(3),(4),(5)");
        resultSet = statement.executeQuery("select a.x, s1, s2, s0 from t1_2 a join t2_2 b on a.x = b.x join t3_2 c on a.x = c.x order by a.x");
        stringArray = new String[][]{{"1", "6", "7", "5"}, {"2", "7", "8", "6"}, {"3", "8", "9", "7"}, {"4", "9", "10", "8"}, {"5", "10", "11", "9"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into t1_2 (x) values (6)");
        statement.executeUpdate("insert into t2_2 (x) values (6)");
        statement.executeUpdate("insert into t3_2 (x) values (6)");
        resultSet = statement.executeQuery("select a.x, s1, s2, s0 from t1_2  a join t2_2 b on a.x = b.x join t3_2 c on a.x = c.x order by a.x");
        stringArray = new String[][]{{"1", "6", "7", "5"}, {"2", "7", "8", "6"}, {"3", "8", "9", "7"}, {"4", "9", "10", "8"}, {"5", "10", "11", "9"}, {"6", "11", "12", "10"}};
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("delete from t1_2");
        statement.executeUpdate("delete from t2_2");
        statement.executeUpdate("delete from t3_2");
        statement.executeUpdate("insert into t1_2 (x) values (1),(2),(3),(4),(5)");
        statement.executeUpdate("insert into t2_2 (x) values (1),(2),(3),(4),(5)");
        statement.executeUpdate("insert into t3_2 (x) values (1),(2),(3),(4),(5)");
        resultSet = statement.executeQuery("select a.x, s1, s2, s0 from t1_2 a join t2_2 b on a.x = b.x join t3_2 c on a.x = c.x order by a.x");
        stringArray = new String[][]{{"1", "12", "13", "11"}, {"2", "13", "14", "12"}, {"3", "14", "15", "13"}, {"4", "15", "16", "14"}, {"5", "16", "17", "15"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into t1_2 (x) values (6)");
        statement.executeUpdate("insert into t2_2 (x) values (6)");
        statement.executeUpdate("insert into t3_2 (x) values (6)");
        resultSet = statement.executeQuery("select a.x, s1, s2, s0 from t1_2 a join t2_2 b on a.x = b.x join t3_2 c on a.x = c.x order by a.x");
        stringArray = new String[][]{{"1", "12", "13", "11"}, {"2", "13", "14", "12"}, {"3", "14", "15", "13"}, {"4", "15", "16", "14"}, {"5", "16", "17", "15"}, {"6", "17", "18", "16"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"16"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testsyslocks() throws Exception {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.execute("insert into lockt1 (x) values (1)");
        statement.execute("insert into lockt1 (x) values (2)");
        ResultSet resultSet = statement.executeQuery("select * from lockt1 order by x");
        String[][] stringArray = new String[][]{{"1", "0"}, {"2", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from lock_table order by username, trantype, type, cnt");
        stringArray = new String[][]{{"APP   ", "UserTran", "ROW     ", "1  ", "X", "LOCKT1      ", "GRANT", "ACTIVE"}, {"APP   ", "UserTran", "ROW     ", "1  ", "X", "LOCKT1      ", "GRANT", "ACTIVE"}, {"APP   ", "UserTran", "TABLE   ", "2  ", "IX", "LOCKT1      ", "GRANT", "ACTIVE"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("delete from lockt1");
        this.commit();
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt");
        stringArray = new String[][]{};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("set isolation serializable");
        resultSet = statement.executeQuery("select columnname, autoincrementvalue from sys.syscolumns where columnname = 'YYYY'");
        stringArray = new String[][]{{"APP     ", "UserTran", "TABLE   ", "1   ", "S   ", "SYSCOLUMNS  ", "GRANT", "ACTIVE"}};
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt");
        stringArray = new String[][]{{"APP     ", "UserTran", "TABLE   ", "1  ", "S", "SYSCOLUMNS  ", "GRANT", "ACTIVE"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into lockt1 (x) values (3)");
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt");
        stringArray = new String[][]{{"APP     ", "UserTran", "TABLE   ", "1  ", "IX", "LOCKT1      ", "GRANT", "ACTIVE"}, {"APP     ", "UserTran", "ROW     ", "1  ", "X", "LOCKT1      ", "GRANT", "ACTIVE"}, {"APP     ", "UserTran", "TABLE   ", "1  ", "S", "SYSCOLUMNS  ", "GRANT", "ACTIVE"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        this.commit();
    }

    public void testColoumnSpecs() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into t1_col (x, y) values ('aa', default)");
        statement.executeUpdate("insert into t1_col values ('bb', default)");
        statement.executeUpdate("insert into t1_col (x) values default");
        statement.executeUpdate("insert into t1_col (x) values null");
        statement.executeUpdate("insert into t1_col (y, x) values (default, 'cc')");
        ResultSet resultSet = statement.executeQuery("select * from t1_col order by y");
        String[][] stringArray = new String[][]{{"aa", "1"}, {"bb", "2"}, {"yy", "3"}, {null, "4"}, {"cc", "5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testbug3450() throws Exception {
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into testme (text) values ?");
        preparedStatement.setString(1, "one");
        preparedStatement.execute();
        preparedStatement.setString(1, "two");
        preparedStatement.execute();
        preparedStatement.setString(1, "three");
        preparedStatement.execute();
        ResultSet resultSet = statement.executeQuery("select * from testme order by autonum");
        String[][] stringArray = new String[][]{{"one", "1"}, {"two", "2"}, {"three", "3"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        preparedStatement.setString(1, "four");
        preparedStatement.execute();
        preparedStatement.setString(1, "four");
        preparedStatement.execute();
        resultSet = statement.executeQuery("select * from testme order by autonum");
        stringArray = new String[][]{{"one", "1"}, {"two", "2"}, {"three", "3"}, {"four", "4"}, {"four", "5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("drop table testme");
    }

    public void testnegativeinvalidtype() throws Exception {
        Statement statement = this.createStatement();
        Statement statement2 = this.createStatement();
        AutoIncrementTest.assertStatementError("42Z22", statement, "create table ni (x int, y char(1) generated always as identity)");
        AutoIncrementTest.assertStatementError("42Z22", statement, "create table ni (x int, y decimal(5,2) generated always as identity)");
        AutoIncrementTest.assertStatementError("42Z22", statement, "create table ni (x int, y float generated always as identity (start with 1, increment by 1))");
        AutoIncrementTest.assertStatementError("42Z22", statement, "create table ni (s int, y varchar(10) generated always as identity)");
        AutoIncrementTest.assertStatementError("42Z21", statement, "create table ni (x int, y int generated always as identity (increment by 0))");
        AutoIncrementTest.assertStatementError("42Z21", statement, "create table ni (x int, y int generated always as identity (start with 0, increment by 0))");
        AutoIncrementTest.assertStatementError("42Z21", statement, "create table ni (x int, y smallint generated always as identity (increment by 0))");
        AutoIncrementTest.assertStatementError("42Z21", statement, "create table ni (x int, y smallint generated always as identity (start with 0, increment by 0))");
        AutoIncrementTest.assertStatementError("42X01", statement, "create table ni (x int, y int generated always as identity (increment by 0)");
        AutoIncrementTest.assertStatementError("42Z21", statement, "create table ni (x int, y int generated always as identity (start with 0, increment by 0))");
        AutoIncrementTest.assertStatementError("42Z21", statement, "create table ni (x int, y bigint generated always as identity (increment by 0))");
        AutoIncrementTest.assertStatementError("42Z21", statement, "create table ni (x int, y bigint generated always as identity (start with 0, increment by 0))");
        AutoIncrementTest.assertStatementError("42Z21", statement, "create table ni (x int, y bigint generated always as identity (start with 0, increment by 0))");
        AutoIncrementTest.assertStatementError("22003", statement, "create table ni (x int, y smallint generated always as identity (start with 32768))");
        AutoIncrementTest.assertStatementError("22003", statement, "create table ni (x int, y smallint generated always as identity (start with -32769))");
        AutoIncrementTest.assertStatementError("22003", statement, "create table ni (x int, y int generated always as identity (start with  2147483648))");
        AutoIncrementTest.assertStatementError("22003", statement, "create table ni (x int, y int generated always as identity (start with  -2147483649))");
        AutoIncrementTest.assertStatementError("42X49", statement, "create table ni (x int, y int generated always as identity (start with  9223372036854775808))");
        AutoIncrementTest.assertStatementError("42X49", statement, "create table ni (x int, y bigint  generated always as identity (start with  -9223372036854775809))");
        statement2.executeUpdate("insert into ai_neg (y) values (0),(1),(2),(3),(4),(5),(6),(7),(8),(9),(10)");
        ResultSet resultSet = statement2.executeQuery("select * from ai_neg order by x");
        String[][] stringArray = new String[][]{{"1", "0"}, {"2", "1"}, {"3", "2"}, {"4", "3"}, {"5", "4"}, {"6", "5"}, {"7", "6"}, {"8", "7"}, {"9", "8"}, {"10", "9"}, {"11", "10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("delete from ai_neg where y=8 OR y=4");
        statement2.executeUpdate("insert into ai_neg (y) values (11),(13),(14),(15),(17),(18),(19)");
        resultSet = statement2.executeQuery("select * from ai_neg order by x");
        stringArray = new String[][]{{"1", "0"}, {"2", "1"}, {"3", "2"}, {"4", "3"}, {"6", "5"}, {"7", "6"}, {"8", "7"}, {"10", "9"}, {"11", "10"}, {"12", "11"}, {"13", "13"}, {"14", "14"}, {"15", "15"}, {"16", "17"}, {"17", "18"}, {"18", "19"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("update ai_neg set y=-y");
        resultSet = statement2.executeQuery("select * from ai_neg order by x");
        stringArray = new String[][]{{"1", "0"}, {"2", "-1"}, {"3", "-2"}, {"4", "-3"}, {"6", "-5"}, {"7", "-6"}, {"8", "-7"}, {"10", "-9"}, {"11", "-10"}, {"12", "-11"}, {"13", "-13"}, {"14", "-14"}, {"15", "-15"}, {"16", "-17"}, {"17", "-18"}, {"18", "-19"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("update ai_neg set y=-y");
        resultSet = statement2.executeQuery("select * from ai_neg order by x");
        stringArray = new String[][]{{"1", "0"}, {"2", "1"}, {"3", "2"}, {"4", "3"}, {"6", "5"}, {"7", "6"}, {"8", "7"}, {"10", "9"}, {"11", "10"}, {"12", "11"}, {"13", "13"}, {"14", "14"}, {"15", "15"}, {"16", "17"}, {"17", "18"}, {"18", "19"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("update ai_neg set y=4 where y=3");
        resultSet = statement2.executeQuery("select * from ai_neg order by x");
        stringArray = new String[][]{{"1", "0"}, {"2", "1"}, {"3", "2"}, {"4", "4"}, {"6", "5"}, {"7", "6"}, {"8", "7"}, {"10", "9"}, {"11", "10"}, {"12", "11"}, {"13", "13"}, {"14", "14"}, {"15", "15"}, {"16", "17"}, {"17", "18"}, {"18", "19"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        AutoIncrementTest.assertStatementError("42Z23", statement, "insert into ai_neg values (1,2)");
    }

    public void testOverflow() throws Exception {
        Statement statement = this.createStatement();
        Statement statement2 = this.createStatement();
        AutoIncrementTest.assertStatementError("2200H", statement, "insert into ai_over1 (x) values (1),(2),(3),(4),(5),(6),(7),(8),(9),(10),(11),(12),(13),(14),(15),(16),(17),(18),(19)");
        AutoIncrementTest.assertStatementError("2200H", statement, "insert into ai_over1 (x) values (1)");
        statement2.executeUpdate("insert into ai_over2 (x) values (1),(2),(3),(4),(5),(6),(7),(8)");
        AutoIncrementTest.assertStatementError("2200H", statement, "insert into ai_over2 (x) values (9),(10)");
        String[][] stringArray = new String[][]{{"1", "-32760"}, {"2", "-32761"}, {"3", "-32762"}, {"4", "-32763"}, {"5", "-32764"}, {"6", "-32765"}, {"7", "-32766"}, {"8", "-32767"}};
        ResultSet resultSet = statement2.executeQuery("select * from ai_over2 order by x");
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("insert into ai_over3 (x) values (1)");
        statement2.executeUpdate("insert into ai_over3 (x) values (2)");
        resultSet = statement2.executeQuery("select * from ai_over3 order by x");
        stringArray = new String[][]{{"1", "2147483646"}, {"2", "2147483647"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        AutoIncrementTest.assertStatementError("2200H", statement, "insert into ai_over3 (x) select x from ai_over3");
        statement2.executeUpdate("insert into ai_over4 (x) values (1),(2),(3)");
        AutoIncrementTest.assertStatementError("2200H", statement, "insert into ai_over4 (x) values (4)");
        resultSet = statement2.executeQuery("select * from ai_over4 order by x");
        stringArray = new String[][]{{"1", "9223372036854775805"}, {"2", "9223372036854775806"}, {"3", "9223372036854775807"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testIdentity() throws Exception {
        Statement statement = this.createStatement();
        Statement statement2 = this.createStatement();
        statement.executeUpdate("insert into base values (1),(2),(3),(4),(5),(6)");
        String[][] stringArray = new String[][]{{"1", "10"}, {"2", "11"}, {"3", "12"}, {"4", "13"}, {"5", "14"}, {"6", "15"}};
        AutoIncrementTest.assertUpdateCount(statement, 0, "alter table base add column y smallint generated always as identity (start with 10)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from base order by x"), stringArray);
        AutoIncrementTest.assertUpdateCount(statement, 0, "alter table base drop column y");
        AutoIncrementTest.assertUpdateCount(statement, 0, "alter table base add column y int generated always as identity (start with 10)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from base order by x"), stringArray);
        AutoIncrementTest.assertUpdateCount(statement, 0, "alter table base drop column y");
        AutoIncrementTest.assertUpdateCount(statement, 0, "alter table base add column y bigint generated always as identity (start with 10)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from base order by x"), stringArray);
        AutoIncrementTest.assertUpdateCount(statement, 0, "alter table base drop column y");
        AutoIncrementTest.assertUpdateCount(statement, 0, "alter table base add column y bigint generated always as identity (start with 10)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from base order by x"), stringArray);
        AutoIncrementTest.assertUpdateCount(statement, 0, "alter table base drop column y");
        ResultSet resultSet = statement.executeQuery("select * from base order by x");
        stringArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("insert into idt1(c2) values (8)");
        resultSet = statement2.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement2.executeQuery("select IDENTITY_VAL_LOCAL()+1, IDENTITY_VAL_LOCAL()-1 from idt1");
        stringArray = new String[][]{{"2", "0"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("insert into idt1(c2) values (IDENTITY_VAL_LOCAL())");
        resultSet = statement2.executeQuery("select * from idt1 order by c1");
        stringArray = new String[][]{{"1", "8"}, {"2", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement2.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement2.executeQuery("select IDENTITY_VAL_LOCAL()+1, IDENTITY_VAL_LOCAL()-1 from idt1");
        stringArray = new String[][]{{"3", "1"}, {"3", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("insert into idt1(c2) values (8), (9)");
        resultSet = statement2.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement2.executeQuery("select * from idt1 order by c1");
        stringArray = new String[][]{{"1", "8"}, {"2", "1"}, {"3", "8"}, {"4", "9"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("insert into idt1(c2) select c1 from idt1");
        resultSet = statement2.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement2.executeQuery("select * from idt1 order by c1");
        stringArray = new String[][]{{"1", "8"}, {"2", "1"}, {"3", "8"}, {"4", "9"}, {"5", "1"}, {"6", "2"}, {"7", "3"}, {"8", "4"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("delete from idt1");
        resultSet = statement2.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("insert into idt1(c2) select c1 from idt1");
        resultSet = statement2.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.executeUpdate("insert into idt1(c2) values (8)");
        resultSet = statement2.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"9"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testdefaultautoincrement() throws Exception {
        Statement statement = this.createStatement();
        Statement statement2 = this.createStatement();
        statement.executeUpdate("insert into autoinct1 values (default)");
        ResultSet resultSet = statement.executeQuery("select * from autoinct1");
        String[][] stringArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct1 values (1), (1)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct1 values (1), (default)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct1 values (default), (1)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct1 values (default), (default), (default), (2)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct1 values (default), (default), (2)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct1 values (default), (default), (2), (default)");
        statement.executeUpdate("insert into autoinct1 values (default), (default)");
        resultSet = statement.executeQuery("select * from autoinct1 order by c1");
        stringArray = new String[][]{{"1"}, {"2"}, {"3"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into autoinct1 values (default), (default), (default)");
        resultSet = statement.executeQuery("select * from autoinct1 order by c1");
        stringArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into autoinct1 values (default), (default), (default),(default)");
        resultSet = statement.executeQuery("select * from autoinct1 order by c1");
        stringArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}, {"9"}, {"10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into autoinct2 values (1, default), (2, default)");
        resultSet = statement.executeQuery("select * from autoinct2 order by a");
        stringArray = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct2 values (1, default), (2, 2)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct2 values (1, default), (2, default), (2, 2)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct2 values (1, 2), (2, default), (2, default)");
        statement.executeUpdate("insert into autoinct3 values (default)");
        resultSet = statement.executeQuery("select * from autoinct3");
        stringArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into autoinct3 values (default)");
        resultSet = statement.executeQuery("select * from autoinct3 order by c1");
        stringArray = new String[][]{{"1"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct3 values (1), (default)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct3 values (default), (1)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct3 values (default), (default), (default), (2)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct3 values (default), (default), (2)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct3 values (default), (default), (2), (default)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into autoinct3 select * from autoinct1");
        statement.executeUpdate("insert into autoinct3 values (default), (default)");
        resultSet = statement.executeQuery("select * from autoinct3 order by c1");
        stringArray = new String[][]{{"1"}, {"4"}, {"7"}, {"10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into autoinct3 values (default), (default), (default)");
        resultSet = statement.executeQuery("select * from autoinct3 order by c1");
        stringArray = new String[][]{{"1"}, {"4"}, {"7"}, {"10"}, {"13"}, {"16"}, {"19"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("insert into autoinct3 values (default), (default), (default),(default)");
        resultSet = statement.executeQuery("select * from autoinct3 order by c1");
        stringArray = new String[][]{{"1"}, {"4"}, {"7"}, {"10"}, {"13"}, {"16"}, {"19"}, {"22"}, {"25"}, {"28"}, {"31"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("drop table autoinct1");
        statement.executeUpdate("drop table autoinct2");
        statement.executeUpdate("drop table autoinct3");
    }

    public void testwithIncrement() throws Exception {
        Statement statement = this.createStatement();
        Statement statement2 = this.createStatement();
        statement.execute("insert into withinct1(i) values(1)");
        statement.execute("insert into withinct1(i) values(1)");
        ResultSet resultSet = statement.executeQuery("select * from withinct1 order by withinct1_autogen");
        String[][] stringArray = new String[][]{{"1", "1"}, {"1", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into withinct2(i) values(1)");
        statement.execute("insert into withinct2(i) values(1)");
        resultSet = statement.executeQuery("select * from withinct2 order by withinct2_autogen");
        stringArray = new String[][]{{"1", "1"}, {"1", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into withinctempt1(i,withinct1_autogen) values(2,1)");
        AutoIncrementTest.assertStatementError("42Z23", statement2, "insert into withinctempt1(i,withinct1_autogen) values(2,2)");
        statement.execute("insert into withinctempt1(i) values(2)");
        statement.execute("insert into withinctempt1(i) values(2)");
        resultSet = statement.executeQuery("select * from withinctempt1 order by withinct1_autogen");
        stringArray = new String[][]{{"2", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into withinctempt2(i,withinct2_autogen) values(2,1)");
        statement.execute("insert into withinctempt2(i,withinct2_autogen) values(2,2)");
        statement.execute("insert into withinctempt2(i) values(2)");
        statement.execute("insert into withinctempt2(i) values(2)");
        resultSet = statement.executeQuery("select * from withinctempt2 order by withinct2_autogen, i");
        stringArray = new String[][]{{"2", "1"}, {"2", "1"}, {"2", "2"}, {"2", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into withinctempt3(i) values(1)");
        statement.execute("insert into withinctempt3(i) values(1)");
        resultSet = statement.executeQuery("select * from withinctempt3 order by t1_autogen");
        stringArray = new String[][]{{"1", "1"}, {"1", "11"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into withinctempt4(i) values(1)");
        statement.execute("insert into withinctempt4(i) values(1)");
        resultSet = statement.executeQuery("select * from withinctempt4 order by t2_autogen");
        stringArray = new String[][]{{"1", "1"}, {"1", "11"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        AutoIncrementTest.assertStatementError("42Z23", statement, "insert into withinct3(i,withinct3_autogen) values(2,1)");
        AutoIncrementTest.assertStatementError("42Z23", statement, "insert into withinct3(i,withinct3_autogen) values(2,2)");
        statement.execute("insert into withinct3(i) values(2)");
        statement.execute("insert into withinct3(i) values(2)");
        resultSet = statement.executeQuery("select * from withinct3 order by withinct3_autogen");
        stringArray = new String[][]{{"2", "1"}, {"2", "11"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into withinct4(i,withinct4_autogen) values(2,1)");
        statement.execute("insert into withinct4(i,withinct4_autogen) values(2,2)");
        statement.execute("insert into withinct4(i) values(2)");
        statement.execute("insert into withinct4(i) values(2)");
        resultSet = statement.executeQuery("select * from withinct4 order by withinct4_autogen");
        stringArray = new String[][]{{"2", "1"}, {"2", "1"}, {"2", "2"}, {"2", "11"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testunique() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("insert into uniquet1(i) values(1)");
        statement.execute("insert into uniquet1(i) values(1)");
        String[][] stringArray = new String[][]{{"1", "100"}, {"1", "120"}};
        ResultSet resultSet = statement.executeQuery("select * from uniquet1 order by t1_autogen");
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into uniquet2(i) values(1)");
        statement.execute("insert into uniquet2(i) values(1)");
        stringArray = new String[][]{{"1", "100"}, {"1", "120"}};
        resultSet = statement.executeQuery("select * from uniquet2 order by t2_autogen");
        JDBC.assertFullResultSet(resultSet, stringArray);
        AutoIncrementTest.assertStatementError("42Z23", statement, "insert into uniquetempt1(i,t1_autogen) values(2,1)");
        AutoIncrementTest.assertStatementError("42Z23", statement, "insert into uniquetempt1(i,t1_autogen) values(2,2)");
        statement.execute("insert into uniquetempt1(i) values(2)");
        statement.execute("insert into uniquetempt1(i) values(2)");
        stringArray = new String[][]{{"2", "100"}, {"2", "120"}};
        resultSet = statement.executeQuery("select * from uniquetempt1 order by t1_autogen");
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into uniquetempt2(i,t2_autogen) values(2,1)");
        statement.execute("insert into uniquetempt2(i,t2_autogen) values(2,2)");
        statement.execute("insert into uniquetempt2(i) values(2)");
        statement.execute("insert into uniquetempt2(i) values(2)");
        stringArray = new String[][]{{"2", "1"}, {"2", "2"}, {"2", "100"}, {"2", "120"}};
        statement.execute("insert into uniquet3(i,uniquet3_autogen) values(1,0)");
        statement.execute("insert into uniquet3(i,uniquet3_autogen) values(2,1)");
        AutoIncrementTest.assertStatementError("23505", statement, "insert into uniquet3(i) values(3)");
        AutoIncrementTest.assertStatementError("23505", statement, "insert into uniquet3(i) values(4)");
        statement.execute("insert into uniquet3(i) values(5)");
        resultSet = statement.executeQuery("select i,uniquet3_autogen from uniquet3 order by i");
        stringArray = new String[][]{{"1", "0"}, {"2", "1"}, {"5", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into uniquet4(i,uniquet4_autogen) values(1,0)");
        statement.execute("insert into uniquet4(i,uniquet4_autogen) values(2,1)");
        AutoIncrementTest.assertStatementError("23505", statement, "insert into uniquet4(i) values(3)");
        AutoIncrementTest.assertStatementError("23505", statement, "insert into uniquet4(i) values(4)");
        statement.execute("insert into uniquet4(i) values(5)");
        resultSet = statement.executeQuery("select i,uniquet4_autogen from uniquet4 order by i");
        stringArray = new String[][]{{"1", "0"}, {"2", "1"}, {"5", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testidvalconn() throws Exception {
        Connection connection = this.openUserConnection("conn1");
        Statement statement = connection.createStatement();
        statement.execute("create table idvalt1 (c11 int generated always as identity (start with 101, increment by 3), c12 int)");
        statement.execute("create table idvalt2 (c21 int generated always as identity (start with 201, increment by 5), c22 int)");
        ResultSet resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        String[][] stringArray = new String[][]{{null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        connection.commit();
        Connection connection2 = this.openUserConnection("conn2");
        Statement statement2 = connection2.createStatement();
        resultSet = statement2.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2.execute("insert into conn1.idvalt2 (c22) values (1)");
        resultSet = statement2.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"201"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        connection = this.openUserConnection("conn1");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into idvalt1 (c12) values (1)");
        resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"101"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement2 = connection2.createStatement();
        resultSet = statement2.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"201"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        connection2.commit();
        statement2 = connection2.createStatement();
        resultSet = statement2.executeQuery("values IDENTITY_VAL_LOCAL()");
        stringArray = new String[][]{{"201"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("drop table idvalt1");
        statement.execute("drop table idvalt2");
    }

    public void testidvalVariants() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("insert into variantt1 (c12) values (1)");
        ResultSet resultSet = statement.executeQuery("values IDENTITY_VAL_LOCAL()");
        String[][] stringArray = new String[][]{{"101"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from variantt1");
        stringArray = new String[][]{{"101", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from variantt2");
        stringArray = new String[][]{{"201", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testrestart() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME = 'REC11'");
        String[][] stringArray = new String[][]{{"REC11", "2", "2", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into restartt1 values(2,2)");
        resultSet = statement.executeQuery("select * from restartt1");
        stringArray = new String[][]{{"2", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME = 'REC11'");
        stringArray = new String[][]{{"REC11", "2", "2", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into restartt1(c12) values(9999)");
        resultSet = statement.executeQuery("select * from restartt1 order by c12");
        stringArray = new String[][]{{"2", "2"}, {"2", "9999"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        this.vetSequenceState("RESTARTT1", 4L, 2L, 2L);
        AutoIncrementTest.assertStatementError("42837", statement, "alter table restartt1 alter column c12 RESTART WITH 2");
        AutoIncrementTest.assertStatementError("42X49", statement, "alter table restartt1 alter column rec11 RESTART WITH 2.20");
        statement.execute("alter table restartt1 alter column rec11 RESTART WITH 2");
        resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC\tfrom sys.syscolumns where COLUMNNAME = 'REC11'");
        stringArray = new String[][]{{"REC11", "2", "2", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testDerby6903AlterCycleSimple() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("alter table cycle1 alter column rec21 set CYCLE");
        ResultSet resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC, AUTOINCREMENTCYCLE        from sys.syscolumns where COLUMNNAME = 'REC21'");
        String[][] stringArray = new String[][]{{"REC21", "2", "2", "2", "true"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("alter table cycle1 alter column rec21 RESTART WITH 10");
        resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC, AUTOINCREMENTCYCLE        from sys.syscolumns where COLUMNNAME = 'REC21'");
        stringArray = new String[][]{{"REC21", "10", "10", "2", "true"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("alter table cycle1 alter column rec21 SET INCREMENT BY 50");
        resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC, AUTOINCREMENTCYCLE        from sys.syscolumns where COLUMNNAME = 'REC21'");
        stringArray = new String[][]{{"REC21", "50", "10", "50", "true"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testDerby6904AlterCycleSimple() throws Exception {
        Statement statement = this.createStatement();
        AutoIncrementTest.assertStatementError("42X01", statement, "alter table restartt1 alter column c12 cycle cycle");
        AutoIncrementTest.assertStatementError("42X01", statement, "alter table restartt1 alter column c12 no");
        AutoIncrementTest.assertStatementError("42X01", statement, "alter table restartt1 alter column c12 restart cycle");
        AutoIncrementTest.assertStatementError("42X01", statement, "alter table restartt1 alter column c12 restart with cycle");
        AutoIncrementTest.assertStatementError("42837", statement, "alter table restartt1 alter column c12 set cycle");
        AutoIncrementTest.assertStatementError("42837", statement, "alter table restartt1 alter column c12 set no cycle");
        ResultSet resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTCYCLE        from sys.syscolumns where COLUMNNAME = 'REC11'");
        String[][] stringArray = new String[][]{{"REC11", "false"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("alter table restartt1 alter column rec11 set cycle");
        resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTCYCLE        from sys.syscolumns where COLUMNNAME = 'REC11'");
        stringArray = new String[][]{{"REC11", "true"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("alter table restartt1 alter column rec11 set no cycle");
        resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTCYCLE        from sys.syscolumns where COLUMNNAME = 'REC11'");
        stringArray = new String[][]{{"REC11", "false"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testDerby6906NoCycleSimple() throws Exception {
        Statement statement = this.createStatement();
        AutoIncrementTest.assertStatementError("42XAJ", statement, "create table derby6906 (rec11 int generated by default as identity       (start with 2, increment by 2, cycle cycle) )");
        AutoIncrementTest.assertStatementError("42X01", statement, "create table derby6906 (rec11 int generated by default as identity       (start with 2, increment by 2, no) )");
        AutoIncrementTest.assertStatementError("42XAJ", statement, "create table derby6906 (rec11 int generated by default as identity       (start with 2, increment by 2, cycle no cycle) )");
        statement.execute("create table derby6906 (rec11 int generated by default as identity       (start with 2, increment by 2,cycle) )");
        statement.execute("drop table derby6906 ");
        statement.execute("create table derby6906 (rec11 int generated by default as identity       (start with 2, increment by 2,no cycle) )");
        statement.execute("drop table derby6906 ");
    }

    public void testlock() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("insert into t1lock values(1,1)");
        ResultSet resultSet = statement.executeQuery("select * from t1lock");
        String[][] stringArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME = 'LOCKC11'");
        stringArray = new String[][]{{"LOCKC11", "1", "1", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        AutoIncrementTest.assertStatementError("23505", statement, "insert into t1lock(c12) values(3)");
        this.vetSequenceState("T1LOCK", 2L, 1L, 1L);
        resultSet = statement.executeQuery("select * from t1lock");
        stringArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("alter table t1lock alter column lockc11 restart with 2");
        resultSet = statement.executeQuery("select COLUMNNAME, AUTOINCREMENTVALUE, AUTOINCREMENTSTART, AUTOINCREMENTINC from sys.syscolumns where COLUMNNAME = 'LOCKC11'");
        stringArray = new String[][]{{"LOCKC11", "2", "2", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into t1lock(c12) values(3)");
        resultSet = statement.executeQuery("select * from t1lock");
        stringArray = new String[][]{{"1", "1"}, {"2", "3"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void test_Derby14951465() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT\tcol.columndefault,col.autoincrementvalue, col.autoincrementstart,col.autoincrementinc FROM sys.syscolumns col INNER JOIN sys.systables tab ON col.referenceId = tab.tableid WHERE tab.tableName = 'DERBY_1495' AND ColumnName = 'TESTID'");
        String[][] stringArray = new String[][]{{"GENERATED_BY_DEFAULT", "1", "1", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("INSERT INTO DERBY_1495(TESTID, TESTCOL2) VALUES(2, 2)");
        statement.execute("ALTER TABLE DERBY_1495 ALTER COLUMN TESTid RESTART WITH 3");
        resultSet = statement.executeQuery("SELECT\tcol.columndefault,col.autoincrementvalue, col.autoincrementstart,col.autoincrementinc FROM sys.syscolumns col INNER JOIN sys.systables tab ON col.referenceId = tab.tableid WHERE tab.tableName = 'DERBY_1495' AND ColumnName = 'TESTID'");
        stringArray = new String[][]{{"GENERATED_BY_DEFAULT", "3", "3", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("SELECT col.columndefault,col.autoincrementvalue, col.autoincrementstart,col.autoincrementinc FROM sys.syscolumns col INNER JOIN sys.systables tab ON col.referenceId = tab.tableid WHERE tab.tableName = 'DERBY_1645' AND ColumnName = 'TESTTABLEID'");
        stringArray = new String[][]{{"GENERATED_BY_DEFAULT", "1", "1", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("INSERT INTO derby_1645 (TESTTableId, TESTStringValue) VALUES (-1, 'test1')");
        statement.execute("INSERT INTO derby_1645 (TESTTableId, TESTStringValue) VALUES (-2, 'test2')");
        statement.execute("INSERT INTO derby_1645 (TESTTableId, TESTStringValue) VALUES (-3, 'test3')");
        statement.execute("ALTER TABLE derby_1645 ALTER TESTTableId SET INCREMENT BY 50");
        resultSet = statement.executeQuery("SELECT col.columndefault,col.autoincrementvalue, col.autoincrementstart,col.autoincrementinc FROM sys.syscolumns col INNER JOIN sys.systables tab ON col.referenceId = tab.tableid WHERE tab.tableName = 'DERBY_1645' AND ColumnName = 'TESTTABLEID'");
        stringArray = new String[][]{{"GENERATED_BY_DEFAULT", "53", "1", "50"}};
        statement.execute("INSERT INTO derby_1645 (TESTStringValue) VALUES ('test53')");
        statement.execute("INSERT INTO derby_1645 (TESTTableId, TESTStringValue) VALUES (-999, 'test3')");
        statement.execute("drop table derby_1645");
    }

    public void TESTD1644() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("insert into D1644 (d1644c2) values default, 10");
        statement.execute("insert into D1644 (d1644c2) values (11)");
        statement.execute("insert into D1644 (d1644c2) values default");
        statement.execute("insert into D1644 (d1644c2) values (default)");
        statement.execute("insert into D1644 (d1644c2) values 12, 13, 14");
        statement.execute("insert into D1644 (d1644c2) values 15, 16, default");
        statement.execute("insert into D1644 values (17, 18)");
        statement.execute("insert into D1644 values (19, default)");
        statement.execute("insert into D1644 values (20, default), (21, 22), (23, 24), (25, default)");
        statement.execute("insert into D1644 (d1644c2, d1644c1) values (default, 26)");
        statement.execute("insert into D1644 (d1644c2, d1644c1) values (27, 28), (default, 29), (30, 31)");
        statement.execute("insert into D1644 (d1644c2) values default, default, default, default");
        statement.execute("insert into D1644 (d1644c2, d1644c1) values (default, 128),(default, 129),(default, 131)");
        ResultSet resultSet = statement.executeQuery("select * from D1644 order by d1644c1, d1644c2");
        String[][] stringArray = new String[][]{{"17", "18"}, {"19", "5"}, {"20", "6"}, {"21", "22"}, {"23", "24"}, {"25", "7"}, {"26", "8"}, {"28", "27"}, {"29", "9"}, {"31", "30"}, {"128", "14"}, {"129", "15"}, {"131", "16"}, {null, "1"}, {null, "2"}, {null, "3"}, {null, "4"}, {null, "10"}, {null, "10"}, {null, "11"}, {null, "11"}, {null, "12"}, {null, "12"}, {null, "13"}, {null, "13"}, {null, "14"}, {null, "15"}, {null, "16"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into D1644_A (c3, d1644_Ac1, d1644_Ac2) values (1, 2, default)");
        statement.execute("insert into D1644_A (c3, d1644_Ac1, d1644_Ac2) values (3,4,5), (6,7,default)");
        statement.execute("insert into D1644_A (c3, d1644_Ac2) values (8, default), (9, 10)");
        resultSet = statement.executeQuery("select * from D1644_A order by d1644_Ac1, d1644_Ac2");
        stringArray = new String[][]{{"2", "1", "1"}, {"4", "5", "3"}, {"7", "2", "6"}, {null, "3", "8"}, {null, "10", "9"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into D1644_B (d1644_Bc1) values default, 10");
        statement.execute("insert into D1644_B values default, 10");
        resultSet = statement.executeQuery("select * from D1644_B order by d1644_Bc1");
        stringArray = new String[][]{{"1"}, {"2"}, {"10"}, {"10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testDerby2902() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("insert into d4006 values default");
        statement.execute("alter table d4006 alter column x with default null");
        statement.execute("insert into d4006 values default");
        statement.execute("alter table d4006 alter column x with default 'def'");
        statement.execute("insert into d4006 values default");
        ResultSet resultSet = statement.executeQuery("select * from d4006 order by x");
        String[][] stringArray = new String[][]{{"abc"}, {"def"}, {null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("alter table d4006 add column y int generated always as (-1)");
        AutoIncrementTest.assertStatementError("42XA7", statement, "alter table d4006 alter column y default 42");
        AutoIncrementTest.assertStatementError("42XA7", statement, "alter table d4006 alter column y default null");
        AutoIncrementTest.assertStatementError("42XA7", statement, "alter table d4006_a alter column z default 99");
        AutoIncrementTest.assertStatementError("42XA7", statement, "alter table d4006_a alter column z default null");
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup((Test)new BaseTestSuite(AutoIncrementTest.class, "AutoIncrementTest")){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                AutoIncrementTest.createSchemaObjects(statement);
            }
        };
    }
}

