/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.multi;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StressMultiTest
extends BaseJDBCTestCase {
    private static int THREADS = 10;
    private static int MINUTES = 10;
    private static final String THREADSMINUTES = "derby.tests.ThreadsMinutes";
    private static boolean DEBUG = false;
    private Throwable thrown = null;
    private Thread[] threads = null;
    private Random rnd = new Random();
    private boolean complete = false;

    public StressMultiTest(String s) {
        super(s);
    }

    public static Test suite() {
        Properties dbprops = new Properties();
        dbprops.put("derby.locks.deadlockTimeout", "2");
        dbprops.put("derby.locks.waitTimeout", "3");
        Properties sysprops = new Properties();
        sysprops.put("derby.storage.keepTransactionLog", "true");
        sysprops.put("derby.language.logStatementText", "true");
        sysprops.put("derby.infolog.append", "true");
        Object embedded = new BaseTestSuite(StressMultiTest.class);
        embedded = new SystemPropertyTestSetup((Test)embedded, sysprops, true);
        embedded = new DatabasePropertyTestSetup((Test)embedded, dbprops);
        embedded = TestConfiguration.singleUseDatabaseDecorator(StressMultiTest.newCleanDatabase((Test)embedded));
        Test client = TestConfiguration.clientServerDecorator((Test)new BaseTestSuite(StressMultiTest.class));
        client = StressMultiTest.newCleanDatabase((Test)new DatabasePropertyTestSetup(client, dbprops));
        BaseTestSuite encrypted = new BaseTestSuite(StressMultiTest.class);
        BaseTestSuite unencrypted = new BaseTestSuite("StressMultiTest:unencrypted");
        unencrypted.addTest((Test)embedded);
        unencrypted.addTest(client);
        BaseTestSuite suite = new BaseTestSuite("StressMultiTest, " + THREADS + " Threads " + MINUTES + " Minutes");
        suite.addTest(StressMultiTest.newCleanDatabase((Test)unencrypted));
        suite.addTest(Decorator.encryptedDatabase((Test)new DatabasePropertyTestSetup(StressMultiTest.newCleanDatabase((Test)encrypted), dbprops)));
        return suite;
    }

    public static Test suite(int threads, int minutes) {
        THREADS = threads;
        MINUTES = minutes;
        return StressMultiTest.suite();
    }

    public static Test embeddedSuite(int threads, int minutes) {
        THREADS = threads;
        MINUTES = minutes;
        Properties dbprops = new Properties();
        dbprops.put("derby.locks.deadlockTimeout", "2");
        dbprops.put("derby.locks.waitTimeout", "3");
        dbprops.put("derby.language.logStatementText", "true");
        dbprops.put("derby.storage.keepTransactionLog", "true");
        Properties sysprops = new Properties();
        sysprops.put("derby.storage.keepTransactionLog", "true");
        sysprops.put("derby.language.logStatementText", "true");
        sysprops.put("derby.infolog.append", "true");
        Object embedded = new BaseTestSuite(StressMultiTest.class);
        embedded = new SystemPropertyTestSetup((Test)embedded, sysprops, true);
        embedded = new DatabasePropertyTestSetup((Test)embedded, dbprops);
        embedded = TestConfiguration.singleUseDatabaseDecorator(StressMultiTest.newCleanDatabase((Test)embedded));
        return embedded;
    }

    private static Test newCleanDatabase(Test s) {
        return new CleanDatabaseTestSetup(s){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("CREATE FUNCTION  PADSTRING (DATA VARCHAR(32000), LENGTH INTEGER) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Formatters.padString' LANGUAGE JAVA PARAMETER STYLE JAVA");
                s.execute("CREATE FUNCTION RANDOM() RETURNS DOUBLE EXTERNAL NAME 'java.lang.Math.random' LANGUAGE JAVA PARAMETER STYLE JAVA");
                s.execute("create table main(x int not null primary key, y varchar(2000))");
                s.execute("insert into main values(1, PADSTRING('aaaa',2000))");
                s.execute("insert into main values(2, PADSTRING('aaaa',2000))");
                s.execute("insert into main values(3, PADSTRING('aaaa',2000))");
                s.execute("insert into main values(4, PADSTRING('aaaa',2000))");
                s.execute("insert into main values(5, PADSTRING('aaaa',2000))");
                s.execute("insert into main values(6, PADSTRING('aaaa',2000))");
                s.execute("insert into main values(7, PADSTRING('aaaa',2000))");
                s.execute("insert into main values(8, PADSTRING('aaaa',2000))");
                s.execute("insert into main values(9, PADSTRING('aaaa',2000))");
                s.execute("insert into main values(10, PADSTRING('aaaa',2000))");
                s.execute("insert into main values(12, PADSTRING('aaaa',2000))");
                s.execute("insert into main values(13, PADSTRING('aaaa',2000))");
                s.execute("create table main2(x int not null primary key, y varchar(2000))");
                s.execute("insert into main2 values(1, PADSTRING('aaaa',2000))");
                s.execute("insert into main2 values(2, PADSTRING('aaaa',2000))");
                s.execute("insert into main2 values(3, PADSTRING('aaaa',2000))");
                s.execute("insert into main2 values(4, PADSTRING('aaaa',2000))");
                s.execute("insert into main2 values(5, PADSTRING('aaaa',2000))");
                s.execute("insert into main2 values(6, PADSTRING('aaaa',2000))");
                s.execute("insert into main2 values(7, PADSTRING('aaaa',2000))");
                s.execute("insert into main2 values(8, PADSTRING('aaaa',2000))");
                s.execute("insert into main2 values(9, PADSTRING('aaaa',2000))");
                s.execute("insert into main2 values(10, PADSTRING('aaaa',2000))");
                s.execute("insert into main2 values(12, PADSTRING('aaaa',2000))");
                s.execute("insert into main2 values(13, PADSTRING('aaaa',2000))");
                this.getConnection().commit();
            }
        };
    }

    public void setUp() throws Exception {
        super.setUp();
        this.getTestConfiguration().setVerbosity(DEBUG);
        String optThreadsMinutes = StressMultiTest.getSystemProperty(THREADSMINUTES);
        if (optThreadsMinutes != null) {
            int xPos = optThreadsMinutes.indexOf("x");
            try {
                THREADS = Integer.parseInt(optThreadsMinutes.substring(0, xPos));
                MINUTES = Integer.parseInt(optThreadsMinutes.substring(xPos + 1, optThreadsMinutes.length()));
            }
            catch (Exception e) {
                StressMultiTest.alarm("Illegal value for 'derby.tests.ThreadsMinutes': '" + optThreadsMinutes + "' - " + e.getMessage() + ". Threads: " + THREADS + ", minutes: " + MINUTES);
            }
            StressMultiTest.traceit("Threads: " + THREADS + ", minutes: " + MINUTES);
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.rnd = null;
        this.threads = null;
        super.tearDown();
    }

    public void testStressMulti() throws Throwable {
        this.thrown = null;
        StressMultiRunnable[] tct = new StressMultiRunnable[THREADS];
        for (int i = 0; i < tct.length; ++i) {
            tct[i] = new StressMultiRunnable("Tester" + i, MINUTES);
        }
        this.runTestCaseRunnables(tct);
        tct = null;
        if (this.thrown != null) {
            throw this.thrown;
        }
    }

    protected void runTestCaseRunnables(StressMultiRunnable[] runnables) {
        int i;
        if (runnables == null) {
            throw new IllegalArgumentException("runnables is null");
        }
        this.threads = new Thread[runnables.length];
        for (i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new Thread(runnables[i]);
        }
        for (i = 0; i < this.threads.length; ++i) {
            this.threads[i].start();
        }
        try {
            for (i = 0; i < this.threads.length; ++i) {
                this.threads[i].join();
            }
        }
        catch (InterruptedException ignore) {
            BaseTestCase.println("Thread join interrupted.");
        }
        this.threads = null;
    }

    private synchronized void handleException(Throwable t, String message) {
        this.complete = true;
        if (this.thrown == null) {
            if (t instanceof AssertionFailedError) {
                this.thrown = (AssertionFailedError)t;
            } else if (t instanceof SQLException) {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                t.printStackTrace(new PrintStream(b));
                this.thrown = new AssertionFailedError("Caused by: \n" + b.toString());
            } else {
                this.thrown = t;
            }
            StressMultiTest.println("Exception handled!!: " + message + " - " + t);
        } else {
            StressMultiTest.println("Exception discarded because another was already caught and the threads are terminating..:\n" + message + " - " + t);
        }
    }

    class StressMultiRunnable
    implements Runnable {
        String name;
        Connection con;
        long starttime;
        long runtime;

        public StressMultiRunnable(String name, int minutes) {
            this.name = name;
            this.starttime = System.currentTimeMillis();
            this.runtime = minutes * 60 * 1000;
            try {
                this.con = StressMultiTest.this.openDefaultConnection();
                this.con.setAutoCommit(false);
            }
            catch (SQLException e) {
                BaseTestCase.println(e.toString());
            }
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while (!StressMultiTest.this.complete) {
                    ++i;
                    int r = StressMultiTest.this.rnd.nextInt(100);
                    if (r < 10) {
                        n = "x";
                        switch (StressMultiTest.this.rnd.nextInt(4)) {
                            case 0: {
                                n = "a";
                                break;
                            }
                            case 1: {
                                n = "x";
                                break;
                            }
                            case 2: {
                                n = "y";
                                break;
                            }
                            case 3: {
                                n = "z";
                            }
                        }
                        this.create(n);
                        BaseTestCase.println(this.name + " - Run " + i + " - Create " + n + " " + new Date(System.currentTimeMillis()).toString());
                    } else if (r < 25) {
                        n = "main";
                        if (StressMultiTest.this.rnd.nextInt(2) == 1) {
                            n = "main2";
                        }
                        this.roll(n);
                        BaseTestCase.println(this.name + " - Run " + i + " - Roll " + n + " " + new Date(System.currentTimeMillis()).toString());
                    } else if (r < 40) {
                        n = "main";
                        if (StressMultiTest.this.rnd.nextInt(2) == 1) {
                            n = "main2";
                        }
                        this.insert(n);
                        BaseTestCase.println(this.name + " - Run " + i + " - Insert " + n + " " + new Date(System.currentTimeMillis()).toString());
                    } else if (r < 60) {
                        n = "main";
                        if (StressMultiTest.this.rnd.nextInt(2) == 1) {
                            n = "main2";
                        }
                        this.update(n);
                        BaseTestCase.println(this.name + " - Run " + i + " - Update " + n + " " + new Date(System.currentTimeMillis()).toString());
                    } else if (r <= 99) {
                        n = "main";
                        if (StressMultiTest.this.rnd.nextInt(2) == 1) {
                            n = "main2";
                        }
                        this.select(n);
                        BaseTestCase.println(this.name + " - Run " + i + " - Select " + n + " " + new Date(System.currentTimeMillis()).toString());
                    }
                    if (this.starttime + this.runtime <= System.currentTimeMillis()) {
                        BaseTestCase.println(this.name + " - STOPPING - " + new Date(System.currentTimeMillis()).toString());
                        break;
                    }
                    Thread.sleep(StressMultiTest.this.rnd.nextInt(10));
                }
            }
            catch (Throwable t) {
                BaseTestCase.println("Exception in " + this.name + ": " + t);
                StressMultiTest.this.handleException(t, this.name + " - " + new Date(System.currentTimeMillis()).toString());
            }
            BaseTestCase.println(this.name + " terminated!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create(String table) throws SQLException {
            block6: {
                Statement s = this.con.createStatement();
                try {
                    s.execute("create table " + table + " (x int)");
                    s.execute("insert into " + table + " values (1)");
                    s.execute("insert into " + table + " values (1)");
                    s.execute("insert into " + table + " values (1)");
                    s.execute("insert into " + table + " values (1)");
                    s.execute("insert into " + table + " values (1)");
                    s.execute("drop table " + table);
                    this.con.commit();
                }
                catch (SQLException se) {
                    String e = se.getSQLState();
                    if (e.equals("X0X08") || e.equals("X0X05") || e.equals("42X05") || e.equals("42Y55") || e.equals("42000") || e.equals("40001") || e.equals("40XL1") || e.equals("40XL2") || e.equals("42Y07")) break block6;
                    if (e.equals("42Y55")) {
                        break block6;
                    }
                    throw se;
                }
                finally {
                    s = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insert(String table) throws SQLException {
            block6: {
                Statement s = this.con.createStatement();
                try {
                    s.executeUpdate("insert into " + table + " values (random() * 1000 + 100, 'rand')");
                    this.con.commit();
                }
                catch (SQLException se) {
                    String e = se.getSQLState();
                    if (e.equals("42000") || e.equals("23505") || e.equals("40001") || e.equals("40XL1") || e.equals("40XL2") || e.equals("42Y07")) break block6;
                    if (e.equals("42Y55")) {
                        break block6;
                    }
                    throw se;
                }
                finally {
                    s = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void roll(String table) throws SQLException {
            block6: {
                Statement s = this.con.createStatement();
                this.con.setAutoCommit(false);
                try {
                    s.executeUpdate("insert into " + table + " values (666, '666')");
                    this.con.rollback();
                }
                catch (SQLException se) {
                    String e = se.getSQLState();
                    if (e.equals("X0X05") || e.equals("42X05") || e.equals("42Y55") || e.equals("42000") || e.equals("23505") || e.equals("40001") || e.equals("40XL1") || e.equals("40XL2") || e.equals("42Y07")) break block6;
                    if (e.equals("42Y55")) {
                        break block6;
                    }
                    throw se;
                }
                finally {
                    s = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void select(String table) throws SQLException {
            block6: {
                Statement s = this.con.createStatement();
                try {
                    ResultSet rs = s.executeQuery("select * from " + table);
                    JDBC.assertDrainResults(rs);
                }
                catch (SQLException se) {
                    String e = se.getSQLState();
                    if (e.equals("42Y55") || e.equals("42000") || e.equals("40001") || e.equals("40XL1") || e.equals("40XL2")) break block6;
                    if (e.equals("42Y07")) {
                        break block6;
                    }
                    throw se;
                }
                finally {
                    s = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(String table) throws SQLException {
            block6: {
                Statement s = this.con.createStatement();
                try {
                    s.executeUpdate("update " + table + " main set y = 'zzz' where x = 5");
                }
                catch (SQLException se) {
                    String e = se.getSQLState();
                    if (e.equals("42Y55") || e.equals("42000") || e.equals("40001") || e.equals("40XL1") || e.equals("40XL2")) break block6;
                    if (e.equals("42Y07")) {
                        break block6;
                    }
                    throw se;
                }
                finally {
                    s = null;
                }
            }
        }
    }
}

