/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.NumberFormat;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;

public class TableFunctionTest
extends BaseJDBCTestCase {
    private static final String UTF8 = "UTF-8";
    private static final String BAD_ARG_JOIN = "42ZB7";
    private static final int MAX_VARIABLE_DATA_TYPE_LENGTH = 32700;
    private static final String[] FUNCTION_NAMES = new String[]{"SIMPLEFUNCTIONTABLE", "invert", "returnsACoupleRows", "getXXXrecord", "returnsAllLegalDatatypes", "missingConstructor", "zeroArgConstructorNotPublic", "constructorException", "goodVTICosting", "allStringTypesFunction", "coercionFunction"};
    private static final String[] TABLE_NAMES = new String[]{"allStringTypesTable", "fooTestTable"};
    private static final String[][] SIMPLE_ROWS = new String[][]{{"who", "put"}, {"the", "bop"}, {null, "in"}, {"the", null}};
    private static final String[][] SIMPLY_ROWS = new String[][]{{"the       ", null}, {"the       ", "bop       "}, {"who       ", "put       "}, {null, "in        "}};
    private static final String[][] DOUBLY_SIMPLE_ROWS = new String[][]{{"the       ", null}, {"the       ", "bop       "}, {"the       ", null}, {"the       ", "bop       "}, {"who       ", "put       "}, {"who       ", "put       "}, {null, "in        "}, {null, "in        "}};
    private static final String[][] BOOLEAN_ROWS = new String[][]{{"tRuE", "true"}, {"fAlSe", "false"}};
    private static final String[][] BULK_INSERT_ROWS = new String[][]{{"1", "red"}, {"2", "blue"}};
    private static final String[][] BULK_INSERT_SELF_JOIN_ROWS = new String[][]{{"2", "blue"}};
    private static final String[][] DOUBLY_INSERTED_ROWS = new String[][]{{"1", "red"}, {"1", "red"}, {"2", "blue"}, {"2", "blue"}};
    private static final String[][] WARNING_VTI_ROWS = new String[][]{{"1", "red"}, {"2", "blue"}};
    private static final String[][] ALL_TYPES_ROWS = new String[][]{{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}};
    private static final String EXPECTED_GET_XXX_CALLS = "getLong getBlob getString getBytes getString getDate getBigDecimal getDouble getDouble getFloat getDouble getInt getString getBytes getBigDecimal getFloat getShort getTime getTimestamp getString getBytes getBoolean ";
    private static final String EXPECTED_GET_XXX_CALLS_JSR169 = "getLong getBlob getString getBytes getString getDate getString getDouble getDouble getFloat getDouble getInt getString getBytes getString getFloat getShort getTime getTimestamp getString getBytes getBoolean ";
    private static final String[] STRING_TYPES = new String[]{"CHAR( 20 )", "VARCHAR( 20 )"};
    private static final int[] STRING_JDBC_TYPES = new int[]{1, 12};
    private static final String[][] ALL_STRING_TYPES_ROWS = new String[][]{{"char col            ", "varchar col"}};
    private static final String SFT_RETURN_TYPE = "TABLE ( \"INTCOL\" INTEGER, \"VARCHARCOL\" VARCHAR(10) )";
    private static final String RADT_RETURN_TYPE = "TABLE ( \"COLUMN0\" BIGINT, \"COLUMN1\" BLOB(2147483647), \"COLUMN2\" CHAR(10), \"COLUMN3\" CHAR (10) FOR BIT DATA, \"COLUMN4\" CLOB(2147483647), \"COLUMN5\" DATE, \"COLUMN6\" DECIMAL(5,0), \"COLUMN7\" DOUBLE, \"COLUMN8\" DOUBLE, \"COLUMN9\" REAL, \"COLUMN10\" DOUBLE, \"COLUMN11\" INTEGER, \"COLUMN12\" LONG VARCHAR, \"COLUMN13\" LONG VARCHAR FOR BIT DATA, \"COLUMN14\" NUMERIC(5,0), \"COLUMN15\" REAL, \"COLUMN16\" SMALLINT, \"COLUMN17\" TIME, \"COLUMN18\" TIMESTAMP, \"COLUMN19\" VARCHAR(10), \"COLUMN20\" VARCHAR (10) FOR BIT DATA, \"COLUMN21\" BOOLEAN )";
    private static final Integer FUNCTION_COLUMN_IN = 1;
    private static final Integer FUNCTION_RETURN_VALUE = 4;
    private static final Integer FUNCTION_RESULT_COLUMN = 5;
    private static final Integer FUNCTION_RETURNS_TABLE = 2;
    private static final Integer JDBC_TYPE_OTHER = 1111;
    private static final Integer JDBC_TYPE_INT = 4;
    private static final Integer JDBC_TYPE_VARCHAR = 12;
    private static final Integer JDBC_TYPE_BIGINT = -5;
    private static final Integer JDBC_TYPE_BLOB = 2004;
    private static final Integer JDBC_TYPE_CHAR = 1;
    private static final Integer JDBC_TYPE_CLOB = 2005;
    private static final Integer JDBC_TYPE_DATE = 91;
    private static final Integer JDBC_TYPE_DECIMAL = 3;
    private static final Integer JDBC_TYPE_DOUBLE = 8;
    private static final Integer JDBC_TYPE_REAL = 7;
    private static final Integer JDBC_TYPE_NUMERIC = 2;
    private static final Integer JDBC_TYPE_SMALLINT = 5;
    private static final Integer JDBC_TYPE_TIME = 92;
    private static final Integer JDBC_TYPE_TIMESTAMP = 93;
    private static final Integer JDBC_TYPE_BINARY = -2;
    private static final Integer JDBC_TYPE_LONGVARBINARY = -4;
    private static final Integer JDBC_TYPE_LONGVARCHAR = -1;
    private static final Integer JDBC_TYPE_VARBINARY = -3;
    private static final Integer JDBC_TYPE_BOOLEAN = 16;
    private static final Integer PRECISION_NONE = 0;
    private static final Integer PRECISION_INTEGER = 10;
    private static final Integer PRECISION_BIGINT = 19;
    private static final Integer PRECISION_MAX = Integer.MAX_VALUE;
    private static final Integer LENGTH_UNDEFINED = -1;
    private static final Integer LENGTH_INTEGER = 4;
    private static final Integer LENGTH_BIGINT = 40;
    private static final Integer LENGTH_MAX = Integer.MAX_VALUE;
    private static final Integer SCALE_UNDEFINED = null;
    private static final Integer SCALE_INTEGER = 0;
    private static final Integer RADIX_UNDEFINED = null;
    private static final Integer RADIX_INTEGER = 10;
    private static final Object NO_CATALOG = null;
    private static final String RETURN_VALUE_NAME = "";
    private static final Integer ALLOWS_NULLS = 1;
    private static final Object EMPTY_REMARKS = null;
    private static final Object UNDEFINED_CHAR_OCTET_LENGTH = null;
    private static final String IS_NULLABLE = "YES";
    private static final Integer ROW_ORDER_RETURN_VALUE = -1;
    private static final Integer ROW_ORDER_1 = 0;
    private static final Integer ROW_ORDER_2 = 1;
    private static final Integer POSITION_RETURN_VALUE = 0;
    private static final Integer POSITION_ARG_1 = 1;
    private static final Integer POSITION_ARG_2 = 2;
    private static final Integer ARG_COUNT_0 = 0;
    private static final Integer ARG_COUNT_1 = 1;
    private static final Integer ARG_COUNT_2 = 2;
    private static final Integer ARG_COUNT_3 = 3;
    private static final JDBC.GeneratedId GENERIC_NAME = new JDBC.GeneratedId();
    private static final Object[][] GF_SFT = new Object[][]{{NO_CATALOG, "APP", "SIMPLEFUNCTIONTABLE", "com.scores.proc.Functions.weighQuestion", FUNCTION_RETURNS_TABLE, GENERIC_NAME}};
    private static final Object[][] GFC_SFT = new Object[][]{{NO_CATALOG, "APP", "SIMPLEFUNCTIONTABLE", "INTCOL", FUNCTION_RESULT_COLUMN, JDBC_TYPE_INT, "INTEGER", PRECISION_INTEGER, LENGTH_INTEGER, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 1, "YES", GENERIC_NAME, ARG_COUNT_0, ROW_ORDER_1}, {NO_CATALOG, "APP", "SIMPLEFUNCTIONTABLE", "VARCHARCOL", FUNCTION_RESULT_COLUMN, JDBC_TYPE_VARCHAR, "VARCHAR", 10, 20, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 20, 2, "YES", GENERIC_NAME, ARG_COUNT_0, ROW_ORDER_2}};
    private static final Object[][] GF_RADT = new Object[][]{{NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "org.apache.derbyTesting.functionTests.tests.lang.TableFunctionTest.returnsAllLegalDatatypes", FUNCTION_RETURNS_TABLE, GENERIC_NAME}};
    private static final Object[][] GFC_RADT = new Object[][]{{NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "INTARGUMENT", FUNCTION_COLUMN_IN, JDBC_TYPE_INT, "INTEGER", PRECISION_INTEGER, LENGTH_INTEGER, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, POSITION_ARG_1, "YES", GENERIC_NAME, ARG_COUNT_2, ROW_ORDER_1}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "VARCHARARGUMENT", FUNCTION_COLUMN_IN, JDBC_TYPE_VARCHAR, "VARCHAR", 10, 20, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 20, POSITION_ARG_2, "YES", GENERIC_NAME, ARG_COUNT_2, ROW_ORDER_2}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN0", FUNCTION_RESULT_COLUMN, JDBC_TYPE_BIGINT, "BIGINT", PRECISION_BIGINT, LENGTH_BIGINT, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 1, "YES", GENERIC_NAME, ARG_COUNT_2, 2}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN1", FUNCTION_RESULT_COLUMN, JDBC_TYPE_BLOB, "BLOB", PRECISION_MAX, LENGTH_MAX, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 2, "YES", GENERIC_NAME, ARG_COUNT_2, 3}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN2", FUNCTION_RESULT_COLUMN, JDBC_TYPE_CHAR, "CHAR", 10, 20, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 20, 3, "YES", GENERIC_NAME, ARG_COUNT_2, 4}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN3", FUNCTION_RESULT_COLUMN, JDBC_TYPE_BINARY, "CHAR () FOR BIT DATA", 10, 10, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 10, 4, "YES", GENERIC_NAME, ARG_COUNT_2, 5}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN4", FUNCTION_RESULT_COLUMN, JDBC_TYPE_CLOB, "CLOB", PRECISION_MAX, LENGTH_MAX, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 5, "YES", GENERIC_NAME, ARG_COUNT_2, 6}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN5", FUNCTION_RESULT_COLUMN, JDBC_TYPE_DATE, "DATE", 10, 6, 0, 10, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 6, "YES", GENERIC_NAME, ARG_COUNT_2, 7}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN6", FUNCTION_RESULT_COLUMN, JDBC_TYPE_DECIMAL, "DECIMAL", 5, 14, 0, 10, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 7, "YES", GENERIC_NAME, ARG_COUNT_2, 8}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN7", FUNCTION_RESULT_COLUMN, JDBC_TYPE_DOUBLE, "DOUBLE", 52, 8, SCALE_UNDEFINED, 2, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 8, "YES", GENERIC_NAME, ARG_COUNT_2, 9}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN8", FUNCTION_RESULT_COLUMN, JDBC_TYPE_DOUBLE, "DOUBLE", 52, 8, SCALE_UNDEFINED, 2, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 9, "YES", GENERIC_NAME, ARG_COUNT_2, 10}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN9", FUNCTION_RESULT_COLUMN, JDBC_TYPE_REAL, "REAL", 23, 4, SCALE_UNDEFINED, 2, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 10, "YES", GENERIC_NAME, ARG_COUNT_2, 11}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN10", FUNCTION_RESULT_COLUMN, JDBC_TYPE_DOUBLE, "DOUBLE", 52, 8, SCALE_UNDEFINED, 2, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 11, "YES", GENERIC_NAME, ARG_COUNT_2, 12}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN11", FUNCTION_RESULT_COLUMN, JDBC_TYPE_INT, "INTEGER", PRECISION_INTEGER, LENGTH_INTEGER, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 12, "YES", GENERIC_NAME, ARG_COUNT_2, 13}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN12", FUNCTION_RESULT_COLUMN, JDBC_TYPE_LONGVARCHAR, "LONG VARCHAR", 32700, 65400, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 13, "YES", GENERIC_NAME, ARG_COUNT_2, 14}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN13", FUNCTION_RESULT_COLUMN, JDBC_TYPE_LONGVARBINARY, "LONG VARCHAR FOR BIT DATA", 32700, 32700, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 14, "YES", GENERIC_NAME, ARG_COUNT_2, 15}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN14", FUNCTION_RESULT_COLUMN, JDBC_TYPE_NUMERIC, "NUMERIC", 5, 14, 0, 10, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 15, "YES", GENERIC_NAME, ARG_COUNT_2, 16}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN15", FUNCTION_RESULT_COLUMN, JDBC_TYPE_REAL, "REAL", 23, 4, SCALE_UNDEFINED, 2, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 16, "YES", GENERIC_NAME, ARG_COUNT_2, 17}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN16", FUNCTION_RESULT_COLUMN, JDBC_TYPE_SMALLINT, "SMALLINT", 5, 2, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 17, "YES", GENERIC_NAME, ARG_COUNT_2, 18}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN17", FUNCTION_RESULT_COLUMN, JDBC_TYPE_TIME, "TIME", 8, 6, SCALE_INTEGER, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 18, "YES", GENERIC_NAME, ARG_COUNT_2, 19}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN18", FUNCTION_RESULT_COLUMN, JDBC_TYPE_TIMESTAMP, "TIMESTAMP", 29, 16, 9, RADIX_INTEGER, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 19, "YES", GENERIC_NAME, ARG_COUNT_2, 20}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN19", FUNCTION_RESULT_COLUMN, JDBC_TYPE_VARCHAR, "VARCHAR", 10, 20, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 20, 20, "YES", GENERIC_NAME, ARG_COUNT_2, 21}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN20", FUNCTION_RESULT_COLUMN, JDBC_TYPE_VARBINARY, "VARCHAR () FOR BIT DATA", 10, 10, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, 10, 21, "YES", GENERIC_NAME, ARG_COUNT_2, 22}, {NO_CATALOG, "APP", "RETURNSALLLEGALDATATYPES", "COLUMN21", FUNCTION_RESULT_COLUMN, JDBC_TYPE_BOOLEAN, "BOOLEAN", 1, 1, SCALE_UNDEFINED, RADIX_UNDEFINED, ALLOWS_NULLS, EMPTY_REMARKS, UNDEFINED_CHAR_OCTET_LENGTH, 22, "YES", GENERIC_NAME, ARG_COUNT_2, 23}};
    private static final String ESTIMATED_ROW_COUNT = "optimizer estimated row count:";
    private static final String ESTIMATED_COST = "optimizer estimated cost:";
    private boolean _usingLocaleSpecificCollation;
    private DatabaseMetaData _databaseMetaData;

    public TableFunctionTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("TableFunctionTest");
        suite.addTest((Test)new TableFunctionTest("noSpecialCollation"));
        suite.addTest(TableFunctionTest.collatedSuite("en", "specialCollation"));
        return suite;
    }

    private static Test collatedSuite(String locale, String baseFixture) {
        BaseTestSuite suite = new BaseTestSuite("TableFunctionTest:territory=" + locale);
        suite.addTest((Test)new TableFunctionTest(baseFixture));
        return Decorator.territoryCollatedDatabase((Test)suite, locale);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._databaseMetaData = this.getConnection().getMetaData();
        this.dropSchema();
    }

    @Override
    protected void tearDown() throws Exception {
        this.dropSchema();
        this._databaseMetaData = null;
        super.tearDown();
    }

    public void noSpecialCollation() throws Exception {
        this._usingLocaleSpecificCollation = false;
        this.tableFunctionTest();
    }

    public void specialCollation() throws Exception {
        this._usingLocaleSpecificCollation = true;
        this.tableFunctionTest();
    }

    public void tableFunctionTest() throws Exception {
        this.badDDL();
        this.simpleDDL();
        this.notTableFunction();
        this.simpleVTIResults();
        this.allLegalDatatypesVTIResults();
        this.vtiCosting();
        this.collationTest();
        this.subqueryTest();
        this.coercionTest();
        this.bulkInsert();
        this.miscBugs();
        this.classpathError();
    }

    private void badDDL() throws Exception {
        this.expectError("42ZB1", "create function badParameterStyle()\nreturns varchar(10)\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'com.scores.proc.Functions.weighQuestion'\n");
        this.expectError("42ZB1", "create procedure badParameterStyle\n( in takingID int )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nmodifies sql data\nexternal name 'com.scores.proc.Procedures.ScoreTestTaking'\n");
        this.expectError("42ZB2", "create function badParameterStyleForTableFunction()\nreturns TABLE\n  (\n     intCol int,\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style java\nno sql\nexternal name 'com.scores.proc.Functions.weighQuestion'\n");
        this.expectError("42ZB3", "create function xmlForbiddenInReturnedColumns()\nreturns TABLE\n  (\n     intCol int,\n     xmlCol xml\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'com.scores.proc.Functions.weighQuestion'\n");
    }

    private void simpleDDL() throws Exception {
        this.goodStatement("create function simpleFunctionTable()\nreturns TABLE\n  (\n     intCol int,\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'com.scores.proc.Functions.weighQuestion'\n");
        this.verifyReturnType("SIMPLEFUNCTIONTABLE", "weighQuestion() RETURNS TABLE ( \"INTCOL\" INTEGER, \"VARCHARCOL\" VARCHAR(10) ) LANGUAGE JAVA PARAMETER STYLE DERBY_JDBC_RESULT_SET NO SQL CALLED ON NULL INPUT");
        this.assertFunctionDBMD("SIMPLEFUNCTIONTABLE", GF_SFT, GFC_SFT);
    }

    private void notTableFunction() throws Exception {
        this.goodStatement("create function invert( intValue int )\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".invert'\n");
        this.expectError("42ZB4", "select s.*\n    from TABLE( invert( 1 ) ) s\n");
    }

    private void classpathError() throws Exception {
        this.goodStatement("create function foo( a int )\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name 'Bop.doowop'\n");
        this.expectError("42X51", "values ( foo( 1 ) )");
        this.goodStatement("create function bar( a int )\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name 'java.lang.Integer.doowop'\n");
        this.expectError("42X50", "values ( bar( 1 ) )");
    }

    private void simpleVTIResults() throws Exception {
        this.goodStatement("create function returnsACoupleRows()\nreturns TABLE\n  (\n     column0 varchar( 10 ),\n     column1 varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".returnsACoupleRows'\n");
        this.assertResults("select s.*\n    from TABLE( returnsACoupleRows() ) s\n", SIMPLE_ROWS, new int[]{12, 12});
        this.goodStatement("create function returnsACoupleRowsAsCHAR()\nreturns TABLE\n  (\n     column0 char( 10 ),\n     column1 char( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".returnsACoupleRows'\n");
        String[][] CHAR_ROWS = new String[SIMPLE_ROWS.length][];
        for (int r = 0; r < CHAR_ROWS.length; ++r) {
            CHAR_ROWS[r] = new String[SIMPLE_ROWS[r].length];
            for (int c = 0; c < CHAR_ROWS[r].length; ++c) {
                String cv = SIMPLE_ROWS[r][c];
                if (cv == null || cv.length() >= 10) continue;
                StringBuffer sb = new StringBuffer(cv);
                for (int p = cv.length(); p < 10; ++p) {
                    sb.append(' ');
                }
                CHAR_ROWS[r][c] = sb.toString();
            }
        }
        this.assertResults("select s.*\n    from TABLE( returnsACoupleRowsAsCHAR() ) s\n", CHAR_ROWS, new int[]{1, 1});
        this.goodStatement("create function returnsBooleans()\nreturns TABLE\n  (\n     column0 varchar( 10 ),\n     column1 boolean\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".returnsBooleans'\n");
        this.assertResults("select s.*\n    from TABLE( returnsBooleans() ) s\n", BOOLEAN_ROWS, new int[]{12, 16});
    }

    private void bulkInsert() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement("create table bulkInsertTable\n  (\n     column0 int,\n     column1 varchar( 10 )\n  )\n");
        this.goodStatement("create table biSourceTable\n  (\n     column0 int,\n     column1 varchar( 10 )\n  )\n");
        this.goodStatement("create function bulkInsertVTI()\nreturns TABLE\n  (\n     column0 int,\n     column1 varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".bulkInsertVTI'\n");
        this.goodStatement("create view bulkInsertView( column0, column1 ) as select column0, column1\nfrom table( bulkInsertVTI() ) s\n");
        this.goodStatement("insert into biSourceTable select * from bulkInsertView\n");
        this.goodStatement("create table bulkInsertSimpleTable\n  (\n     column0 varchar( 10 ),\n     column1 varchar( 10 )\n  )\n");
        this.vetBulkInsert(conn, "insert into bulkInsertTable select * from table( bulkInsertVTI() ) s", true);
        this.vetBulkInsert(conn, "insert into bulkInsertTable select * from bulkInsertView", true);
        this.vetBulkInsert(conn, "insert into bulkInsertTable select * from table( bulkInsertVTI() ) s union select * from table (bulkInsertVTI()) t", true);
        this.vetBulkInsert(conn, "insert into bulkInsertTable select * from table( bulkInsertVTI()) b where b.column0 in (select c.column0 from table( bulkInsertVTI()) c)", true);
        this.goodStatement("delete from bulkInsertTable");
        this.vetBulkInsert(conn, "insert into bulkInsertTable select * from bulkInsertView b where 1 = (select count(*) from bulkInsertView bc where b.column0 > bc.column0)", true, BULK_INSERT_SELF_JOIN_ROWS);
        this.vetBulkInsert(conn, "insert into bulkInsertTable select * from biSourceTable", false);
        this.vetBulkInsert(conn, "insert into bulkInsertTable select * from table( bulkInsertVTI() ) s", true);
        this.vetBulkInsertSimple(conn, "insert into bulkInsertSimpleTable select * from table(RETURNSACOUPLEROWSASCHAR()) r", true);
        this.vetBulkInsertSimple(conn, "insert into bulkInsertSimpleTable select * from table( RETURNSACOUPLEROWSASCHAR() ) s union select * from table ( RETURNSACOUPLEROWSASCHAR() ) t", true);
        this.vetBulkInsertSimple(conn, "insert into bulkInsertSimpleTable select c.column0, c.column1 from table( RETURNSACOUPLEROWSASCHAR() ) c left outer join (select * from table( RETURNSACOUPLEROWSASCHAR() ) d) e on c.column0 = e.column0 and c.column1 = e.column1", true);
    }

    private void vetBulkInsert(Connection conn, String insert, boolean bulkInsertExpected) throws Exception {
        this.goodStatement("delete from bulkInsertTable");
        this.vetBulkInsert(conn, insert, bulkInsertExpected, BULK_INSERT_ROWS);
        this.vetBulkInsert(conn, insert, false, DOUBLY_INSERTED_ROWS);
    }

    private void vetBulkInsert(Connection conn, String insert, boolean bulkInsertExpected, String[][] expectedRows) throws Exception {
        long originalConglomerateID = this.getConglomerateID(conn, "BULKINSERTTABLE");
        this.goodStatement(insert);
        long conglomerateIDAfterInsert = this.getConglomerateID(conn, "BULKINSERTTABLE");
        TableFunctionTest.assertEquals((boolean)bulkInsertExpected, (originalConglomerateID != conglomerateIDAfterInsert ? 1 : 0) != 0);
        this.assertResults("select * from bulkInsertTable order by column0", expectedRows, new int[]{4, 12});
    }

    private void vetBulkInsertSimple(Connection conn, String insert, boolean bulkInsertSimpleExpected) throws Exception {
        this.goodStatement("delete from bulkInsertSimpleTable");
        this.vetBulkInsertSimple(conn, insert, bulkInsertSimpleExpected, SIMPLY_ROWS);
        this.vetBulkInsertSimple(conn, insert, false, DOUBLY_SIMPLE_ROWS);
    }

    private void vetBulkInsertSimple(Connection conn, String insert, boolean bulkInsertSimpleExpected, String[][] expectedRows) throws Exception {
        long originalConglomerateID = this.getConglomerateID(conn, "BULKINSERTSIMPLETABLE");
        this.goodStatement(insert);
        long conglomerateIDAfterInsert = this.getConglomerateID(conn, "BULKINSERTSIMPLETABLE");
        TableFunctionTest.assertEquals((boolean)bulkInsertSimpleExpected, (originalConglomerateID != conglomerateIDAfterInsert ? 1 : 0) != 0);
        this.assertResults("select * from bulkInsertSimpleTable order by column0", expectedRows, new int[]{12, 12});
    }

    private void allLegalDatatypesVTIResults() throws Exception {
        this.goodStatement("create function getXXXrecord()\nreturns varchar( 1000 )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI.getXXXrecord'\n");
        this.goodStatement("create function returnsAllLegalDatatypes( intArgument int, varcharArgument varchar( 10 ) )\nreturns TABLE\n  (\ncolumn0 BIGINT,\ncolumn1 BLOB,\ncolumn2 CHAR( 10 ),\ncolumn3 CHAR( 10 ) FOR BIT DATA,\ncolumn4 CLOB,\ncolumn5 DATE,\ncolumn6 DECIMAL,\ncolumn7 DOUBLE,\ncolumn8 DOUBLE PRECISION,\ncolumn9 FLOAT( 23 ),\ncolumn10 FLOAT( 24 ),\ncolumn11 INTEGER,\ncolumn12 LONG VARCHAR,\ncolumn13 LONG VARCHAR FOR BIT DATA,\ncolumn14 NUMERIC,\ncolumn15 REAL,\ncolumn16 SMALLINT,\ncolumn17 TIME,\ncolumn18 TIMESTAMP,\ncolumn19 VARCHAR( 10 ),\ncolumn20 VARCHAR( 10 ) FOR BIT DATA,\ncolumn21 BOOLEAN\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".returnsAllLegalDatatypes'\n");
        this.assertResults("select s.*\n    from TABLE( returnsAllLegalDatatypes( 1, 'one' ) ) s\n", ALL_TYPES_ROWS, new int[]{-5, 2004, 1, -2, 2005, 91, 3, 8, 8, 7, 8, 4, -1, -4, 2, 7, 5, 92, 93, 12, -3, 16});
        this.assertFunctionDBMD("RETURNSALLLEGALDATATYPES", GF_RADT, GFC_RADT);
        this.checkGetXXXCalls();
    }

    private void checkGetXXXCalls() throws Exception {
        int datatypeCount = ALL_TYPES_ROWS[0].length;
        StringBuffer buffer = new StringBuffer();
        buffer.append("select s.*\n");
        buffer.append("    from TABLE( returnsAllLegalDatatypes( 1, 'one' ) ) s\n");
        buffer.append("    where\n");
        for (int i = 0; i < datatypeCount; ++i) {
            String rc = "s.column" + i;
            if (i > 0) {
                buffer.append("   and ");
            }
            buffer.append("( " + rc + " is null )\n");
        }
        this.assertResults(buffer.toString(), ALL_TYPES_ROWS, new int[]{-5, 2004, 1, -2, 2005, 91, 3, 8, 8, 7, 8, 4, -1, -4, 2, 7, 5, 92, 93, 12, -3, 16});
        PreparedStatement ps = this.prepareStatement("values getXXXrecord()");
        ResultSet rs = ps.executeQuery();
        rs.next();
        String actualGetXXXCalls = rs.getString(1);
        rs.close();
        ps.close();
        TableFunctionTest.println(actualGetXXXCalls);
        String expectedGetXXXCalls = JDBC.vmSupportsJSR169() ? EXPECTED_GET_XXX_CALLS_JSR169 : EXPECTED_GET_XXX_CALLS;
        TableFunctionTest.assertEquals((String)expectedGetXXXCalls, (String)actualGetXXXCalls);
    }

    private void vtiCosting() throws Exception {
        this.goodStatement("create function missingConstructor()\nreturns TABLE\n  (\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI$MissingConstructor.dummyVTI'\n");
        this.expectError("42ZB5", "select s.*\n    from TABLE( missingConstructor() ) s\n");
        this.goodStatement("create function zeroArgConstructorNotPublic()\nreturns TABLE\n  (\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI$ZeroArgConstructorNotPublic.dummyVTI'\n");
        this.expectError("42ZB5", "select s.*\n    from TABLE( missingConstructor() ) s\n");
        this.goodStatement("create function constructorException()\nreturns TABLE\n  (\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI$ConstructorException.dummyVTI'\n");
        this.expectError("38000", "select s.*\n    from TABLE( constructorException() ) s\n");
        this.goodStatement("create function goodVTICosting()\nreturns TABLE\n  (\n     varcharCol varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI$GoodVTICosting.dummyVTI'\n");
        String optimizerStats = this.getOptimizerStats("select s.*\n    from TABLE( goodVTICosting() ) s\n");
        TableFunctionTest.assertEquals((double)13.0, (double)this.readDoubleTag(optimizerStats, ESTIMATED_ROW_COUNT), (double)0.0);
        TableFunctionTest.assertEquals((double)3149.0, (double)this.readDoubleTag(optimizerStats, ESTIMATED_COST), (double)0.0);
    }

    private void collationTest() throws Exception {
        Object tcol;
        String fcol;
        int i;
        TableFunctionTest.assertEquals((int)STRING_TYPES.length, (int)ALL_STRING_TYPES_ROWS[0].length);
        StringBuffer rowSet = new StringBuffer();
        int stringTypeCount = STRING_TYPES.length;
        rowSet.append("(\n");
        for (int i2 = 0; i2 < stringTypeCount; ++i2) {
            rowSet.append('\t');
            if (i2 > 0) {
                rowSet.append(", ");
            }
            rowSet.append("column" + i2 + " " + STRING_TYPES[i2] + "\n");
        }
        rowSet.append(")\n");
        this.goodStatement("create table allStringTypesTable\n" + rowSet.toString());
        this.goodStatement("create function allStringTypesFunction()\nreturns TABLE\n" + rowSet.toString() + "language java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".allStringTypesFunction'\n");
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into allStringTypesTable values\n");
        insertSql.append("(\n");
        for (int i3 = 0; i3 < stringTypeCount; ++i3) {
            if (i3 > 0) {
                insertSql.append(", ");
            }
            insertSql.append("?");
        }
        insertSql.append(")\n");
        PreparedStatement ps = this.chattyPrepare(insertSql.toString());
        int rowCount = ALL_STRING_TYPES_ROWS.length;
        for (int i4 = 0; i4 < rowCount; ++i4) {
            for (int j = 0; j < stringTypeCount; ++j) {
                ps.setString(j + 1, ALL_STRING_TYPES_ROWS[i4][j]);
            }
            ps.execute();
        }
        ps.close();
        StringBuffer compareRows = new StringBuffer();
        compareRows.append("select f.*\n    from TABLE( allStringTypesFunction() ) f,\n    allStringTypesTable t\nwhere\n");
        for (i = 0; i < stringTypeCount; ++i) {
            fcol = "f.column" + i;
            tcol = "t.column" + i;
            if (i > 0) {
                compareRows.append(" and ");
            }
            compareRows.append(fcol + " = " + (String)tcol);
        }
        this.assertResults(compareRows.toString(), ALL_STRING_TYPES_ROWS, STRING_JDBC_TYPES);
        compareRows = new StringBuffer();
        compareRows.append("select f.*\n    from TABLE( allStringTypesFunction() ) f,\n    sys.systables t\nwhere\n");
        for (i = 0; i < stringTypeCount; ++i) {
            fcol = "f.column" + i;
            tcol = "t.tablename";
            if (i > 0) {
                compareRows.append(" and ");
            }
            compareRows.append(fcol + " = " + (String)tcol);
        }
        if (this._usingLocaleSpecificCollation) {
            this.expectError("42818", compareRows.toString());
        } else {
            this.assertResults(compareRows.toString(), (String[][])new String[0][], STRING_JDBC_TYPES);
        }
    }

    private void subqueryTest() throws Exception {
        this.goodStatement("create table fooTestTable\n(\n    inputCol    varchar( 20 ),\n    outputCol   varchar( 30 )\n)\n");
        this.goodStatement("insert into fooTestTable\nvalues\n( 'succeed1', 'succeed1 foo' ),\n( 'fail1', 'ladeedah' ),\n( 'succeed2', 'succeed2 bar' ),\n( 'fail2', 'hoopla' )\n");
        this.goodStatement("create function appendFooAndBar( inputArg varchar( 20 ) )\nreturns TABLE\n  (\n     inputText varchar( 20 ),\n     outputText varchar( 30 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.TableFunctionTest.appendFooAndBar'\n");
        this.assertResults("select * from fooTestTable\nwhere outputCol in\n(\n    select f.outputText\n    from TABLE( appendFooAndBar( inputCol ) ) as f\n)\n", new String[]{"INPUTCOL", "OUTPUTCOL"}, (String[][])new String[][]{{"succeed1", "succeed1 foo"}, {"succeed2", "succeed2 bar"}}, new int[]{12, 12});
    }

    private void coercionTest() throws Exception {
        this.goodStatement("create function coercionFunction( )\nreturns TABLE\n  (\n     keyCol int,\n     charCol char( 5 ),\n     varcharCol varchar( 5 ),\n     charForBitDataCol char( 5 ) for bit data,\n     varcharForBitDataCol varchar( 5 ) for bit data,\n     decimalCol decimal( 5, 2 ),\n     longvarcharCol long varchar,\n     longvarcharForBitDataCol long varchar for bit data\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.TableFunctionTest.coercionFunction'\n");
        this.assertResults("select *\nfrom TABLE( coercionFunction( ) ) as f order by keyCol\n", new String[]{"KEYCOL", "CHARCOL", "VARCHARCOL", "CHARFORBITDATACOL", "VARCHARFORBITDATACOL", "DECIMALCOL", "LONGVARCHARCOL", "LONGVARCHARFORBITDATACOL"}, TableFunctionTest.makeCoercionOutputs(), new int[]{4, 1, 12, -2, -3, 3, -1, -4});
    }

    private void miscBugs() throws Exception {
        this.derby_4092();
        this.derby_5779();
        this.derby_6040();
        this.derby_6151();
    }

    private void derby_4092() throws Exception {
        this.goodStatement("create function derby_4092()\nreturns TABLE\n  (\n     column0 varchar( 10 ),\n     column1 varchar( 10 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".returnsACoupleRows'\n");
        this.expectError("42ZB6", "values( derby_4092() )");
        this.expectError("42ZB6", "select derby_4092(), tablename from sys.systables");
    }

    private void derby_5779() throws Exception {
        this.goodStatement("create function lowerCaseRow( contents varchar( 32672 ) )\nreturns table\n(\n    contents varchar( 32672 )\n)\nlanguage java parameter style DERBY_JDBC_RESULT_SET no sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".lowerCaseRow'\n");
        this.goodStatement("create table t_5779( a int )\n");
        this.assertResults("select contents column0 from table( lowerCaseRow( 'FOO' ) ) t\n", (String[][])new String[][]{{"foo"}}, new int[]{12});
        PreparedStatement ps = this.prepareStatement("select contents from table( lowerCaseRow( ? ) ) t\n");
        ps.setString(1, "FOO");
        ResultSet rs = ps.executeQuery();
        this.assertResults(new int[]{12}, new String[]{"CONTENTS"}, rs, new String[][]{{"foo"}});
        rs.close();
        ps.close();
        this.assertResults("select tablename column0\nfrom sys.systables t\nwhere lower( cast (tablename as varchar( 32672 )) ) in\n( select contents from table( lowerCaseRow( 'SYSCOLUMNS' ) ) s )\n", (String[][])new String[][]{{"SYSCOLUMNS"}}, new int[]{12});
        this.assertResults("select tablename column0\nfrom sys.systables t\nwhere lower( cast (tablename as varchar( 32672 )) ) in\n( select contents from table( lowerCaseRow( cast (t.tablename as varchar(32672)) ) ) s )\nand length( tablename ) = 16\n", (String[][])new String[][]{{"SYSCONGLOMERATES"}}, new int[]{12});
        this.assertResults("select t2.conglomeratename column0\n    from \n        sys.systables systabs,\n        table (syscs_diag.space_table(systabs.tablename)) as t2\n    where cast (systabs.tablename as varchar(10)) = 'T_5779'\n", (String[][])new String[][]{{"T_5779"}}, new int[]{12});
        this.assertResults("select contents column0\nfrom table( lowerCaseRow( 'FOO' ) ) s\nwhere exists ( select tableid from sys.systables t )\n", (String[][])new String[][]{{"foo"}}, new int[]{12});
        this.expectError(BAD_ARG_JOIN, "select tablename, contents\nfrom sys.systables t, table( lowerCaseRow( cast (t.tablename as varchar(32672)) ) ) s\n");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table(syscs_diag.space_table(st.tablename)) tt join sys.systables st using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st join table(syscs_diag.space_table(st.tablename)) tt using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table(syscs_diag.space_table(st.tablename)) tt right join sys.systables st using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st right join table(syscs_diag.space_table(st.tablename)) tt using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table(syscs_diag.space_table(st.tablename)) tt left join sys.systables st using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st left join table(syscs_diag.space_table(st.tablename)) tt using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table( lowerCaseRow(st.tablename)) tt join sys.systables st on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st join table( lowerCaseRow(st.tablename)) tt on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table( lowerCaseRow(st.tablename)) tt right join sys.systables st on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st right join table( lowerCaseRow(st.tablename)) tt on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table( lowerCaseRow(st.tablename)) tt left join sys.systables st on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from sys.systables st left join table( lowerCaseRow(st.tablename)) tt on tt.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from ( table(syscs_diag.space_table('foo')) tt join sys.systables st using(tableid) ) join table(syscs_diag.space_table(st.tablename)) tr using(tableid)");
        this.expectError(BAD_ARG_JOIN, "select tt.* from ( table( lowerCaseRow('foo')) tt join sys.systables st on tt.contents = st.tablename ) join table( lowerCaseRow(st.tablename)) tr on tr.contents = st.tablename");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table(syscs_diag.space_table(st.tablename)) tt cross join sys.systables st");
        this.expectError(BAD_ARG_JOIN, "select tt.* from table( lowerCaseRow(st.tablename)) tt cross join sys.systables st");
        this.expectError(BAD_ARG_JOIN, "select tt.* from ( table(syscs_diag.space_table('foo')) tt cross join sys.systables st ) cross join table(syscs_diag.space_table(st.tablename)) tr");
        this.expectError(BAD_ARG_JOIN, "select tt.* from ( table( lowerCaseRow('foo')) tt cross join sys.systables st ) cross join table( lowerCaseRow(st.tablename)) tr");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        ( select * from table (syscs_diag.space_table( systabs.tablename )) as t2 ) tt\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        ( select * from table (lowerCaseRow( systabs.tablename )) as t2 ) tt\n    where systabs.tabletype = 'T' and systabs.tablename = tt.contents\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        ( select tablename from table (syscs_diag.space_table( systabs.tablename )) as t2 ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        ( select * from table (lowerCaseRow( systabs.tablename )) as t2 ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        (\n            select columnname from sys.syscolumns\n            union\n            select tablename from table (syscs_diag.space_table( systabs.tablename )) as t2\n        ) tt\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        (\n            select columnname from sys.syscolumns\n            union\n            select tablename from table (syscs_diag.space_table( systabs.tablename )) as t2\n        ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        (\n            select columnname from sys.syscolumns\n            union\n            select contents from table (lowerCaseRow( systabs.tablename )) as t2\n        ) tt\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        (\n            select columnname from sys.syscolumns\n            union\n            select contents from table (lowerCaseRow( systabs.tablename )) as t\n        ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        (\n            select * from\n            sys.syscolumns col,\n            ( select tablename from table (syscs_diag.space_table( systabs.tablename )) as t2 ) ti\n            where col.columnname = ti.tablename\n        ) tt\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        sys.systables systabs,\n        (\n            select * from\n            sys.syscolumns col,\n            ( select contents from table (lowerCaseRow( systabs.tablename )) as t2 ) ti\n            where col.columnname = ti.contents\n        ) tt\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        (\n            select * from\n            sys.syscolumns col,\n            ( select tablename from table (syscs_diag.space_table( systabs.tablename )) as t2 ) ti\n            where col.columnname = ti.tablename\n        ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError(BAD_ARG_JOIN, "select tt.*\n    from\n        (\n            select * from\n            sys.syscolumns col,\n            ( select contents from table (lowerCaseRow( systabs.tablename )) as t2 ) ti\n            where col.columnname = ti.contents\n        ) tt,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = tt.tableid\n");
        this.expectError("42X04", "select contents\nfrom table( lowerCaseRow( cast( t.tablename as varchar(32672)) ) ) s\nwhere exists ( select tableid from sys.systables t )\n");
    }

    private void derby_6040() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.goodStatement("create function leftTable\n(\n    columnNames varchar( 32672 ),\n    rowContents varchar( 32672 ) ...\n)\nreturns table\n(\n    a0   varchar( 5 ),\n    a1   varchar( 5 ),\n    a2   varchar( 5 ),\n    a3   varchar( 5 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.stringArrayTable'\n");
        this.goodStatement("create function rightTable\n(\n    columnNames varchar( 32672 ),\n    rowContents varchar( 32672 ) ...\n)\nreturns table\n(\n    b1   varchar( 5 ),\n    b2   varchar( 5 ),\n    b3   varchar( 5 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.VarargsRoutines.stringArrayTable'\n");
        this.assertResults("select l.a2 column0, r.b3 column1\nfrom\n    table( leftTable\n            (\n            'A0 A1 A2 A3',\n            'X APP T Z',\n            'X APP S Z'\n            ) ) l,\n    table( rightTable\n           (\n           'B1 B2 B3',\n           'APP T A',\n           'APP T B',\n           'APP S A',\n           'APP S B'\n           ) ) r\nwhere r.b2 = l.a2\nand l.a3 = 'Z'\nand r.b1 = l.a1\norder by column0, column1\n", (String[][])new String[][]{{"S", "A"}, {"S", "B"}, {"T", "A"}, {"T", "B"}}, new int[]{12, 12});
    }

    private void derby_6151() throws Exception {
        this.goodStatement("create function warningVTI() returns table( a int, b varchar( 5 ) )\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".warningVTI'\n");
        ResultSet rs = this.getConnection().prepareStatement("select * from table( warningVTI() ) t").executeQuery();
        rs.next();
        TableFunctionTest.assertEquals((String)"Warning for row 1", (String)rs.getWarnings().getMessage());
        rs.clearWarnings();
        rs.next();
        TableFunctionTest.assertEquals((String)"Warning for row 2", (String)rs.getWarnings().getMessage());
        rs.close();
        this.goodStatement("drop function warningVTI");
    }

    private static String[][] makeCoercionInputs() {
        return new String[][]{{"1", "abc", "abc", "abc", "abc", "12.3", TableFunctionTest.makeString(5), TableFunctionTest.makeByteString(5)}, {"2", "abcdef", "abcdef", "abcdef", "abcdef", "12.345", TableFunctionTest.makeString(32701), TableFunctionTest.makeByteString(32701)}, {"3", "abcde", "abcde", "abcde", "abcde", "123.45", TableFunctionTest.makeString(5), TableFunctionTest.makeByteString(5)}};
    }

    private static String[][] makeCoercionOutputs() {
        return new String[][]{{"1", "abc  ", "abc", "abc  ", "abc", "12.30", TableFunctionTest.makeString(5), TableFunctionTest.makeByteString(5)}, {"2", "abcde", "abcde", "abcde", "abcde", "12.34", TableFunctionTest.makeString(32700), TableFunctionTest.makeByteString(32700)}, {"3", "abcde", "abcde", "abcde", "abcde", "123.45", TableFunctionTest.makeString(5), TableFunctionTest.makeByteString(5)}};
    }

    private static String makeString(int count) {
        char[] raw = new char[count];
        Arrays.fill(raw, 'a');
        return new String(raw);
    }

    private static String makeByteString(int count) {
        try {
            byte[] raw = new byte[count];
            byte value = 1;
            Arrays.fill(raw, value);
            return new String(raw, UTF8);
        }
        catch (Throwable t) {
            TableFunctionTest.println(t.getMessage());
            return null;
        }
    }

    public static int invert(int value) {
        return -value;
    }

    public static ResultSet returnsBooleans() {
        return TableFunctionTest.makeVTI(BOOLEAN_ROWS);
    }

    public static ResultSet returnsACoupleRows() {
        return TableFunctionTest.makeVTI(SIMPLE_ROWS);
    }

    public static ResultSet bulkInsertVTI() {
        return TableFunctionTest.makeVTI(BULK_INSERT_ROWS);
    }

    public static ResultSet returnsAllLegalDatatypes(int intArg, String varcharArg) {
        return TableFunctionTest.makeVTI(ALL_TYPES_ROWS);
    }

    public static ResultSet allStringTypesFunction() {
        return TableFunctionTest.makeVTI(ALL_STRING_TYPES_ROWS);
    }

    public static ResultSet appendFooAndBar(String text) {
        String[][] kernel = new String[][]{{text, text + " foo"}, {text, text + " bar"}};
        return TableFunctionTest.makeVTI(kernel);
    }

    public static ResultSet coercionFunction() {
        return TableFunctionTest.makeVTI(TableFunctionTest.makeCoercionInputs());
    }

    public static ResultSet lowerCaseRow(String contents) {
        return TableFunctionTest.makeVTI(new String[][]{{contents.toLowerCase()}});
    }

    public void assertResults(String sql, String[][] rows, int[] expectedJdbcTypes) throws Exception {
        String[] columnNames = TableFunctionTest.makeColumnNames(expectedJdbcTypes.length, "COLUMN");
        this.assertResults(sql, columnNames, rows, expectedJdbcTypes);
    }

    public void assertResults(String sql, String[] columnNames, String[][] rows, int[] expectedJdbcTypes) throws Exception {
        TableFunctionTest.println("\nExpecting good results from " + sql);
        PreparedStatement ps = this.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        this.assertResults(expectedJdbcTypes, columnNames, rs, rows);
        rs.close();
        ps.close();
    }

    private void expectError(String sqlState, String query) {
        TableFunctionTest.println("\nExpecting " + sqlState + " when preparing:\n\t" + query);
        this.assertCompileError(sqlState, query);
    }

    private void goodStatement(String ddl) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(ddl);
        ps.execute();
        ps.close();
    }

    private PreparedStatement chattyPrepare(String text) throws SQLException {
        TableFunctionTest.println("Preparing statement:\n\t" + text);
        return this.prepareStatement(text);
    }

    private void verifyReturnType(String functionName, String expectedReturnType) throws SQLException {
        TableFunctionTest.println(functionName + " should have return type = " + expectedReturnType);
        String ddl = "select aliasinfo from sys.sysaliases where alias=?";
        PreparedStatement ps = this.prepareStatement(ddl);
        ps.setString(1, functionName);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), expectedReturnType);
    }

    public void assertFunctionDBMD(String functionName, Object[][] expectedGetFunctionsResult, Object[][] expectedGetFunctionColumnsResult) throws Exception {
        TableFunctionTest.println("\nExpecting correct function metadata from " + functionName);
        ResultSet rs = this._databaseMetaData.getFunctions(null, "APP", functionName);
        JDBC.assertFullResultSet(rs, expectedGetFunctionsResult, false);
        rs.close();
        TableFunctionTest.println("\nExpecting correct function column metadata from " + functionName);
        rs = this._databaseMetaData.getFunctionColumns(null, "APP", functionName, "%");
        JDBC.assertFullResultSet(rs, expectedGetFunctionColumnsResult, false);
        rs.close();
    }

    private void dropSchema() throws Exception {
        int functionCount = FUNCTION_NAMES.length;
        for (int i = 0; i < functionCount; ++i) {
            this.dropFunction(FUNCTION_NAMES[i]);
        }
        int tableCount = TABLE_NAMES.length;
        for (int i = 0; i < tableCount; ++i) {
            this.dropTable(TABLE_NAMES[i]);
        }
    }

    private void dropFunction(String functionName) throws Exception {
        try {
            PreparedStatement ps = this.prepareStatement("drop function " + functionName);
            ps.execute();
            ps.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void assertResults(int[] expectedJdbcTypes, String[] columnNames, ResultSet rs, String[][] rows) throws Exception {
        int rowCount = rows.length;
        int[] actualJdbcTypes = this.getJdbcColumnTypes(rs);
        this.compareJdbcTypes(expectedJdbcTypes, actualJdbcTypes);
        this.compareColumnNames(columnNames, rs);
        for (int i = 0; i < rowCount; ++i) {
            String[] row = rows[i];
            int columnCount = row.length;
            TableFunctionTest.assertTrue((boolean)rs.next());
            for (int j = 0; j < columnCount; ++j) {
                String columnName = columnNames[j];
                String expectedValue = row[j];
                String actualValue = null;
                String actualValueByName = null;
                int column = j + 1;
                int actualJdbcType = actualJdbcTypes[j];
                switch (actualJdbcType) {
                    case 16: {
                        actualValue = Boolean.toString(rs.getBoolean(column));
                        actualValueByName = Boolean.toString(rs.getBoolean(columnName));
                        if (!rs.wasNull()) break;
                        actualValueByName = null;
                        actualValue = null;
                        break;
                    }
                    case -5: {
                        actualValue = Long.toString(rs.getLong(column));
                        actualValueByName = Long.toString(rs.getLong(columnName)).toString();
                        if (!rs.wasNull()) break;
                        actualValueByName = null;
                        actualValue = null;
                        break;
                    }
                    case 4: {
                        actualValue = Integer.toString(rs.getInt(column));
                        actualValueByName = Integer.toString(rs.getInt(columnName));
                        if (!rs.wasNull()) break;
                        actualValueByName = null;
                        actualValue = null;
                        break;
                    }
                    case 5: {
                        actualValue = Short.toString(rs.getShort(column));
                        actualValueByName = Short.toString(rs.getShort(columnName));
                        if (!rs.wasNull()) break;
                        actualValueByName = null;
                        actualValue = null;
                        break;
                    }
                    case -6: {
                        actualValue = Byte.toString(rs.getByte(column));
                        actualValueByName = Byte.toString(rs.getByte(columnName));
                        if (!rs.wasNull()) break;
                        actualValueByName = null;
                        actualValue = null;
                        break;
                    }
                    case 8: {
                        actualValue = Double.toString(rs.getDouble(column));
                        actualValueByName = Double.toString(rs.getDouble(columnName));
                        if (!rs.wasNull()) break;
                        actualValueByName = null;
                        actualValue = null;
                        break;
                    }
                    case 6: 
                    case 7: {
                        actualValue = Float.toString(rs.getFloat(column));
                        actualValueByName = Float.toString(rs.getFloat(columnName));
                        if (!rs.wasNull()) break;
                        actualValueByName = null;
                        actualValue = null;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (JDBC.vmSupportsJDBC3()) {
                            actualValue = this.squeezeString(rs.getBigDecimal(column));
                            actualValueByName = this.squeezeString(rs.getBigDecimal(columnName));
                            break;
                        }
                        actualValue = this.squeezeString(rs.getString(column));
                        actualValueByName = this.squeezeString(rs.getString(columnName));
                        break;
                    }
                    case 91: {
                        actualValue = this.squeezeString(rs.getDate(column));
                        actualValueByName = this.squeezeString(rs.getDate(columnName));
                        break;
                    }
                    case 92: {
                        actualValue = this.squeezeString(rs.getTime(column));
                        actualValueByName = this.squeezeString(rs.getTime(columnName));
                        break;
                    }
                    case 93: {
                        actualValue = this.squeezeString(rs.getTimestamp(column));
                        actualValueByName = this.squeezeString(rs.getTimestamp(columnName));
                        break;
                    }
                    case 2004: {
                        Blob blob = rs.getBlob(column);
                        actualValue = this.squeezeString(blob);
                        actualValueByName = this.squeezeString(blob);
                        break;
                    }
                    case 2005: {
                        Clob clob = rs.getClob(column);
                        actualValue = this.squeezeString(clob);
                        actualValueByName = this.squeezeString(clob);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] bytes = rs.getBytes(column);
                        actualValue = this.squeezeString(bytes);
                        actualValueByName = this.squeezeString(rs.getBytes(columnName));
                        break;
                    }
                    case 2000: {
                        actualValue = this.squeezeString(rs.getObject(column));
                        actualValueByName = this.squeezeString(rs.getObject(columnName));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        actualValue = rs.getString(column);
                        actualValueByName = rs.getString(columnName);
                        break;
                    }
                    default: {
                        TableFunctionTest.fail((String)("Can't handle jdbc type " + actualJdbcType));
                    }
                }
                if (actualValue == null) {
                    TableFunctionTest.assertNull(actualValueByName);
                } else {
                    TableFunctionTest.assertTrue((boolean)actualValue.equals(actualValueByName));
                }
                TableFunctionTest.assertEquals((expectedValue == null ? 1 : 0) != 0, (boolean)rs.wasNull());
                if (expectedValue == null) {
                    TableFunctionTest.assertNull((Object)actualValue);
                    continue;
                }
                TableFunctionTest.assertEquals((String)expectedValue, (String)actualValue);
            }
        }
        TableFunctionTest.assertFalse((boolean)rs.next());
    }

    private void compareJdbcTypes(int[] expected, int[] actual) throws Exception {
        int count = expected.length;
        TableFunctionTest.assertEquals((int)count, (int)actual.length);
        for (int i = 0; i < count; ++i) {
            TableFunctionTest.assertEquals((String)("Type at position " + i), (int)expected[i], (int)actual[i]);
        }
    }

    private void compareColumnNames(String[] expectedNames, ResultSet rs) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = rsmd.getColumnCount();
        TableFunctionTest.println("Expecting " + expectedNames.length + " columns.");
        TableFunctionTest.assertEquals((int)expectedNames.length, (int)count);
        for (int i = 0; i < count; ++i) {
            TableFunctionTest.assertEquals((String)expectedNames[i], (String)rsmd.getColumnName(i + 1));
        }
    }

    private int[] getJdbcColumnTypes(ResultSet rs) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = rsmd.getColumnCount();
        int[] actualJdbcTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            actualJdbcTypes[i] = rsmd.getColumnType(i + 1);
        }
        return actualJdbcTypes;
    }

    private String squeezeString(Object obj) throws Exception {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            return new String(blob.getBytes(0L, (int)blob.length()), UTF8);
        }
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            return clob.getSubString(0L, (int)clob.length());
        }
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            return new String(bytes, UTF8);
        }
        return obj.toString();
    }

    private static StringArrayVTI makeVTI(String[][] rows) {
        int columnCount = rows[0].length;
        return new StringArrayVTI(TableFunctionTest.makeColumnNames(columnCount, "mycol"), rows);
    }

    private static String[] makeColumnNames(int columnCount, String stub) {
        String[] names = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            names[i] = stub + i;
        }
        return names;
    }

    public static void prettyPrint(Connection conn, ResultSet rs) throws SQLException {
        JDBCDisplayUtil.DisplayResults((PrintStream)System.out, (ResultSet)rs, (Connection)conn);
    }

    private String getOptimizerStats(String query) throws Exception {
        this.goodStatement("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.goodStatement("CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        this.goodStatement(query);
        PreparedStatement ps = this.prepareStatement("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        ResultSet rs = ps.executeQuery();
        rs.next();
        String retval = rs.getString(1);
        rs.close();
        ps.close();
        this.goodStatement("CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)");
        this.goodStatement("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        return retval;
    }

    private double readDoubleTag(String optimizerOutput, String tag) throws Exception {
        String line;
        StringReader stringReader = new StringReader(optimizerOutput);
        LineNumberReader lineNumberReader = new LineNumberReader(stringReader);
        while ((line = lineNumberReader.readLine()) != null) {
            int idx = line.indexOf(tag);
            if (idx < 0) continue;
            String remnant = line.substring(idx + tag.length()).trim();
            Number result = NumberFormat.getInstance().parse(remnant);
            TableFunctionTest.println("Read " + result + " from optimizer output.");
            return result.doubleValue();
        }
        return 0.0;
    }

    private long getConglomerateID(Connection conn, String tableName) throws Exception {
        PreparedStatement ps = conn.prepareStatement("select c.conglomeratenumber\nfrom sys.sysconglomerates c, sys.systables t\nwhere t.tablename = ? and t.tableid = c.tableid");
        ps.setString(1, tableName);
        long result = this.getScalarLong(ps);
        ps.close();
        return result;
    }

    private long getScalarLong(PreparedStatement ps) throws Exception {
        ResultSet rs = ps.executeQuery();
        rs.next();
        long retval = rs.getLong(1);
        rs.close();
        ps.close();
        return retval;
    }

    public static WarningVTI warningVTI() {
        return new WarningVTI();
    }

    public static final class WarningVTI
    extends StringArrayVTI {
        private int _count;

        public WarningVTI() {
            super(TableFunctionTest.makeColumnNames(2, "mycol"), WARNING_VTI_ROWS);
        }

        @Override
        public boolean next() throws SQLException {
            boolean retval = super.next();
            if (retval) {
                ++this._count;
            }
            return retval;
        }

        public SQLWarning getWarnings() {
            return new SQLWarning("Warning for row " + this._count);
        }
    }
}

