/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OptionalToolsTest
extends GeneratedColumnsHelper {
    protected static final String NO_SUCH_TABLE_FUNCTION = "42ZB4";
    protected static final String UNEXPECTED_USER_EXCEPTION = "38000";
    protected static final String MISSING_SCHEMA = "42Y07";
    protected static final String UNKNOWN_TOOL = "X0Y88";
    protected static final String UNKNOWN_ROUTINE = "42Y03";
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK"};
    private static final String FOREIGN_DB = "foreignDB";

    public OptionalToolsTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.embeddedSuite(OptionalToolsTest.class);
        Object test = DatabasePropertyTestSetup.builtinAuthentication((Test)suite, LEGAL_USERS, "optionalToolsPermissions");
        test = TestConfiguration.sqlAuthorizationDecorator(test);
        test = TestConfiguration.additionalDatabaseDecorator(test, FOREIGN_DB);
        return test;
    }

    public void test_01_dbmdWrapper() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        String getTypeInfo = "select type_name, minimum_scale, maximum_scale from table( getTypeInfo() ) s";
        this.expectExecutionError(ruthConnection, "42504", "call syscs_util.syscs_register_tool( 'databaseMetaData', true )");
        this.goodStatement(dboConnection, "create table t( a int )");
        this.expectCompilationError(dboConnection, NO_SUCH_TABLE_FUNCTION, getTypeInfo);
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'databaseMetaData', true )");
        this.assertResults(dboConnection, getTypeInfo, new String[][]{{"BIGINT", "0", "0"}, {"LONG VARCHAR FOR BIT DATA", null, null}, {"VARCHAR () FOR BIT DATA", null, null}, {"CHAR () FOR BIT DATA", null, null}, {"LONG VARCHAR", null, null}, {"CHAR", null, null}, {"NUMERIC", "0", "31"}, {"DECIMAL", "0", "31"}, {"INTEGER", "0", "0"}, {"SMALLINT", "0", "0"}, {"FLOAT", null, null}, {"REAL", null, null}, {"DOUBLE", null, null}, {"VARCHAR", null, null}, {"BOOLEAN", null, null}, {"DATE", "0", "0"}, {"TIME", "0", "0"}, {"TIMESTAMP", "0", "9"}, {"OBJECT", null, null}, {"BLOB", null, null}, {"CLOB", null, null}, {"XML", null, null}}, false);
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'databaseMetaData', false )");
        this.expectCompilationError(dboConnection, NO_SUCH_TABLE_FUNCTION, getTypeInfo);
    }

    public void test_02_foreignDBViews() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection foreignFrankConnection = this.getTestConfiguration().openConnection(FOREIGN_DB, FRANK, FRANK);
        Connection foreignAliceConnection = this.getTestConfiguration().openConnection(FOREIGN_DB, ALICE, ALICE);
        this.goodStatement(foreignFrankConnection, "create table employee\n(\n    firstName   varchar( 50 ),\n    lastName    varchar( 50 ),\n    employeeID  int primary key\n)\n");
        this.goodStatement(foreignFrankConnection, "insert into employee values ( 'Billy', 'Goatgruff', 1 )\n");
        this.goodStatement(foreignFrankConnection, "insert into employee values ( 'Mary', 'Hadalittlelamb', 2 )\n");
        this.goodStatement(foreignAliceConnection, "create table stars\n(\n    name   varchar( 50 ),\n    magnitude int,\n    starID  int primary key\n)\n");
        this.goodStatement(foreignAliceConnection, "insert into stars values ( 'Polaris', 100, 1 )\n");
        String foreignURL = "jdbc:derby:" + this.getTestConfiguration().getPhysicalDatabaseName(FOREIGN_DB) + ";user=TEST_DBO;password=TEST_DBO";
        String employeeSelect = "select * from frank.employee order by employeeID";
        String starSelect = "select * from alice.stars order by starID";
        String[][] employeeResult = new String[][]{{"Billy", "Goatgruff", "1"}, {"Mary", "Hadalittlelamb", "2"}};
        String[][] starResult = new String[][]{{"Polaris", "100", "1"}};
        this.goodStatement(dboConnection, "create function countConnections() returns int\nlanguage java parameter style java no sql\nexternal name 'org.apache.derby.vti.ForeignTableVTI.countConnections'\n");
        this.expectExecutionError(dboConnection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool( 'foreignViews', true )");
        this.expectCompilationError(dboConnection, MISSING_SCHEMA, employeeSelect);
        this.expectCompilationError(dboConnection, MISSING_SCHEMA, starSelect);
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'foreignViews', true, '" + foreignURL + "' )");
        this.assertResults(dboConnection, employeeSelect, employeeResult, false);
        this.assertResults(dboConnection, starSelect, starResult, false);
        this.assertResults(dboConnection, "values countConnections()", new String[][]{{"1"}}, false);
        this.expectExecutionError(dboConnection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool( 'foreignViews', false )");
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'foreignViews', false, '" + foreignURL + "' )");
        this.assertResults(dboConnection, "values countConnections()", new String[][]{{"0"}}, false);
        this.expectCompilationError(dboConnection, MISSING_SCHEMA, employeeSelect);
        this.expectCompilationError(dboConnection, MISSING_SCHEMA, starSelect);
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'foreignViews', false, '" + foreignURL + "' )");
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'foreignViews', true, '" + foreignURL + "', 'XYZ_' )");
        employeeSelect = "select * from xyz_frank.employee order by employeeID";
        starSelect = "select * from xyz_alice.stars order by starID";
        this.assertResults(dboConnection, employeeSelect, employeeResult, false);
        this.assertResults(dboConnection, starSelect, starResult, false);
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'foreignViews', false, '" + foreignURL + "', 'XYZ_' )");
        this.expectCompilationError(dboConnection, MISSING_SCHEMA, employeeSelect);
        this.expectCompilationError(dboConnection, MISSING_SCHEMA, starSelect);
        this.assertResults(dboConnection, "values countConnections()", new String[][]{{"0"}}, false);
        this.goodStatement(dboConnection, "drop function countConnections");
    }

    public void test_03_customTool() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.expectExecutionError(dboConnection, UNKNOWN_TOOL, "call syscs_util.syscs_register_tool( 'uknownToolName', true )");
        this.expectExecutionError(dboConnection, UNKNOWN_TOOL, "call syscs_util.syscs_register_tool( 'customTool', true )");
        this.expectExecutionError(dboConnection, UNKNOWN_TOOL, "call syscs_util.syscs_register_tool( 'customTool', true, 'java.lang.String' )");
        this.expectCompilationError(dboConnection, UNKNOWN_ROUTINE, "values toString( 100 )");
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'customTool', true, 'org.apache.derbyTesting.functionTests.tests.lang.OptionalToolExample' )");
        this.assertResults(dboConnection, "values toString( 100 )", new String[][]{{"100"}}, false);
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'customTool', false, 'org.apache.derbyTesting.functionTests.tests.lang.OptionalToolExample' )");
        this.expectCompilationError(dboConnection, UNKNOWN_ROUTINE, "values toString( 100 )");
        this.expectCompilationError(dboConnection, UNKNOWN_ROUTINE, "values foobar( 100 )");
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool\n(\n    'customTool',\n    true,\n    'org.apache.derbyTesting.functionTests.tests.lang.OptionalToolExample$VariableName',\n    'foobar'\n)\n");
        this.assertResults(dboConnection, "values foobar( 100 )", new String[][]{{"100"}}, false);
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool\n(\n    'customTool',\n    false,\n    'org.apache.derbyTesting.functionTests.tests.lang.OptionalToolExample$VariableName',\n    'foobar'\n)\n");
        this.expectCompilationError(dboConnection, UNKNOWN_ROUTINE, "values foobar( 100 )");
    }

    public void test_04_customOptimizerTrace() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create function fullTrace() returns varchar( 32672 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.DummyOptTrace.fullTrace'\n");
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool\n(\n    'optimizerTracing', true, 'custom',\n    'org.apache.derbyTesting.functionTests.tests.lang.DummyOptTrace'\n)\n");
        this.goodStatement(dboConnection, "select tablename from sys.systables where 1=2");
        this.goodStatement(dboConnection, "select columnname from sys.syscolumns where 1=2");
        this.goodStatement(dboConnection, "call syscs_util.syscs_register_tool( 'optimizerTracing', false )");
        this.assertResults(dboConnection, "values fullTrace()", new String[][]{{"<text>select tablename from sys.systables where 1=2</text><text>select columnname from sys.syscolumns where 1=2</text><text>call syscs_util.syscs_register_tool( 'optimizerTracing', false )</text>"}}, false);
        this.goodStatement(dboConnection, "drop function fullTrace");
        this.expectExecutionError(dboConnection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool( 'optimizerTracing', true, 'custom' )");
        this.expectExecutionError(dboConnection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool( 'optimizerTracing', true, 'custom', 'foo.bar.Wibble' )");
        this.expectExecutionError(dboConnection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool( 'optimizerTracing', true, 'custom', 'java.lang.String' )");
        this.expectExecutionError(dboConnection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool\n(\n    'optimizerTracing', true, 'custom',\n    'org.apache.derbyTesting.functionTests.tests.lang.DummyOptTrace$BadSubclass'\n)\n");
    }
}

