/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryListOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class InListOperatorNode
extends BinaryListOperatorNode {
    private boolean isOrdered;
    private boolean sortDescending;

    InListOperatorNode(ValueNode leftOperand, ValueNodeList rightOperandList, ContextManager cm) throws StandardException {
        super(leftOperand, rightOperandList, "IN", "in", cm);
    }

    @Override
    public String toString() {
        return "isOrdered: " + this.isOrdered + "\n" + super.toString();
    }

    protected InListOperatorNode shallowCopy() throws StandardException {
        InListOperatorNode ilon = new InListOperatorNode(this.leftOperand, this.rightOperandList, this.getContextManager());
        ilon.copyFields(this);
        if (this.isOrdered) {
            ilon.markAsOrdered();
        }
        if (this.sortDescending) {
            ilon.markSortDescending();
        }
        return ilon;
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        super.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (this.rightOperandList.size() == 1) {
            BinaryRelationalOperatorNode equal = new BinaryRelationalOperatorNode(0, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(0), false, this.getContextManager());
            equal.bindComparisonOperator();
            return equal;
        }
        DataTypeDescriptor targetType = this.getDominantType();
        int targetTypePrecedence = targetType.getTypeId().typePrecedence();
        if (this.leftOperand.getTypeServices().getTypeId().typePrecedence() != targetTypePrecedence && !this.rightOperandList.allSamePrecendence(targetTypePrecedence)) {
            CastNode cn = new CastNode(this.leftOperand, targetType, this.getContextManager());
            cn.bindCastNodeOnly();
            this.leftOperand = cn;
        }
        if (this.leftOperand instanceof ColumnReference && this.rightOperandList.containsOnlyConstantAndParamNodes()) {
            boolean allConstants = this.rightOperandList.containsAllConstantNodes();
            if (allConstants) {
                DataValueDescriptor judgeODV = targetType.getNull();
                this.rightOperandList.sortInAscendingOrder(judgeODV);
                this.isOrdered = true;
                ValueNode minValue = (ValueNode)this.rightOperandList.elementAt(0);
                ValueNode maxValue = (ValueNode)this.rightOperandList.elementAt(this.rightOperandList.size() - 1);
                DataValueDescriptor minODV = ((ConstantNode)minValue).getValue();
                DataValueDescriptor maxODV = ((ConstantNode)maxValue).getValue();
                if (judgeODV.equals(minODV, maxODV).equals(true)) {
                    BinaryRelationalOperatorNode equal = new BinaryRelationalOperatorNode(0, this.leftOperand, minValue, false, this.getContextManager());
                    equal.bindComparisonOperator();
                    return equal;
                }
            }
            ValueNode srcVal = (ValueNode)this.rightOperandList.elementAt(0);
            ParameterNode pNode = new ParameterNode(0, null, this.getContextManager());
            DataTypeDescriptor pType = srcVal.getTypeServices();
            pNode.setType(pType);
            pNode.setValueToGenerate(srcVal);
            BinaryRelationalOperatorNode equal = new BinaryRelationalOperatorNode(0, this.leftOperand, pNode, this, false, this.getContextManager());
            equal.bindComparisonOperator();
            return equal;
        }
        return this;
    }

    private DataTypeDescriptor getDominantType() {
        DataTypeDescriptor targetType = this.leftOperand.getTypeServices();
        TypeId judgeTypeId = targetType.getTypeId();
        if (!this.rightOperandList.allSamePrecendence(judgeTypeId.typePrecedence())) {
            ClassFactory cf = this.getClassFactory();
            for (ValueNode vn : this.rightOperandList) {
                targetType = targetType.getDominantType(vn.getTypeServices(), cf);
            }
        }
        return targetType;
    }

    @Override
    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        int listSize = this.rightOperandList.size();
        SanityManager.ASSERT(listSize > 0, "rightOperandList.size() is expected to be > 0");
        if (!underNotNode) {
            return this;
        }
        ValueNode leftClone = this.leftOperand instanceof ColumnReference ? this.leftOperand.getClone() : this.leftOperand;
        BinaryRelationalOperatorNode leftBCO = new BinaryRelationalOperatorNode(5, leftClone, (ValueNode)this.rightOperandList.elementAt(0), false, this.getContextManager());
        leftBCO.bindComparisonOperator();
        BinaryOperatorNode leftSide = leftBCO;
        for (int elemsDone = 1; elemsDone < listSize; ++elemsDone) {
            leftClone = this.leftOperand instanceof ColumnReference ? this.leftOperand.getClone() : this.leftOperand;
            BinaryRelationalOperatorNode rightBCO = new BinaryRelationalOperatorNode(5, leftClone, (ValueNode)this.rightOperandList.elementAt(elemsDone), false, this.getContextManager());
            rightBCO.bindComparisonOperator();
            AndNode newAnd = new AndNode(leftSide, rightBCO, this.getContextManager());
            newAnd.postBindFixup();
            leftSide = newAnd;
        }
        return leftSide;
    }

    boolean selfReference(ColumnReference cr) throws StandardException {
        for (ValueNode vn : this.rightOperandList) {
            if (!vn.getTablesReferenced().get(cr.getTableNumber())) continue;
            return true;
        }
        return false;
    }

    @Override
    public double selectivity(Optimizable optTable) {
        return 0.3;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int listSize = this.rightOperandList.size();
        String receiverType = "org.apache.derby.iapi.types.DataValueDescriptor";
        String leftInterfaceType = "org.apache.derby.iapi.types.DataValueDescriptor";
        String rightInterfaceType = "org.apache.derby.iapi.types.DataValueDescriptor[]";
        SanityManager.ASSERT(listSize > 0, "listSize is expected to be > 0");
        String resultTypeName = this.getTypeCompiler().interfaceName();
        LocalField arrayField = this.generateListAsArray(acb, mb);
        this.leftOperand.generateExpression(acb, mb);
        mb.dup();
        mb.upCast(leftInterfaceType);
        mb.getField(arrayField);
        mb.push(this.isOrdered);
        mb.callMethod((short)185, receiverType, this.methodName, resultTypeName, 3);
    }

    protected LocalField generateListAsArray(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int listSize = this.rightOperandList.size();
        LocalField arrayField = acb.newFieldDeclaration(2, "org.apache.derby.iapi.types.DataValueDescriptor[]");
        MethodBuilder cb = acb.getConstructor();
        cb.pushNewArray("org.apache.derby.iapi.types.DataValueDescriptor", listSize);
        cb.setField(arrayField);
        int numConstants = 0;
        MethodBuilder nonConstantMethod = null;
        MethodBuilder currentConstMethod = cb;
        for (int index = 0; index < listSize; ++index) {
            MethodBuilder setArrayMethod;
            if (this.rightOperandList.elementAt(index) instanceof ConstantNode) {
                ++numConstants;
                if (currentConstMethod.statementNumHitLimit(1)) {
                    MethodBuilder genConstantMethod = acb.newGeneratedFun("void", 2);
                    currentConstMethod.pushThis();
                    currentConstMethod.callMethod((short)182, null, genConstantMethod.getName(), "void", 0);
                    if (currentConstMethod != cb) {
                        currentConstMethod.methodReturn();
                        currentConstMethod.complete();
                    }
                    currentConstMethod = genConstantMethod;
                }
                setArrayMethod = currentConstMethod;
            } else {
                if (nonConstantMethod == null) {
                    nonConstantMethod = acb.newGeneratedFun("void", 4);
                }
                setArrayMethod = nonConstantMethod;
            }
            setArrayMethod.getField(arrayField);
            ((ValueNode)this.rightOperandList.elementAt(index)).generateExpression(acb, setArrayMethod);
            setArrayMethod.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
            setArrayMethod.setArrayElement(index);
        }
        if (currentConstMethod != cb) {
            currentConstMethod.methodReturn();
            currentConstMethod.complete();
        }
        if (nonConstantMethod != null) {
            nonConstantMethod.methodReturn();
            nonConstantMethod.complete();
            mb.pushThis();
            mb.callMethod((short)182, null, nonConstantMethod.getName(), "void", 0);
        }
        return arrayField;
    }

    void generateStartStopKey(boolean isAsc, boolean isStartKey, ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int numValInLastLoop;
        int numLoops;
        int leftTypeFormatId = this.leftOperand.getTypeId().getTypeFormatId();
        int leftPrecision = this.leftOperand.getTypeServices().getPrecision();
        int leftScale = this.leftOperand.getTypeServices().getScale();
        boolean leftIsNullable = this.leftOperand.getTypeServices().isNullable();
        int leftMaximumWidth = this.leftOperand.getTypeServices().getMaximumWidth();
        int leftCollationType = this.leftOperand.getTypeServices().getCollationType();
        int leftCollationDerivation = this.leftOperand.getTypeServices().getCollationDerivation();
        int leftJDBCTypeId = this.leftOperand.getTypeId().isUserDefinedTypeId() ? this.leftOperand.getTypeId().getJDBCTypeId() : -1;
        int listSize = this.rightOperandList.size();
        int currentOpnd = 0;
        if (listSize < 5) {
            numLoops = 1;
            numValInLastLoop = (listSize - 1) % 4 + 1;
        } else {
            numLoops = (listSize - 5) / 3 + 2;
            numValInLastLoop = (listSize - 5) % 3 + 1;
        }
        for (int i = 0; i < numLoops; ++i) {
            int numVals = i == numLoops - 1 ? numValInLastLoop : (i == 0 ? 4 : 3);
            for (int j = 0; j < numVals; ++j) {
                ValueNode vn = (ValueNode)this.rightOperandList.elementAt(currentOpnd++);
                vn.generateExpression(acb, mb);
                mb.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
            }
            int numNulls = i < numLoops - 1 ? 0 : (i == 0 ? 4 - numValInLastLoop : 3 - numValInLastLoop);
            for (int j = 0; j < numNulls; ++j) {
                mb.pushNull("org.apache.derby.iapi.types.DataValueDescriptor");
            }
            mb.push(leftTypeFormatId);
            mb.push(leftJDBCTypeId);
            mb.push(leftPrecision);
            mb.push(leftScale);
            mb.push(leftIsNullable);
            mb.push(leftMaximumWidth);
            mb.push(leftCollationType);
            mb.push(leftCollationDerivation);
            String methodNam = isAsc && isStartKey || !isAsc && !isStartKey ? "minValue" : "maxValue";
            mb.callMethod((short)184, "org.apache.derby.impl.sql.execute.BaseExpressionActivation", methodNam, "org.apache.derby.iapi.types.DataValueDescriptor", 12);
        }
    }

    protected void markAsOrdered() {
        this.isOrdered = true;
    }

    protected void markSortDescending() {
        this.sortDescending = true;
    }

    protected boolean isOrdered() {
        return this.isOrdered;
    }

    protected boolean sortDescending() {
        return this.sortDescending;
    }
}

