/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.derbyTesting.functionTests.util.ScriptTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class ToolScripts
extends ScriptTestCase {
    private static final String[] CLIENT_AND_EMBEDDED_TESTS = new String[]{"ij4", "ij6", "ij7", "setholdij"};
    private static final String[] EMBEDDED_TESTS = new String[]{"showindex_embed"};
    private static final String[] CLIENT_TESTS = new String[]{"showindex_client"};
    private static final String[] JDBC3_TESTS = new String[]{"qualifiedIdentifiers", "URLCheck"};
    private static final String[][][] SQLAUTHORIZATION_TESTS = new String[][][]{{{"ij_show_roles_dbo"}, {"test_dbo", "donald"}, {"test_dbo"}}, {{"ij_show_roles_usr"}, {"test_dbo", "donald"}, {"donald"}}};

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ToolScripts.getSuite(stringArray));
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ToolScripts");
        baseTestSuite.addTest(ToolScripts.getSuite(CLIENT_AND_EMBEDDED_TESTS));
        baseTestSuite.addTest(ToolScripts.getSuite(EMBEDDED_TESTS));
        if (JDBC.vmSupportsJDBC3()) {
            baseTestSuite.addTest(ToolScripts.getSuite(JDBC3_TESTS));
        }
        baseTestSuite.addTest(ToolScripts.getAuthorizationSuite(SQLAUTHORIZATION_TESTS));
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("ToolScripts:client");
        baseTestSuite2.addTest(ToolScripts.getSuite(CLIENT_AND_EMBEDDED_TESTS));
        baseTestSuite2.addTest(ToolScripts.getAuthorizationSuite(SQLAUTHORIZATION_TESTS));
        baseTestSuite2.addTest(ToolScripts.getSuite(CLIENT_TESTS));
        Test test = TestConfiguration.clientServerDecorator((Test)baseTestSuite2);
        baseTestSuite.addTest(test);
        return baseTestSuite;
    }

    private ToolScripts(String string) {
        super(string);
    }

    private ToolScripts(String string, String string2) {
        super(string, null, null, string2);
    }

    private static Test getSuite(String[] stringArray) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Tool scripts");
        for (int i = 0; i < stringArray.length; ++i) {
            baseTestSuite.addTest((Test)new CleanDatabaseTestSetup((Test)new ToolScripts(stringArray[i])));
        }
        return ToolScripts.getIJConfig((Test)baseTestSuite);
    }

    private static Test getAuthorizationSuite(String[][][] stringArray) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Tool scripts w/authorization");
        for (int i = 0; i < stringArray.length; ++i) {
            CleanDatabaseTestSetup cleanDatabaseTestSetup = stringArray[i][0][0].startsWith("ij_show_roles") ? new CleanDatabaseTestSetup((Test)new ToolScripts(stringArray[i][0][0], stringArray[i][2][0])){

                @Override
                protected void decorateSQL(Statement statement) throws SQLException {
                    statement.execute("create role a");
                    statement.execute("create role b");
                    statement.execute("create role \"\"\"eve\"\"\"");
                    statement.execute("create role publicrole");
                    statement.execute("grant a to b");
                    statement.execute("grant publicrole to public");
                    statement.execute("grant b to donald");
                }
            } : new CleanDatabaseTestSetup((Test)new ToolScripts(stringArray[i][0][0], stringArray[i][2][0]));
            baseTestSuite.addTest(TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication((Test)cleanDatabaseTestSetup, stringArray[i][1], "pwSuffix")));
        }
        return ToolScripts.getIJConfig((Test)baseTestSuite);
    }
}

