/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

class CachedValueNode
extends ValueNode {
    private ValueNode value;
    private LocalField field;

    CachedValueNode(ValueNode value) {
        super(value.getContextManager());
        this.value = value;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.field == null) {
            this.field = acb.newFieldDeclaration(2, "org.apache.derby.iapi.types.DataValueDescriptor");
            this.value.generateExpression(acb, mb);
            mb.putField(this.field);
        } else {
            mb.getField(this.field);
        }
    }

    void generateClearField(MethodBuilder mb) {
        if (this.field != null) {
            mb.pushNull("org.apache.derby.iapi.types.DataValueDescriptor");
            mb.setField(this.field);
        }
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.value = this.value.bindExpression(fromList, subqueryList, aggregates);
        return this;
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.value = this.value.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    boolean isEquivalent(ValueNode other) throws StandardException {
        if (other instanceof CachedValueNode) {
            CachedValueNode that = (CachedValueNode)other;
            return this.value.isEquivalent(that.value);
        }
        return false;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.value != null) {
            this.value = (ValueNode)this.value.accept(v);
        }
    }

    @Override
    DataTypeDescriptor getTypeServices() {
        return this.value.getTypeServices();
    }

    @Override
    void setType(DataTypeDescriptor dtd) throws StandardException {
        this.value.setType(dtd);
    }

    @Override
    boolean requiresTypeFromContext() {
        return this.value.requiresTypeFromContext();
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.value = this.value.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.value.categorize(referencedTabs, simplePredsOnly);
    }
}

