/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;
import org.apache.derby.shared.common.sanity.SanityManager;

class PermissionsCacheable
implements Cacheable {
    protected final DataDictionaryImpl dd;
    private PermissionsDescriptor permissions;

    PermissionsCacheable(DataDictionaryImpl dd) {
        this.dd = dd;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Cacheable setIdentity(Object key) throws StandardException {
        if (key instanceof TablePermsDescriptor) {
            tablePermsKey = (TablePermsDescriptor)key;
            this.permissions = this.dd.getUncachedTablePermsDescriptor(tablePermsKey);
            if (this.permissions == null) {
                td = this.dd.getTableDescriptor(tablePermsKey.getTableUUID());
                sd = td.getSchemaDescriptor();
                if (sd.isSystemSchema()) {
                    this.permissions = new TablePermsDescriptor(this.dd, tablePermsKey.getGrantee(), null, tablePermsKey.getTableUUID(), "Y", "N", "N", "N", "N", "N");
                    ((TablePermsDescriptor)this.permissions).setUUID(tablePermsKey.getTableUUID());
                } else {
                    this.permissions = tablePermsKey.getGrantee().equals(sd.getAuthorizationId()) ? new TablePermsDescriptor(this.dd, tablePermsKey.getGrantee(), "_SYSTEM", tablePermsKey.getTableUUID(), "Y", "Y", "Y", "Y", "Y", "Y") : new TablePermsDescriptor(this.dd, tablePermsKey.getGrantee(), null, tablePermsKey.getTableUUID(), "N", "N", "N", "N", "N", "N");
                }
            }
        } else if (key instanceof ColPermsDescriptor) {
            colPermsKey = (ColPermsDescriptor)key;
            this.permissions = this.dd.getUncachedColPermsDescriptor(colPermsKey);
            if (this.permissions == null) {
                this.permissions = new ColPermsDescriptor(this.dd, colPermsKey.getGrantee(), null, colPermsKey.getTableUUID(), colPermsKey.getType(), null);
            }
        } else if (key instanceof RoutinePermsDescriptor) {
            routinePermsKey = (RoutinePermsDescriptor)key;
            this.permissions = this.dd.getUncachedRoutinePermsDescriptor(routinePermsKey);
            if (this.permissions == null) {
                try {
                    ad = this.dd.getAliasDescriptor(routinePermsKey.getRoutineUUID());
                    sd = this.dd.getSchemaDescriptor(ad.getSchemaUUID(), ConnectionUtil.getCurrentLCC().getTransactionExecute());
                    if (sd.isSystemSchema() && !sd.isSchemaWithGrantableRoutines()) {
                        this.permissions = new RoutinePermsDescriptor(this.dd, routinePermsKey.getGrantee(), null, routinePermsKey.getRoutineUUID(), true);
                    }
                    if (!routinePermsKey.getGrantee().equals(sd.getAuthorizationId())) ** GOTO lbl49
                    this.permissions = new RoutinePermsDescriptor(this.dd, routinePermsKey.getGrantee(), "_SYSTEM", routinePermsKey.getRoutineUUID(), true);
                }
                catch (SQLException sqle) {
                    throw StandardException.plainWrapException(sqle);
                }
            }
        } else if (key instanceof PermDescriptor) {
            permKey = (PermDescriptor)key;
            this.permissions = this.dd.getUncachedGenericPermDescriptor(permKey);
            if (this.permissions == null) {
                objectType = permKey.getObjectType();
                privilege = permKey.getPermission();
                protectedObjectsID = permKey.getPermObjectId();
                pso = PermDescriptor.getProtectedObject(this.dd, protectedObjectsID, objectType);
                sd = pso.getSchemaDescriptor();
                if (permKey.getGrantee().equals(sd.getAuthorizationId())) {
                    this.permissions = new PermDescriptor(this.dd, null, objectType, pso.getUUID(), privilege, "_SYSTEM", permKey.getGrantee(), true);
                }
            }
        } else {
            SanityManager.NOTREACHED();
            return null;
        }
lbl49:
        // 8 sources

        if (this.permissions != null) {
            return this;
        }
        return null;
    }

    @Override
    public Cacheable createIdentity(Object key, Object createParameter) throws StandardException {
        SanityManager.ASSERT(key instanceof TablePermsDescriptor || key instanceof ColPermsDescriptor || key instanceof RoutinePermsDescriptor, "Invalid class, " + key.getClass().getName() + ", passed as key to PermissionsCacheable.createIdentity");
        if (key == null) {
            return null;
        }
        this.permissions = (PermissionsDescriptor)((PermissionsDescriptor)key).clone();
        return this;
    }

    @Override
    public void clearIdentity() {
        this.permissions = null;
    }

    @Override
    public Object getIdentity() {
        return this.permissions;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void clean(boolean forRemove) throws StandardException {
    }
}

