/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.hll;

import java.io.IOException;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.hll.AlgebraicInitial;
import org.apache.datasketches.pig.hll.DataToSketch;
import org.apache.datasketches.pig.hll.UnionSketchAlgebraicFinal;
import org.apache.datasketches.pig.hll.UnionSketchAlgebraicIntermediate;
import org.apache.log4j.Logger;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class UnionSketch
extends EvalFunc<DataByteArray>
implements Accumulator<DataByteArray>,
Algebraic {
    private DataByteArray emptySketch_;
    private final int lgK_;
    private final TgtHllType tgtHllType_;
    private Union accumUnion_;
    private boolean isFirstCall_;

    public UnionSketch() {
        this(12, DataToSketch.DEFAULT_HLL_TYPE);
    }

    public UnionSketch(String lgK) {
        this(Integer.parseInt(lgK), DataToSketch.DEFAULT_HLL_TYPE);
    }

    public UnionSketch(String lgK, String tgtHllType) {
        this(Integer.parseInt(lgK), TgtHllType.valueOf((String)tgtHllType));
    }

    public UnionSketch(int lgK, TgtHllType tgtHllType) {
        this.lgK_ = lgK;
        this.tgtHllType_ = tgtHllType;
    }

    public DataByteArray exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Exec was used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            if (this.emptySketch_ == null) {
                this.emptySketch_ = new DataByteArray(new HllSketch(this.lgK_, this.tgtHllType_).toCompactByteArray());
            }
            return this.emptySketch_;
        }
        Union union = new Union(this.lgK_);
        DataBag bag = (DataBag)inputTuple.get(0);
        UnionSketch.updateUnion(bag, union);
        return new DataByteArray(union.getResult(this.tgtHllType_).toCompactByteArray());
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Accumulator was used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            return;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            return;
        }
        if (this.accumUnion_ == null) {
            this.accumUnion_ = new Union(this.lgK_);
        }
        UnionSketch.updateUnion(bag, this.accumUnion_);
    }

    public DataByteArray getValue() {
        if (this.accumUnion_ == null) {
            if (this.emptySketch_ == null) {
                this.emptySketch_ = new DataByteArray(new HllSketch(this.lgK_, this.tgtHllType_).toCompactByteArray());
            }
            return this.emptySketch_;
        }
        return new DataByteArray(this.accumUnion_.getResult(this.tgtHllType_).toCompactByteArray());
    }

    public void cleanup() {
        this.accumUnion_ = null;
    }

    public String getInitial() {
        return AlgebraicInitial.class.getName();
    }

    public String getIntermed() {
        return UnionSketchAlgebraicIntermediate.class.getName();
    }

    public String getFinal() {
        return UnionSketchAlgebraicFinal.class.getName();
    }

    static void updateUnion(DataBag bag, Union union) throws ExecException {
        for (Tuple innerTuple : bag) {
            Object f0 = innerTuple.get(0);
            if (f0 == null) continue;
            byte type = innerTuple.getType(0);
            if (type == 50) {
                DataByteArray dba = (DataByteArray)f0;
                union.update(HllSketch.wrap((Memory)Memory.wrap((byte[])dba.get())));
                continue;
            }
            throw new IllegalArgumentException("Field type was not DataType.BYTEARRAY: " + type);
        }
    }
}

