/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.cpc;

import java.io.IOException;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class GetEstimateAndErrorBounds
extends EvalFunc<Tuple> {
    private static int DEFAULT_KAPPA = 2;
    private final int kappa_;
    private final long seed_;

    public GetEstimateAndErrorBounds() {
        this(DEFAULT_KAPPA, 9001L);
    }

    public GetEstimateAndErrorBounds(String kappa) {
        this(Integer.parseInt(kappa), 9001L);
    }

    public GetEstimateAndErrorBounds(String kappa, String seed) {
        this(Integer.parseInt(kappa), Long.parseLong(seed));
    }

    GetEstimateAndErrorBounds(int kappa, long seed) {
        this.kappa_ = kappa;
        this.seed_ = seed;
    }

    public Tuple exec(Tuple sketchTuple) throws IOException {
        if (sketchTuple == null || sketchTuple.size() == 0) {
            return null;
        }
        DataByteArray dba = (DataByteArray)sketchTuple.get(0);
        CpcSketch sketch = CpcSketch.heapify((byte[])dba.get(), (long)this.seed_);
        Tuple outputTuple = TupleFactory.getInstance().newTuple(3);
        outputTuple.set(0, (Object)sketch.getEstimate());
        outputTuple.set(1, (Object)sketch.getLowerBound(this.kappa_));
        outputTuple.set(2, (Object)sketch.getUpperBound(this.kappa_));
        return outputTuple;
    }

    public Schema outputSchema(Schema input) {
        if (input == null) {
            return null;
        }
        try {
            Schema tupleSchema = new Schema();
            tupleSchema.add(new Schema.FieldSchema("Estimate", 25));
            tupleSchema.add(new Schema.FieldSchema("LowerBound", 25));
            tupleSchema.add(new Schema.FieldSchema("UpperBound", 25));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 110));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

