/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common.positional;

import org.apache.datasketches.common.positional.PositionInvariantsException;
import org.apache.datasketches.common.positional.Positional;

class PositionalImpl
implements Positional {
    private final long capacity;
    private long start = 0L;
    private long pos = 0L;
    private long end;

    PositionalImpl(long capacity) {
        this.capacity = this.end = capacity;
    }

    @Override
    public final PositionalImpl incrementPosition(long increment) {
        this.pos += increment;
        return this;
    }

    @Override
    public final long getEnd() {
        return this.end;
    }

    @Override
    public final long getPosition() {
        return this.pos;
    }

    @Override
    public final long getStart() {
        return this.start;
    }

    @Override
    public final long getRemaining() {
        return this.end - this.pos;
    }

    @Override
    public final boolean hasRemaining() {
        return this.end - this.pos > 0L;
    }

    @Override
    public final PositionalImpl resetPosition() {
        this.pos = this.start;
        return this;
    }

    @Override
    public final PositionalImpl setPosition(long position) {
        PositionalImpl.checkInvariants(this.start, position, this.end, this.capacity);
        this.pos = position;
        return this;
    }

    @Override
    public final PositionalImpl setStartPositionEnd(long start, long position, long end) {
        PositionalImpl.checkInvariants(start, position, end, this.capacity);
        this.start = start;
        this.end = end;
        this.pos = position;
        return this;
    }

    private static final void checkInvariants(long start, long pos, long end, long cap) {
        if ((start | pos | end | cap | pos - start | end - pos | cap - end) < 0L) {
            throw new PositionInvariantsException("Violation of Invariants: start: " + start + " <= pos: " + pos + " <= end: " + end + " <= cap: " + cap + "; (pos - start): " + (pos - start) + ", (end - pos): " + (end - pos) + ", (cap - end): " + (cap - end));
        }
    }
}

