/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import org.apache.cxf.rs.security.jose.common.AbstractJoseConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;

public class JoseJwtConsumer
extends AbstractJoseConsumer {
    private int clockOffset;
    private int ttl;

    public JwtToken getJwtToken(String wrappedJwtToken) {
        return this.getJwtToken(wrappedJwtToken, null, null);
    }

    public JwtToken getJwtToken(String wrappedJwtToken, JweDecryptionProvider theDecryptor, JwsSignatureVerifier theSigVerifier) {
        Object jwtConsumer;
        super.checkProcessRequirements();
        JweHeaders jweHeaders = new JweHeaders();
        if (this.isJweRequired()) {
            jwtConsumer = new JweJwtCompactConsumer(wrappedJwtToken);
            if (theDecryptor == null) {
                theDecryptor = this.getInitializedDecryptionProvider(((JweJwtCompactConsumer)jwtConsumer).getHeaders());
            }
            if (theDecryptor == null) {
                throw new JwtException("Unable to decrypt JWT");
            }
            if (!this.isJwsRequired()) {
                return ((JweJwtCompactConsumer)jwtConsumer).decryptWith(theDecryptor);
            }
            JweDecryptionOutput decOutput = theDecryptor.decrypt(wrappedJwtToken);
            wrappedJwtToken = decOutput.getContentText();
            jweHeaders = decOutput.getHeaders();
        }
        jwtConsumer = new JwsJwtCompactConsumer(wrappedJwtToken);
        JwtToken jwt = ((JwsJwtCompactConsumer)jwtConsumer).getJwtToken();
        jwt = new JwtToken(jwt.getJwsHeaders(), jweHeaders, jwt.getClaims());
        if (this.isJwsRequired()) {
            if (theSigVerifier == null) {
                theSigVerifier = this.getInitializedSignatureVerifier(jwt);
            }
            if (theSigVerifier == null) {
                throw new JwtException("Unable to validate JWT");
            }
            if (!((JwsCompactConsumer)jwtConsumer).verifySignatureWith(theSigVerifier)) {
                throw new JwtException("Invalid Signature");
            }
        }
        this.validateToken(jwt);
        return jwt;
    }

    protected JwsSignatureVerifier getInitializedSignatureVerifier(JwtToken jwt) {
        return this.getInitializedSignatureVerifier(jwt.getJwsHeaders());
    }

    protected void validateToken(JwtToken jwt) {
    }

    public int getClockOffset() {
        return this.clockOffset;
    }

    public void setClockOffset(int clockOffset) {
        this.clockOffset = clockOffset;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }
}

