/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.artemis.core.persistence.impl.journal.AbstractJournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;

public final class TXLargeMessageConfirmationOperation
extends TransactionOperationAbstract {
    private AbstractJournalStorageManager journalStorageManager;
    public List<Long> confirmedMessages = new LinkedList<Long>();

    public TXLargeMessageConfirmationOperation(AbstractJournalStorageManager journalStorageManager) {
        this.journalStorageManager = journalStorageManager;
    }

    @Override
    public void afterRollback(Transaction tx) {
        for (Long msg : this.confirmedMessages) {
            try {
                this.journalStorageManager.confirmPendingLargeMessage(msg);
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.journalErrorConfirmingLargeMessage(msg, e);
            }
        }
    }
}

