/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.sm;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SecurityManagerShim {
    public static Subject currentSubject() {
        return Subject.current();
    }

    public static <T> T callAs(Subject subject, Callable<T> callable) throws CompletionException {
        Objects.requireNonNull(callable);
        return Subject.callAs(subject, callable);
    }

    public static boolean isSecurityManagerEnabled() {
        return false;
    }

    public static Object getAccessControlContext() {
        return null;
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        Objects.requireNonNull(action, "action must be provided");
        return action.run();
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action, Object accessControlContext) {
        Objects.requireNonNull(action, "action must be provided");
        return action.run();
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> exceptionAction) throws PrivilegedActionException {
        Objects.requireNonNull(exceptionAction, "exceptionAction must be provided");
        try {
            return exceptionAction.run();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }
}

