/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ThreadUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.time.DurationUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

class StopWatchTest
extends AbstractLangTest {
    private static final int SPLIT_CLOCK_STR_LEN = 12;
    private static final Duration MIN_DURATION = Duration.ofMillis(20L);
    private static final String MESSAGE = "Baking cookies";
    private static final String ZERO_HOURS_PREFIX = "00:";
    private static final String ZERO_TIME_ELAPSED = "00:00:00.000";

    StopWatchTest() {
    }

    private StopWatch createMockStopWatch(long nanos) {
        StopWatch watch = StopWatch.createStarted();
        watch.suspend();
        return this.set(watch, nanos);
    }

    private StopWatch set(StopWatch watch, long nanos) {
        try {
            long currentNanos = System.nanoTime();
            FieldUtils.writeField((Object)watch, (String)"startTimeNanos", (Object)(currentNanos - nanos), (boolean)true);
            FieldUtils.writeField((Object)watch, (String)"stopTimeNanos", (Object)currentNanos, (boolean)true);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return watch;
    }

    private void sleepPlus1(Duration duration) throws InterruptedException {
        ThreadUtils.sleep((Duration)duration.plusMillis(1L));
    }

    @Test
    void testBadStates() {
        StopWatch watch = new StopWatch();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).stop(), (String)"Calling stop on an unstarted StopWatch should throw an exception.");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).suspend(), (String)"Calling suspend on an unstarted StopWatch should throw an exception.");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).split(), (String)"Calling split on a non-running StopWatch should throw an exception.");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).unsplit(), (String)"Calling unsplit on an unsplit StopWatch should throw an exception.");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).resume(), (String)"Calling resume on an unsuspended StopWatch should throw an exception.");
        watch.start();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).start(), (String)"Calling start on a started StopWatch should throw an exception.");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).unsplit(), (String)"Calling unsplit on an unsplit StopWatch should throw an exception.");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getSplitTime(), (String)"Calling getSplitTime on an unsplit StopWatch should throw an exception.");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getSplitDuration(), (String)"Calling getSplitTime on an unsplit StopWatch should throw an exception.");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).resume(), (String)"Calling resume on an unsuspended StopWatch should throw an exception.");
        watch.stop();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).start(), (String)"Calling start on a stopped StopWatch should throw an exception as it needs to be reset.");
    }

    @Test
    void testBooleanStates() {
        StopWatch watch = new StopWatch();
        Assertions.assertFalse((boolean)watch.isStarted());
        Assertions.assertFalse((boolean)watch.isSuspended());
        Assertions.assertTrue((boolean)watch.isStopped());
        watch.start();
        Assertions.assertTrue((boolean)watch.isStarted());
        Assertions.assertFalse((boolean)watch.isSuspended());
        Assertions.assertFalse((boolean)watch.isStopped());
        watch.suspend();
        Assertions.assertTrue((boolean)watch.isStarted());
        Assertions.assertTrue((boolean)watch.isSuspended());
        Assertions.assertFalse((boolean)watch.isStopped());
        watch.stop();
        Assertions.assertFalse((boolean)watch.isStarted());
        Assertions.assertFalse((boolean)watch.isSuspended());
        Assertions.assertTrue((boolean)watch.isStopped());
    }

    @Test
    void testFormatSplitTime() {
        StopWatch watch = StopWatch.createStarted();
        ThreadUtils.sleepQuietly((Duration)MIN_DURATION);
        watch.split();
        String formatSplitTime = watch.formatSplitTime();
        Assertions.assertNotEquals((Object)ZERO_TIME_ELAPSED, (Object)formatSplitTime);
        Assertions.assertTrue((boolean)formatSplitTime.startsWith(ZERO_HOURS_PREFIX), (String)"formatSplitTime");
    }

    @Test
    void testFormatSplitTimeWithMessage() {
        StopWatch watch = new StopWatch(MESSAGE);
        watch.start();
        ThreadUtils.sleepQuietly((Duration)MIN_DURATION);
        watch.split();
        String formatSplitTime = watch.formatSplitTime();
        Assertions.assertFalse((boolean)formatSplitTime.startsWith(MESSAGE), (String)"formatSplitTime");
        Assertions.assertTrue((boolean)formatSplitTime.startsWith(ZERO_HOURS_PREFIX), (String)"formatSplitTime");
    }

    @Test
    void testFormatTime() {
        StopWatch watch = StopWatch.create();
        String formatTime = watch.formatTime();
        Assertions.assertEquals((Object)ZERO_TIME_ELAPSED, (Object)formatTime);
        Assertions.assertTrue((boolean)formatTime.startsWith(ZERO_HOURS_PREFIX), (String)"formatTime");
    }

    @Test
    void testFormatTimeWithMessage() {
        StopWatch watch = new StopWatch(MESSAGE);
        String formatTime = watch.formatTime();
        Assertions.assertFalse((boolean)formatTime.startsWith(MESSAGE), (String)"formatTime");
    }

    @Test
    void testGet() throws Throwable {
        StopWatch watch = new StopWatch();
        AtomicInteger i = new AtomicInteger();
        Assertions.assertEquals((int)1, (Integer)((Integer)watch.get(i::incrementAndGet)));
        Assertions.assertEquals((int)2, (Integer)((Integer)watch.getT(i::incrementAndGet)));
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> watch.getT(this::throwIOException));
        Assertions.assertEquals((Object)"A", (Object)e.getMessage());
        Assertions.assertTrue((boolean)watch.isSuspended());
        Assertions.assertEquals((int)3, (Integer)((Integer)watch.get(() -> {
            Assertions.assertTrue((boolean)watch.isStarted());
            return i.incrementAndGet();
        })));
        Assertions.assertTrue((boolean)watch.isSuspended());
        long nanos1 = watch.getDuration().toNanos();
        Assertions.assertTrue((nanos1 >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)watch.isSuspended());
        Assertions.assertEquals((int)4, (Integer)((Integer)watch.getT(() -> {
            Assertions.assertTrue((boolean)watch.isStarted());
            return i.incrementAndGet();
        })));
        Assertions.assertTrue((boolean)watch.isSuspended());
        Assertions.assertTrue((watch.getDuration().toNanos() >= nanos1 ? 1 : 0) != 0);
    }

    @Test
    void testGetDuration() throws InterruptedException {
        StopWatch watch = new StopWatch();
        Assertions.assertEquals((Object)Duration.ZERO, (Object)watch.getDuration());
        Assertions.assertEquals((Object)ZERO_TIME_ELAPSED, (Object)watch.toString());
        watch.start();
        this.sleepPlus1(MIN_DURATION);
        long nanos = watch.getNanoTime();
        Assertions.assertTrue((nanos > 0L ? 1 : 0) != 0, () -> "getNanoTime(): " + nanos);
        Assertions.assertTrue((boolean)DurationUtils.isPositive((Duration)watch.getDuration()));
    }

    @Test
    void testGetSplitDuration() {
        StopWatch watch = StopWatch.createStarted();
        watch.split();
        this.set(watch, 123456L);
        Assertions.assertEquals((Object)Duration.ofNanos(123456L), (Object)watch.getSplitDuration());
    }

    @Test
    void testGetStartInstant() {
        long beforeStopWatchMillis = System.currentTimeMillis();
        StopWatch watch = new StopWatch();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getStartInstant(), (String)"Calling getStartInstant on an unstarted StopWatch should throw an exception");
        watch.start();
        watch.getStartInstant();
        Assertions.assertTrue((watch.getStartInstant().compareTo(Instant.ofEpochMilli(beforeStopWatchMillis)) >= 0 ? 1 : 0) != 0);
        watch.reset();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getStartInstant(), (String)"Calling getStartInstant on a reset, but unstarted StopWatch should throw an exception");
    }

    @Test
    void testGetStartTime() {
        long beforeStopWatchMillis = System.currentTimeMillis();
        StopWatch watch = new StopWatch();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getStartTime(), (String)"Calling getStartTime on an unstarted StopWatch should throw an exception");
        watch.start();
        watch.getStartTime();
        Assertions.assertTrue((watch.getStartTime() >= beforeStopWatchMillis ? 1 : 0) != 0, (String)"getStartTime");
        watch.reset();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getStartTime(), (String)"Calling getStartTime on a reset, but unstarted StopWatch should throw an exception");
    }

    @RepeatedTest(value=10)
    void testGetTime() throws InterruptedException {
        StopWatch watch = new StopWatch();
        Assertions.assertEquals((long)0L, (long)watch.getTime());
        Assertions.assertEquals((Object)ZERO_TIME_ELAPSED, (Object)watch.toString());
        watch.start();
        this.sleepPlus1(MIN_DURATION);
        long time = watch.getTime();
        Assertions.assertTrue((time > 0L ? 1 : 0) != 0, () -> "getTime() millis: " + time);
        Assertions.assertTrue((time < 2000L ? 1 : 0) != 0, () -> "getTime() millis: " + time);
    }

    @Test
    void testGetWithTimeUnit() {
        StopWatch watch = this.createMockStopWatch(TimeUnit.HOURS.toNanos(2L) + TimeUnit.MINUTES.toNanos(59L) + TimeUnit.SECONDS.toNanos(1L) + TimeUnit.MILLISECONDS.toNanos(999L));
        Assertions.assertEquals((long)2L, (long)watch.getTime(TimeUnit.HOURS));
        Assertions.assertEquals((long)179L, (long)watch.getTime(TimeUnit.MINUTES));
        Assertions.assertEquals((long)10741L, (long)watch.getTime(TimeUnit.SECONDS));
        Assertions.assertEquals((long)10741999L, (long)watch.getTime(TimeUnit.MILLISECONDS));
    }

    @Test
    void testLang315() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        this.sleepPlus1(MIN_DURATION);
        watch.suspend();
        long suspendTime = watch.getTime();
        Duration suspendDuration = watch.getDuration();
        this.sleepPlus1(MIN_DURATION);
        watch.stop();
        long totalTime = watch.getTime();
        Duration totalDuration = watch.getDuration();
        Assertions.assertEquals((long)suspendTime, (long)totalTime);
        Assertions.assertEquals((Object)suspendDuration, (Object)totalDuration);
    }

    @Test
    void testMessage() {
        Assertions.assertNull((Object)StopWatch.create().getMessage());
        StopWatch stopWatch = new StopWatch(MESSAGE);
        Assertions.assertEquals((Object)MESSAGE, (Object)stopWatch.getMessage());
        Assertions.assertTrue((boolean)stopWatch.toString().startsWith(MESSAGE), (String)"stopWatch.toString");
        stopWatch.start();
        stopWatch.split();
        Assertions.assertTrue((boolean)stopWatch.toSplitString().startsWith(MESSAGE), (String)"stopWatch.toSplitString");
    }

    @Test
    void testRun() throws Throwable {
        StopWatch watch = new StopWatch();
        AtomicInteger i = new AtomicInteger();
        watch.run(i::incrementAndGet);
        Assertions.assertEquals((int)1, (int)i.get());
        watch.runT(i::incrementAndGet);
        Assertions.assertEquals((int)2, (int)i.get());
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> watch.runT(this::throwIOException));
        Assertions.assertEquals((Object)"A", (Object)e.getMessage());
        Assertions.assertTrue((boolean)watch.isSuspended());
        watch.run(() -> {
            Assertions.assertTrue((boolean)watch.isStarted());
            i.incrementAndGet();
        });
        Assertions.assertEquals((int)3, (int)i.get());
        Assertions.assertTrue((boolean)watch.isSuspended());
        long nanos1 = watch.getDuration().toNanos();
        Assertions.assertTrue((nanos1 > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)watch.isSuspended());
        watch.runT(() -> {
            Assertions.assertTrue((boolean)watch.isStarted());
            i.incrementAndGet();
        });
        Assertions.assertEquals((int)4, (int)i.get());
        Assertions.assertTrue((boolean)watch.isSuspended());
        Assertions.assertTrue((watch.getDuration().toNanos() >= nanos1 ? 1 : 0) != 0);
    }

    @Test
    void testSimple() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        Duration sleepDuration = MIN_DURATION;
        this.sleepPlus1(sleepDuration);
        watch.stop();
        long time = watch.getTime();
        Duration duration = watch.getDuration();
        Assertions.assertEquals((long)time, (long)watch.getTime());
        Assertions.assertEquals((Object)duration, (Object)watch.getDuration());
        Assertions.assertTrue((duration.compareTo(sleepDuration) >= 0 ? 1 : 0) != 0, () -> "duration: " + duration);
        watch.reset();
        Assertions.assertEquals((long)0L, (long)watch.getTime());
        Assertions.assertEquals((Object)Duration.ZERO, (Object)watch.getDuration());
    }

    @Test
    void testSplit() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        Duration sleepDuration = MIN_DURATION;
        long sleepMillis = sleepDuration.toMillis();
        Assertions.assertTrue((sleepMillis > 0L ? 1 : 0) != 0);
        this.sleepPlus1(sleepDuration);
        watch.split();
        long splitTime = watch.getSplitTime();
        Duration splitDuration = watch.getSplitDuration();
        Assertions.assertEquals((long)splitTime, (long)watch.getSplitDuration().toMillis());
        Assertions.assertEquals((int)12, (int)watch.toSplitString().length(), (String)"Formatted split string not the correct length");
        this.sleepPlus1(sleepDuration);
        watch.unsplit();
        this.sleepPlus1(sleepDuration);
        watch.stop();
        long totalTime = watch.getTime();
        Duration totalDuration = watch.getDuration();
        Assertions.assertTrue((splitTime >= sleepMillis ? 1 : 0) != 0, () -> "splitTime: " + splitTime);
        Assertions.assertTrue((splitDuration.toMillis() >= sleepMillis ? 1 : 0) != 0, () -> "splitDuration: " + splitDuration);
        long sleepMillisX3 = sleepMillis * 3L;
        Assertions.assertTrue((totalTime >= sleepMillisX3 && splitTime < 21000L ? 1 : 0) != 0);
        Assertions.assertTrue((totalDuration.toMillis() >= sleepMillisX3 ? 1 : 0) != 0);
    }

    @Test
    void testStatic() {
        StopWatch watch = StopWatch.createStarted();
        Assertions.assertTrue((boolean)watch.isStarted());
    }

    @Test
    void testStopInstantSimple() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        long testStartMillis = System.currentTimeMillis();
        this.sleepPlus1(MIN_DURATION);
        watch.stop();
        long testEndMillis = System.currentTimeMillis();
        Instant stopTime = watch.getStopInstant();
        Assertions.assertEquals((Object)stopTime, (Object)watch.getStopInstant());
        Assertions.assertTrue((testStartMillis < testEndMillis ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Instant.ofEpochMilli(testStartMillis).isBefore(Instant.ofEpochMilli(testEndMillis)));
    }

    @Test
    void testStopTimeSimple() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        long testStartMillis = System.currentTimeMillis();
        this.sleepPlus1(MIN_DURATION);
        watch.stop();
        long testEndMillis = System.currentTimeMillis();
        long stopTime = watch.getStopTime();
        Assertions.assertEquals((long)stopTime, (long)watch.getStopTime());
        Assertions.assertTrue((testStartMillis < testEndMillis ? 1 : 0) != 0);
    }

    @Test
    void testSuspend() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        long testStartMillis = System.currentTimeMillis();
        long testStartNanos = System.nanoTime();
        Instant testStartInstant = Instant.ofEpochMilli(testStartMillis);
        Duration sleepDuration = MIN_DURATION;
        long sleepMillis = sleepDuration.toMillis();
        this.sleepPlus1(sleepDuration);
        watch.suspend();
        long testSuspendMillis = System.currentTimeMillis();
        long testSuspendNanos = System.nanoTime();
        long testSuspendTimeNanos = testSuspendNanos - testStartNanos;
        Duration testSuspendDuration = Duration.ofNanos(testSuspendTimeNanos).plusMillis(1L);
        long suspendTimeFromNanos = watch.getTime();
        Duration suspendDuration = watch.getDuration();
        long stopTimeMillis = watch.getStopTime();
        Instant stopInstant = watch.getStopInstant();
        Assertions.assertTrue((testStartMillis <= stopTimeMillis ? 1 : 0) != 0, () -> String.format("testStartMillis %s <= stopTimeMillis %s", testStartMillis, stopTimeMillis));
        Assertions.assertTrue((boolean)testStartInstant.isBefore(stopInstant), () -> String.format("testStartInstant %s < stopInstant %s", testStartInstant, stopInstant));
        Assertions.assertTrue((testSuspendMillis <= stopTimeMillis ? 1 : 0) != 0, () -> String.format("testSuspendMillis %s <= stopTimeMillis %s", testSuspendMillis, stopTimeMillis));
        Assertions.assertTrue((testSuspendMillis <= stopInstant.toEpochMilli() ? 1 : 0) != 0, () -> String.format("testSuspendMillis %s <= stopInstant %s", testSuspendMillis, stopInstant));
        this.sleepPlus1(sleepDuration);
        watch.resume();
        this.sleepPlus1(sleepDuration);
        watch.stop();
        long totalTimeFromNanos = watch.getTime();
        Duration totalDuration = watch.getDuration();
        Assertions.assertTrue((suspendTimeFromNanos >= sleepMillis ? 1 : 0) != 0, () -> String.format("suspendTimeFromNanos %s >= sleepMillis %s", suspendTimeFromNanos, sleepMillis));
        Assertions.assertTrue((suspendDuration.compareTo(Duration.ofMillis(sleepMillis)) >= 0 ? 1 : 0) != 0, () -> String.format("suspendDuration %s >= sleepMillis %s", suspendDuration, sleepMillis));
        Assertions.assertTrue((suspendTimeFromNanos <= testSuspendTimeNanos ? 1 : 0) != 0, () -> String.format("suspendTimeFromNanos %s <= testSuspendTimeNanos %s", suspendTimeFromNanos, testSuspendTimeNanos));
        Assertions.assertTrue((suspendDuration.compareTo(testSuspendDuration) <= 0 ? 1 : 0) != 0, () -> String.format("suspendDuration %s <= testSuspendDuration %s", suspendDuration, testSuspendDuration));
        long sleepMillisX2 = sleepMillis + sleepMillis;
        Assertions.assertTrue((totalTimeFromNanos >= sleepMillisX2 ? 1 : 0) != 0, () -> String.format("totalTimeFromNanos %s >= sleepMillisX2 %s", totalTimeFromNanos, sleepMillisX2));
        Assertions.assertTrue((totalDuration.compareTo(Duration.ofMillis(sleepMillisX2)) >= 0 ? 1 : 0) != 0, () -> String.format("totalDuration >= sleepMillisX2", totalDuration, sleepMillisX2));
        long testTooLongMillis = sleepMillis * 100L;
        Assertions.assertTrue((totalTimeFromNanos < testTooLongMillis ? 1 : 0) != 0, () -> String.format("totalTimeFromNanos %s < testTooLongMillis %s", totalTimeFromNanos, testTooLongMillis));
        Assertions.assertTrue((totalDuration.compareTo(Duration.ofMillis(testTooLongMillis)) < 0 ? 1 : 0) != 0, () -> String.format("totalDuration %s < testTooLongMillis %s", totalDuration, testTooLongMillis));
    }

    @Test
    void testToSplitString() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        this.sleepPlus1(MIN_DURATION);
        watch.split();
        String splitStr = watch.toSplitString();
        Assertions.assertEquals((int)12, (int)splitStr.length(), (String)"Formatted split string not the correct length");
    }

    @Test
    void testToSplitStringWithMessage() throws InterruptedException {
        StopWatch watch = new StopWatch(MESSAGE);
        watch.start();
        this.sleepPlus1(MIN_DURATION);
        watch.split();
        String splitStr = watch.toSplitString();
        Assertions.assertEquals((int)(12 + MESSAGE.length() + 1), (int)splitStr.length(), (String)"Formatted split string not the correct length");
    }

    @Test
    void testToString() throws InterruptedException {
        StopWatch watch = StopWatch.createStarted();
        this.sleepPlus1(MIN_DURATION);
        watch.split();
        String splitStr = watch.toString();
        Assertions.assertEquals((int)12, (int)splitStr.length(), (String)"Formatted split string not the correct length");
    }

    @Test
    void testToStringWithMessage() throws InterruptedException {
        Assertions.assertTrue((boolean)new StopWatch(MESSAGE).toString().startsWith(MESSAGE), (String)"message");
        StopWatch watch = new StopWatch(MESSAGE);
        watch.start();
        this.sleepPlus1(MIN_DURATION);
        watch.split();
        String splitStr = watch.toString();
        Assertions.assertEquals((int)(12 + MESSAGE.length() + 1), (int)splitStr.length(), (String)"Formatted split string not the correct length");
    }

    private int throwIOException() throws IOException {
        throw new IOException("A");
    }
}

