/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializerTest;
import org.apache.commons.lang3.concurrent.AtomicInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AtomicInitializerObjectTest
extends AbstractConcurrentInitializerTest<Object> {
    AtomicInitializerObjectTest() {
    }

    @Override
    protected ConcurrentInitializer<Object> createInitializer() {
        return new AtomicInitializer<Object>(){

            protected Object initialize() {
                return new Object();
            }
        };
    }

    @Test
    void testGetThatReturnsNullFirstTime() throws ConcurrentException {
        AtomicInitializer<Object> initializer = new AtomicInitializer<Object>(){
            final AtomicBoolean firstRun = new AtomicBoolean(true);

            protected Object initialize() {
                if (this.firstRun.getAndSet(false)) {
                    return null;
                }
                return new Object();
            }
        };
        Assertions.assertNull((Object)initializer.get());
        Assertions.assertNull((Object)initializer.get());
    }
}

