/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StringUtilsAbbreviateTest {
    StringUtilsAbbreviateTest() {
    }

    private void assertAbbreviateWithAbbrevMarkerAndOffset(String expected, String abbrevMarker, int offset, int maxWidth) {
        String abcdefghijklmno = "abcdefghijklmno";
        String message = "abbreviate(String,String,int,int) failed";
        String actual = StringUtils.abbreviate((String)"abcdefghijklmno", (String)abbrevMarker, (int)offset, (int)maxWidth);
        if (offset >= 0 && offset < "abcdefghijklmno".length()) {
            Assertions.assertTrue((actual.indexOf((char)(97 + offset)) != -1 ? 1 : 0) != 0, (String)"abbreviate(String,String,int,int) failed -- should contain offset character");
        }
        Assertions.assertTrue((actual.length() <= maxWidth ? 1 : 0) != 0, () -> "abbreviate(String,String,int,int) failed -- should not be greater than maxWidth");
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"abbreviate(String,String,int,int) failed");
    }

    private void assertAbbreviateWithOffset(String expected, int offset, int maxWidth) {
        String abcdefghijklmno = "abcdefghijklmno";
        String message = "abbreviate(String,int,int) failed";
        String actual = StringUtils.abbreviate((String)"abcdefghijklmno", (int)offset, (int)maxWidth);
        if (offset >= 0 && offset < "abcdefghijklmno".length()) {
            Assertions.assertTrue((actual.indexOf((char)(97 + offset)) != -1 ? 1 : 0) != 0, (String)"abbreviate(String,int,int) failed -- should contain offset character");
        }
        Assertions.assertTrue((actual.length() <= maxWidth ? 1 : 0) != 0, () -> "abbreviate(String,int,int) failed -- should not be greater than maxWidth");
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"abbreviate(String,int,int) failed");
    }

    @Test
    void testAbbreviate_StringInt() {
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (int)10));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)10));
        Assertions.assertEquals((Object)"short", (Object)StringUtils.abbreviate((String)"short", (int)10));
        Assertions.assertEquals((Object)"Now is ...", (Object)StringUtils.abbreviate((String)"Now is the time for all good men to come to the aid of their party.", (int)10));
        String raspberry = "raspberry peach";
        Assertions.assertEquals((Object)"raspberry p...", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)14));
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)15));
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)16));
        Assertions.assertEquals((Object)"abc...", (Object)StringUtils.abbreviate((String)"abcdefg", (int)6));
        Assertions.assertEquals((Object)"abcdefg", (Object)StringUtils.abbreviate((String)"abcdefg", (int)7));
        Assertions.assertEquals((Object)"abcdefg", (Object)StringUtils.abbreviate((String)"abcdefg", (int)8));
        Assertions.assertEquals((Object)"a...", (Object)StringUtils.abbreviate((String)"abcdefg", (int)4));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)4));
        LangAssertions.assertIllegalArgumentException(() -> StringUtils.abbreviate((String)"abc", (int)3), "StringUtils.abbreviate expecting IllegalArgumentException");
    }

    @Test
    void testAbbreviate_StringIntInt() {
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (int)10, (int)12));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)0, (int)10));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)2, (int)10));
        LangAssertions.assertIllegalArgumentException(() -> StringUtils.abbreviate((String)"abcdefghij", (int)0, (int)3), "StringUtils.abbreviate expecting IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> StringUtils.abbreviate((String)"abcdefghij", (int)5, (int)6), "StringUtils.abbreviate expecting IllegalArgumentException");
        String raspberry = "raspberry peach";
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (int)11, (int)15));
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (int)7, (int)14));
        this.assertAbbreviateWithOffset("abcdefg...", -1, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 0, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 1, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 2, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 3, 10);
        this.assertAbbreviateWithOffset("abcdefg...", 4, 10);
        this.assertAbbreviateWithOffset("...fghi...", 5, 10);
        this.assertAbbreviateWithOffset("...ghij...", 6, 10);
        this.assertAbbreviateWithOffset("...hijk...", 7, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 8, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 9, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 10, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 11, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 12, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 13, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 14, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 15, 10);
        this.assertAbbreviateWithOffset("...ijklmno", 16, 10);
        this.assertAbbreviateWithOffset("...ijklmno", Integer.MAX_VALUE, 10);
    }

    @Test
    void testAbbreviate_StringStringInt() {
        Assertions.assertNull((Object)StringUtils.abbreviate(null, null, (int)10));
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (String)"...", (int)10));
        Assertions.assertEquals((Object)"paranaguacu", (Object)StringUtils.abbreviate((String)"paranaguacu", null, (int)10));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (String)"...", (int)2));
        Assertions.assertEquals((Object)"wai**", (Object)StringUtils.abbreviate((String)"waiheke", (String)"**", (int)5));
        Assertions.assertEquals((Object)"And af,,,,", (Object)StringUtils.abbreviate((String)"And after a long time, he finally met his son.", (String)",,,,", (int)10));
        String raspberry = "raspberry peach";
        Assertions.assertEquals((Object)"raspberry pe..", (Object)StringUtils.abbreviate((String)"raspberry peach", (String)"..", (int)14));
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (String)"---*---", (int)15));
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (String)".", (int)16));
        Assertions.assertEquals((Object)"abc()(", (Object)StringUtils.abbreviate((String)"abcdefg", (String)"()(", (int)6));
        Assertions.assertEquals((Object)"abcdefg", (Object)StringUtils.abbreviate((String)"abcdefg", (String)";", (int)7));
        Assertions.assertEquals((Object)"abcdefg", (Object)StringUtils.abbreviate((String)"abcdefg", (String)"_-", (int)8));
        Assertions.assertEquals((Object)"abc.", (Object)StringUtils.abbreviate((String)"abcdefg", (String)".", (int)4));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (int)4));
        LangAssertions.assertIllegalArgumentException(() -> StringUtils.abbreviate((String)"abcdefghij", (String)"...", (int)3), "StringUtils.abbreviate expecting IllegalArgumentException");
    }

    @Test
    void testAbbreviate_StringStringIntInt() {
        Assertions.assertNull((Object)StringUtils.abbreviate(null, null, (int)10, (int)12));
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (String)"...", (int)10, (int)12));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", null, (int)0, (int)10));
        Assertions.assertEquals((Object)"", (Object)StringUtils.abbreviate((String)"", (String)"...", (int)2, (int)10));
        LangAssertions.assertIllegalArgumentException(() -> StringUtils.abbreviate((String)"abcdefghij", (String)"::", (int)0, (int)2), "StringUtils.abbreviate expecting IllegalArgumentException");
        LangAssertions.assertIllegalArgumentException(() -> StringUtils.abbreviate((String)"abcdefghij", (String)"!!!", (int)5, (int)6), "StringUtils.abbreviate expecting IllegalArgumentException");
        String raspberry = "raspberry peach";
        Assertions.assertEquals((Object)"raspberry peach", (Object)StringUtils.abbreviate((String)"raspberry peach", (String)"--", (int)12, (int)15));
        Assertions.assertNull((Object)StringUtils.abbreviate(null, (String)";", (int)7, (int)14));
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdefgh;;", ";;", -1, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdefghi.", ".", 0, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdefgh++", "++", 1, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdefghi*", "*", 2, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdef{{{{", "{{{{", 4, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("abcdef____", "____", 5, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("==fghijk==", "==", 5, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("___ghij___", "___", 6, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("/ghijklmno", "/", 7, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("/ghijklmno", "/", 8, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("/ghijklmno", "/", 9, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("///ijklmno", "///", 10, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("//hijklmno", "//", 10, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("//hijklmno", "//", 11, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("...ijklmno", "...", 12, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("/ghijklmno", "/", 13, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("/ghijklmno", "/", 14, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("999ijklmno", "999", 15, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("_ghijklmno", "_", 16, 10);
        this.assertAbbreviateWithAbbrevMarkerAndOffset("+ghijklmno", "+", Integer.MAX_VALUE, 10);
    }

    @Test
    void testAbbreviateMarkerWithEmptyString() {
        String greaterThanMaxTest = "much too long text";
        Assertions.assertEquals((Object)"much too long", (Object)StringUtils.abbreviate((String)"much too long text", (String)"", (int)13));
    }

    @Test
    void testAbbreviateMiddle() {
        Assertions.assertNull((Object)StringUtils.abbreviateMiddle(null, null, (int)0));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", null, (int)0));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)0));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)3));
        Assertions.assertEquals((Object)"ab.f", (Object)StringUtils.abbreviateMiddle((String)"abcdef", (String)".", (int)4));
        Assertions.assertEquals((Object)"A very long text with un...f the text is complete.", (Object)StringUtils.abbreviateMiddle((String)"A very long text with unimportant stuff in the middle but interesting start and end to see if the text is complete.", (String)"...", (int)50));
        String longText = "Start text" + StringUtils.repeat((String)"x", (int)10000) + "Close text";
        Assertions.assertEquals((Object)"Start text->Close text", (Object)StringUtils.abbreviateMiddle((String)longText, (String)"->", (int)22));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)-1));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)1));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.abbreviateMiddle((String)"abc", (String)".", (int)2));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.abbreviateMiddle((String)"a", (String)".", (int)1));
        Assertions.assertEquals((Object)"a.d", (Object)StringUtils.abbreviateMiddle((String)"abcd", (String)".", (int)3));
        Assertions.assertEquals((Object)"a..f", (Object)StringUtils.abbreviateMiddle((String)"abcdef", (String)"..", (int)4));
        Assertions.assertEquals((Object)"ab.ef", (Object)StringUtils.abbreviateMiddle((String)"abcdef", (String)".", (int)5));
    }

    @Test
    void testEmoji() {
        String abbreviateResult;
        int i;
        String[] expectedResultsFox = new String[]{"\ud83e\udd8a...", "\ud83e\udd8a\ud83e\udd8a...", "\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a...", "\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a...", "\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a...", "\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a...", "\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a..."};
        String[] expectedResultsFamilyWithCodepoints = new String[]{"\ud83d\udc69...", "\ud83d\udc69\ud83c\udffb...", "\ud83d\udc69\ud83c\udffb\u200d...", "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68...", "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb...", "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d...", "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66..."};
        String[] expectedResultsFamilyWithGrapheme = new String[]{"\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb...", "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\ud83d\udc69\ud83c\udffc\u200d\ud83d\udc68\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc...", "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\ud83d\udc69\ud83c\udffc\u200d\ud83d\udc68\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\ud83d\udc69\ud83c\udffd\u200d\ud83d\udc68\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd...", "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\ud83d\udc69\ud83c\udffc\u200d\ud83d\udc68\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\ud83d\udc69\ud83c\udffd\u200d\ud83d\udc68\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\ud83d\udc69\ud83c\udffe\u200d\ud83d\udc68\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe...", "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\ud83d\udc69\ud83c\udffc\u200d\ud83d\udc68\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\ud83d\udc69\ud83c\udffd\u200d\ud83d\udc68\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\ud83d\udc69\ud83c\udffe\u200d\ud83d\udc68\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe\ud83d\udc69\ud83c\udfff\u200d\ud83d\udc68\ud83c\udfff\u200d\ud83d\udc66\ud83c\udfff\u200d\ud83d\udc66\ud83c\udfff...", "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\ud83d\udc69\ud83c\udffc\u200d\ud83d\udc68\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\ud83d\udc69\ud83c\udffd\u200d\ud83d\udc68\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\ud83d\udc69\ud83c\udffe\u200d\ud83d\udc68\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe\ud83d\udc69\ud83c\udfff\u200d\ud83d\udc68\ud83c\udfff\u200d\ud83d\udc66\ud83c\udfff\u200d\ud83d\udc66\ud83c\udfff\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb...", "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\ud83d\udc69\ud83c\udffc\u200d\ud83d\udc68\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\ud83d\udc69\ud83c\udffd\u200d\ud83d\udc68\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\ud83d\udc69\ud83c\udffe\u200d\ud83d\udc68\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe\ud83d\udc69\ud83c\udfff\u200d\ud83d\udc68\ud83c\udfff\u200d\ud83d\udc66\ud83c\udfff\u200d\ud83d\udc66\ud83c\udfff\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\ud83d\udc69\ud83c\udffc\u200d\ud83d\udc68\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc..."};
        for (i = 4; i <= 10; ++i) {
            abbreviateResult = StringUtils.abbreviate((String)"\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a\ud83e\udd8a", (int)i);
            Assertions.assertNotNull((Object)abbreviateResult);
        }
        for (i = 4; i <= 10; ++i) {
            abbreviateResult = StringUtils.abbreviate((String)"\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\ud83d\udc69\ud83c\udffc\u200d\ud83d\udc68\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\ud83d\udc69\ud83c\udffd\u200d\ud83d\udc68\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\ud83d\udc69\ud83c\udffe\u200d\ud83d\udc68\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe\ud83d\udc69\ud83c\udfff\u200d\ud83d\udc68\ud83c\udfff\u200d\ud83d\udc66\ud83c\udfff\u200d\ud83d\udc66\ud83c\udfff\ud83d\udc69\ud83c\udffb\u200d\ud83d\udc68\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\u200d\ud83d\udc66\ud83c\udffb\ud83d\udc69\ud83c\udffc\u200d\ud83d\udc68\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\u200d\ud83d\udc66\ud83c\udffc\ud83d\udc69\ud83c\udffd\u200d\ud83d\udc68\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\u200d\ud83d\udc66\ud83c\udffd\ud83d\udc69\ud83c\udffe\u200d\ud83d\udc68\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe\u200d\ud83d\udc66\ud83c\udffe\ud83d\udc69\ud83c\udfff\u200d\ud83d\udc68\ud83c\udfff\u200d\ud83d\udc66\ud83c\udfff\u200d\ud83d\udc66\ud83c\udfff", (int)i);
            Assertions.assertNotNull((Object)abbreviateResult);
        }
    }
}

