/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.impl;

import java.net.URL;
import java.util.Map;
import org.apache.commons.jelly.DynaTag;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.impl.StaticTag;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.jelly.impl.TagScript;
import org.xml.sax.SAXException;

public class StaticTagScript
extends TagScript {
    public StaticTagScript() {
    }

    public StaticTagScript(TagFactory tagFactory) {
        super(tagFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(JellyContext context, XMLOutput output) throws JellyTagException {
        try {
            this.startNamespacePrefixes(output);
        }
        catch (SAXException e) {
            throw new JellyTagException("could not start namespace prefixes", e);
        }
        Tag tag = null;
        try {
            tag = this.getTag(context);
            if (tag instanceof StaticTag) {
                tag = this.findDynamicTag(context, (StaticTag)tag);
            }
            this.setTag(tag, context);
        }
        catch (JellyException e) {
            throw new JellyTagException(e);
        }
        URL rootURL = context.getRootURL();
        URL currentURL = context.getCurrentURL();
        try {
            if (tag == null) {
                return;
            }
            tag.setContext(context);
            this.setContextURLs(context);
            DynaTag dynaTag = (DynaTag)tag;
            for (Map.Entry entry : this.attributes.entrySet()) {
                String name = (String)entry.getKey();
                Expression expression = (Expression)entry.getValue();
                Object value = null;
                value = Expression.class.isAssignableFrom(dynaTag.getAttributeType(name)) ? expression : expression.evaluate(context);
                dynaTag.setAttribute(name, value);
            }
            tag.doTag(output);
        }
        catch (JellyTagException e) {
            this.handleException(e);
        }
        catch (RuntimeException e) {
            this.handleException(e);
        }
        finally {
            context.setCurrentURL(currentURL);
            context.setRootURL(rootURL);
        }
        try {
            this.endNamespacePrefixes(output);
        }
        catch (SAXException e) {
            throw new JellyTagException("could not end namespace prefixes", e);
        }
    }

    protected Tag findDynamicTag(JellyContext context, StaticTag tag) throws JellyException {
        Tag newTag;
        TagLibrary taglib = context.getTagLibrary(tag.getUri());
        if (taglib != null && (newTag = taglib.createTag(tag.getLocalName(), this.getSaxAttributes())) != null) {
            newTag.setParent(tag.getParent());
            newTag.setBody(tag.getBody());
            return newTag;
        }
        return tag;
    }
}

