/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.expression;

import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.expression.CompositeExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.jexl.JexlExpressionFactory;

public class TestDynaBeans
extends TestCase {
    protected JellyContext context = new JellyContext();
    protected ExpressionFactory factory = new JexlExpressionFactory();

    public static void main(String[] args) {
        TestRunner.run((Test)TestDynaBeans.suite());
    }

    public static Test suite() {
        return new TestSuite(TestDynaBeans.class);
    }

    public TestDynaBeans(String testName) {
        super(testName);
    }

    public void testDynaBeans() throws Exception {
        DynaClass dynaClass = this.createDynaClass();
        DynaBean dynaBean = dynaClass.newInstance();
        dynaBean.set("stringProperty", (Object)"foo");
        dynaBean.set("intProperty", (Object)new Integer(24));
        this.context.setVariable("dbean", (Object)dynaBean);
        this.assertExpression("${dbean.stringProperty}", "foo");
        this.assertExpression("${dbean.intProperty}", new Integer(24));
    }

    protected DynaClass createDynaClass() {
        DynaProperty[] properties = new DynaProperty[]{new DynaProperty("booleanProperty", Boolean.TYPE), new DynaProperty("booleanSecond", Boolean.TYPE), new DynaProperty("doubleProperty", Double.TYPE), new DynaProperty("floatProperty", Float.TYPE), new DynaProperty("intProperty", Integer.TYPE), new DynaProperty("listIndexed", List.class), new DynaProperty("longProperty", Long.TYPE), new DynaProperty("mappedProperty", Map.class), new DynaProperty("mappedIntProperty", Map.class), new DynaProperty("nullProperty", String.class), new DynaProperty("shortProperty", Short.TYPE), new DynaProperty("stringProperty", String.class)};
        return new BasicDynaClass("TestDynaClass", null, properties);
    }

    protected void assertExpression(String expressionText, Object expectedValue) throws Exception {
        Expression expression = CompositeExpression.parse((String)expressionText, (ExpressionFactory)this.factory);
        TestDynaBeans.assertTrue((String)("Created a valid expression for: " + expressionText), (expression != null ? 1 : 0) != 0);
        Object value = expression.evaluate(this.context);
        TestDynaBeans.assertEquals((String)("Wrong result for expression: " + expressionText), (Object)expectedValue, (Object)value);
    }
}

