/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BaseMemoryLeakTest
extends TestCase {
    private static final Log log = LogFactory.getLog(BaseMemoryLeakTest.class);

    public BaseMemoryLeakTest(String name) {
        super(name);
    }

    public long runScriptManyTimes(String scriptName, int count) throws IOException, SAXException, JellyException {
        Script script;
        XMLParser parser;
        Runtime rt = Runtime.getRuntime();
        JellyContext jc = new JellyContext();
        jc.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        XMLOutput output = XMLOutput.createDummyXMLOutput();
        URL url = ((Object)((Object)this)).getClass().getResource(scriptName);
        String exturl = url.toExternalForm();
        int lastSlash = exturl.lastIndexOf("/");
        String extBase = exturl.substring(0, lastSlash + 1);
        URL baseurl = new URL(extBase);
        jc.setCurrentURL(baseurl);
        InputStream is = url.openStream();
        byte[] bytes = new byte[is.available()];
        is.read(bytes);
        ByteArrayInputStream scriptIStream = new ByteArrayInputStream(bytes);
        InputSource scriptISource = new InputSource(scriptIStream);
        is.close();
        is = null;
        bytes = null;
        rt.runFinalization();
        rt.gc();
        long start = rt.totalMemory() - rt.freeMemory();
        log.info((Object)("Starting memory test with used memory of " + start));
        int outputEveryXIterations = this.outputEveryXIterations();
        for (int i = 0; i < count; ++i) {
            ((InputStream)scriptIStream).reset();
            parser = new XMLParser();
            script = parser.parse(scriptISource);
            script.run(jc, output);
            jc.clear();
            if (outputEveryXIterations == 0 || i % outputEveryXIterations != 0) continue;
            parser = null;
            script = null;
            rt.runFinalization();
            rt.gc();
            long middle = rt.totalMemory() - rt.freeMemory();
            log.info((Object)("Memory test after " + i + " runs: " + (middle - start)));
        }
        rt.gc();
        jc = null;
        output = null;
        parser = null;
        script = null;
        scriptIStream = null;
        scriptISource = null;
        rt.runFinalization();
        rt.gc();
        long nullsDone = rt.totalMemory() - rt.freeMemory();
        log.info((Object)("Memory test completed, memory \"leaked\": " + (nullsDone - start)));
        return nullsDone - start;
    }

    protected int outputEveryXIterations() {
        return 1000;
    }
}

