/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.TextScript;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestCoreTags
extends TestCase {
    private static final Log log = LogFactory.getLog(TestCoreTags.class);

    public static void main(String[] args) {
        TestRunner.run((Test)TestCoreTags.suite());
    }

    public static Test suite() {
        return new TestSuite(TestCoreTags.class);
    }

    public TestCoreTags(String testName) {
        super(testName);
    }

    public void testArgs() throws Exception {
        FileInputStream in = new FileInputStream("src/test/org/apache/commons/jelly/test_args.jelly");
        XMLParser parser = new XMLParser();
        Script script = parser.parse((InputStream)in);
        script = script.compile();
        log.debug((Object)("Found: " + script));
        TestCoreTags.assertTrue((String)"Parsed a Script", (boolean)(script instanceof Script));
        String[] args = new String[]{"one", "two", "three"};
        JellyContext context = new JellyContext();
        context.setVariable("args", (Object)args);
        StringWriter buffer = new StringWriter();
        script.run(context, XMLOutput.createXMLOutput((Writer)buffer));
        String text = buffer.toString().trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Evaluated script as...");
            log.debug((Object)text);
        }
        TestCoreTags.assertEquals((String)"Produces the correct output", (String)"one two three", (String)text);
    }

    public void testTrimEndWhitespace() throws Exception {
        TextScript textScript = new TextScript(" ");
        textScript.trimEndWhitespace();
        TestCoreTags.assertEquals((String)"", (String)textScript.getText());
        textScript = new TextScript("");
        textScript.trimEndWhitespace();
        TestCoreTags.assertEquals((String)"", (String)textScript.getText());
        textScript = new TextScript(" foo ");
        textScript.trimEndWhitespace();
        TestCoreTags.assertEquals((String)" foo", (String)textScript.getText());
        textScript = new TextScript("foo");
        textScript.trimEndWhitespace();
        TestCoreTags.assertEquals((String)"foo", (String)textScript.getText());
    }

    public void testTrimStartWhitespace() throws Exception {
        TextScript textScript = new TextScript(" ");
        textScript.trimStartWhitespace();
        TestCoreTags.assertEquals((String)"", (String)textScript.getText());
        textScript = new TextScript("");
        textScript.trimStartWhitespace();
        TestCoreTags.assertEquals((String)"", (String)textScript.getText());
        textScript = new TextScript(" foo ");
        textScript.trimStartWhitespace();
        TestCoreTags.assertEquals((String)"foo ", (String)textScript.getText());
        textScript = new TextScript("foo");
        textScript.trimStartWhitespace();
        TestCoreTags.assertEquals((String)"foo", (String)textScript.getText());
    }
}

