// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
package com.cloud.network.vpc;

import java.util.List;

import com.cloud.utils.db.GenericDao;

/**
 * Data Access Object for network_acl_item table
 */
public interface NetworkACLItemDao extends GenericDao<NetworkACLItemVO, Long> {

    boolean setStateToAdd(NetworkACLItemVO rule);

    boolean revoke(NetworkACLItemVO rule);

    List<NetworkACLItemVO> listByACL(Long aclId);

    int getMaxNumberByACL(long aclId);

    NetworkACLItemVO findByAclAndNumber(long aclId, int number);

    void loadCidrs(NetworkACLItemVO item);

    /**
     * Updated the network ACL item 'number' field.
     *
     * @param networkItemId is the ID of the network ACL rule that will have its 'number' field updated.
     * @param newNumberValue is the new value that will be assigned to the 'number' field.
     */
    void updateNumberFieldNetworkItem(long networkItemId, int newNumberValue);
}
