/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.ReadData;

public class SubPartitionReadData
extends ReadData {
    private int subPartitionId;

    public SubPartitionReadData(long streamId, int subPartitionId, ByteBuf buf) {
        super(streamId, buf);
        this.subPartitionId = subPartitionId;
    }

    @Override
    public int encodedLength() {
        return super.encodedLength() + 4;
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        buf.writeInt(this.subPartitionId);
    }

    public int getSubPartitionId() {
        return this.subPartitionId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.SUBPARTITION_READ_DATA;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubPartitionReadData readData = (SubPartitionReadData)o;
        return this.streamId == readData.getStreamId() && this.subPartitionId == readData.getSubPartitionId() && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.streamId, this.subPartitionId, super.hashCode());
    }

    @Override
    public String toString() {
        return "SubpartitionReadData{streamId=" + this.streamId + ", subPartitionId=" + this.subPartitionId + '}';
    }
}

