/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.protocol.message.Message;
import org.apache.celeborn.common.rpc.RpcSource;
import org.apache.celeborn.common.rpc.RpcSource$;
import org.apache.celeborn.common.rpc.netty.InboxMessage;
import org.apache.celeborn.common.rpc.netty.OneWayMessage;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier$;
import org.apache.celeborn.common.rpc.netty.RpcMessage;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.shaded.com.google.protobuf.GeneratedMessageV3;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]e!B\u0001\u0003\u0001\u0019a!!\u0005*qG6+GO]5dgR\u0013\u0018mY6fe*\u00111\u0001B\u0001\u0004eB\u001c'BA\u0003\u0007\u0003\u0019\u0019w.\\7p]*\u0011q\u0001C\u0001\tG\u0016dWMY8s]*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q9R\"A\u000b\u000b\u0005Y!\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005a)\"a\u0002'pO\u001eLgn\u001a\u0005\t5\u0001\u0011)\u0019!C\u00019\u0005!a.Y7f\u0007\u0001)\u0012!\b\t\u0003=\u0005r!AD\u0010\n\u0005\u0001z\u0011A\u0002)sK\u0012,g-\u0003\u0002#G\t11\u000b\u001e:j]\u001eT!\u0001I\b\t\u0011\u0015\u0002!\u0011!Q\u0001\nu\tQA\\1nK\u0002B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\neB\u001c7k\\;sG\u0016\u0004\"!\u000b\u0016\u000e\u0003\tI!a\u000b\u0002\u0003\u0013I\u00038mU8ve\u000e,\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\t\r|gN\u001a\t\u0003_Aj\u0011\u0001B\u0005\u0003c\u0011\u0011AbQ3mK\n|'O\\\"p]\u001aDQa\r\u0001\u0005\u0002Q\na\u0001P5oSRtD\u0003B\u001b7oa\u0002\"!\u000b\u0001\t\u000bi\u0011\u0004\u0019A\u000f\t\u000b\u001d\u0012\u0004\u0019\u0001\u0015\t\u000b5\u0012\u0004\u0019\u0001\u0018\t\u000fi\u0002!\u0019!C\u0001w\u0005a\u0001.[:u_\u001e\u0014\u0018-\\'baV\tA\b\u0005\u0003>\tv1U\"\u0001 \u000b\u0005}\u0002\u0015AC2p]\u000e,(O]3oi*\u0011\u0011IQ\u0001\u0005kRLGNC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015s$!D\"p]\u000e,(O]3oi6\u000b\u0007\u000f\u0005\u0002H\u001d6\t\u0001J\u0003\u0002J\u0015\u00069Q.\u001a;sS\u000e\u001c(BA&M\u0003!\u0019w\u000eZ1iC2,'\"A'\u0002\u0007\r|W.\u0003\u0002P\u0011\nI\u0001*[:u_\u001e\u0014\u0018-\u001c\u0005\u0007#\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u001b!L7\u000f^8he\u0006lW*\u00199!\u0011\u001d\u0019\u0006A1A\u0005\nQ\u000ba\"\\1y#V,W/\u001a'f]\u001e$\b.F\u0001V!\t1\u0016,D\u0001X\u0015\tAf(\u0001\u0004bi>l\u0017nY\u0005\u00035^\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019a\u0006\u0001)A\u0005+\u0006yQ.\u0019=Rk\u0016,X\rT3oORD\u0007\u0005C\u0004_\u0001\t\u0007I\u0011B0\u0002!Mdwn\u001e*qGRC'/Z:i_2$W#\u00011\u0011\u00059\t\u0017B\u00012\u0010\u0005\u0011auN\\4\t\r\u0011\u0004\u0001\u0015!\u0003a\u0003E\u0019Hn\\<Sa\u000e$\u0006N]3tQ>dG\r\t\u0005\bM\u0002\u0011\r\u0011\"\u0003`\u0003=\u0019Hn\\<Sa\u000eLe\u000e^3sm\u0006d\u0007B\u00025\u0001A\u0003%\u0001-\u0001\ttY><(\u000b]2J]R,'O^1mA!9!\u000e\u0001b\u0001\n\u0013y\u0016a\u0004:qG\u0012+X\u000e]%oi\u0016\u0014h/\u00197\t\r1\u0004\u0001\u0015!\u0003a\u0003A\u0011\bo\u0019#v[BLe\u000e^3sm\u0006d\u0007\u0005C\u0004o\u0001\t\u0007I\u0011\u0002+\u0002\u00191\f7\u000f\u001e#v[B$\u0016.\\3\t\rA\u0004\u0001\u0015!\u0003V\u00035a\u0017m\u001d;Ek6\u0004H+[7fA!9!\u000f\u0001b\u0001\n\u0013!\u0016a\u00047bgR\u001cFn\\<M_\u001e$\u0016.\\3\t\rQ\u0004\u0001\u0015!\u0003V\u0003Aa\u0017m\u001d;TY><Hj\\4US6,\u0007\u0005C\u0004w\u0001\t\u0007IQB<\u0002\u0019U\u001cX\rS5ti><'/Y7\u0016\u0003a\u0004\"AD=\n\u0005i|!a\u0002\"p_2,\u0017M\u001c\u0005\u0007y\u0002\u0001\u000bQ\u0002=\u0002\u001bU\u001cX\rS5ti><'/Y7!\u0011\u001dq\bA1A\u0005\u000e}\f!BT!N\u000b~c\u0015IQ#M+\t\t\t\u0001E\u0004\u0002\u0004\u00055\u0011\u0011C\u000f\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005-q\"\u0001\u0006d_2dWm\u0019;j_:LA!a\u0004\u0002\u0006\t\u0019Q*\u00199\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006C\u0003\u0011a\u0017M\\4\n\u0007\t\n)\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000bQBA\u0001\u0003-q\u0015)T#`\u0019\u0006\u0013U\t\u0014\u0011\t\u0017\u0005\u0005\u0002\u00011AA\u0002\u0013%\u00111E\u0001\u0010cV,W/\u001a'f]\u001e$\bNR;oGV\u0011\u0011Q\u0005\t\u0005\u001d\u0005\u001d\u0002-C\u0002\u0002*=\u0011\u0011BR;oGRLwN\u001c\u0019\t\u0017\u00055\u0002\u00011AA\u0002\u0013%\u0011qF\u0001\u0014cV,W/\u001a'f]\u001e$\bNR;oG~#S-\u001d\u000b\u0005\u0003c\t9\u0004E\u0002\u000f\u0003gI1!!\u000e\u0010\u0005\u0011)f.\u001b;\t\u0015\u0005e\u00121FA\u0001\u0002\u0004\t)#A\u0002yIEB\u0001\"!\u0010\u0001A\u0003&\u0011QE\u0001\u0011cV,W/\u001a'f]\u001e$\bNR;oG\u0002Bq!!\u0011\u0001\t\u0003\t\u0019%\u0001\u0003j]&$H\u0003BA\u0019\u0003\u000bB\u0001\"a\u0012\u0002@\u0001\u0007\u0011QE\u0001\u000bY\u0016tw\r\u001e5Gk:\u001c\u0007bBA&\u0001\u0011\u0005\u0011QJ\u0001\u0010kB$\u0017\r^3ISN$xn\u001a:b[R1\u0011\u0011GA(\u0003#BaAGA%\u0001\u0004i\u0002bBA*\u0003\u0013\u0002\r\u0001Y\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003/\u0002A\u0011AA-\u0003=)\b\u000fZ1uK6\u000b\u0007\u0010T3oORDGCAA\u0019\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\n!\u0002\\8h'2|wO\u00159d)!\t\t$!\u0019\u0002r\u0005U\u0004\u0002CA2\u00037\u0002\r!!\u001a\u0002\u000f5,7o]1hKB!\u0011qMA7\u001b\t\tIGC\u0002\u0002l\t\tQA\\3uifLA!a\u001c\u0002j\ta\u0011J\u001c2pq6+7o]1hK\"9\u00111OA.\u0001\u0004\u0001\u0017!C9vKV,G+[7f\u0011\u001d\t9(a\u0017A\u0002\u0001\f1\u0002\u001d:pG\u0016\u001c8\u000fV5nK\"9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014A\u0002:fG>\u0014H\r\u0006\u0005\u00022\u0005}\u0014qQAE\u0011!\t\u0019'!\u001fA\u0002\u0005\u0005\u0005c\u0001\b\u0002\u0004&\u0019\u0011QQ\b\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002t\u0005e\u0004\u0019\u00011\t\u000f\u0005]\u0014\u0011\u0010a\u0001A\"9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0015AB;qI\u0006$X\r\u0006\u0003\u00022\u0005E\u0005\u0002CA2\u0003\u0017\u0003\r!!\u001a\t\u000f\u0005U\u0005\u0001\"\u0001\u0002Z\u0005!A-^7q\u0001")
public class RpcMetricsTracker
implements Logging {
    private final String name;
    private final RpcSource rpcSource;
    private final ConcurrentMap<String, Histogram> histogramMap;
    private final AtomicLong maxQueueLength;
    private final long slowRpcThreshold;
    private final long slowRpcInterval;
    private final long rpcDumpInterval;
    private final AtomicLong lastDumpTime;
    private final AtomicLong lastSlowLogTime;
    private final boolean useHistogram;
    private final Map<String, String> NAME_LABEL;
    private Function0<Object> org$apache$celeborn$common$rpc$RpcMetricsTracker$$queueLengthFunc;
    private final transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        RpcMetricsTracker rpcMetricsTracker = this;
        synchronized (rpcMetricsTracker) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    public String name() {
        return this.name;
    }

    public ConcurrentMap<String, Histogram> histogramMap() {
        return this.histogramMap;
    }

    private AtomicLong maxQueueLength() {
        return this.maxQueueLength;
    }

    private long slowRpcThreshold() {
        return this.slowRpcThreshold;
    }

    private long slowRpcInterval() {
        return this.slowRpcInterval;
    }

    private long rpcDumpInterval() {
        return this.rpcDumpInterval;
    }

    private AtomicLong lastDumpTime() {
        return this.lastDumpTime;
    }

    private AtomicLong lastSlowLogTime() {
        return this.lastSlowLogTime;
    }

    private final boolean useHistogram() {
        return this.useHistogram;
    }

    private final Map<String, String> NAME_LABEL() {
        return this.NAME_LABEL;
    }

    public Function0<Object> org$apache$celeborn$common$rpc$RpcMetricsTracker$$queueLengthFunc() {
        return this.org$apache$celeborn$common$rpc$RpcMetricsTracker$$queueLengthFunc;
    }

    private void org$apache$celeborn$common$rpc$RpcMetricsTracker$$queueLengthFunc_$eq(Function0<Object> x$1) {
        this.org$apache$celeborn$common$rpc$RpcMetricsTracker$$queueLengthFunc = x$1;
    }

    public void init(Function0<Object> lengthFunc) {
        this.org$apache$celeborn$common$rpc$RpcMetricsTracker$$queueLengthFunc_$eq(lengthFunc);
        if (this.name() != null) {
            this.rpcSource.addGauge(RpcSource$.MODULE$.QUEUE_LENGTH(), this.NAME_LABEL(), this.org$apache$celeborn$common$rpc$RpcMetricsTracker$$queueLengthFunc());
            this.rpcSource.addTimer(RpcSource$.MODULE$.QUEUE_TIME(), this.NAME_LABEL());
            this.rpcSource.addTimer(RpcSource$.MODULE$.PROCESS_TIME(), this.NAME_LABEL());
        }
    }

    public void updateHistogram(String name, long value) {
        this.histogramMap().putIfAbsent(name, new Histogram((Reservoir)new UniformReservoir()));
        Histogram histogram = (Histogram)this.histogramMap().get(name);
        histogram.update(value);
    }

    public void updateMaxLength() {
        long len = this.org$apache$celeborn$common$rpc$RpcMetricsTracker$$queueLengthFunc().apply$mcJ$sp();
        if (len > this.maxQueueLength().get()) {
            this.maxQueueLength().set(len);
        }
    }

    private void logSlowRpc(InboxMessage message, long queueTime, long processTime) {
        if (queueTime + processTime > this.slowRpcThreshold()) {
            long lastLogTime = this.lastSlowLogTime().get();
            if (this.slowRpcInterval() < 0L || System.currentTimeMillis() - lastLogTime > this.slowRpcInterval() && this.lastSlowLogTime().compareAndSet(lastLogTime, System.currentTimeMillis())) {
                this.logWarning((Function0<String>)new Serializable(this, message, queueTime, processTime){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RpcMetricsTracker $outer;
                    private final InboxMessage message$1;
                    private final long queueTime$1;
                    private final long processTime$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"slow rpc detected: currentQueueSize = ", ", queueTime=", "(ns) processTime=", "(ns) message=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$celeborn$common$rpc$RpcMetricsTracker$$queueLengthFunc().apply$mcJ$sp()), BoxesRunTime.boxToLong((long)this.queueTime$1), BoxesRunTime.boxToLong((long)this.processTime$1), this.message$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.message$1 = message$1;
                        this.queueTime$1 = queueTime$1;
                        this.processTime$1 = processTime$1;
                    }
                });
            }
            long lastTime = this.lastDumpTime().get();
            if (this.useHistogram() && System.currentTimeMillis() - lastTime > this.rpcDumpInterval() && this.lastDumpTime().compareAndSet(lastTime, System.currentTimeMillis())) {
                this.dump();
            }
        }
    }

    public void record(Object message, long queueTime, long processTime) {
        String msgName = this.messageName$1(message);
        if (this.useHistogram()) {
            this.updateHistogram(RpcSource$.MODULE$.QUEUE_TIME(), queueTime);
            this.updateHistogram(RpcSource$.MODULE$.PROCESS_TIME(), processTime);
            this.updateHistogram(msgName, processTime);
        } else {
            this.rpcSource.updateTimer(RpcSource$.MODULE$.QUEUE_TIME(), queueTime, this.NAME_LABEL());
            this.rpcSource.updateTimer(RpcSource$.MODULE$.PROCESS_TIME(), processTime, this.NAME_LABEL());
            this.rpcSource.updateTimer(msgName, processTime);
        }
    }

    public void update(InboxMessage message) {
        InboxMessage inboxMessage = message;
        if (inboxMessage instanceof RpcMessage) {
            RpcMessage rpcMessage = (RpcMessage)inboxMessage;
            Object content = rpcMessage.content();
            long queueTime = rpcMessage.dequeueTime() - rpcMessage.enqueueTime();
            long processTime = rpcMessage.endProcessTime() - rpcMessage.dequeueTime();
            this.record(content, queueTime, processTime);
            this.logSlowRpc(message, queueTime, processTime);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (inboxMessage instanceof OneWayMessage) {
            OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
            Object content = oneWayMessage.content();
            long queueTime = oneWayMessage.dequeueTime() - oneWayMessage.enqueueTime();
            long processTime = oneWayMessage.endProcessTime() - oneWayMessage.dequeueTime();
            this.record(content, queueTime, processTime);
            this.logSlowRpc(message, queueTime, processTime);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void dump() {
        if (this.useHistogram()) {
            StringBuilder builder = new StringBuilder();
            builder.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RPC statistics for ", " (time unit: ns)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()}))).append("\n");
            builder.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current queue size = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.org$apache$celeborn$common$rpc$RpcMetricsTracker$$queueLengthFunc().apply$mcJ$sp())}))).append("\n");
            builder.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max queue length = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxQueueLength().get())}))).append("\n");
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.histogramMap().entrySet()).asScala()).foreach((Function1)new Serializable(this, builder){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RpcMetricsTracker $outer;
                private final StringBuilder builder$1;

                public final StringBuilder apply(Map.Entry<String, Histogram> entry) {
                    Histogram histogram = entry.getValue();
                    Snapshot snapshot = histogram.getSnapshot();
                    this.builder$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"histogram for ", " RPC metrics: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name()}))).append(entry.getKey()).append("\n");
                    return this.builder$1.append("count: ").append(histogram.getCount()).append("\n").append("min: ").append(snapshot.getMin()).append("\n").append("mean: ").append(snapshot.getMean()).append("\n").append("p50: ").append(snapshot.getMedian()).append("\n").append("p75: ").append(snapshot.get75thPercentile()).append("\n").append("p95: ").append(snapshot.get95thPercentile()).append("\n").append("p99: ").append(snapshot.get99thPercentile()).append("\n").append("max: ").append(snapshot.getMax()).append("\n");
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.builder$1 = builder$1;
                }
            });
            this.logInfo((Function0<String>)new Serializable(this, builder){
                public static final long serialVersionUID = 0L;
                private final StringBuilder builder$1;

                public final String apply() {
                    return this.builder$1.toString();
                }
                {
                    this.builder$1 = builder$1;
                }
            });
            return;
        }
    }

    private final String messageName$1(Object message) {
        String string;
        Object object = message;
        if (object instanceof Message) {
            Message message2 = (Message)object;
            string = message2.getClass().toString();
        } else if (object instanceof GeneratedMessageV3) {
            GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)object;
            string = generatedMessageV3.getDescriptorForType().getFullName();
        } else {
            string = object instanceof RpcEndpointVerifier.CheckExistence ? "CheckExistence" : "unknown";
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public RpcMetricsTracker(String name, RpcSource rpcSource, CelebornConf conf) {
        this.name = name;
        this.rpcSource = rpcSource;
        super();
        Logging$class.$init$(this);
        this.histogramMap = JavaUtils.newConcurrentHashMap();
        this.maxQueueLength = new AtomicLong(0L);
        this.slowRpcThreshold = conf.rpcSlowThresholdNs();
        this.slowRpcInterval = conf.rpcSlowIntervalMs();
        this.rpcDumpInterval = conf.rpcDumpIntervalMs();
        this.lastDumpTime = new AtomicLong(0L);
        this.lastSlowLogTime = new AtomicLong(0L);
        v0 = name;
        var4_4 = RpcNameConstants.LIFECYCLE_MANAGER_EP;
        if (!(v0 == null ? var4_4 != null : v0.equals(var4_4) == false)) ** GOTO lbl-1000
        v1 = name;
        var5_5 = RpcEndpointVerifier$.MODULE$.NAME();
        if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        this.useHistogram = v2;
        this.NAME_LABEL = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)}));
    }
}

