/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.client.read.PartitionReader;
import org.apache.celeborn.client.read.checkpoint.PartitionReaderCheckpointMetadata;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.client.ChunkReceivedCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbBufferStreamEnd;
import org.apache.celeborn.common.protocol.PbOpenStream;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.StreamType;
import org.apache.celeborn.common.util.ExceptionUtils;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerPartitionReader
implements PartitionReader {
    private final Logger logger = LoggerFactory.getLogger(WorkerPartitionReader.class);
    private PartitionLocation location;
    private final TransportClientFactory clientFactory;
    private PbStreamHandler streamHandler;
    private TransportClient client;
    private MetricsCallback metricsCallback;
    private int lastReturnedChunkId = -1;
    private int returnedChunks;
    private int chunkIndex;
    private int startChunkIndex;
    private int endChunkIndex;
    private int inflightRequestCount;
    private final LinkedBlockingQueue<Pair<Integer, ByteBuf>> results;
    private final ChunkReceivedCallback callback;
    private final AtomicReference<IOException> exception = new AtomicReference();
    private final String shuffleKey;
    private final int fetchMaxReqsInFlight;
    private final long fetchTimeoutMs;
    private boolean closed = false;
    private int fetchChunkRetryCnt;
    private int fetchChunkMaxRetry;
    private final boolean testFetch;
    private Long pollChunkWaitTime;
    private Optional<PartitionReaderCheckpointMetadata> partitionReaderCheckpointMetadata;

    WorkerPartitionReader(CelebornConf conf, final String shuffleKey, PartitionLocation location, PbStreamHandler pbStreamHandler, TransportClientFactory clientFactory, int startMapIndex, int endMapIndex, int fetchChunkRetryCnt, int fetchChunkMaxRetry, MetricsCallback metricsCallback, int startChunkIndex, int endChunkIndex, Optional<PartitionReaderCheckpointMetadata> checkpointMetadata) throws IOException, InterruptedException {
        this.shuffleKey = shuffleKey;
        this.fetchMaxReqsInFlight = conf.clientFetchMaxReqsInFlight();
        this.results = new LinkedBlockingQueue();
        this.fetchTimeoutMs = conf.clientFetchTimeoutMs();
        this.pollChunkWaitTime = conf.clientFetchPollChunkWaitTime();
        this.inflightRequestCount = 0;
        this.metricsCallback = metricsCallback;
        this.callback = new ChunkReceivedCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(int chunkIndex, ManagedBuffer buffer) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    ByteBuf buf = ((NettyManagedBuffer)buffer).getBuf();
                    if (!WorkerPartitionReader.this.closed) {
                        buf.retain();
                        WorkerPartitionReader.this.results.add(Pair.of(chunkIndex, buf));
                    }
                }
            }

            @Override
            public void onFailure(int chunkIndex, Throwable e) {
                String errorMsg = String.format("Fetch chunk %d of shuffle key %s failed.", chunkIndex, shuffleKey);
                WorkerPartitionReader.this.logger.error(errorMsg, e);
                WorkerPartitionReader.this.exception.set(new CelebornIOException(errorMsg, e));
            }
        };
        try {
            this.client = clientFactory.createClient(location.getHost(), location.getFetchPort());
        }
        catch (InterruptedException ie) {
            this.logger.error("PartitionReader thread interrupted while creating client.");
            throw ie;
        }
        if (pbStreamHandler == null) {
            TransportMessage openStreamMsg = new TransportMessage(MessageType.OPEN_STREAM, PbOpenStream.newBuilder().setShuffleKey(shuffleKey).setFileName(location.getFileName()).setStartIndex(startMapIndex).setEndIndex(endMapIndex).build().toByteArray());
            ByteBuffer response = this.client.sendRpcSync(openStreamMsg.toByteBuffer(), this.fetchTimeoutMs);
            this.streamHandler = (PbStreamHandler)TransportMessage.fromByteBuffer(response).getParsedPayload();
        } else {
            this.streamHandler = pbStreamHandler;
        }
        this.startChunkIndex = startChunkIndex == -1 ? 0 : startChunkIndex;
        this.endChunkIndex = endChunkIndex == -1 ? this.streamHandler.getNumChunks() - 1 : Math.min(this.streamHandler.getNumChunks() - 1, endChunkIndex);
        this.chunkIndex = this.startChunkIndex;
        this.location = location;
        this.clientFactory = clientFactory;
        this.fetchChunkRetryCnt = fetchChunkRetryCnt;
        this.fetchChunkMaxRetry = fetchChunkMaxRetry;
        if (checkpointMetadata.isPresent()) {
            this.partitionReaderCheckpointMetadata = checkpointMetadata;
            this.returnedChunks = checkpointMetadata.get().getReturnedChunks().size();
        } else {
            this.partitionReaderCheckpointMetadata = conf.isPartitionReaderCheckpointEnabled() ? Optional.of(new PartitionReaderCheckpointMetadata()) : Optional.empty();
        }
        this.testFetch = conf.testFetchFailure();
        ShuffleClient.incrementTotalReadCounter();
    }

    @Override
    public boolean hasNext() {
        return this.returnedChunks < this.endChunkIndex - this.startChunkIndex + 1;
    }

    private void checkpoint() {
        if (this.lastReturnedChunkId != -1) {
            this.partitionReaderCheckpointMetadata.ifPresent(readerCheckpointMetadata -> readerCheckpointMetadata.checkpoint(this.lastReturnedChunkId));
        }
    }

    @Override
    public ByteBuf next() throws IOException, InterruptedException {
        this.checkpoint();
        this.checkException();
        if (this.chunkIndex <= this.endChunkIndex) {
            this.fetchChunks();
        }
        Pair<Integer, ByteBuf> chunk = null;
        try {
            while (chunk == null) {
                this.checkException();
                Long startFetchWait = System.nanoTime();
                chunk = this.results.poll(this.pollChunkWaitTime, TimeUnit.MILLISECONDS);
                this.metricsCallback.incReadTime(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startFetchWait));
            }
        }
        catch (InterruptedException e) {
            this.logger.error("PartitionReader thread interrupted while polling data.");
            throw e;
        }
        ++this.returnedChunks;
        --this.inflightRequestCount;
        this.lastReturnedChunkId = chunk.getLeft();
        return chunk.getRight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        WorkerPartitionReader workerPartitionReader = this;
        synchronized (workerPartitionReader) {
            this.closed = true;
        }
        if (this.results.size() > 0) {
            this.results.forEach((Consumer<Pair<Integer, ByteBuf>>)((Consumer<Pair>)chunk -> ((ByteBuf)chunk.getRight()).release()));
        }
        this.results.clear();
        this.closeStream();
    }

    private void closeStream() {
        if (this.client != null && this.client.isActive()) {
            TransportMessage bufferStreamEnd = new TransportMessage(MessageType.BUFFER_STREAM_END, PbBufferStreamEnd.newBuilder().setStreamType(StreamType.ChunkStream).setStreamId(this.streamHandler.getStreamId()).build().toByteArray());
            this.client.sendRpc(bufferStreamEnd.toByteBuffer());
        }
    }

    @Override
    public PartitionLocation getLocation() {
        return this.location;
    }

    @Override
    public Optional<PartitionReaderCheckpointMetadata> getPartitionReaderCheckpointMetadata() {
        return this.partitionReaderCheckpointMetadata;
    }

    private void fetchChunks() throws IOException, InterruptedException {
        int inFlight = this.inflightRequestCount;
        if (inFlight < this.fetchMaxReqsInFlight) {
            int toFetch = Math.min(this.fetchMaxReqsInFlight - inFlight + 1, this.endChunkIndex + 1 - this.chunkIndex);
            while (toFetch > 0 && this.chunkIndex <= this.endChunkIndex) {
                if (this.partitionReaderCheckpointMetadata.isPresent() && this.partitionReaderCheckpointMetadata.get().isCheckpointed(this.chunkIndex)) {
                    this.logger.info("Skipping chunk {} as it has already been returned, likely by a previous reader for the same partition.", (Object)this.chunkIndex);
                    ++this.chunkIndex;
                    continue;
                }
                if (this.testFetch && this.fetchChunkRetryCnt < this.fetchChunkMaxRetry - 1 && this.chunkIndex == 3) {
                    this.callback.onFailure(this.chunkIndex, new CelebornIOException("Test fetch chunk failure"));
                    --toFetch;
                    continue;
                }
                if (!this.client.isActive()) {
                    try {
                        this.client = this.clientFactory.createClient(this.location.getHost(), this.location.getFetchPort());
                    }
                    catch (IOException e) {
                        this.logger.error("FetchChunk for shuffleKey: {}, streamId: {}, chunkIndex: {} failed.", new Object[]{this.shuffleKey, this.streamHandler.getStreamId(), this.chunkIndex, e});
                        ExceptionUtils.wrapAndThrowIOException(e);
                    }
                    catch (InterruptedException e) {
                        this.logger.error("PartitionReader thread interrupted while fetching chunks.");
                        throw e;
                    }
                }
                this.client.fetchChunk(this.streamHandler.getStreamId(), this.chunkIndex, this.fetchTimeoutMs, this.callback);
                ++this.inflightRequestCount;
                ++this.chunkIndex;
                --toFetch;
            }
        }
    }

    private void checkException() throws IOException {
        IOException e = this.exception.get();
        if (e != null) {
            throw e;
        }
    }
}

