/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.shaded.io.netty.handler.address;

import java.net.SocketAddress;
import org.apache.celeborn.shaded.io.netty.channel.ChannelFuture;
import org.apache.celeborn.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.celeborn.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.celeborn.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.apache.celeborn.shaded.io.netty.channel.ChannelPromise;

public abstract class DynamicAddressConnectHandler
extends ChannelOutboundHandlerAdapter {
    @Override
    public final void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        SocketAddress local;
        SocketAddress remote2;
        try {
            remote2 = this.remoteAddress(remoteAddress, localAddress);
            local = this.localAddress(remoteAddress, localAddress);
        }
        catch (Exception e) {
            promise.setFailure(e);
            return;
        }
        ctx.connect(remote2, local, promise).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    future.channel().pipeline().remove(DynamicAddressConnectHandler.this);
                }
            }
        });
    }

    protected SocketAddress localAddress(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        return localAddress;
    }

    protected SocketAddress remoteAddress(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        return remoteAddress;
    }
}

