/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.client.write.PushTask;
import org.apache.celeborn.common.util.ThreadUtils;

public class SendBufferPool {
    private static volatile SendBufferPool _instance;
    private final int capacity;
    private final LinkedList<byte[][]> buffers;
    private long lastAquireTime;
    private final LinkedList<LinkedBlockingQueue<PushTask>> pushTaskQueues;
    private ScheduledExecutorService cleaner = ThreadUtils.newDaemonSingleThreadScheduledExecutor("celeborn-client-sendBufferPool-cleaner");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SendBufferPool get(int capacity, long checkInterval, long timeout) {
        if (_instance != null) return _instance;
        Class<SendBufferPool> clazz = SendBufferPool.class;
        synchronized (SendBufferPool.class) {
            if (_instance != null) return _instance;
            _instance = new SendBufferPool(capacity, checkInterval, timeout);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return _instance;
        }
    }

    private SendBufferPool(int capacity, long checkInterval, long timeout) {
        assert (capacity > 0);
        this.capacity = capacity;
        this.buffers = new LinkedList();
        this.pushTaskQueues = new LinkedList();
        this.lastAquireTime = System.currentTimeMillis();
        this.cleaner.scheduleWithFixedDelay(() -> {
            if (System.currentTimeMillis() - this.lastAquireTime > timeout) {
                SendBufferPool sendBufferPool = this;
                synchronized (sendBufferPool) {
                    this.buffers.clear();
                    this.pushTaskQueues.clear();
                }
            }
        }, checkInterval, checkInterval, TimeUnit.MILLISECONDS);
    }

    public synchronized byte[][] acquireBuffer(int numPartitions) {
        this.lastAquireTime = System.currentTimeMillis();
        Iterator iterator = this.buffers.iterator();
        while (iterator.hasNext()) {
            byte[][] candidate = (byte[][])iterator.next();
            if (candidate.length != numPartitions) continue;
            iterator.remove();
            return candidate;
        }
        if (this.buffers.size() > 0) {
            this.buffers.removeFirst();
        }
        return new byte[numPartitions][];
    }

    public synchronized LinkedBlockingQueue<PushTask> acquirePushTaskQueue() {
        this.lastAquireTime = System.currentTimeMillis();
        if (!this.pushTaskQueues.isEmpty()) {
            return this.pushTaskQueues.removeFirst();
        }
        return null;
    }

    public synchronized void returnBuffer(byte[][] buffer) {
        if (this.buffers.size() == this.capacity) {
            this.buffers.removeFirst();
        }
        this.buffers.addLast(buffer);
    }

    public synchronized void returnPushTaskQueue(LinkedBlockingQueue<PushTask> pushTaskQueue) {
        if (this.pushTaskQueues.size() == this.capacity) {
            this.pushTaskQueues.removeFirst();
        }
        this.pushTaskQueues.addLast(pushTaskQueue);
    }
}

