/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnected;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnectionError;
import org.apache.celeborn.common.rpc.netty.RemoteProcessDisconnected;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RequestMessage$;
import org.apache.celeborn.common.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb!B\u0007\u000f\u0001QQ\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u0011=\u0002!\u0011!Q\u0001\nABQa\r\u0001\u0005\u0002QBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004I\u0001\u0001\u0006IA\u000f\u0005\u0006\u0013\u0002!\tE\u0013\u0005\u0006\u0013\u0002!\t\u0005\u0019\u0005\u0006Q\u0002!I!\u001b\u0005\u0006k\u0002!\tE\u001e\u0005\u0006u\u0002!\te\u001f\u0005\b\u0003/\u0001A\u0011IA\r\u0011\u001d\ti\u0002\u0001C!\u0003?\u0011qBT3uif\u0014\u0006o\u0019%b]\u0012dWM\u001d\u0006\u0003\u001fA\tQA\\3uifT!!\u0005\n\u0002\u0007I\u00048M\u0003\u0002\u0014)\u000511m\\7n_:T!!\u0006\f\u0002\u0011\r,G.\u001a2pe:T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sON\u0019\u0001aG\u0012\u0011\u0005q\tS\"A\u000f\u000b\u0005yy\u0012AB:feZ,'O\u0003\u0002!%\u00059a.\u001a;x_J\\\u0017B\u0001\u0012\u001e\u0005I\u0011\u0015m]3NKN\u001c\u0018mZ3IC:$G.\u001a:\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\u0012\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005!*#a\u0002'pO\u001eLgnZ\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u00148\u0001\u0001\t\u0003Y5j\u0011AD\u0005\u0003]9\u0011!\u0002R5ta\u0006$8\r[3s\u0003!qW\r\u001e;z\u000b:4\bC\u0001\u00172\u0013\t\u0011dBA\u0006OKR$\u0018P\u00159d\u000b:4\u0018A\u0002\u001fj]&$h\bF\u00026m]\u0002\"\u0001\f\u0001\t\u000b%\u001a\u0001\u0019A\u0016\t\u000b=\u001a\u0001\u0019\u0001\u0019\u0002\u001fI,Wn\u001c;f\u0003\u0012$'/Z:tKN,\u0012A\u000f\t\u0005w\t#E)D\u0001=\u0015\tid(\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0010!\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0003\u0006!!.\u0019<b\u0013\t\u0019EHA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"!\u0012$\u000e\u0003AI!a\u0012\t\u0003\u0015I\u00038-\u00113ee\u0016\u001c8/\u0001\tsK6|G/Z!eIJ,7o]3tA\u00059!/Z2fSZ,GcA&R1B\u0011AjT\u0007\u0002\u001b*\ta*A\u0003tG\u0006d\u0017-\u0003\u0002Q\u001b\n!QK\\5u\u0011\u0015\u0011f\u00011\u0001T\u0003\u0019\u0019G.[3oiB\u0011AKV\u0007\u0002+*\u0011!kH\u0005\u0003/V\u0013q\u0002\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e\u0005\u00063\u001a\u0001\rAW\u0001\u000fe\u0016\fX/Z:u\u001b\u0016\u001c8/Y4f!\tYf,D\u0001]\u0015\tiv$\u0001\u0005qe>$xnY8m\u0013\tyFL\u0001\bSKF,Xm\u001d;NKN\u001c\u0018mZ3\u0015\t-\u000b'm\u0019\u0005\u0006%\u001e\u0001\ra\u0015\u0005\u00063\u001e\u0001\rA\u0017\u0005\u0006I\u001e\u0001\r!Z\u0001\tG\u0006dGNY1dWB\u0011AKZ\u0005\u0003OV\u00131C\u00159d%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\fq\"\u001b8uKJt\u0017\r\u001c*fG\u0016Lg/\u001a\u000b\u0004U2l\u0007C\u0001\u0017l\u0013\tyf\u0002C\u0003S\u0011\u0001\u00071\u000bC\u0003o\u0011\u0001\u0007q.A\u0004nKN\u001c\u0018mZ3\u0011\u0005A\u001cX\"A9\u000b\u0005I\u0004\u0015a\u00018j_&\u0011A/\u001d\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018aD2iK\u000e\\'+Z4jgR,'/\u001a3\u0015\u0003]\u0004\"\u0001\u0014=\n\u0005el%a\u0002\"p_2,\u0017M\\\u0001\u0010Kb\u001cW\r\u001d;j_:\u001c\u0015-^4iiR!1\n`A\u000b\u0011\u0015i(\u00021\u0001\u007f\u0003\u0015\u0019\u0017-^:f!\ry\u0018q\u0002\b\u0005\u0003\u0003\tYA\u0004\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9AK\u0001\u0007yI|w\u000e\u001e \n\u00039K1!!\u0004N\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0005\u0002\u0014\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u001bi\u0005\"\u0002*\u000b\u0001\u0004\u0019\u0016!D2iC:tW\r\\!di&4X\rF\u0002L\u00037AQAU\u0006A\u0002M\u000bqb\u00195b]:,G.\u00138bGRLg/\u001a\u000b\u0004\u0017\u0006\u0005\u0002\"\u0002*\r\u0001\u0004\u0019\u0006")
public class NettyRpcHandler
extends BaseMessageHandler
implements Logging {
    private final Dispatcher dispatcher;
    private final NettyRpcEnv nettyEnv;
    private final ConcurrentHashMap<RpcAddress, RpcAddress> remoteAddresses;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        NettyRpcHandler nettyRpcHandler = this;
        synchronized (nettyRpcHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    private ConcurrentHashMap<RpcAddress, RpcAddress> remoteAddresses() {
        return this.remoteAddresses;
    }

    @Override
    public void receive(TransportClient client, org.apache.celeborn.common.network.protocol.RequestMessage requestMessage) {
        try {
            ByteBuffer message = requestMessage.body().nioByteBuffer();
            RequestMessage messageToDispatch = this.internalReceive(client, message);
            this.dispatcher.postOneWayMessage(messageToDispatch);
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while invoking NettyRpcHandler#receive() for one-way message.", e);
        }
    }

    @Override
    public void receive(TransportClient client, org.apache.celeborn.common.network.protocol.RequestMessage requestMessage, RpcResponseCallback callback) {
        try {
            ByteBuffer message = requestMessage.body().nioByteBuffer();
            RequestMessage messageToDispatch = this.internalReceive(client, message);
            this.dispatcher.postRemoteMessage(messageToDispatch, callback);
        }
        catch (Exception e) {
            RpcRequest rpcReq = (RpcRequest)requestMessage;
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Error while invoking NettyRpcHandler#receive() on RPC id ").append(rpcReq$1.requestId).toString(), e);
            callback.onFailure(e);
        }
    }

    private RequestMessage internalReceive(TransportClient client, ByteBuffer message) {
        RequestMessage requestMessage;
        block1: {
            InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
            Predef$.MODULE$.assert(addr != null);
            RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
            requestMessage = RequestMessage$.MODULE$.apply(this.nettyEnv, client, message);
            if (requestMessage.senderAddress() == null) {
                return new RequestMessage(clientAddr, requestMessage.receiver(), requestMessage.content());
            }
            RpcAddress remoteEnvAddress = requestMessage.senderAddress();
            if (this.remoteAddresses().putIfAbsent(clientAddr, remoteEnvAddress) != null) break block1;
            this.dispatcher.postToAll(new RemoteProcessConnected(remoteEnvAddress));
        }
        return requestMessage;
    }

    @Override
    public boolean checkRegistered() {
        return this.nettyEnv.checkRegistered();
    }

    @Override
    public void exceptionCaught(Throwable cause, TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        if (addr != null) {
            RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
            this.dispatcher.postToAll(new RemoteProcessConnectionError(cause, clientAddr));
            RpcAddress remoteEnvAddress = this.remoteAddresses().get(clientAddr);
            if (remoteEnvAddress != null) {
                this.dispatcher.postToAll(new RemoteProcessConnectionError(cause, remoteEnvAddress));
                return;
            }
            return;
        }
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception before connecting to the client", cause);
    }

    @Override
    public void channelActive(TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        Predef$.MODULE$.assert(addr != null);
        RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
        this.dispatcher.postToAll(new RemoteProcessConnected(clientAddr));
    }

    @Override
    public void channelInactive(TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        if (addr != null) {
            RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
            this.nettyEnv.removeOutbox(clientAddr);
            this.dispatcher.postToAll(new RemoteProcessDisconnected(clientAddr));
            RpcAddress remoteEnvAddress = this.remoteAddresses().remove(clientAddr);
            if (remoteEnvAddress != null) {
                this.dispatcher.postToAll(new RemoteProcessDisconnected(remoteEnvAddress));
                return;
            }
            return;
        }
    }

    public NettyRpcHandler(Dispatcher dispatcher, NettyRpcEnv nettyEnv) {
        this.dispatcher = dispatcher;
        this.nettyEnv = nettyEnv;
        Logging.$init$(this);
        this.remoteAddresses = JavaUtils.newConcurrentHashMap();
    }
}

