/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.execution.columnar.CelebornBooleanColumnAccessor;
import org.apache.spark.sql.execution.columnar.CelebornByteColumnAccessor;
import org.apache.spark.sql.execution.columnar.CelebornColumnAccessor;
import org.apache.spark.sql.execution.columnar.CelebornCompactDecimalColumnAccessor;
import org.apache.spark.sql.execution.columnar.CelebornDecimalColumnAccessor;
import org.apache.spark.sql.execution.columnar.CelebornDoubleColumnAccessor;
import org.apache.spark.sql.execution.columnar.CelebornFloatColumnAccessor;
import org.apache.spark.sql.execution.columnar.CelebornIntColumnAccessor;
import org.apache.spark.sql.execution.columnar.CelebornLongColumnAccessor;
import org.apache.spark.sql.execution.columnar.CelebornNativeColumnAccessor;
import org.apache.spark.sql.execution.columnar.CelebornShortColumnAccessor;
import org.apache.spark.sql.execution.columnar.CelebornStringColumnAccessor;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.Predef$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class CelebornColumnAccessor$ {
    public static CelebornColumnAccessor$ MODULE$;

    static {
        new CelebornColumnAccessor$();
    }

    public CelebornColumnAccessor apply(DataType dataType, ByteBuffer buffer) {
        ByteBuffer buf = buffer.order(ByteOrder.nativeOrder());
        boolean bl = false;
        DecimalType decimalType = null;
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return new CelebornBooleanColumnAccessor(buf);
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return new CelebornByteColumnAccessor(buf);
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return new CelebornShortColumnAccessor(buf);
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return new CelebornIntColumnAccessor(buf);
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return new CelebornLongColumnAccessor(buf);
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return new CelebornFloatColumnAccessor(buf);
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return new CelebornDoubleColumnAccessor(buf);
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return new CelebornStringColumnAccessor(buf);
        }
        if (dataType2 instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType2;
            if (decimalType.precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
                return new CelebornCompactDecimalColumnAccessor(buf, decimalType);
            }
        }
        if (bl) {
            return new CelebornDecimalColumnAccessor(buf, decimalType);
        }
        throw new Exception(new StringBuilder(18).append("not support type: ").append(dataType2).toString());
    }

    public void decompress(CelebornColumnAccessor columnAccessor, WritableColumnVector columnVector, int numRows) {
        CelebornColumnAccessor celebornColumnAccessor = columnAccessor;
        if (celebornColumnAccessor instanceof CelebornNativeColumnAccessor) {
            CelebornNativeColumnAccessor celebornNativeColumnAccessor = (CelebornNativeColumnAccessor)celebornColumnAccessor;
            celebornNativeColumnAccessor.decompress(columnVector, numRows);
            return;
        }
        if (celebornColumnAccessor instanceof CelebornDecimalColumnAccessor) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> columnAccessor.extractToColumnVector(columnVector, x$1));
            return;
        }
        throw new RuntimeException("Not support non-primitive type now");
    }

    public void decompress(byte[] array, WritableColumnVector columnVector, DataType dataType, int numRows) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        CelebornColumnAccessor columnAccessor = this.apply(dataType, byteBuffer);
        this.decompress(columnAccessor, columnVector, numRows);
    }

    private CelebornColumnAccessor$() {
        MODULE$ = this;
    }
}

