/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.client.ShuffleClientImpl;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.protocol.ReviveRequest;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

class ReviveManager {
    private static final Logger logger = LoggerFactory.getLogger(ReviveManager.class);
    LinkedBlockingQueue<ReviveRequest> requestQueue = new LinkedBlockingQueue();
    private final int batchSize;
    ShuffleClientImpl shuffleClient;
    private final ScheduledExecutorService batchReviveRequestScheduler = ThreadUtils.newDaemonSingleThreadScheduledExecutor("celeborn-client-lifecycle-manager-batch-revive-scheduler");

    public ReviveManager(ShuffleClientImpl shuffleClient, CelebornConf conf) {
        this.shuffleClient = shuffleClient;
        this.batchSize = conf.clientPushReviveBatchSize();
        long interval = conf.clientPushReviveInterval();
        this.batchReviveRequestScheduler.scheduleWithFixedDelay(() -> {
            HashMap<Integer, Set> shuffleMap = new HashMap<Integer, Set>();
            do {
                ArrayList batchRequests = new ArrayList();
                this.requestQueue.drainTo(batchRequests, this.batchSize);
                for (ReviveRequest reviveRequest : batchRequests) {
                    Set set = shuffleMap.computeIfAbsent(reviveRequest.shuffleId, id -> new HashSet());
                    set.add(reviveRequest);
                }
                for (Map.Entry entry : shuffleMap.entrySet()) {
                    int shuffleId = (Integer)entry.getKey();
                    Set requests = (Set)entry.getValue();
                    HashSet<Integer> mapIds = new HashSet<Integer>();
                    ArrayList<ReviveRequest> filteredRequests = new ArrayList<ReviveRequest>();
                    HashMap<Integer, ReviveRequest> requestsToSend = new HashMap<Integer, ReviveRequest>();
                    Map partitionMap = shuffleClient.reducePartitionMap.get(shuffleId);
                    for (ReviveRequest req : requests) {
                        if (shuffleClient.newerPartitionLocationExists(partitionMap, req.partitionId, req.epoch, false) || shuffleClient.mapperEnded(shuffleId, req.mapId)) {
                            req.reviveStatus = StatusCode.SUCCESS.getValue();
                            continue;
                        }
                        filteredRequests.add(req);
                        mapIds.add(req.mapId);
                        if (requestsToSend.containsKey(req.partitionId) && ((ReviveRequest)requestsToSend.get((Object)Integer.valueOf((int)req.partitionId))).epoch >= req.epoch) continue;
                        requestsToSend.put(req.partitionId, req);
                    }
                    if (requestsToSend.isEmpty()) continue;
                    Map<Integer, Integer> results = shuffleClient.reviveBatch(shuffleId, mapIds, requestsToSend.values());
                    if (results == null) {
                        for (ReviveRequest req : filteredRequests) {
                            req.reviveStatus = StatusCode.REVIVE_FAILED.getValue();
                        }
                        continue;
                    }
                    for (ReviveRequest req : filteredRequests) {
                        if (shuffleClient.mapperEnded(shuffleId, req.mapId)) {
                            req.reviveStatus = StatusCode.SUCCESS.getValue();
                            continue;
                        }
                        req.reviveStatus = results.get(req.partitionId);
                    }
                }
            } while (this.requestQueue.size() > this.batchSize / 2);
        }, interval, interval, TimeUnit.MILLISECONDS);
    }

    public void addRequest(ReviveRequest request) {
        this.shuffleClient.excludeWorkerByCause(request.cause, request.loc);
        try {
            this.requestQueue.put(request);
        }
        catch (InterruptedException e) {
            logger.error("Exception when put into requests!", (Throwable)e);
        }
    }

    public void close() {
        ThreadUtils.shutdown(this.batchReviveRequestScheduler, Duration.apply((String)"800ms"));
    }
}

