/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.service.deploy.worker.storage.PartitionFilesSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionFilesCleaner {
    private static final Logger logger = LoggerFactory.getLogger(PartitionFilesCleaner.class);
    private final LinkedBlockingQueue<PartitionFilesSorter.FileSorter> fileSorters = new LinkedBlockingQueue();
    private final Lock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final ExecutorService cleaner = ThreadUtils.newDaemonSingleThreadExecutor((String)"worker-partition-file-cleaner");

    PartitionFilesCleaner(PartitionFilesSorter partitionFilesSorter) {
        this.cleaner.submit(() -> {
            try {
                while (!partitionFilesSorter.isShutdown()) {
                    this.lock.lockInterruptibly();
                    try {
                        while (this.fileSorters.isEmpty()) {
                            this.notEmpty.await();
                        }
                        Iterator<PartitionFilesSorter.FileSorter> it = this.fileSorters.iterator();
                        while (it.hasNext()) {
                            PartitionFilesSorter.FileSorter sorter = it.next();
                            try {
                                if (!sorter.getOriginFileInfo().isStreamsEmpty()) continue;
                                logger.debug("Deleting the original files for shuffle key {}: {}", (Object)sorter.getShuffleKey(), (Object)sorter.getOriginFileInfo().getFilePath());
                                sorter.deleteOriginFiles();
                                it.remove();
                            }
                            catch (IOException e) {
                                logger.error("catch IOException when delete origin files", (Throwable)e);
                            }
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
            catch (InterruptedException e) {
                logger.warn("partition file cleaner thread interrupted while wait new sorter.", (Throwable)e);
            }
        });
    }

    public void add(PartitionFilesSorter.FileSorter fileSorter) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            this.fileSorters.add(fileSorter);
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cleanupExpiredShuffleKey(Set<String> expiredShuffleKeys) {
        this.lock.lock();
        try {
            this.fileSorters.removeIf(sorter -> expiredShuffleKeys.contains(sorter.getShuffleKey()));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.fileSorters.clear();
        this.cleaner.shutdownNow();
    }
}

