/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.unsafe.Platform;
import org.apache.celeborn.common.util.CelebornExitKind;
import org.apache.celeborn.common.util.FileChannelUtils;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.PbSerDeUtils;
import org.apache.celeborn.common.util.ShuffleBlockInfoUtils;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.service.deploy.worker.LevelDBProvider;
import org.apache.celeborn.service.deploy.worker.ShuffleRecoverHelper;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionFilesSorter
extends ShuffleRecoverHelper {
    private static final Logger logger = LoggerFactory.getLogger(PartitionFilesSorter.class);
    private static final LevelDBProvider.StoreVersion CURRENT_VERSION = new LevelDBProvider.StoreVersion(1, 0);
    private static final String RECOVERY_SORTED_FILES_FILE_NAME = "sortedFiles.ldb";
    private File recoverFile;
    private volatile boolean shutdown = false;
    private final ConcurrentHashMap<String, Set<String>> sortedShuffleFiles = JavaUtils.newConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> sortingShuffleFiles = JavaUtils.newConcurrentHashMap();
    private final ConcurrentHashMap<String, Map<String, Map<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>>>> cachedIndexMaps = JavaUtils.newConcurrentHashMap();
    private final LinkedBlockingQueue<FileSorter> shuffleSortTaskDeque = new LinkedBlockingQueue();
    private final AtomicInteger sortedFileCount = new AtomicInteger();
    private final AtomicLong sortedFilesSize = new AtomicLong();
    protected final boolean eagerlyRemoveOriginalFilesEnabled;
    protected final long sortTimeout;
    protected final long shuffleChunkSize;
    protected final long reservedMemoryPerPartition;
    private boolean gracefulShutdown;
    private long partitionSorterShutdownAwaitTime;
    private DB sortedFilesDb;
    private MemoryManager memoryManager;
    protected final AbstractSource source;
    private final ExecutorService fileSorterExecutors;
    private final Thread fileSorterSchedulerThread;

    public PartitionFilesSorter(MemoryManager memoryManager, CelebornConf conf, AbstractSource source) {
        this.eagerlyRemoveOriginalFilesEnabled = conf.partitionSorterEagerlyRemoveOriginalFilesEnabled();
        this.sortTimeout = conf.partitionSorterSortPartitionTimeout();
        this.shuffleChunkSize = conf.shuffleChunkSize();
        this.reservedMemoryPerPartition = conf.partitionSorterReservedMemoryPerPartition();
        this.partitionSorterShutdownAwaitTime = conf.workerGracefulShutdownPartitionSorterCloseAwaitTimeMs();
        this.source = source;
        this.memoryManager = memoryManager;
        this.gracefulShutdown = conf.workerGracefulShutdown();
        if (this.gracefulShutdown) {
            try {
                String recoverPath = conf.workerGracefulShutdownRecoverPath();
                this.recoverFile = new File(recoverPath, RECOVERY_SORTED_FILES_FILE_NAME);
                this.sortedFilesDb = LevelDBProvider.initLevelDB(this.recoverFile, CURRENT_VERSION);
                this.reloadAndCleanSortedShuffleFiles(this.sortedFilesDb);
            }
            catch (Exception e) {
                logger.error("Failed to reload LevelDB for sorted shuffle files from: " + this.recoverFile, (Throwable)e);
                this.sortedFilesDb = null;
            }
        } else {
            this.sortedFilesDb = null;
        }
        this.fileSorterExecutors = ThreadUtils.newDaemonCachedThreadPool((String)"worker-file-sorter-execute", (int)conf.partitionSorterThreads(), (int)120);
        this.fileSorterSchedulerThread = new Thread(() -> {
            try {
                while (!this.shutdown) {
                    FileSorter task = this.shuffleSortTaskDeque.take();
                    memoryManager.reserveSortMemory(this.reservedMemoryPerPartition);
                    while (!memoryManager.sortMemoryReady()) {
                        Thread.sleep(20L);
                    }
                    this.fileSorterExecutors.submit(() -> {
                        try {
                            task.sort();
                        }
                        catch (InterruptedException e) {
                            logger.warn("File sorter thread was interrupted.");
                        }
                        finally {
                            memoryManager.releaseSortMemory(this.reservedMemoryPerPartition);
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                logger.warn("Sort scheduler thread is shutting down, detail: ", (Throwable)e);
            }
        });
        this.fileSorterSchedulerThread.start();
    }

    public int getSortingCount() {
        return this.shuffleSortTaskDeque.size();
    }

    public int getSortedCount() {
        return this.sortedFileCount.get();
    }

    public long getSortedSize() {
        return this.sortedFilesSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo getSortedFileInfo(String shuffleKey, String fileName, FileInfo fileInfo, int startMapIndex, int endMapIndex) throws IOException {
        String fileId = shuffleKey + "-" + fileName;
        UserIdentifier userIdentifier = fileInfo.getUserIdentifier();
        Set sorted = this.sortedShuffleFiles.computeIfAbsent(shuffleKey, v -> ConcurrentHashMap.newKeySet());
        Set sorting = this.sortingShuffleFiles.computeIfAbsent(shuffleKey, v -> ConcurrentHashMap.newKeySet());
        String sortedFilePath = Utils.getSortedFilePath((String)fileInfo.getFilePath());
        String indexFilePath = Utils.getIndexFilePath((String)fileInfo.getFilePath());
        Set set = sorting;
        synchronized (set) {
            if (sorted.contains(fileId)) {
                return this.resolve(shuffleKey, fileId, userIdentifier, sortedFilePath, indexFilePath, startMapIndex, endMapIndex);
            }
            if (!sorting.contains(fileId)) {
                try {
                    FileSorter fileSorter = new FileSorter(fileInfo, fileId, shuffleKey);
                    sorting.add(fileId);
                    this.shuffleSortTaskDeque.put(fileSorter);
                }
                catch (InterruptedException e) {
                    logger.error("Sorter scheduler thread is interrupted means worker is shutting down.", (Throwable)e);
                    throw new IOException("Sort scheduler thread is interrupted means worker is shutting down.", e);
                }
                catch (IOException e) {
                    logger.error("File sorter access HDFS failed.", (Throwable)e);
                    throw new IOException("File sorter access HDFS failed.", e);
                }
            }
        }
        long sortStartTime = System.currentTimeMillis();
        while (!sorted.contains(fileId)) {
            if (sorting.contains(fileId)) {
                try {
                    Thread.sleep(50L);
                    if (System.currentTimeMillis() - sortStartTime <= this.sortTimeout) continue;
                    logger.error("Sorting file {} timeout after {}ms", (Object)fileId, (Object)this.sortTimeout);
                    throw new IOException("Sort file " + fileInfo.getFilePath() + " timeout after " + this.sortTimeout);
                }
                catch (InterruptedException e) {
                    logger.error("Sorter scheduler thread is interrupted means worker is shutting down.", (Throwable)e);
                    throw new IOException("Sorter scheduler thread is interrupted means worker is shutting down.", e);
                }
            }
            logger.debug("Sorting shuffle file for {} {} failed.", (Object)shuffleKey, (Object)fileInfo.getFilePath());
            throw new IOException("Sorting shuffle file for " + shuffleKey + " " + fileInfo.getFilePath() + " failed.");
        }
        return this.resolve(shuffleKey, fileId, userIdentifier, sortedFilePath, indexFilePath, startMapIndex, endMapIndex);
    }

    public void cleanup(HashSet<String> expiredShuffleKeys) {
        for (String expiredShuffleKey : expiredShuffleKeys) {
            this.sortingShuffleFiles.remove(expiredShuffleKey);
            this.deleteSortedShuffleFiles(expiredShuffleKey);
            this.cachedIndexMaps.remove(expiredShuffleKey);
        }
    }

    public void close(int exitKind) {
        logger.info("Closing {}", (Object)this.getClass().getSimpleName());
        this.shutdown = true;
        if (exitKind == CelebornExitKind.WORKER_GRACEFUL_SHUTDOWN()) {
            long start = System.currentTimeMillis();
            try {
                this.fileSorterExecutors.shutdown();
                this.fileSorterExecutors.awaitTermination(this.partitionSorterShutdownAwaitTime, TimeUnit.MILLISECONDS);
                if (!this.fileSorterExecutors.isShutdown()) {
                    this.fileSorterExecutors.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                logger.error("Await partition sorter executor shutdown catch exception: ", (Throwable)e);
            }
            if (this.sortedFilesDb != null) {
                try {
                    this.updateSortedShuffleFilesInDB();
                    this.sortedFilesDb.close();
                }
                catch (IOException e) {
                    logger.error("Store recover data to LevelDB failed.", (Throwable)e);
                }
            }
            long end = System.currentTimeMillis();
            logger.info("Await partition sorter executor complete cost " + (end - start) + "ms");
        } else {
            this.fileSorterSchedulerThread.interrupt();
            this.fileSorterExecutors.shutdownNow();
            if (this.sortedFilesDb != null) {
                try {
                    this.sortedFilesDb.close();
                    this.recoverFile.delete();
                }
                catch (IOException e) {
                    logger.error("Clean LevelDB failed.", (Throwable)e);
                }
            }
        }
        this.cachedIndexMaps.clear();
    }

    private void reloadAndCleanSortedShuffleFiles(DB db) {
        if (db != null) {
            DBIterator itr = db.iterator();
            itr.seek(this.SHUFFLE_KEY_PREFIX.getBytes(StandardCharsets.UTF_8));
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                String key = new String((byte[])entry.getKey(), StandardCharsets.UTF_8);
                if (!key.startsWith(this.SHUFFLE_KEY_PREFIX)) continue;
                String shuffleKey = this.parseDbShuffleKey(key);
                try {
                    Set sortedFiles = PbSerDeUtils.fromPbSortedShuffleFileSet((byte[])((byte[])entry.getValue()));
                    logger.debug("Reload DB: {} -> {}", (Object)shuffleKey, (Object)sortedFiles);
                    this.sortedShuffleFiles.put(shuffleKey, sortedFiles);
                    this.sortedFilesDb.delete((byte[])entry.getKey());
                }
                catch (Exception exception) {
                    logger.error("Reload DB: {} failed.", (Object)shuffleKey, (Object)exception);
                }
            }
        }
    }

    @VisibleForTesting
    public void updateSortedShuffleFilesInDB() {
        for (String shuffleKey : this.sortedShuffleFiles.keySet()) {
            try {
                this.sortedFilesDb.put(this.dbShuffleKey(shuffleKey), PbSerDeUtils.toPbSortedShuffleFileSet(this.sortedShuffleFiles.get(shuffleKey)));
                logger.debug("Update DB: {} -> {}", (Object)shuffleKey, this.sortedShuffleFiles.get(shuffleKey));
            }
            catch (Exception exception) {
                logger.error("Update DB: {} failed.", (Object)shuffleKey, (Object)exception);
            }
        }
    }

    @VisibleForTesting
    public Set<String> initSortedShuffleFiles(String shuffleKey) {
        return this.sortedShuffleFiles.computeIfAbsent(shuffleKey, v -> ConcurrentHashMap.newKeySet());
    }

    @VisibleForTesting
    public void updateSortedShuffleFiles(String shuffleKey, String fileId, long fileLength) {
        this.sortedShuffleFiles.get(shuffleKey).add(fileId);
        this.sortedFileCount.incrementAndGet();
        this.sortedFilesSize.addAndGet(fileLength);
    }

    @VisibleForTesting
    public void deleteSortedShuffleFiles(String expiredShuffleKey) {
        this.sortedShuffleFiles.remove(expiredShuffleKey);
    }

    @VisibleForTesting
    public Set<String> getSortedShuffleFiles(String shuffleKey) {
        return this.sortedShuffleFiles.get(shuffleKey);
    }

    protected void writeIndex(Map<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>> indexMap, String indexFilePath, boolean isHdfs) throws IOException {
        FSDataOutputStream hdfsIndexOutput = null;
        FileChannel indexFileChannel = null;
        if (isHdfs) {
            hdfsIndexOutput = StorageManager.hadoopFs().create(new Path(indexFilePath));
        } else {
            indexFileChannel = FileChannelUtils.createWritableFileChannel((String)indexFilePath);
        }
        int indexSize = 0;
        for (Map.Entry<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>> entry : indexMap.entrySet()) {
            indexSize += 8;
            indexSize += entry.getValue().size() * 16;
        }
        ByteBuffer indexBuf = ByteBuffer.allocate(indexSize);
        for (Map.Entry<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>> entry : indexMap.entrySet()) {
            int mapId = entry.getKey();
            List<ShuffleBlockInfoUtils.ShuffleBlockInfo> list = entry.getValue();
            indexBuf.putInt(mapId);
            indexBuf.putInt(list.size());
            list.forEach(info -> {
                indexBuf.putLong(info.offset);
                indexBuf.putLong(info.length);
            });
        }
        indexBuf.flip();
        if (isHdfs) {
            byte[] byArray = new byte[indexSize];
            indexBuf.get(byArray);
            hdfsIndexOutput.write(byArray);
            hdfsIndexOutput.close();
        } else {
            while (indexBuf.hasRemaining()) {
                indexFileChannel.write(indexBuf);
            }
            indexFileChannel.close();
        }
    }

    protected void readStreamFully(FSDataInputStream stream, ByteBuffer buffer, String path) throws IOException {
        while (buffer.hasRemaining()) {
            if (-1 != stream.read(buffer)) continue;
            throw new IOException("Unexpected EOF, file name : " + path + " position :" + stream.getPos() + " buffer size :" + buffer.limit());
        }
    }

    protected void readChannelFully(FileChannel channel, ByteBuffer buffer, String path) throws IOException {
        while (buffer.hasRemaining()) {
            if (-1 != channel.read(buffer)) continue;
            throw new IOException("Unexpected EOF, file name : " + path + " position :" + channel.position() + " buffer size :" + buffer.limit());
        }
    }

    private long transferStreamFully(FSDataInputStream origin, FSDataOutputStream sorted, long offset, long length) throws IOException {
        byte[] buffer = new byte[Math.toIntExact(length)];
        origin.readFully(offset, buffer);
        sorted.write(buffer);
        return length;
    }

    private long transferChannelFully(FileChannel originChannel, FileChannel targetChannel, long offset, long length) throws IOException {
        long transferredSize;
        for (transferredSize = 0L; transferredSize != length; transferredSize += originChannel.transferTo(offset + transferredSize, length - transferredSize, targetChannel)) {
        }
        return transferredSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileInfo resolve(String shuffleKey, String fileId, UserIdentifier userIdentifier, String sortedFilePath, String indexFilePath, int startMapIndex, int endMapIndex) throws IOException {
        Map indexMap;
        if (this.cachedIndexMaps.containsKey(shuffleKey) && this.cachedIndexMaps.get(shuffleKey).containsKey(fileId)) {
            indexMap = this.cachedIndexMaps.get(shuffleKey).get(fileId);
            return new FileInfo(sortedFilePath, ShuffleBlockInfoUtils.getChunkOffsetsFromShuffleBlockInfos((int)startMapIndex, (int)endMapIndex, (long)this.shuffleChunkSize, indexMap), userIdentifier);
        }
        FileChannel indexChannel = null;
        FSDataInputStream hdfsIndexStream = null;
        boolean isHdfs = Utils.isHdfsPath((String)indexFilePath);
        int indexSize = 0;
        try {
            if (isHdfs) {
                hdfsIndexStream = StorageManager.hadoopFs().open(new Path(indexFilePath));
                indexSize = (int)StorageManager.hadoopFs().getFileStatus(new Path(indexFilePath)).getLen();
            } else {
                indexChannel = FileChannelUtils.openReadableFileChannel((String)indexFilePath);
                File indexFile = new File(indexFilePath);
                indexSize = (int)indexFile.length();
            }
            ByteBuffer indexBuf = ByteBuffer.allocate(indexSize);
            if (isHdfs) {
                this.readStreamFully(hdfsIndexStream, indexBuf, indexFilePath);
            } else {
                this.readChannelFully(indexChannel, indexBuf, indexFilePath);
            }
            indexBuf.rewind();
            indexMap = ShuffleBlockInfoUtils.parseShuffleBlockInfosFromByteBuffer((ByteBuffer)indexBuf);
            Map cacheMap = this.cachedIndexMaps.computeIfAbsent(shuffleKey, v -> JavaUtils.newConcurrentHashMap());
            cacheMap.put(fileId, indexMap);
        }
        catch (Exception e) {
            try {
                logger.error("Read sorted shuffle file index " + indexFilePath + " error, detail: ", (Throwable)e);
                throw new IOException("Read sorted shuffle file index failed.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Closeable)indexChannel, null);
                IOUtils.closeQuietly(hdfsIndexStream, null);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)indexChannel, null);
        IOUtils.closeQuietly((Closeable)hdfsIndexStream, null);
        return new FileInfo(sortedFilePath, ShuffleBlockInfoUtils.getChunkOffsetsFromShuffleBlockInfos((int)startMapIndex, (int)endMapIndex, (long)this.shuffleChunkSize, indexMap), userIdentifier);
    }

    class FileSorter {
        private final String originFilePath;
        private final String sortedFilePath;
        private final String indexFilePath;
        private final long originFileLen;
        private final String fileId;
        private final String shuffleKey;
        private final boolean isHdfs;
        private FSDataInputStream hdfsOriginInput = null;
        private FSDataOutputStream hdfsSortedOutput = null;
        private FileChannel originFileChannel = null;
        private FileChannel sortedFileChannel = null;

        FileSorter(FileInfo fileInfo, String fileId, String shuffleKey) throws IOException {
            this.originFilePath = fileInfo.getFilePath();
            this.sortedFilePath = Utils.getSortedFilePath((String)this.originFilePath);
            this.isHdfs = fileInfo.isHdfs();
            this.originFileLen = fileInfo.getFileLength();
            this.fileId = fileId;
            this.shuffleKey = shuffleKey;
            this.indexFilePath = Utils.getIndexFilePath((String)this.originFilePath);
            if (!this.isHdfs) {
                File indexFile;
                File sortedFile = new File(this.sortedFilePath);
                if (sortedFile.exists()) {
                    sortedFile.delete();
                }
                if ((indexFile = new File(this.indexFilePath)).exists()) {
                    indexFile.delete();
                }
            } else {
                if (StorageManager.hadoopFs().exists(fileInfo.getHdfsSortedPath())) {
                    StorageManager.hadoopFs().delete(fileInfo.getHdfsSortedPath(), false);
                }
                if (StorageManager.hadoopFs().exists(fileInfo.getHdfsIndexPath())) {
                    StorageManager.hadoopFs().delete(fileInfo.getHdfsIndexPath(), false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sort() throws InterruptedException {
            PartitionFilesSorter.this.source.startTimer(WorkerSource.SORT_TIME(), this.fileId);
            try {
                int compressedSize;
                this.initializeFiles();
                TreeMap<Integer, List> originShuffleBlockInfos = new TreeMap<Integer, List>();
                HashMap<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>> sortedBlockInfoMap = new HashMap<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>>();
                int batchHeaderLen = 16;
                int reserveMemory = (int)PartitionFilesSorter.this.reservedMemoryPerPartition;
                ByteBuffer headerBuf = ByteBuffer.allocate(batchHeaderLen);
                ByteBuffer paddingBuf = ByteBuffer.allocateDirect(reserveMemory);
                for (long index = 0L; index != this.originFileLen; index += (long)(batchHeaderLen + compressedSize)) {
                    long blockStartIndex = index;
                    this.readBufferFully(headerBuf);
                    byte[] batchHeader = headerBuf.array();
                    headerBuf.rewind();
                    int mapId = Platform.getInt((Object)batchHeader, (long)Platform.BYTE_ARRAY_OFFSET);
                    compressedSize = Platform.getInt((Object)batchHeader, (long)(Platform.BYTE_ARRAY_OFFSET + 12));
                    List singleMapIdShuffleBlockList = originShuffleBlockInfos.computeIfAbsent(mapId, v -> new ArrayList());
                    ShuffleBlockInfoUtils.ShuffleBlockInfo blockInfo = new ShuffleBlockInfoUtils.ShuffleBlockInfo();
                    blockInfo.offset = blockStartIndex;
                    blockInfo.length = compressedSize + 16;
                    singleMapIdShuffleBlockList.add(blockInfo);
                    paddingBuf.clear();
                    this.readBufferBySize(paddingBuf, compressedSize);
                }
                long fileIndex = 0L;
                for (Map.Entry originBlockInfoEntry : originShuffleBlockInfos.entrySet()) {
                    int mapId = (Integer)originBlockInfoEntry.getKey();
                    List originShuffleBlocks = (List)originBlockInfoEntry.getValue();
                    ArrayList<ShuffleBlockInfoUtils.ShuffleBlockInfo> sortedShuffleBlocks = new ArrayList<ShuffleBlockInfoUtils.ShuffleBlockInfo>();
                    for (ShuffleBlockInfoUtils.ShuffleBlockInfo blockInfo : originShuffleBlocks) {
                        long offset = blockInfo.offset;
                        long length = blockInfo.length;
                        ShuffleBlockInfoUtils.ShuffleBlockInfo sortedBlock = new ShuffleBlockInfoUtils.ShuffleBlockInfo();
                        sortedBlock.offset = fileIndex;
                        sortedBlock.length = length;
                        sortedShuffleBlocks.add(sortedBlock);
                        fileIndex += this.transferBlock(offset, length);
                    }
                    sortedBlockInfoMap.put(mapId, sortedShuffleBlocks);
                }
                PartitionFilesSorter.this.writeIndex(sortedBlockInfoMap, this.indexFilePath, this.isHdfs);
                PartitionFilesSorter.this.updateSortedShuffleFiles(this.shuffleKey, this.fileId, this.originFileLen);
                if (PartitionFilesSorter.this.eagerlyRemoveOriginalFilesEnabled) {
                    this.deleteOriginFiles();
                }
                logger.debug("sort complete for {} {}", (Object)this.shuffleKey, (Object)this.originFilePath);
            }
            catch (Exception e) {
                logger.error("Sorting shuffle file for " + this.fileId + " " + this.originFilePath + " failed, detail: ", (Throwable)e);
            }
            finally {
                Set sorting;
                this.closeFiles();
                Set set = sorting = (Set)PartitionFilesSorter.this.sortingShuffleFiles.get(this.shuffleKey);
                synchronized (set) {
                    sorting.remove(this.fileId);
                }
            }
            PartitionFilesSorter.this.source.stopTimer(WorkerSource.SORT_TIME(), this.fileId);
        }

        private void initializeFiles() throws IOException {
            if (this.isHdfs) {
                this.hdfsOriginInput = StorageManager.hadoopFs().open(new Path(this.originFilePath));
                this.hdfsSortedOutput = StorageManager.hadoopFs().create(new Path(this.sortedFilePath), true, 262144);
            } else {
                this.originFileChannel = FileChannelUtils.openReadableFileChannel((String)this.originFilePath);
                this.sortedFileChannel = FileChannelUtils.createWritableFileChannel((String)this.sortedFilePath);
            }
        }

        private void closeFiles() {
            IOUtils.closeQuietly((Closeable)this.hdfsOriginInput, null);
            IOUtils.closeQuietly((Closeable)this.hdfsSortedOutput, null);
            IOUtils.closeQuietly((Closeable)this.originFileChannel, null);
            IOUtils.closeQuietly((Closeable)this.sortedFileChannel, null);
        }

        private void readBufferFully(ByteBuffer buffer) throws IOException {
            if (this.isHdfs) {
                PartitionFilesSorter.this.readStreamFully(this.hdfsOriginInput, buffer, this.originFilePath);
            } else {
                PartitionFilesSorter.this.readChannelFully(this.originFileChannel, buffer, this.originFilePath);
            }
        }

        private long transferBlock(long offset, long length) throws IOException {
            if (this.isHdfs) {
                return PartitionFilesSorter.this.transferStreamFully(this.hdfsOriginInput, this.hdfsSortedOutput, offset, length);
            }
            return PartitionFilesSorter.this.transferChannelFully(this.originFileChannel, this.sortedFileChannel, offset, length);
        }

        private void deleteOriginFiles() throws IOException {
            boolean deleteSuccess = false;
            deleteSuccess = this.isHdfs ? StorageManager.hadoopFs().delete(new Path(this.originFilePath), false) : new File(this.originFilePath).delete();
            if (!deleteSuccess) {
                logger.warn("Clean origin file failed, origin file is : {}", (Object)this.originFilePath);
            }
        }

        protected void readChannelBySize(FileChannel channel, ByteBuffer buffer, String path, int toRead) throws IOException {
            int read = 0;
            if (toRead < buffer.capacity()) {
                buffer.limit(toRead);
            }
            while (read != toRead) {
                int tmpRead = channel.read(buffer);
                if (-1 == tmpRead) {
                    throw new IOException("Unexpected EOF, file name : " + path + " position :" + channel.position() + " read size :" + read);
                }
                read += tmpRead;
                if (buffer.hasRemaining()) continue;
                buffer.clear();
                if (toRead - read >= buffer.capacity()) continue;
                buffer.limit(toRead - read);
            }
        }

        private void readBufferBySize(ByteBuffer buffer, int toRead) throws IOException {
            if (this.isHdfs) {
                this.hdfsOriginInput.seek((long)toRead + this.hdfsOriginInput.getPos());
            } else {
                this.readChannelBySize(this.originFileChannel, buffer, this.originFilePath, toRead);
            }
        }
    }
}

