/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.channels.ClosedByInterruptException;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.TimeWindow;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.service.deploy.worker.WorkerSource$;
import org.apache.celeborn.service.deploy.worker.congestcontrol.CongestionController;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.FlushTask;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005}fAB\u0011#\u0003\u0003!\u0003\u0007\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001B\u0011!Q\u0005A!A!\u0002\u0013\u0011\u0005\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001'\t\u0011A\u0003!\u0011!Q\u0001\n5C\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t;\u0002\u0011\t\u0011)A\u0005'\"Aa\f\u0001BC\u0002\u0013\u0005A\n\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\"B4\u0001\t\u0003A\u0007\u0002\u00039\u0001\u0011\u000b\u0007I\u0011\u0003'\t\u000fE\u0004!\u0019!C\te\"9\u0011q\u0001\u0001!\u0002\u0013\u0019\b\"CA\u0005\u0001\t\u0007I\u0011CA\u0006\u0011!\t)\u0002\u0001Q\u0001\n\u00055\u0001\"CA\f\u0001\t\u0007I\u0011CA\r\u0011!\tI\u0003\u0001Q\u0001\n\u0005m\u0001\u0002CA\u0016\u0001\u0001\u0007I\u0011\u0003'\t\u0013\u00055\u0002\u00011A\u0005\u0012\u0005=\u0002bBA\u001e\u0001\u0001\u0006K!\u0014\u0005\n\u0003{\u0001!\u0019!C\u0001\u0003\u007fA\u0001\"!\u0014\u0001A\u0003%\u0011\u0011\t\u0005\n\u0003\u001f\u0002!\u0019!C\u0001\u0003#B\u0001\"!\u0017\u0001A\u0003%\u00111\u000b\u0005\b\u00037\u0002A\u0011BA/\u0011\u0019\ty\u0006\u0001C\u0001\u0019\"9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!!)\u0001\t\u0003\ti\u0006C\u0004\u0002$\u00021\t!!*\u0003\u000f\u0019cWo\u001d5fe*\u00111\u0005J\u0001\bgR|'/Y4f\u0015\t)c%\u0001\u0004x_J\\WM\u001d\u0006\u0003O!\na\u0001Z3qY>L(BA\u0015+\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u000b\u0017\u0002\u0011\r,G.\u001a2pe:T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sON\u0019\u0001!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g!\tAT(D\u0001:\u0015\tQ4(\u0001\u0005j]R,'O\\1m\u0015\ta$&\u0001\u0004d_6lwN\\\u0005\u0003}e\u0012q\u0001T8hO&tw-\u0001\u0007x_J\\WM]*pkJ\u001cWm\u0001\u0001\u0016\u0003\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\rM|WO]2f\u0015\t95(A\u0004nKR\u0014\u0018nY:\n\u0005%#%AD!cgR\u0014\u0018m\u0019;T_V\u00148-Z\u0001\u000eo>\u00148.\u001a:T_V\u00148-\u001a\u0011\u0002\u0017QD'/Z1e\u0007>,h\u000e^\u000b\u0002\u001bB\u0011!GT\u0005\u0003\u001fN\u00121!\u00138u\u00031!\bN]3bI\u000e{WO\u001c;!\u0003%\tG\u000e\\8dCR|'/F\u0001T!\t!6,D\u0001V\u0015\t1v+\u0001\u0004ck\u001a4WM\u001d\u0006\u00031f\u000bQA\\3uifT\u0011AW\u0001\u0003S>L!\u0001X+\u0003-A{w\u000e\\3e\u0005f$XMQ;g\u00032dwnY1u_J\f!\"\u00197m_\u000e\fGo\u001c:!\u00035i\u0017\r_\"p[B|g.\u001a8ug\u0006qQ.\u0019=D_6\u0004xN\\3oiN\u0004\u0013a\u00044mkNDG+[7f\u001b\u0016$(/[2\u0011\u0005\t,W\"A2\u000b\u0005\u0011\\\u0014\u0001B7fi\u0006L!AZ2\u0003\u0015QKW.Z,j]\u0012|w/\u0001\u0004=S:LGO\u0010\u000b\u0007S.dWN\\8\u0011\u0005)\u0004Q\"\u0001\u0012\t\u000b}R\u0001\u0019\u0001\"\t\u000b-S\u0001\u0019A'\t\u000bES\u0001\u0019A*\t\u000byS\u0001\u0019A'\t\u000b\u0001T\u0001\u0019A1\u0002\u0013\u0019dWo\u001d5fe&#\u0017!D<pe.LgnZ)vKV,7/F\u0001t!\r\u0011DO^\u0005\u0003kN\u0012Q!\u0011:sCf\u0004Ba\u001e@\u0002\u00025\t\u0001P\u0003\u0002zu\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005md\u0018\u0001B;uS2T\u0011!`\u0001\u0005U\u00064\u0018-\u0003\u0002\u0000q\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vKB\u0019!.a\u0001\n\u0007\u0005\u0015!EA\u0005GYV\u001c\b\u000eV1tW\u0006qqo\u001c:lS:<\u0017+^3vKN\u0004\u0013a\u00032vM\u001a,'/U;fk\u0016,\"!!\u0004\u0011\t]t\u0018q\u0002\t\u0004)\u0006E\u0011bAA\n+\n\u00012i\\7q_NLG/\u001a\"zi\u0016\u0014UOZ\u0001\rEV4g-\u001a:Rk\u0016,X\rI\u0001\bo>\u00148.\u001a:t+\t\tY\u0002\u0005\u00033i\u0006u\u0001\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rB0\u0001\u0003mC:<\u0017\u0002BA\u0014\u0003C\u0011a\u0001\u00165sK\u0006$\u0017\u0001C<pe.,'o\u001d\u0011\u0002\u001f9,\u0007\u0010^,pe.,'/\u00138eKb\f1C\\3yi^{'o[3s\u0013:$W\r_0%KF$B!!\r\u00028A\u0019!'a\r\n\u0007\u0005U2G\u0001\u0003V]&$\b\u0002CA\u001d'\u0005\u0005\t\u0019A'\u0002\u0007a$\u0013'\u0001\toKb$xk\u001c:lKJLe\u000eZ3yA\u0005\u0011B.Y:u\u0005\u0016<\u0017N\u001c$mkNDG+[7f+\t\t\t\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9\u0005_\u0001\u0007CR|W.[2\n\t\u0005-\u0013Q\t\u0002\u0010\u0003R|W.[2M_:<\u0017I\u001d:bs\u0006\u0019B.Y:u\u0005\u0016<\u0017N\u001c$mkNDG+[7fA\u0005A1\u000f^8q\r2\fw-\u0006\u0002\u0002TA!\u00111IA+\u0013\u0011\t9&!\u0012\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003%\u0019Ho\u001c9GY\u0006<\u0007%\u0001\u0003j]&$HCAA\u0019\u000399W\r^,pe.,'/\u00138eKb\f!\u0002^1lK\n+hMZ3s)\t\ty!\u0001\u0007sKR,(O\u001c\"vM\u001a,'\u000f\u0006\u0003\u00022\u0005%\u0004B\u0002,\u001d\u0001\u0004\ty!A\u0004bI\u0012$\u0016m]6\u0015\u0011\u0005=\u0014QOA=\u0003\u0007\u00032AMA9\u0013\r\t\u0019h\r\u0002\b\u0005>|G.Z1o\u0011\u001d\t9(\ba\u0001\u0003\u0003\tA\u0001^1tW\"9\u00111P\u000fA\u0002\u0005u\u0014!\u0003;j[\u0016|W\u000f^'t!\r\u0011\u0014qP\u0005\u0004\u0003\u0003\u001b$\u0001\u0002'p]\u001eDa!!\"\u001e\u0001\u0004i\u0015aC<pe.,'/\u00138eKb\fqBY;gM\u0016\u0014\u0018+^3vK&sgm\u001c\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u001c:!\u0011qRAL!\r\t\tjM\u0007\u0003\u0003'S1!!&A\u0003\u0019a$o\\8u}%\u0019\u0011\u0011T\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\ti*a(\u0003\rM#(/\u001b8h\u0015\r\tIjM\u0001\u0014gR|\u0007/\u00118e\u00072,\u0017M\u001c$mkNDWM]\u0001\u0013aJ|7-Z:t\u0013>+\u0005pY3qi&|g\u000e\u0006\u0004\u00022\u0005\u001d\u0016Q\u0017\u0005\b\u0003S\u0003\u0003\u0019AAV\u0003\u0005)\u0007\u0003BAW\u0003ck!!a,\u000b\u0005ic\u0018\u0002BAZ\u0003_\u00131\"S(Fq\u000e,\u0007\u000f^5p]\"9\u0011q\u0017\u0011A\u0002\u0005e\u0016a\u00043fm&\u001cW-\u0012:s_J$\u0016\u0010]3\u0011\u0007\t\fY,C\u0002\u0002>\u000e\u0014!\u0002R5tWN#\u0018\r^;t\u0001")
public abstract class Flusher
implements Logging {
    private int flusherId;
    private final AbstractSource workerSource;
    private final int threadCount;
    private final PooledByteBufAllocator allocator;
    private final int maxComponents;
    public final TimeWindow org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric;
    private final LinkedBlockingQueue<FlushTask>[] workingQueues;
    private final LinkedBlockingQueue<CompositeByteBuf> bufferQueue;
    private final Thread[] workers;
    private int nextWorkerIndex;
    private final AtomicLongArray lastBeginFlushTime;
    private final AtomicBoolean stopFlag;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        Flusher flusher = this;
        synchronized (flusher) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public AbstractSource workerSource() {
        return this.workerSource;
    }

    public int threadCount() {
        return this.threadCount;
    }

    public PooledByteBufAllocator allocator() {
        return this.allocator;
    }

    public int maxComponents() {
        return this.maxComponents;
    }

    private int flusherId$lzycompute() {
        Flusher flusher = this;
        synchronized (flusher) {
            if (!this.bitmap$0) {
                this.flusherId = System.identityHashCode(this);
                this.bitmap$0 = true;
            }
        }
        return this.flusherId;
    }

    public int flusherId() {
        return !this.bitmap$0 ? this.flusherId$lzycompute() : this.flusherId;
    }

    public LinkedBlockingQueue<FlushTask>[] workingQueues() {
        return this.workingQueues;
    }

    public LinkedBlockingQueue<CompositeByteBuf> bufferQueue() {
        return this.bufferQueue;
    }

    public Thread[] workers() {
        return this.workers;
    }

    public int nextWorkerIndex() {
        return this.nextWorkerIndex;
    }

    public void nextWorkerIndex_$eq(int x$1) {
        this.nextWorkerIndex = x$1;
    }

    public AtomicLongArray lastBeginFlushTime() {
        return this.lastBeginFlushTime;
    }

    public AtomicBoolean stopFlag() {
        return this.stopFlag;
    }

    private void init() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.lastBeginFlushTime().length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.lastBeginFlushTime().set(i, -1L));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.threadCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            $this.workingQueues()[index] = new LinkedBlockingQueue();
            $this.workers()[index] = new Thread(this, index){
                private final /* synthetic */ Flusher $outer;
                private final int index$1;

                public void run() {
                    while (!this.$outer.stopFlag().get()) {
                        FlushTask task = this.$outer.workingQueues()[this.index$1].take();
                        String key = new StringBuilder(9).append("Flusher-").append(this).append("-").append(Random$.MODULE$.nextInt()).toString();
                        this.$outer.workerSource().sample(WorkerSource$.MODULE$.FLUSH_DATA_TIME(), key, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                            if (!task.notifier().hasException()) {
                                try {
                                    long flushBeginTime = System.nanoTime();
                                    $this.$outer.lastBeginFlushTime().set($this.index$1, flushBeginTime);
                                    task.flush();
                                    if ($this.$outer.org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric != null) {
                                        long delta = System.nanoTime() - flushBeginTime;
                                        $this.$outer.org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric.update(delta);
                                    }
                                }
                                catch (ClosedByInterruptException closedByInterruptException) {
                                }
                                catch (IOException e) {
                                    task.notifier().setException(e);
                                    $this.$outer.processIOException(e, DiskStatus.READ_OR_WRITE_FAILURE);
                                }
                                $this.$outer.lastBeginFlushTime().set($this.index$1, -1L);
                            }
                            $this.$outer.returnBuffer(task.buffer());
                            return task$1.notifier().numPendingFlushes.decrementAndGet();
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.index$1 = index$1;
                    super(new StringBuilder(1).append($outer).append("-").append(index$1).toString());
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.celeborn.service.deploy.worker.storage.Flusher$$anon$1 org.apache.celeborn.service.deploy.worker.storage.FlushTask )}, serializedLambda);
                }
            };
            this.workers()[index].setDaemon(true);
            this.workers()[index].setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
                private final /* synthetic */ Flusher $outer;

                public void uncaughtException(Thread t, Throwable e) {
                    this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(this).append(" thread terminated.").toString(), e);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$uncaughtException$1(org.apache.celeborn.service.deploy.worker.storage.Flusher$$anon$2 )}, serializedLambda);
                }
            });
            this.workers()[index].start();
        });
    }

    public synchronized int getWorkerIndex() {
        this.nextWorkerIndex_$eq((this.nextWorkerIndex() + 1) % this.threadCount());
        return this.nextWorkerIndex();
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf takeBuffer() {
        void var1_1;
        block0: {
            CompositeByteBuf buffer = this.bufferQueue().poll();
            if (buffer != null) break block0;
            buffer = this.allocator().compositeDirectBuffer(this.maxComponents());
        }
        return var1_1;
    }

    public void returnBuffer(CompositeByteBuf buffer) {
        MemoryManager.instance().releaseDiskBuffer(buffer.readableBytes());
        Option$.MODULE$.apply((Object)CongestionController.instance()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.consumeBytes(buffer.readableBytes());
            return BoxedUnit.UNIT;
        });
        buffer.removeComponents(0, buffer.numComponents());
        buffer.clear();
        this.bufferQueue().put(buffer);
    }

    public boolean addTask(FlushTask task, long timeoutMs, int workerIndex) {
        return this.workingQueues()[workerIndex].offer(task, timeoutMs, TimeUnit.MILLISECONDS);
    }

    public String bufferQueueInfo() {
        return new StringBuilder(15).append(this).append(" used buffers: ").append(this.bufferQueue().size()).toString();
    }

    public void stopAndCleanFlusher() {
        this.stopFlag().set(true);
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.workers())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.interrupt();
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Exception when interrupt worker: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.workers())).mkString(",")).append(", ").append(e).toString());
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.workingQueues())).foreach((Function1 & Serializable & scala.Serializable)queue -> {
            Flusher.$anonfun$stopAndCleanFlusher$3(this, queue);
            return BoxedUnit.UNIT;
        });
    }

    public abstract void processIOException(IOException var1, DiskStatus var2);

    public static final /* synthetic */ void $anonfun$stopAndCleanFlusher$3(Flusher $this, LinkedBlockingQueue queue) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)queue).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            $this.returnBuffer(task.buffer());
            return BoxedUnit.UNIT;
        });
    }

    public Flusher(AbstractSource workerSource, int threadCount, PooledByteBufAllocator allocator, int maxComponents, TimeWindow flushTimeMetric) {
        this.workerSource = workerSource;
        this.threadCount = threadCount;
        this.allocator = allocator;
        this.maxComponents = maxComponents;
        this.org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric = flushTimeMetric;
        Logging.$init$((Logging)this);
        this.workingQueues = new LinkedBlockingQueue[threadCount];
        this.bufferQueue = new LinkedBlockingQueue();
        this.workers = new Thread[threadCount];
        this.nextWorkerIndex = 0;
        this.lastBeginFlushTime = new AtomicLongArray(threadCount);
        this.stopFlag = new AtomicBoolean(false);
        this.init();
    }
}

