/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.memory;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.memory.ReadBufferRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadBufferDispatcher
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(ReadBufferDispatcher.class);
    private final LinkedBlockingQueue<ReadBufferRequest> requests = new LinkedBlockingQueue();
    private final MemoryManager memoryManager;
    private final PooledByteBufAllocator readBufferAllocator;
    private final LongAdder allocatedReadBuffers = new LongAdder();
    private final long readBufferAllocationWait;
    private volatile boolean stopFlag = false;

    public ReadBufferDispatcher(MemoryManager memoryManager, CelebornConf conf) {
        this.readBufferAllocationWait = conf.readBufferAllocationWait();
        this.readBufferAllocator = NettyUtils.getPooledByteBufAllocator((TransportConf)new TransportConf("readBuffer", conf), null, (boolean)true);
        this.memoryManager = memoryManager;
        this.setName("Read-Buffer-Dispatcher");
        this.start();
    }

    public void addBufferRequest(ReadBufferRequest request) {
        this.requests.add(request);
    }

    public void recycle(ByteBuf buf) {
        int bufferSize = buf.capacity();
        int refCnt = buf.refCnt();
        if (refCnt > 0) {
            buf.release(refCnt);
        }
        this.allocatedReadBuffers.decrement();
        this.memoryManager.changeReadBufferCounter(-1 * bufferSize);
    }

    @Override
    public void run() {
        while (!this.stopFlag) {
            ReadBufferRequest request = null;
            try {
                request = this.requests.poll(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.logger.info("Buffer dispatcher is closing");
            }
            if (request != null) {
                long start = System.nanoTime();
                ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>();
                int bufferSize = request.getBufferSize();
                while (buffers.size() < request.getNumber()) {
                    if (this.memoryManager.readBufferAvailable(bufferSize)) {
                        this.memoryManager.changeReadBufferCounter(bufferSize);
                        ByteBuf buf = this.readBufferAllocator.buffer(bufferSize, bufferSize);
                        buffers.add(buf);
                        this.allocatedReadBuffers.increment();
                        continue;
                    }
                    try {
                        Thread.sleep(this.readBufferAllocationWait);
                    }
                    catch (InterruptedException e) {
                        this.logger.info("Buffer dispatcher is closing");
                    }
                }
                long end = System.nanoTime();
                this.logger.debug("process read buffer request using {} ms", (Object)TimeUnit.NANOSECONDS.toMillis(end - start));
                request.getBufferListener().notifyBuffers(buffers, null);
                continue;
            }
            this.readBufferAllocator.trimCurrentThreadCache();
        }
    }

    public int requestsLength() {
        return this.requests.size();
    }

    public long getAllocatedReadBuffers() {
        return this.allocatedReadBuffers.sum();
    }

    public void close() {
        this.stopFlag = true;
        this.requests.clear();
    }
}

