/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.readclient;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.network.protocol.TransportableError;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbBufferStreamEnd;
import org.apache.celeborn.common.protocol.PbOpenStream;
import org.apache.celeborn.common.protocol.PbReadAddCredit;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.plugin.flink.network.FlinkTransportClientFactory;
import org.apache.celeborn.plugin.flink.readclient.FlinkShuffleClientImpl;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornBufferStream {
    private static Logger logger = LoggerFactory.getLogger(CelebornBufferStream.class);
    private FlinkTransportClientFactory clientFactory;
    private String shuffleKey;
    private PartitionLocation[] locations;
    private int subIndexStart;
    private int subIndexEnd;
    private TransportClient client;
    private AtomicInteger currentLocationIndex = new AtomicInteger(0);
    private long streamId = 0L;
    private FlinkShuffleClientImpl mapShuffleClient;
    private boolean isClosed;
    private boolean isOpenSuccess;
    private Object lock = new Object();
    private Supplier<ByteBuf> bufferSupplier;
    private int initialCredit;
    private Consumer<RequestMessage> messageConsumer;
    private static final CelebornBufferStream EMPTY_CELEBORN_BUFFER_STREAM = new CelebornBufferStream();

    public CelebornBufferStream() {
    }

    public CelebornBufferStream(FlinkShuffleClientImpl mapShuffleClient, FlinkTransportClientFactory dataClientFactory, String shuffleKey, PartitionLocation[] locations, int subIndexStart, int subIndexEnd) {
        this.mapShuffleClient = mapShuffleClient;
        this.clientFactory = dataClientFactory;
        this.shuffleKey = shuffleKey;
        this.locations = locations;
        this.subIndexStart = subIndexStart;
        this.subIndexEnd = subIndexEnd;
    }

    public void open(Supplier<ByteBuf> bufferSupplier, int initialCredit, Consumer<RequestMessage> messageConsumer) {
        this.bufferSupplier = bufferSupplier;
        this.initialCredit = initialCredit;
        this.messageConsumer = messageConsumer;
        this.moveToNextPartitionIfPossible(0L);
    }

    public void addCredit(PbReadAddCredit pbReadAddCredit) {
        this.client.sendRpc(new TransportMessage(MessageType.READ_ADD_CREDIT, pbReadAddCredit.toByteArray()).toByteBuffer(), new RpcResponseCallback(){

            @Override
            public void onSuccess(ByteBuffer response) {
            }

            @Override
            public void onFailure(Throwable e) {
                logger.warn("Send PbReadAddCredit to {} failed, detail {}", (Object)NettyUtils.getRemoteAddress(CelebornBufferStream.this.client.getChannel()), (Object)e.getCause());
            }
        });
    }

    public static CelebornBufferStream empty() {
        return EMPTY_CELEBORN_BUFFER_STREAM;
    }

    public long getStreamId() {
        return this.streamId;
    }

    public static CelebornBufferStream create(FlinkShuffleClientImpl client, FlinkTransportClientFactory dataClientFactory, String shuffleKey, PartitionLocation[] locations, int subIndexStart, int subIndexEnd) {
        if (locations == null || locations.length == 0) {
            return CelebornBufferStream.empty();
        }
        return new CelebornBufferStream(client, dataClientFactory, shuffleKey, locations, subIndexStart, subIndexEnd);
    }

    private void closeStream(long streamId) {
        if (this.client != null && this.client.isActive()) {
            this.client.sendRpc(new TransportMessage(MessageType.BUFFER_STREAM_END, PbBufferStreamEnd.newBuilder().setStreamId(streamId).build().toByteArray()).toByteBuffer());
        }
    }

    private void cleanStream(long streamId) {
        if (this.isOpenSuccess) {
            this.mapShuffleClient.getReadClientHandler().removeHandler(streamId);
            this.clientFactory.unregisterSupplier(streamId);
            this.closeStream(streamId);
            this.isOpenSuccess = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.cleanStream(this.streamId);
            this.isClosed = true;
        }
    }

    public void moveToNextPartitionIfPossible(long endedStreamId) {
        logger.debug("MoveToNextPartitionIfPossible in this:{},  endedStreamId: {}, currentLocationIndex: {}, currentSteamId:{}, locationsLength:{}", new Object[]{this, endedStreamId, this.currentLocationIndex.get(), this.streamId, this.locations.length});
        if (this.currentLocationIndex.get() > 0) {
            logger.debug("Get end streamId {}", (Object)endedStreamId);
            this.cleanStream(endedStreamId);
        }
        if (this.currentLocationIndex.get() < this.locations.length) {
            try {
                this.openStreamInternal();
                logger.debug("MoveToNextPartitionIfPossible after openStream this:{},  endedStreamId: {}, currentLocationIndex: {}, currentSteamId:{}, locationsLength:{}", new Object[]{this, endedStreamId, this.currentLocationIndex.get(), this.streamId, this.locations.length});
            }
            catch (Exception e) {
                logger.warn("Failed to open stream and report to flink framework. ", (Throwable)e);
                this.messageConsumer.accept(new TransportableError(0L, e));
            }
        }
    }

    private void openStreamInternal() throws IOException, InterruptedException {
        this.client = this.clientFactory.createClientWithRetry(this.locations[this.currentLocationIndex.get()].getHost(), this.locations[this.currentLocationIndex.get()].getFetchPort());
        final String fileName = this.locations[this.currentLocationIndex.getAndIncrement()].getFileName();
        TransportMessage openStream = new TransportMessage(MessageType.OPEN_STREAM, PbOpenStream.newBuilder().setShuffleKey(this.shuffleKey).setFileName(fileName).setStartIndex(this.subIndexStart).setEndIndex(this.subIndexEnd).setInitialCredit(this.initialCredit).build().toByteArray());
        this.client.sendRpc(openStream.toByteBuffer(), new RpcResponseCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(ByteBuffer response) {
                try {
                    PbStreamHandler pbStreamHandler = (PbStreamHandler)TransportMessage.fromByteBuffer(response).getParsedPayload();
                    CelebornBufferStream.this.streamId = pbStreamHandler.getStreamId();
                    Object object = CelebornBufferStream.this.lock;
                    synchronized (object) {
                        if (!CelebornBufferStream.this.isClosed) {
                            CelebornBufferStream.this.clientFactory.registerSupplier(CelebornBufferStream.this.streamId, CelebornBufferStream.this.bufferSupplier);
                            CelebornBufferStream.this.mapShuffleClient.getReadClientHandler().registerHandler(CelebornBufferStream.this.streamId, CelebornBufferStream.this.messageConsumer, CelebornBufferStream.this.client);
                            CelebornBufferStream.this.isOpenSuccess = true;
                            logger.debug("open stream success from remote:{}, stream id:{}, fileName: {}", new Object[]{CelebornBufferStream.this.client.getSocketAddress(), CelebornBufferStream.this.streamId, fileName});
                        } else {
                            logger.debug("open stream success from remote:{}, but stream reader is already closed, stream id:{}, fileName: {}", new Object[]{CelebornBufferStream.this.client.getSocketAddress(), CelebornBufferStream.this.streamId, fileName});
                            CelebornBufferStream.this.closeStream(CelebornBufferStream.this.streamId);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Open file {} stream for {} error from {}", new Object[]{fileName, CelebornBufferStream.this.shuffleKey, NettyUtils.getRemoteAddress(CelebornBufferStream.this.client.getChannel())});
                    CelebornBufferStream.this.messageConsumer.accept(new TransportableError(CelebornBufferStream.this.streamId, e));
                }
            }

            @Override
            public void onFailure(Throwable e) {
                logger.error("Open file {} stream for {} error from {}", new Object[]{fileName, CelebornBufferStream.this.shuffleKey, NettyUtils.getRemoteAddress(CelebornBufferStream.this.client.getChannel())});
                CelebornBufferStream.this.messageConsumer.accept(new TransportableError(CelebornBufferStream.this.streamId, e));
            }
        });
    }

    public TransportClient getClient() {
        return this.client;
    }
}

