/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.pref.CayenneProjectPreferences;
import org.apache.cayenne.pref.PreferenceEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CayennePreferenceEditor
implements PreferenceEditor {
    protected boolean restartRequired;
    protected CayenneProjectPreferences cayenneProjectPreferences;
    private Map<Preferences, Map<String, String>> changedPreferences;
    private Map<Preferences, Map<String, String>> removedPreferences;
    private Map<Preferences, Map<String, Boolean>> changedBooleanPreferences;
    private List<Preferences> removedNode;
    private List<Preferences> addedNode;
    private static Logger logger = LoggerFactory.getLogger(CayennePreferenceEditor.class);

    public CayennePreferenceEditor(CayenneProjectPreferences cayenneProjectPreferences) {
        this.cayenneProjectPreferences = cayenneProjectPreferences;
        this.changedPreferences = new HashMap<Preferences, Map<String, String>>();
        this.removedPreferences = new HashMap<Preferences, Map<String, String>>();
        this.changedBooleanPreferences = new HashMap<Preferences, Map<String, Boolean>>();
        this.removedNode = new ArrayList<Preferences>();
        this.addedNode = new ArrayList<Preferences>();
    }

    public List<Preferences> getAddedNode() {
        return this.addedNode;
    }

    public List<Preferences> getRemovedNode() {
        return this.removedNode;
    }

    public Map<Preferences, Map<String, String>> getRemovedPreferences() {
        return this.removedPreferences;
    }

    public Map<Preferences, Map<String, String>> getChangedPreferences() {
        return this.changedPreferences;
    }

    public Map<Preferences, Map<String, Boolean>> getChangedBooleanPreferences() {
        return this.changedBooleanPreferences;
    }

    protected boolean isRestartRequired() {
        return this.restartRequired;
    }

    protected void setRestartRequired(boolean restartOnSave) {
        this.restartRequired = restartOnSave;
    }

    @Override
    public void save() {
        Preferences pref;
        this.cayenneProjectPreferences.getDetailObject(DBConnectionInfo.class).save();
        if (this.restartRequired) {
            this.restart();
        }
        for (Map.Entry<Preferences, Map<String, Boolean>> entry : this.changedBooleanPreferences.entrySet()) {
            pref = entry.getKey();
            for (Map.Entry<String, Boolean> entry2 : entry.getValue().entrySet()) {
                pref.putBoolean(entry2.getKey(), entry2.getValue());
            }
        }
        for (Map.Entry<Preferences, Map<String, Object>> entry : this.changedPreferences.entrySet()) {
            pref = entry.getKey();
            for (Map.Entry<String, Object> entry3 : entry.getValue().entrySet()) {
                pref.put(entry3.getKey(), (String)entry3.getValue());
            }
        }
        for (Map.Entry<Preferences, Map<String, Object>> entry : this.removedPreferences.entrySet()) {
            pref = entry.getKey();
            for (Map.Entry<String, Object> entry4 : entry.getValue().entrySet()) {
                pref.remove(entry4.getKey());
            }
        }
        for (Preferences preferences : this.removedNode) {
            try {
                preferences.removeNode();
            }
            catch (BackingStoreException e) {
                logger.warn("Error removing preferences");
            }
        }
        Application.getInstance().initClassLoader();
    }

    @Override
    public void revert() {
        for (Preferences pref : this.addedNode) {
            try {
                pref.removeNode();
            }
            catch (BackingStoreException backingStoreException) {}
        }
        this.cayenneProjectPreferences.getDetailObject(DBConnectionInfo.class).cancel();
        this.restartRequired = false;
    }

    protected abstract void restart();
}

