/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.extension;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.xml.DefaultHandlerFactory;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.project.extension.LoaderDelegate;
import org.apache.cayenne.project.extension.ProjectExtension;

public class ExtensionAwareHandlerFactory
extends DefaultHandlerFactory {
    Map<String, LoaderDelegate> loaderDelegates = new ConcurrentHashMap<String, LoaderDelegate>();

    public ExtensionAwareHandlerFactory(@Inject List<ProjectExtension> extensions) {
        for (ProjectExtension extension : extensions) {
            LoaderDelegate delegate = extension.createLoaderDelegate();
            LoaderDelegate old = this.loaderDelegates.put(delegate.getTargetNamespace(), delegate);
            if (old == null) continue;
            throw new CayenneRuntimeException("Found two loader delegates for namespace %s", new Object[]{delegate.getTargetNamespace()});
        }
    }

    public NamespaceAwareNestedTagHandler createHandler(String namespace, String localName, NamespaceAwareNestedTagHandler parent) {
        NamespaceAwareNestedTagHandler handler;
        LoaderDelegate delegate = this.loaderDelegates.get(namespace);
        if (delegate != null && (handler = delegate.createHandler(parent, localName)) != null) {
            return handler;
        }
        return super.createHandler(namespace, localName, parent);
    }
}

