/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client;

import io.vertx.core.buffer.Buffer;
import java.nio.ByteBuffer;
import org.apache.cassandra.sidecar.client.StreamBuffer;

public class VertxStreamBuffer
implements StreamBuffer {
    private final Buffer buffer;

    public VertxStreamBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public void copyBytes(int sourceOffset, ByteBuffer destination, int length) {
        destination.put(this.buffer.getBytes(sourceOffset, sourceOffset + length));
        destination.flip();
    }

    public void copyBytes(int sourceOffset, byte[] destination, int destinationIndex, int length) {
        this.buffer.getBytes(sourceOffset, sourceOffset + length, destination, destinationIndex);
    }

    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    public int readableBytes() {
        return this.buffer.length();
    }

    public void release() {
    }
}

