/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import org.apache.cassandra.sidecar.common.server.ICassandraAdapter;
import org.apache.cassandra.sidecar.db.DatabaseAccessor;
import org.apache.cassandra.sidecar.db.schema.TableSchema;

public abstract class LocalDatabaseAccessor<T extends TableSchema>
extends DatabaseAccessor<T> {
    private final ICassandraAdapter cassandraAdapter;

    protected LocalDatabaseAccessor(T tableSchema, ICassandraAdapter cassandraAdapter) {
        super(tableSchema, null);
        this.cassandraAdapter = cassandraAdapter;
    }

    @Override
    public Session session() {
        throw new UnsupportedOperationException("LocalDatabaseAccessor does not expose Session object");
    }

    @Override
    protected ResultSet execute(Statement statement) {
        return this.cassandraAdapter.executeLocal(statement);
    }
}

