/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class IOUtils {
    public static String readFully(String resource) throws IOException {
        return IOUtils.readFully(IOUtils.class.getResourceAsStream(resource));
    }

    public static String readFully(InputStream inputStream) throws IOException {
        try (InputStream input = inputStream;){
            String string;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                int length;
                byte[] buffer = new byte[32];
                while ((length = input.read(buffer)) >= 0) {
                    output.write(buffer, 0, length);
                }
                string = output.toString(StandardCharsets.UTF_8.name());
            }
            return string;
        }
    }
}

