/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoMap;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.function.Function;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.coordination.ClusterLease;
import org.apache.cassandra.sidecar.modules.multibindings.KeyClassMapKey;
import org.apache.cassandra.sidecar.modules.multibindings.MultiBindingTypeResolver;
import org.apache.cassandra.sidecar.modules.multibindings.PeriodicTaskMapKeys;
import org.apache.cassandra.sidecar.server.Server;
import org.apache.cassandra.sidecar.tasks.KeyStoreCheckPeriodicTask;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.tasks.PeriodicTaskExecutor;
import org.apache.cassandra.sidecar.utils.SidecarClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulingModule.class);

    @Provides
    @Singleton
    public PeriodicTaskExecutor periodicTaskExecutor(Vertx vertx, ExecutorPools executorPools, ClusterLease clusterLease, MultiBindingTypeResolver<PeriodicTask> resolver) {
        PeriodicTaskExecutor periodicTaskExecutor = new PeriodicTaskExecutor(executorPools, clusterLease);
        resolver.resolve().values().forEach(pt -> {
            LOGGER.info("Deploying periodic task: {}", (Object)pt.identifier());
            try {
                pt.deploy(vertx, periodicTaskExecutor);
            }
            catch (Throwable cause) {
                throw new RuntimeException("Failed to deploy periodic task: " + pt.identifier(), cause);
            }
        });
        return periodicTaskExecutor;
    }

    @ProvidesIntoMap
    @KeyClassMapKey(value=PeriodicTaskMapKeys.KeyStoreCheckPeriodicTaskKey.class)
    PeriodicTask keyStoreCheckPeriodicTask(Vertx vertx, Provider<Server> server, SidecarConfiguration configuration) {
        Function<Long, Future<Boolean>> updateServerSSLOptionsFunction = lastModifiedTime -> ((Server)server.get()).updateSSLOptions((long)lastModifiedTime).compose(v -> Future.succeededFuture((Object)true));
        return KeyStoreCheckPeriodicTask.forServer(vertx, configuration, updateServerSSLOptionsFunction);
    }

    @ProvidesIntoMap
    @KeyClassMapKey(value=PeriodicTaskMapKeys.ClientKeyStoreCheckPeriodicTaskKey.class)
    PeriodicTask clientKeyStoreCheckPeriodicTask(Vertx vertx, SidecarClientProvider sidecarClientProvider, SidecarConfiguration configuration) {
        Function<Long, Future<Boolean>> updateClientSSLOptionsFunction = sidecarClientProvider::updateSSLOptions;
        return KeyStoreCheckPeriodicTask.forClient(vertx, configuration, updateClientSSLOptionsFunction);
    }
}

