/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoMap;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.coordination.ClusterLease;
import org.apache.cassandra.sidecar.coordination.ClusterLeaseClaimTask;
import org.apache.cassandra.sidecar.coordination.ElectorateMembership;
import org.apache.cassandra.sidecar.db.SidecarLeaseDatabaseAccessor;
import org.apache.cassandra.sidecar.db.schema.SidecarLeaseSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.apache.cassandra.sidecar.metrics.SidecarMetrics;
import org.apache.cassandra.sidecar.modules.ElectorateMembershipFactory;
import org.apache.cassandra.sidecar.modules.multibindings.KeyClassMapKey;
import org.apache.cassandra.sidecar.modules.multibindings.PeriodicTaskMapKeys;
import org.apache.cassandra.sidecar.modules.multibindings.TableSchemaMapKeys;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;

public class CoordinationModule
extends AbstractModule {
    @ProvidesIntoMap
    @KeyClassMapKey(value=TableSchemaMapKeys.SidecarLeaseSchemaKey.class)
    TableSchema sidecarLeaseSchema(ServiceConfiguration configuration) {
        return new SidecarLeaseSchema(configuration.schemaKeyspaceConfiguration());
    }

    @ProvidesIntoMap
    @KeyClassMapKey(value=PeriodicTaskMapKeys.ClusterLeaseClaimTaskKey.class)
    PeriodicTask clusterLeaseClaimTask(ServiceConfiguration serviceConfiguration, ElectorateMembership electorateMembership, SidecarLeaseDatabaseAccessor accessor, ClusterLease clusterLease, SidecarMetrics metrics) {
        return new ClusterLeaseClaimTask(serviceConfiguration, electorateMembership, accessor, clusterLease, metrics);
    }

    @Provides
    @Singleton
    ElectorateMembership electorateMembership(InstanceMetadataFetcher instanceMetadataFetcher, CQLSessionProvider cqlSessionProvider, SidecarConfiguration configuration) {
        return new ElectorateMembershipFactory().create(instanceMetadataFetcher, cqlSessionProvider, configuration);
    }
}

