/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.models;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.utils.HttpRange;

public class HttpResponse {
    private final String host;
    private final HttpServerRequest request;
    private final HttpServerResponse response;

    public HttpResponse(HttpServerRequest request, HttpServerResponse response) {
        this.request = request;
        this.response = response;
        this.host = request.host();
    }

    public void setRetryAfterHeader(long waitTimeNanos) {
        this.response.setStatusCode(HttpResponseStatus.TOO_MANY_REQUESTS.code());
        this.response.putHeader((CharSequence)HttpHeaderNames.RETRY_AFTER, (CharSequence)Long.toString(TimeUnit.NANOSECONDS.toSeconds(waitTimeNanos) + 1L)).end();
    }

    public void setTooManyRequestsStatus() {
        this.response.setStatusCode(HttpResponseStatus.TOO_MANY_REQUESTS.code()).end();
    }

    public void setRangeNotSatisfiable(String msg) {
        this.response.setStatusCode(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE.code()).setStatusMessage(msg).end();
    }

    public void setPartialContentStatus(HttpRange range) {
        this.response.setStatusCode(HttpResponseStatus.PARTIAL_CONTENT.code()).putHeader((CharSequence)HttpHeaderNames.CONTENT_RANGE, (CharSequence)this.contentRangeHeader(range));
    }

    private String contentRangeHeader(HttpRange r) {
        return "bytes " + r.start() + "-" + r.end() + "/" + r.length();
    }

    public void setBadRequestStatus(String msg) {
        this.response.setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).setStatusMessage(msg).end();
    }

    public void setNotFoundStatus(String msg) {
        this.response.setStatusCode(HttpResponseStatus.NOT_FOUND.code()).setStatusMessage(msg).end();
    }

    public void setInternalErrorStatus(String msg) {
        this.response.setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setStatusMessage(msg).end();
    }

    public Future<Void> sendFile(String fileName, long fileLength, HttpRange range) {
        this.response.headersEndHandler(v -> {
            this.response.putHeader((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (CharSequence)"bytes");
            if (range.length() != fileLength) {
                this.setPartialContentStatus(range);
            }
            if (!this.response.headers().contains(HttpHeaders.CONTENT_TYPE)) {
                this.response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_OCTET_STREAM);
            }
        });
        return this.response.sendFile(fileName, range.start(), range.length()).onFailure(ignored -> this.response.headersEndHandler(null));
    }

    public SocketAddress remoteAddress() {
        return this.request.remoteAddress();
    }

    public String host() {
        return this.host;
    }
}

