/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics.server;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.apache.cassandra.sidecar.metrics.server.CacheMetrics;
import org.apache.cassandra.sidecar.metrics.server.CdcMetrics;
import org.apache.cassandra.sidecar.metrics.server.CoordinationMetrics;
import org.apache.cassandra.sidecar.metrics.server.HealthMetrics;
import org.apache.cassandra.sidecar.metrics.server.ResourceMetrics;
import org.apache.cassandra.sidecar.metrics.server.RestoreMetrics;
import org.apache.cassandra.sidecar.metrics.server.SchemaMetrics;
import org.apache.cassandra.sidecar.metrics.server.SchemaReportingMetrics;
import org.apache.cassandra.sidecar.metrics.server.ServerMetrics;

public class ServerMetricsImpl
implements ServerMetrics {
    protected final MetricRegistry metricRegistry;
    protected final HealthMetrics healthMetrics;
    protected final ResourceMetrics resourceMetrics;
    protected final RestoreMetrics restoreMetrics;
    protected final SchemaMetrics schemaMetrics;
    protected final SchemaReportingMetrics schemaReportingMetrics;
    protected final CacheMetrics cacheMetrics;
    protected final CoordinationMetrics coordinationMetrics;
    protected final CdcMetrics cdcMetrics;

    public ServerMetricsImpl(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "MetricRegistry can not be null");
        this.healthMetrics = new HealthMetrics(metricRegistry);
        this.resourceMetrics = new ResourceMetrics(metricRegistry);
        this.restoreMetrics = new RestoreMetrics(metricRegistry);
        this.schemaMetrics = new SchemaMetrics(metricRegistry);
        this.schemaReportingMetrics = new SchemaReportingMetrics(metricRegistry);
        this.cacheMetrics = new CacheMetrics(metricRegistry);
        this.coordinationMetrics = new CoordinationMetrics(metricRegistry);
        this.cdcMetrics = new CdcMetrics(metricRegistry);
    }

    @Override
    public HealthMetrics health() {
        return this.healthMetrics;
    }

    @Override
    public ResourceMetrics resource() {
        return this.resourceMetrics;
    }

    @Override
    public RestoreMetrics restore() {
        return this.restoreMetrics;
    }

    @Override
    public SchemaMetrics schema() {
        return this.schemaMetrics;
    }

    @Override
    public SchemaReportingMetrics schemaReporting() {
        return this.schemaReportingMetrics;
    }

    @Override
    public CacheMetrics cache() {
        return this.cacheMetrics;
    }

    @Override
    public CoordinationMetrics coordination() {
        return this.coordinationMetrics;
    }

    @Override
    public CdcMetrics cdc() {
        return this.cdcMetrics;
    }
}

