/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.OrAuthorization;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.ResourceScope;
import org.jetbrains.annotations.NotNull;

public interface Permission {
    public String name();

    @NotNull
    public ResourceScope resourceScope();

    public Authorization toAuthorization(String var1);

    default public Authorization toAuthorization() {
        return this.toAuthorization(this.resourceScope().expandedResources());
    }

    default public Authorization toAuthorization(Set<String> eligibleResources) {
        if (eligibleResources == null || eligibleResources.isEmpty()) {
            return this.toAuthorization((String)null);
        }
        OrAuthorization orAuthorization = OrAuthorization.create();
        for (String resource : eligibleResources) {
            orAuthorization.addAuthorization(this.toAuthorization(resource));
        }
        return orAuthorization;
    }
}

